/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.serializer.handler.patch;

import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.serializer.handler.patch.AbstractSerializerHandler;

public class Patch023SerializerHandler
extends AbstractSerializerHandler {
    @Override
    public Diagram handleAfterDeserialize(Diagram in) {
        logger.info("handleAfterDeserialize");
        if (this.versionUnderEqual(in, 0, 2, 2)) {
            logger.info("apply patch 0.2.3");
            for (ModelElement o : in.getChildren()) {
                if (!(o instanceof AbstractEntityModel)) continue;
                AbstractEntityModel model = (AbstractEntityModel)o;
                this.convert(model);
            }
        }
        return in;
    }

    private void convert(AbstractEntityModel model) {
        this.convertRelatedRelationships(model.getModelSourceConnections());
        this.convertRelatedRelationships(model.getModelTargetConnections());
    }

    private void convertRelatedRelationships(List<AbstractConnectionModel> connections) {
        for (AbstractConnectionModel c : connections) {
            if (c instanceof RelatedRelationship) {
                logger.debug("convertRelatedRelationships():" + c.toString());
                this.convertLocationIfNeeds(c);
            }
            if (!(c instanceof Entity2SubsetTypeRelationship)) continue;
            logger.debug("convertRelatedRelationships():" + c.toString());
            this.convertLocationIfNeeds(c);
        }
    }

    private void convertLocationIfNeeds(AbstractConnectionModel connection) {
        if (connection.getSourceXp() == 0 && connection.getSourceYp() == 0 || connection.getTargetXp() == 0 && connection.getTargetYp() == 0) {
            connection.setSourceLocationp(-1, -1);
            connection.setTargetLocationp(-1, -1);
        }
    }
}

