/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator2;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.services.IDisposable;

public class StructureDiffViewer
extends DiffTreeViewer {
    private Differencer fDifferencer;
    private boolean fThreeWay = false;
    private StructureInfo fAncestorStructure = new StructureInfo();
    private StructureInfo fLeftStructure = new StructureInfo();
    private StructureInfo fRightStructure = new StructureInfo();
    private IStructureCreator fStructureCreator;
    private IDiffContainer fRoot;
    private IContentChangeListener fContentChangedListener;
    private CompareViewerSwitchingPane fParent;
    private ICompareInputChangeListener fCompareInputChangeListener;
    private IRunnableWithProgress diffTask = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(CompareMessages.StructureDiffViewer_0, 100);
            StructureDiffViewer.this.diff((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            monitor.done();
        }
    };
    private IRunnableWithProgress inputChangedTask = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(CompareMessages.StructureDiffViewer_1, 100);
            StructureDiffViewer.this.compareInputChanged((ICompareInput)StructureDiffViewer.this.getInput(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            monitor.done();
        }
    };

    public StructureDiffViewer(Tree tree, CompareConfiguration configuration) {
        super(tree, configuration);
        Composite c = tree.getParent();
        if (c instanceof CompareViewerSwitchingPane) {
            this.fParent = (CompareViewerSwitchingPane)c;
        }
        this.initialize();
    }

    public StructureDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        if (parent instanceof CompareViewerSwitchingPane) {
            this.fParent = (CompareViewerSwitchingPane)parent;
        }
        this.initialize();
    }

    private void initialize() {
        this.setAutoExpandLevel(3);
        this.fContentChangedListener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier changed) {
                StructureDiffViewer.this.contentChanged(changed);
            }
        };
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                StructureDiffViewer.this.compareInputChanged(input, true);
            }
        };
    }

    public void setStructureCreator(IStructureCreator structureCreator) {
        if (this.fStructureCreator != structureCreator) {
            this.fStructureCreator = structureCreator;
            Control tree = this.getControl();
            if (tree != null && !tree.isDisposed()) {
                tree.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
            }
        }
    }

    public IStructureCreator getStructureCreator() {
        return this.fStructureCreator;
    }

    public String getTitle() {
        if (this.fStructureCreator != null) {
            return this.fStructureCreator.getName();
        }
        return super.getTitle();
    }

    protected Object getRoot() {
        return this.fRoot;
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            this.compareInputChanged(ci);
            if (input != oldInput) {
                this.initialSelection();
            }
        }
    }

    protected void initialSelection() {
        this.expandToLevel(2);
    }

    protected void handleDispose(DisposeEvent event) {
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.compareInputChanged(null);
        this.fContentChangedListener = null;
        super.handleDispose(event);
    }

    protected void compareInputChanged(ICompareInput input) {
        this.compareInputChanged(input, false);
    }

    void compareInputChanged(ICompareInput input, boolean force) {
        if (input == null) {
            this.compareInputChanged(input, force, null);
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        StructureDiffViewer.this.inputChangedTask.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        CompareUIPlugin.log(e.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
    }

    void compareInputChanged(ICompareInput input, boolean force, IProgressMonitor monitor) {
        ITypedElement t = null;
        boolean changed = false;
        if (input != null) {
            t = input.getAncestor();
        }
        this.fThreeWay = t != null;
        this.beginWork(monitor, 400);
        try {
            if (this.fAncestorStructure.setInput(t, force, this.subMonitor(monitor, 100))) {
                changed = true;
            }
            if (input != null) {
                t = input.getLeft();
            }
            if (this.fLeftStructure.setInput(t, force, this.subMonitor(monitor, 100))) {
                changed = true;
            }
            if (input != null) {
                t = input.getRight();
            }
            if (this.fRightStructure.setInput(t, force, this.subMonitor(monitor, 100))) {
                changed = true;
            }
            CompareConfiguration cc = this.getCompareConfiguration();
            if (changed && cc != null) {
                cc.getContainer().runAsynchronously(this.diffTask);
            }
        }
        finally {
            this.endWork(monitor);
        }
    }

    private void endWork(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    private IProgressMonitor subMonitor(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled() || this.getControl().isDisposed()) {
                throw new OperationCanceledException();
            }
            return new SubProgressMonitor(monitor, work);
        }
        return null;
    }

    private void beginWork(IProgressMonitor monitor, int totalWork) {
        if (monitor != null) {
            monitor.beginTask(null, totalWork);
        }
    }

    protected void contentChanged(IContentChangeNotifier changed) {
        if (this.fStructureCreator == null) {
            return;
        }
        if (changed == null) {
            this.getCompareConfiguration().getContainer().runAsynchronously(this.fAncestorStructure.getRefreshTask());
            this.getCompareConfiguration().getContainer().runAsynchronously(this.fLeftStructure.getRefreshTask());
            this.getCompareConfiguration().getContainer().runAsynchronously(this.fRightStructure.getRefreshTask());
        } else if (changed == this.fAncestorStructure.getInput()) {
            this.getCompareConfiguration().getContainer().runAsynchronously(this.fAncestorStructure.getRefreshTask());
        } else if (changed == this.fLeftStructure.getInput()) {
            this.getCompareConfiguration().getContainer().runAsynchronously(this.fLeftStructure.getRefreshTask());
        } else if (changed == this.fRightStructure.getInput()) {
            this.getCompareConfiguration().getContainer().runAsynchronously(this.fRightStructure.getRefreshTask());
        } else {
            return;
        }
        this.getCompareConfiguration().getContainer().runAsynchronously(this.diffTask);
    }

    protected void preDiffHook(IStructureComparator ancestor, IStructureComparator left, IStructureComparator right) {
    }

    protected void preDiffHook(final IStructureComparator ancestor, final IStructureComparator left, final IStructureComparator right, IProgressMonitor monitor) {
        this.syncExec(new Runnable(){

            public void run() {
                StructureDiffViewer.this.preDiffHook(ancestor, left, right);
            }
        });
    }

    protected void diff(IProgressMonitor monitor) {
        try {
            this.beginWork(monitor, 150);
            IStructureComparator ancestorComparator = this.fAncestorStructure.getStructureComparator();
            IStructureComparator leftComparator = this.fLeftStructure.getStructureComparator();
            IStructureComparator rightComparator = this.fRightStructure.getStructureComparator();
            this.preDiffHook(ancestorComparator, leftComparator, rightComparator, this.subMonitor(monitor, 25));
            String message = null;
            if (this.fThreeWay && ancestorComparator == null || leftComparator == null || rightComparator == null) {
                this.fRoot = null;
                message = CompareMessages.StructureDiffViewer_StructureError;
            } else {
                if (this.fDifferencer == null) {
                    this.fDifferencer = new Differencer(){

                        protected boolean contentsEqual(Object o1, char contributor1, Object o2, char contributor2) {
                            return StructureDiffViewer.this.contentsEqual(o1, contributor1, o2, contributor2);
                        }

                        protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                            Object o = super.visit(data, result, ancestor, left, right);
                            if (StructureDiffViewer.this.fLeftIsLocal && o instanceof DiffNode) {
                                ((DiffNode)o).swapSides(StructureDiffViewer.this.fLeftIsLocal);
                            }
                            return o;
                        }
                    };
                }
                this.fRoot = (IDiffContainer)this.fDifferencer.findDifferences(this.fThreeWay, this.subMonitor(monitor, 100), null, ancestorComparator, leftComparator, rightComparator);
                if (this.fRoot == null || this.fRoot.getChildren().length == 0) {
                    message = CompareMessages.StructureDiffViewer_NoStructuralDifferences;
                } else {
                    this.postDiffHook(this.fDifferencer, this.fRoot, this.subMonitor(monitor, 25));
                }
            }
            if (Display.getCurrent() != null) {
                this.refreshAfterDiff(message);
            } else {
                final String theMessage = message;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        StructureDiffViewer.this.refreshAfterDiff(theMessage);
                    }
                });
            }
        }
        finally {
            this.endWork(monitor);
        }
    }

    private void refreshAfterDiff(String message) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.setTitleArgument(message);
        }
        this.refresh(this.getRoot());
        this.expandToLevel(3);
    }

    protected void diff() {
        try {
            CompareConfiguration compareConfiguration = this.getCompareConfiguration();
            if (compareConfiguration != null) {
                compareConfiguration.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(CompareMessages.StructureDiffViewer_2, 100);
                        StructureDiffViewer.this.diffTask.run((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        monitor.done();
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            CompareUIPlugin.log(e.getTargetException());
            this.handleFailedRefresh(e.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {
            this.handleFailedRefresh(CompareMessages.StructureDiffViewer_3);
        }
    }

    private void handleFailedRefresh(final String message) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (StructureDiffViewer.this.getControl().isDisposed()) {
                    return;
                }
                StructureDiffViewer.this.refreshAfterDiff(message);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    protected void postDiffHook(Differencer differencer, IDiffContainer root) {
    }

    protected void postDiffHook(final Differencer differencer, final IDiffContainer root, IProgressMonitor monitor) {
        this.syncExec(new Runnable(){

            public void run() {
                StructureDiffViewer.this.postDiffHook(differencer, root);
            }
        });
    }

    private boolean contentsEqual(Object o1, char contributor1, Object o2, char contributor2) {
        if (this.fStructureCreator != null) {
            boolean ignoreWhiteSpace = Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
            ICompareFilter[] compareFilters = Utilities.getCompareFilters(this.getCompareConfiguration());
            if (compareFilters != null && compareFilters.length > 0 && this.fStructureCreator instanceof StructureCreator) {
                return ((StructureCreator)this.fStructureCreator).contentsEquals(o1, contributor1, o2, contributor2, ignoreWhiteSpace, compareFilters);
            }
            String s1 = this.fStructureCreator.getContents(o1, ignoreWhiteSpace);
            String s2 = this.fStructureCreator.getContents(o2, ignoreWhiteSpace);
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }
        return false;
    }

    protected void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE")) {
            this.diff();
        } else if (key.equals("COMPARE_FILTERS") && this.getCompareConfiguration().getProperty("COMPARE_FILTERS_INITIALIZING") == null) {
            this.diff();
        } else if (key.equals("ANCESTOR_STRUCTURE_REFRESH")) {
            this.fAncestorStructure.refresh((IProgressMonitor)new NullProgressMonitor());
            this.diff();
        } else if (key.equals("LEFT_STRUCTURE_REFRESH")) {
            this.fLeftStructure.refresh((IProgressMonitor)new NullProgressMonitor());
            this.diff();
        } else if (key.equals("RIGHT_STRUCTURE_REFRESH")) {
            this.fRightStructure.refresh((IProgressMonitor)new NullProgressMonitor());
            this.diff();
        } else if (key.equals("ALL_STRUCTURE_REFRESH")) {
            this.fAncestorStructure.refresh((IProgressMonitor)new NullProgressMonitor());
            this.fLeftStructure.refresh((IProgressMonitor)new NullProgressMonitor());
            this.fRightStructure.refresh((IProgressMonitor)new NullProgressMonitor());
            this.diff();
        } else {
            super.propertyChange(event);
        }
    }

    protected void copySelected(boolean leftToRight) {
        super.copySelected(leftToRight);
        if (this.fStructureCreator != null) {
            this.fStructureCreator.save(leftToRight ? this.fRightStructure.getStructureComparator() : this.fLeftStructure.getStructureComparator(), leftToRight ? this.fRightStructure.getInput() : this.fLeftStructure.getInput());
        }
    }

    private void syncExec(final Runnable runnable) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            this.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!StructureDiffViewer.this.getControl().isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private class StructureInfo {
        private ITypedElement fInput;
        private IStructureComparator fStructureComparator;
        private IRunnableWithProgress refreshTask = new IRunnableWithProgress(this){
            final /* synthetic */ StructureInfo this$1;
            {
                this.this$1 = structureInfo;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                this.this$1.refresh(monitor);
            }
        };

        private StructureInfo() {
        }

        public boolean setInput(ITypedElement newInput, boolean force, IProgressMonitor monitor) {
            boolean changed = false;
            if (force || newInput != this.fInput) {
                this.removeDocumentRangeUpdaters();
                if (this.fInput instanceof IContentChangeNotifier && StructureDiffViewer.this.fContentChangedListener != null) {
                    ((IContentChangeNotifier)((Object)this.fInput)).removeContentChangeListener(StructureDiffViewer.this.fContentChangedListener);
                }
                this.fInput = newInput;
                if (this.fInput == null) {
                    this.dispose();
                    this.fStructureComparator = null;
                } else {
                    this.refresh(monitor);
                    changed = true;
                }
                if (this.fInput instanceof IContentChangeNotifier && StructureDiffViewer.this.fContentChangedListener != null) {
                    ((IContentChangeNotifier)((Object)this.fInput)).addContentChangeListener(StructureDiffViewer.this.fContentChangedListener);
                }
            }
            return changed;
        }

        private void removeDocumentRangeUpdaters() {
            if (this.fStructureComparator instanceof IDocumentRange) {
                IDocument doc = ((IDocumentRange)((Object)this.fStructureComparator)).getDocument();
                try {
                    doc.removePositionCategory("DocumentRangeCategory");
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        public IStructureComparator getStructureComparator() {
            return this.fStructureComparator;
        }

        public void refresh(IProgressMonitor monitor) {
            IStructureComparator oldComparator = this.fStructureComparator;
            this.fStructureComparator = this.createStructure(monitor);
            if (oldComparator instanceof IDisposable) {
                IDisposable disposable = (IDisposable)oldComparator;
                disposable.dispose();
            }
        }

        public Object getInput() {
            return this.fInput;
        }

        private IStructureComparator createStructure(IProgressMonitor monitor) {
            ITypedElement input = this.fInput;
            if (input == null) {
                return null;
            }
            if (StructureDiffViewer.this.fStructureCreator instanceof IStructureCreator2) {
                IStructureCreator2 sc2 = (IStructureCreator2)StructureDiffViewer.this.fStructureCreator;
                try {
                    return sc2.createStructure(input, monitor);
                }
                catch (CoreException e) {
                    CompareUIPlugin.log(e);
                }
            }
            return StructureDiffViewer.this.fStructureCreator.getStructure(input);
        }

        public void dispose() {
            if (this.fStructureComparator != null && StructureDiffViewer.this.fStructureCreator instanceof IStructureCreator2) {
                IStructureCreator2 sc2 = (IStructureCreator2)StructureDiffViewer.this.fStructureCreator;
                sc2.destroy(this.fStructureComparator);
            }
        }

        public IRunnableWithProgress getRefreshTask() {
            return this.refreshTask;
        }
    }
}

