/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.EntityEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityComponentEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class EntityEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        Entity entity = (Entity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(entity.getEntityType().getLabel());
        entityFigure.setIdentifier(entity.getIdentifier().getName());
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> rk : entity.getReusedIdentifieres().entrySet()) {
            for (Identifier identifier : rk.getValue().getIdentifires()) {
                entityFigure.addRelationship(identifier.getName());
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        Entity entity = (Entity)this.getModel();
        EntityEditDialog dialog = new EntityEditDialog(this.getViewer().getControl().getShell(), entity);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, entity, editAttributeList);
            ModelEditCommand command = new ModelEditCommand(entity, dialog.getEditedValueEntity());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }
}

