/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import jp.sourceforge.tmdmaker.dialog.AttributeDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.rule.EntityRecognitionRule;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EntityNameAndTypeSettingPanel
extends Composite {
    private EditAttribute editIdentifier = null;
    private Label identifierLabel = null;
    private Text identifierText = null;
    private Label typeLabel = null;
    private Combo typeCombo = null;
    private Button nameAutoCreateCheckBox = null;
    private Label nameLabel = null;
    private Text nameText = null;
    private Button descButton = null;

    public EntityNameAndTypeSettingPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.nameAutoCreateCheckBox.setSelection(true);
        this.nameText.setEnabled(false);
        this.typeCombo.select(0);
    }

    public void initializeValue(String identifierName, String entityName, EntityType type) {
        this.setIdentifierNameText(identifierName);
        this.setEntityNameText(entityName);
        this.selectEntityTypeCombo(type);
        this.selectAutoCreateCheckBox(identifierName, entityName);
    }

    public void setEntityNameText(String entityName) {
        this.nameText.setText(entityName);
    }

    public void setIdentifierNameText(String identifierName) {
        this.identifierText.setText(identifierName);
    }

    public void selectAutoCreateCheckBox(String identifierName, String entityName) {
        String autoCreateEntityName = this.createEntityName(identifierName);
        if (autoCreateEntityName.equals(entityName)) {
            this.nameAutoCreateCheckBox.setSelection(true);
            this.nameText.setEnabled(false);
        } else {
            this.nameAutoCreateCheckBox.setSelection(false);
            this.nameText.setEnabled(true);
        }
    }

    public void selectEntityTypeCombo(EntityType type) {
        if (EntityType.RESOURCE.equals((Object)type)) {
            this.typeCombo.select(0);
        } else if (EntityType.EVENT.equals((Object)type)) {
            this.typeCombo.select(1);
        } else {
            this.typeCombo.select(2);
        }
    }

    private void initialize() {
        this.identifierLabel = new Label((Composite)this, 0);
        this.identifierLabel.setText("\u500b\u4f53\u6307\u5b9a\u5b50");
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 2;
        gridData10.verticalAlignment = 2;
        GridData gridData9 = new GridData();
        gridData9.horizontalSpan = 2;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = -1;
        gridData.verticalAlignment = 2;
        this.identifierText = new Text((Composite)this, 2048);
        this.identifierText.setLayoutData((Object)gridData);
        this.descButton = new Button((Composite)this, 0);
        this.descButton.setText("\u8a73\u7d30");
        this.descButton.setLayoutData((Object)gridData11);
        this.nameAutoCreateCheckBox = new Button((Composite)this, 32);
        this.nameAutoCreateCheckBox.setText("\u500b\u4f53\u6307\u5b9a\u5b50\u304b\u3089\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u540d\u3092\u81ea\u52d5\u751f\u6210");
        this.nameAutoCreateCheckBox.setLayoutData((Object)gridData9);
        this.typeLabel = new Label((Composite)this, 0);
        this.typeLabel.setText("\u985e\u5225");
        this.typeLabel.setLayoutData((Object)gridData10);
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u540d");
        this.nameText = new Text((Composite)this, 2048);
        this.nameText.setLayoutData((Object)gridData1);
        this.createTypeCombo();
        this.nameAutoCreateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    EntityNameAndTypeSettingPanel.this.nameText.setEnabled(false);
                    EntityNameAndTypeSettingPanel.this.nameText.setText(EntityNameAndTypeSettingPanel.this.createEntityName(EntityNameAndTypeSettingPanel.this.identifierText.getText()));
                } else {
                    EntityNameAndTypeSettingPanel.this.nameText.setEnabled(true);
                }
            }
        });
        this.identifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                EntityNameAndTypeSettingPanel.this.editIdentifier.setName(t.getText());
                if (EntityNameAndTypeSettingPanel.this.nameAutoCreateCheckBox.getSelection()) {
                    EntityNameAndTypeSettingPanel.this.nameText.setText(EntityNameAndTypeSettingPanel.this.createEntityName(t.getText()));
                }
            }
        });
        this.identifierText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                System.out.println("focusLost()");
            }
        });
        this.descButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAttribute edited;
                System.out.println("widgetSelected()");
                AttributeDialog dialog = new AttributeDialog(EntityNameAndTypeSettingPanel.this.getShell(), EntityNameAndTypeSettingPanel.this.editIdentifier);
                if (dialog.open() == 0 && (edited = dialog.getEditedValue()).isEdited()) {
                    EntityNameAndTypeSettingPanel.this.identifierText.setText(edited.getName());
                }
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(358, 78));
    }

    private void createTypeCombo() {
        this.typeCombo = new Combo((Composite)this, 8);
        this.typeCombo.add("\u30ea\u30bd\u30fc\u30b9");
        this.typeCombo.add("\u30a4\u30d9\u30f3\u30c8");
        this.typeCombo.add("\u4e0d\u660e");
    }

    private String createEntityName(String identifierName) {
        return EntityRecognitionRule.generateEntityNameFromIdentifier(identifierName);
    }

    public String getEntityName() {
        return this.nameText.getText();
    }

    public String getIdentifierName() {
        return this.identifierText.getText();
    }

    public EntityType getSelectedType() {
        int selection = this.typeCombo.getSelectionIndex();
        if (selection == 0) {
            return EntityType.RESOURCE;
        }
        if (selection == 1) {
            return EntityType.EVENT;
        }
        return EntityType.LAPUTA;
    }

    public void setEntityTypeComboEnabled(boolean enabled) {
        this.typeCombo.setEnabled(enabled);
    }

    public EditAttribute getEditIdentifier() {
        return this.editIdentifier;
    }

    public void setEditIdentifier(EditAttribute editIdentifier) {
        this.editIdentifier = editIdentifier;
    }
}

