/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.EntityNameAndIdentifierNameAndTypeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.ImplementInfoSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditEntity;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.Identifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EntityEditDialog
extends Dialog
implements PropertyChangeListener {
    private EntityNameAndIdentifierNameAndTypeSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;
    private EditEntity entity;
    private Entity editedValueEntity;

    public EntityEditDialog(Shell parentShell, Entity original) {
        super(parentShell);
        this.entity = new EditEntity(original);
        this.entity.addPropertyChangeListener(this);
    }

    public boolean close() {
        this.entity.removePropertyChangeListener(this);
        return super.close();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_edit_property_attributes")) {
            this.panel2.updateAttributeTable();
        } else if (evt.getPropertyName().equals("_edit_property_up_identifier")) {
            this.panel1.updateValue();
            this.panel2.updateAttributeTable();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new EntityNameAndIdentifierNameAndTypeSettingPanel(composite, 0, this.entity);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.panel3 = new ImplementInfoSettingPanel(composite, 0);
        gridData = new GridData(768);
        this.panel3.setLayoutData(gridData);
        this.panel2 = new AttributeSettingPanel(composite, 0, this.entity);
        gridData = new GridData(768);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeValue();
        return composite;
    }

    private void initializeValue() {
        this.panel3.initializeValue(this.entity.isNotImplement(), this.entity.getImplementName());
    }

    protected void okPressed() {
        this.editedValueEntity = new Entity();
        Identifier newIdentifier = new Identifier();
        this.entity.getEditIdentifier().copyTo(newIdentifier);
        this.editedValueEntity.setIdentifier(newIdentifier);
        this.editedValueEntity.setName(this.entity.getName());
        this.editedValueEntity.setEntityType(this.entity.getType());
        this.editedValueEntity.setNotImplement(this.panel3.isNotImplement());
        this.editedValueEntity.setImplementName(this.panel3.getImplementName());
        this.editedValueEntity.setAttributes(this.entity.getAttributesOrder());
        this.editedValueEntity.setKeyModels(this.entity.getKeyModels());
        this.editedValueEntity.setImplementDerivationModels(this.entity.getImplementDerivationModels());
        super.okPressed();
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.entity.getAttributes();
    }

    public Entity getEditedValueEntity() {
        return this.editedValueEntity;
    }
}

