/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import jp.sourceforge.tmdmaker.generate.Activator;
import jp.sourceforge.tmdmaker.generate.EscapeTool;
import jp.sourceforge.tmdmaker.generate.HtmlGeneratorRuntimeException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;

public class HtmlGeneratorUtils {
    public static void applyTemplate(String templateName, Class<?> clazz, File output, VelocityContext context) throws Exception {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = new InputStreamReader(clazz.getResourceAsStream(templateName), "UTF-8");
        Velocity.evaluate((Context)context, (Writer)writer, (String)templateName, (Reader)reader);
        FileOutputStream out = new FileOutputStream(output);
        out.write(writer.getBuffer().toString().getBytes("UTF-8"));
        HtmlGeneratorUtils.close(out);
        HtmlGeneratorUtils.close(writer);
        HtmlGeneratorUtils.close(reader);
    }

    public static void copyStream(InputStream in, OutputStream out) {
        try {
            try {
                byte[] buf = new byte[in.available()];
                in.read(buf);
                out.write(buf);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            HtmlGeneratorUtils.close(in);
            HtmlGeneratorUtils.close(out);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    public static VelocityContext getVecityContext() {
        Velocity.addProperty((String)"runtime.log.logsystem.class", (Object)NullLogChute.class.getName());
        try {
            Velocity.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HtmlGeneratorRuntimeException(e);
        }
        System.out.println("init");
        VelocityContext context = new VelocityContext();
        context.put("esc", (Object)new EscapeTool());
        return context;
    }

    public static void outputCSS(String rootDir) throws IOException {
        HtmlGeneratorUtils.copyStream(Activator.class.getResourceAsStream("stylesheet.css"), new FileOutputStream(new File(rootDir, "stylesheet.css")));
    }
}

