/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __SIGMAIN_H__
#define __SIGMAIN_H__


#include "tmaid.h"


/******************************************************************************
*                                                                             *
* シグナル/イベント関数群(テキスト)                                           *
*                                                                             *
******************************************************************************/
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data);


/******************************************************************************
*                                                                             *
* シグナル/イベント関数群(メニュー)                                           *
*                                                                             *
******************************************************************************/
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child);
void signal_activate_menu_history(GtkWidget *widget,gchar *file);
void signal_destroy_menu_history(GtkWidget *widget,gchar *file);


/******************************************************************************
*                                                                             *
* シグナル/イベント関数群(ノート)                                             *
*                                                                             *
******************************************************************************/
void signal_clicked(GtkWidget *widget,GtkWidget *child);
void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data);
void signal_destroy_notebook(GtkWidget *widget,gpointer user_data);


/******************************************************************************
*                                                                             *
* シグナル/イベント関数群(セレクション)                                       *
*                                                                             *
******************************************************************************/
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time);
gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
														gpointer user_data);


void
signal_selection_get (GtkWidget        *widget,
                      GtkSelectionData *data,
                      guint             info,
                      guint             time,
                      TmaidWindow      *tmaid);


void
signal_selection_received (GtkWidget        *widget,
                           GtkSelectionData *data,
                           guint time,
                           gpointer user_data);


void
signal_selection_recv (GObject   *object,
                       gchar    **argv,
                       gpointer   user_data);


/******************************************************************************
*                                                                             *
* シグナル/イベント関数群(メイン)                                             *
*                                                                             *
******************************************************************************/
gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data);
void signal_destroy_window(GtkWidget *widget,gpointer user_data);


#endif
