/*
    conf
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_CONF_H__
#define __MISC_CONF_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_CONF            (misc_conf_get_type ())
#define MISC_CONF(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_CONF, MiscConf))
#define MISC_CONF_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_CONF, MiscConfClass))
#define MISC_IS_CONF(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_CONF))
#define MISC_IS_CONF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_CONF))
#define MISC_CONF_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_CONF, MiscConfClass))


typedef struct _MiscConf      MiscConf;
typedef struct _MiscConfClass MiscConfClass;

struct _MiscConf
{
  /*< private >*/
  GtkWindow parent_instance;

  /*< public >*/
  GtkWidget *ok_button;     /* ja:了解 */
  GtkWidget *cancel_button; /* ja:取消 */

  /*< private >*/
  GtkWidget *history_spin;  /* ja:履歴 */
  GtkWidget *newfile_check; /* ja:新規ファイル */
  GtkWidget *second_check;  /* ja:新規ウインドウ */
  GtkWidget *width_spin;    /* ja:ウインドウサイズ */
  GtkWidget *height_spin;   /* ja:ウインドウサイズ */
  GtkWidget *left_radio;    /* ja:ノートブックの位置 */
  GtkWidget *top_radio;     /* ja:ノートブックの位置 */
  GtkWidget *right_radio;   /* ja:ノートブックの位置 */
  GtkWidget *bottom_radio;  /* ja:ノートブックの位置 */
};

struct _MiscConfClass
{
  GtkWindowClass parent_class;

  /* -- signals -- */
  void (*close) (MiscConf *conf);
};


GType
misc_conf_get_type (void) G_GNUC_CONST;


/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget*
misc_conf_new (void);


/*  ja:履歴を設定する
    conf,ウィジェット
     RET,履歴                                                               */
gint
misc_conf_get_history (MiscConf *conf);


/*  ja:新規ファイルを設定する
    conf,ウィジェット
     RET,新規ファイル                                                       */
gboolean
misc_conf_get_newfile (MiscConf *conf);


/*  ja:新規ウインドウを設定する
    conf,ウィジェット
     RET,新規ウインドウ                                                     */
gboolean
misc_conf_get_second (MiscConf *conf);


/*  ja:ウインドウサイズを設定する
      conf,ウィジェット
     width,幅
    height,高さ                                                             */
void
misc_conf_get_size (MiscConf *conf,
                    gint     *width,
                    gint     *height);


/*  ja:ノートブックの位置を設定する
    conf,ウィジェット
     RET,ノートブックの位置                                                 */
GtkPositionType
misc_conf_get_tab (MiscConf *conf);


/*  ja:履歴を設定する
       conf,ウィジェット
    history,履歴                                                            */
void
misc_conf_set_history (MiscConf   *conf,
                       const gint  history);


/*  ja:新規ファイルを設定する
       conf,ウィジェット
    newfile,新規ファイル                                                    */
void
misc_conf_set_newfile (MiscConf       *conf,
                       const gboolean  newfile);


/*  ja:新規ウインドウを設定する
      conf,ウィジェット
    second,新規ウインドウ                                                   */
void
misc_conf_set_second (MiscConf       *conf,
                      const gboolean  second);


/*  ja:ウインドウサイズを設定する
      conf,ウィジェット
     width,幅
    height,高さ                                                             */
void
misc_conf_set_size (MiscConf   *conf,
                    const gint  width,
                    const gint  height);


/*  ja:ノートブックの位置を設定する
     conf,ウィジェット
    n_pos,ノートブックの位置                                                */
void
misc_conf_set_tab (MiscConf              *conf,
                   const GtkPositionType  n_pos);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_CONF_H__ */
