/*
    accel
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "misc_accel.h"


static void misc_accel_class_init (MiscAccelClass *klass);
static void misc_accel_init       (MiscAccel      *accel);
static void misc_accel_dispose    (GObject        *object);


static GObjectClass *parent_class = NULL;


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_accel_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      static const GTypeInfo info =
      {
        sizeof (MiscAccelClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)misc_accel_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (MiscAccel),
        0,              /* n_preallocs */
        (GInstanceInitFunc)misc_accel_init,
      };

      type = g_type_register_static (G_TYPE_OBJECT, "MiscAccel", &info, 0);
    }

  return type;
}


static void
misc_accel_class_init (MiscAccelClass *klass)
{
  GObjectClass *object_class;

  parent_class = g_type_class_peek_parent (klass);
  object_class = (GObjectClass *) klass;

  object_class->dispose = misc_accel_dispose;
}


/*  ja:新規作成
    RET,オブジェクト                                                        */
static void
misc_accel_init (MiscAccel *accel)
{
  accel->handler_destroy   = 0;
  accel->handler_key_press = 0;
  accel->gslist            = NULL;
  accel->window            = NULL;
}


static void
misc_accel_dispose (GObject *object)
{
  MiscAccel *accel = MISC_ACCEL (object);

  if (accel->window)
    {
      if (accel->handler_destroy)
        g_signal_handler_disconnect (G_OBJECT (accel->window),
                                                    accel->handler_destroy);
      if (accel->handler_key_press)
        g_signal_handler_disconnect (G_OBJECT (accel->window),
                                                    accel->handler_key_press);
      accel->window = NULL;
    }
  if (accel->gslist)
    {
      GSList *gslist;

      for (gslist = accel->gslist; gslist; gslist = gslist->next)
        g_object_unref (gslist->data);
      g_slist_free (accel->gslist);
      accel->gslist = NULL;
    }

  if (G_OBJECT_CLASS (parent_class)->dispose)
    G_OBJECT_CLASS (parent_class)->dispose (object);
}


static void
misc_accel_destroy (GtkWidget *widget,
                    MiscAccel *accel)
{
  accel->window = NULL;
}


static gboolean
misc_accel_key_press (GtkWidget   *widget,
                      GdkEventKey *event,
                      MiscAccel   *accel)
{
  gboolean result = FALSE;

  if (accel->gslist)
    {
      GSList *gslist;

      for (gslist = accel->gslist; gslist; gslist = gslist->next)
        gtk_window_add_accel_group (GTK_WINDOW (widget), gslist->data);
      result = gtk_accel_groups_activate (G_OBJECT (widget),
                                                event->keyval, event->state);
      for (gslist = accel->gslist; gslist; gslist = gslist->next)
        gtk_window_remove_accel_group (GTK_WINDOW (widget), gslist->data);
    }
  return result;
}


/*  ja:新規作成
         window,ウインドウ
    accel_group,アクセルグループ
            RET,オブジェクト                                                */
GObject*
misc_accel_new (void)
{
  return g_object_new (MISC_TYPE_ACCEL, NULL);
}


/*  ja:ウインドウを設定する
     accel,オブジェクト
    window,ウインドウ                                                       */
void
misc_accel_set_window (MiscAccel *accel,
                       GtkWindow *window)
{
  if (accel->window)
    {
      if (accel->handler_destroy)
        g_signal_handler_disconnect (G_OBJECT (accel->window),
                                                    accel->handler_destroy);
      if (accel->handler_key_press)
        g_signal_handler_disconnect (G_OBJECT (accel->window),
                                                    accel->handler_key_press);
    }
  accel->window = window;
  if (accel->window)
    {
      accel->handler_destroy = g_signal_connect (G_OBJECT (window),
                "destroy", G_CALLBACK (misc_accel_destroy), accel);
      accel->handler_key_press = g_signal_connect_after (G_OBJECT (window),
                "key-press-event", G_CALLBACK (misc_accel_key_press), accel);
    }
}


/*  ja:アクセルグループを追加する
          accel,オブジェクト
    accel_group,アクセルグループ                                            */
void
misc_accel_add_accel_group (MiscAccel     *accel,
                            GtkAccelGroup *accel_group)
{
  if (accel && accel_group)
    {
      g_object_ref (accel_group);
      accel->gslist = g_slist_append (accel->gslist, accel_group);
    }
}


/*  ja:アクセルグループを削除する
          accel,オブジェクト
    accel_group,アクセルグループ                                            */
void
misc_accel_remove_accel_group (MiscAccel     *accel,
                               GtkAccelGroup *accel_group)
{
  if (accel && accel_group)
    {
      accel->gslist = g_slist_remove (accel->gslist, accel_group);
      g_object_unref (accel_group);
    }
}
