/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "charlist.h"
#include "reload.h"


/******************************************************************************
*                                                                             *
* ɥؿ                                                    *
*                                                                             *
******************************************************************************/
static gboolean reload_clicked_ok;
static GtkWidget *dialog, *button0, *check0, *check1, *combo0, *combo1;


/* OKܥɽ/ɽȽ */
static void
reload_dialog_ok_sensitive (GtkWidget *widget, gpointer user_data)
{
	gtk_widget_set_sensitive (button0,
				charlist_is_valid (gtk_entry_get_text
									(GTK_ENTRY (GTK_COMBO (combo1)->entry))));
}


/* OKܥ󤬲줿 */
static void
reload_dialog_clicked (GtkWidget *widget, FileType *ft)
{
	const gchar *charset;
	GList *glist;

	ft->html = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check0));
	ft->esc = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check1));
	charset = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo0)->entry));
	glist = gtk_container_children (GTK_CONTAINER (GTK_COMBO (combo0)->list));
	for (ft->crlf = g_list_length (glist) - 1; ft->crlf >= 0; ft->crlf--)
		if (g_strcmp (gtk_label_get_text (GTK_LABEL (GTK_BIN
				(g_list_nth_data (glist, ft->crlf))->child)), charset) == 0)
			break;
	g_list_free (glist);
	if (ft->crlf < 0)
		ft->crlf = 0;
	g_free (ft->charset);
	ft->charset = g_strdup (gtk_entry_get_text
									(GTK_ENTRY (GTK_COMBO (combo1)->entry)));
    gtk_widget_destroy (dialog);
	reload_clicked_ok = TRUE;
}


/* ܥܥåǥ꥿󤬲줿 */
static void
reload_dialog_activate (GtkWidget *widget, FileType *ft)
{
	if (GTK_WIDGET_IS_SENSITIVE (button0))
		reload_dialog_clicked (widget, ft);
}


/* ESC줿 */
static gboolean
reload_dialog_key_press (GtkWidget *widget, GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval == GDK_Escape)
		gtk_widget_destroy (widget);
	return FALSE;
}


gboolean
reload_dialog (FileType *ft, const gchar *text)
{
	gchar **charset;
	gint i, j;
	guint key;
	GList *glist;
	GtkAccelGroup *accel;
	GtkWidget *button1, *hbox, *vbox;

	/* ᥤ󥦥ɥ */
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (dialog), _("Reload"));
	g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
								G_CALLBACK (reload_dialog_key_press), NULL);
	g_signal_connect (G_OBJECT (dialog), "destroy",
											G_CALLBACK (gtk_main_quit), NULL);
	/* 졼 */
	accel = gtk_accel_group_new ();
	gtk_window_add_accel_group (GTK_WINDOW (dialog), accel);
	/* ܥ */
	button0 = gtk_button_new_with_label (_("OK"));
	button1 = gtk_button_new_with_label (_("Cancel"));
	if (text != NULL)
	  {
		key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (button0)->child),
																	_("_Yes"));
		gtk_widget_add_accelerator (button0, "clicked",
												accel, key, GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (button1)->child),
																	_("_No"));
		gtk_widget_add_accelerator (button1, "clicked",
												accel, key, GDK_MOD1_MASK, 0);
	  }
	g_signal_connect (G_OBJECT (button0), "clicked",
									G_CALLBACK (reload_dialog_clicked), ft);
	g_signal_connect_swapped (G_OBJECT (button1), "clicked",
						G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
	GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	/* åܥ */
	check0 = gtk_check_button_new_with_label ("");
	check1 = gtk_check_button_new_with_label ("");
	key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (check0)->child),
									_("_HTML Numeric character reference"));
	gtk_widget_add_accelerator (check0, "clicked",
												accel, key, GDK_MOD1_MASK, 0);
	key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (check1)->child),
														_("_Escape sequence"));
	gtk_widget_add_accelerator (check1, "clicked",
												accel, key, GDK_MOD1_MASK, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check0), ft->html);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check1), ft->esc);
	g_signal_connect (G_OBJECT (check0), "toggled",
								G_CALLBACK (reload_dialog_ok_sensitive), NULL);
	g_signal_connect (G_OBJECT (check1), "toggled",
								G_CALLBACK (reload_dialog_ok_sensitive), NULL);
	/* ܥܥå */
	glist = g_list_append (NULL, "CR+LF");
	glist = g_list_append (glist, "CR");
	glist = g_list_append (glist, "LF");
	combo0 = gtk_combo_new();
	gtk_combo_set_popdown_strings (GTK_COMBO (combo0), glist);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo0)->entry),
											g_list_nth_data (glist, ft->crlf));
	gtk_editable_set_editable
							(GTK_EDITABLE (GTK_COMBO (combo0)->entry), FALSE);
	g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "activate",
									G_CALLBACK (reload_dialog_activate), ft);
	g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "changed",
								G_CALLBACK (reload_dialog_ok_sensitive), NULL);
	glist = NULL;
	for (i = 0; i < ftnum; i++)
	  {
		charset = g_strsplit (ftype[i].charset, ",", G_MAXINT);
		for (j = 0; charset[j] != NULL; j++)
			if (g_list_find_custom (glist, charset[j],
										(GCompareFunc)g_strcasecmp) == NULL)
				glist = g_list_insert_sorted (glist, g_strdup (charset[j]),
												(GCompareFunc)g_strcasecmp);
		g_strfreev (charset);
	  }
	if (g_list_find_custom (glist, ft->charset,
										(GCompareFunc)g_strcasecmp) == NULL)
		glist = g_list_insert_sorted (glist, g_strdup (ft->charset),
												(GCompareFunc)g_strcasecmp);
	combo1 = gtk_combo_new();
	gtk_combo_set_popdown_strings (GTK_COMBO (combo1), glist);
	gtk_combo_set_value_in_list (GTK_COMBO (combo1), FALSE, FALSE);
	gtk_combo_set_case_sensitive (GTK_COMBO (combo1), TRUE);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo1)->entry), ft->charset);
	gtk_editable_select_region
							(GTK_EDITABLE (GTK_COMBO (combo1)->entry), 0, -1);
	g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "activate",
									G_CALLBACK (reload_dialog_activate), ft);
	g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "changed",
								G_CALLBACK (reload_dialog_ok_sensitive), NULL);
	for (i = g_list_length (glist) - 1; i >= 0; i--)
		g_free (g_list_nth_data (glist, i));
	/* ե졼ȥܥå */
	hbox = gtk_hbox_new (FALSE, SPACING);
	gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
	vbox = gtk_vbox_new (FALSE, SPACING);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
	if (text != NULL)
		gtk_box_pack_start (GTK_BOX (vbox),
										gtk_label_new (text), FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), combo0, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), combo1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), check0, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), check1, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (dialog), vbox);

	/* ɽ */
	gtk_widget_grab_focus (text == NULL ? button0 : button1);

	reload_clicked_ok = FALSE;

	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
	gtk_grab_add (dialog);
	gtk_widget_show_all (dialog);
	gtk_main ();

	return reload_clicked_ok;
}
