/*
    orzcharset
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __ORZ_CHARSET_H__
#define __ORZ_CHARSET_H__


#include "gcommon.h"
#include "misc/charuty.h"


G_BEGIN_DECLS


#define ORZ_TYPE_CHARSET            (orz_charset_get_type ())
#define ORZ_CHARSET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_CHARSET, OrzCharset))
#define ORZ_CHARSET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_CHARSET, OrzCharsetClass))
#define ORZ_IS_CHARSET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_CHARSET))
#define ORZ_IS_CHARSET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_CHARSET))
#define ORZ_CHARSET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_CHARSET, OrzCharsetClass))


typedef struct _OrzCharset      OrzCharset;
typedef struct _OrzCharsetClass OrzCharsetClass;

struct _OrzCharset
{
  /*< private >*/
#if GTK_CHECK_VERSION(2,4,0)
  GtkComboBoxEntry parent_instance;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  GtkCombo parent_instance;
#endif /* not GTK_CHECK_VERSION(2,4,0) */

  /*< public >*/
};

struct _OrzCharsetClass
{
#if GTK_CHECK_VERSION(2,4,0)
  GtkComboBoxEntryClass parent_class;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  GtkComboClass parent_class;
#endif /* not GTK_CHECK_VERSION(2,4,0) */

  /* -- signals -- */
  void (*activate) (OrzCharset *charlist);
  void (*edited) (OrzCharset *charlist);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_charset_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
orz_charset_new (void);


/*  ja:文字符号化方式を取得する
    charset,ウィジェット
        RET,文字符号化方式                                                  */
gchar *
orz_charset_get_charset (OrzCharset *charset);


/*  ja:文字符号化方式を設定する
    charset,ウィジェット
        str,文字符号化方式
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
orz_charset_set_charset (OrzCharset  *charset,
                         const gchar *str);


/*  ja:文字符号化方式の候補を取得する
    charset,ウィジェット
        RET,文字符号化方式の候補                                            */
gchar *
orz_charset_get_candidate (OrzCharset *charset);


/*  ja:文字符号化方式の候補を追加する
      charset,ウィジェット
    candidate,文字符号化方式の候補
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
orz_charset_add_candidate (OrzCharset  *charset,
                           const gchar *candidate);


/*  ja:文字符号化方式の候補を削除する
      charset,ウィジェット
    candidate,文字符号化方式の候補,NULL:すべて削除
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
orz_charset_remove_candidate (OrzCharset  *charset,
                              const gchar *candidate);


/*  ja:文字符号化方式が正しいか判定する
    charset,ウィジェット
        RET,TRUE:正しい文字符号化方式,FALSE:不正な文字符号化方式            */
gboolean
orz_charset_is_valid (OrzCharset *charset);


G_END_DECLS


#endif /* __ORZ_CHARSET_H__ */
