/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __CHARSET_H__
#define __CHARSET_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define charset_length(ch) (charset_leng[(gint)(guchar)(ch)])
#define CS_BASIC_LATIN                               1
#define CS_LATIN_1_SUPPLEMENT                        2
#define CS_LATIN_EXTENDED_A                          3
#define CS_LATIN_EXTENDED_B                          4
#define CS_IPA_EXTENSIONS                            5
#define CS_SPACING_MODIFIER_LETTERS                  6
#define CS_COMBINING_DIACRITICAL_MARKS               7
#define CS_GREEK_AND_COPTIC                          8
#define CS_CYRILLIC                                  9
#define CS_CYRILLIC_SUPPLEMENTARY                   10
#define CS_ARMENIAN                                 11
#define CS_HEBREW                                   12
#define CS_ARABIC                                   13
#define CS_SYRIAC                                   14
#define CS_THAANA                                   15
#define CS_DEVANAGARI                               16
#define CS_BENGALI                                  17
#define CS_GURMUKHI                                 18
#define CS_GUJARATI                                 19
#define CS_ORIYA                                    20
#define CS_TAMIL                                    21
#define CS_TELUGU                                   22
#define CS_KANNADA                                  23
#define CS_MALAYALAM                                24
#define CS_SINHALA                                  25
#define CS_THAI                                     26
#define CS_LAO                                      27
#define CS_TIBETAN                                  28
#define CS_MYANMAR                                  29
#define CS_GEORGIAN                                 30
#define CS_HANGUL_JAMO                              31
#define CS_ETHIOPIC                                 32
#define CS_CHEROKEE                                 33
#define CS_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS    34
#define CS_OGHAM                                    35
#define CS_RUNIC                                    36
#define CS_TAGALOG                                  37
#define CS_HANUNOO                                  38
#define CS_BUHID                                    39
#define CS_TAGBANWA                                 40
#define CS_KHMER                                    41
#define CS_MONGOLIAN                                42
#define CS_LIMBU                                    43
#define CS_TAI_LE                                   44
#define CS_KHMER_SYMBOLS                            45
#define CS_PHONETIC_EXTENSIONS                      46
#define CS_LATIN_EXTENDED_ADDITIONAL                47
#define CS_GREEK_EXTENDED                           48
#define CS_GENERAL_PUNCTUATION                      49
#define CS_SUPERSCRIPTS_AND_SUBSCRIPTS              50
#define CS_CURRENCY_SYMBOLS                         51
#define CS_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS  52
#define CS_LETTERLIKE_SYMBOLS                       53
#define CS_NUMBER_FORMS                             54
#define CS_ARROWS                                   55
#define CS_MATHEMATICAL_OPERATORS                   56
#define CS_MISCELLANEOUS_TECHNICAL                  57
#define CS_CONTROL_PICTURES                         58
#define CS_OPTICAL_CHARACTER_RECOGNITION            59
#define CS_ENCLOSED_ALPHANUMERICS                   60
#define CS_BOX_DRAWING                              61
#define CS_BLOCK_ELEMENTS                           62
#define CS_GEOMETRIC_SHAPES                         63
#define CS_MISCELLANEOUS_SYMBOLS                    64
#define CS_DINGBATS                                 65
#define CS_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A     66
#define CS_SUPPLEMENTAL_ARROWS_A                    67
#define CS_BRAILLE_PATTERNS                         68
#define CS_SUPPLEMENTAL_ARROWS_B                    69
#define CS_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B     70
#define CS_SUPPLEMENTAL_MATHEMATICAL_OPERATORS      71
#define CS_MISCELLANEOUS_SYMBOLS_AND_ARROWS         72
#define CS_CJK_RADICALS_SUPPLEMENT                  73
#define CS_KANGXI_RADICALS                          74
#define CS_IDEOGRAPHIC_DESCRIPTION_CHARACTERS       75
#define CS_CJK_SYMBOLS_AND_PUNCTUATION              76
#define CS_HIRAGANA                                 77
#define CS_KATAKANA                                 78
#define CS_BOPOMOFO                                 79
#define CS_HANGUL_COMPATIBILITY_JAMO                80
#define CS_KANBUN                                   81
#define CS_BOPOMOFO_EXTENDED                        82
#define CS_KATAKANA_PHONETIC_EXTENSIONS             83
#define CS_ENCLOSED_CJK_LETTERS_AND_MONTHS          84
#define CS_CJK_COMPATIBILITY                        85
#define CS_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A       86
#define CS_YIJING_HEXAGRAM_SYMBOLS                  87
#define CS_CJK_UNIFIED_IDEOGRAPHS                   88
#define CS_YI_SYLLABLES                             89
#define CS_YI_RADICALS                              90
#define CS_HANGUL_SYLLABLES                         91
#define CS_HIGH_SURROGATES                          92
#define CS_HIGH_PRIVATE_USE_SURROGATES              93
#define CS_LOW_SURROGATES                           94
#define CS_PRIVATE_USE_AREA                         95
#define CS_CJK_COMPATIBILITY_IDEOGRAPHS             96
#define CS_ALPHABETIC_PRESENTATION_FORMS            97
#define CS_ARABIC_PRESENTATION_FORMS_A              98
#define CS_VARIATION_SELECTORS                      99
#define CS_COMBINING_HALF_MARKS                    100
#define CS_CJK_COMPATIBILITY_FORMS                 101
#define CS_SMALL_FORM_VARIANTS                     102
#define CS_ARABIC_PRESENTATION_FORMS_B             103
#define CS_HALFWIDTH_AND_FULLWIDTH_FORMS           104
#define CS_SPECIALS                                105
#define CS_LINEAR_B_SYLLABARY                      106
#define CS_LINEAR_B_IDEOGRAMS                      107
#define CS_AEGEAN_NUMBERS                          108
#define CS_OLD_ITALIC                              109
#define CS_GOTHIC                                  110
#define CS_UGARITIC                                111
#define CS_DESERET                                 112
#define CS_SHAVIAN                                 113
#define CS_OSMANYA                                 114
#define CS_CYPRIOT_SYLLABARY                       115
#define CS_BYZANTINE_MUSICAL_SYMBOLS               116
#define CS_MUSICAL_SYMBOLS                         117
#define CS_TAI_XUAN_JING_SYMBOLS                   118
#define CS_MATHEMATICAL_ALPHANUMERIC_SYMBOLS       119
#define CS_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B      120
#define CS_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT 121
#define CS_TAGS                                    122
#define CS_VARIATION_SELECTORS_SUPPLEMENT          123
#define CS_SUPPLEMENTARY_PRIVATE_USE_AREA_A        124
#define CS_SUPPLEMENTARY_PRIVATE_USE_AREA_B        125


extern gsize charset_leng[];
extern guchar charset_space[];


/******************************************************************************
*                                                                             *
* ja:キャラクターセット関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:フォントの幅と高さを取得する
      layout,レイアウト
       width,幅
      height,高さ
    font_buf,バッファ                                                       */
void
charset_size (PangoLayout *layout,
              gint        *width,
              gint        *height,
              guint8      *font_buf);


/*  ja:表示上の半角単位の文字幅を求める
      layout,レイアウト
        text,文字
       width,幅
    font_buf,バッファ
         RET,半角単位                                                       */
gint
charset_width (PangoLayout *layout,
               const gchar *text,
               const gint   width,
               guint8      *font_buf);


/*  ja:文字の種類を返す
    text,文字
     RET,文字の種類                                                         */
gint
charset_block (const gchar *text);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __CHARSET_H__ */
