/*
    license
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __LICENSE_H__
#define __LICENSE_H__


#include "gcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:ライセンス関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:ライセンス表示
    text:ライセンス
     RET,ハッシュ値(ライセンス同意),-1:ライセンス拒否                       */
gint
license_dialog (const gchar *text);


/*  ja:ライセンスのハッシュ値を求める
    RET,ハッシュ値,-1:エラー                                                */
#define license_hash(text) (text?ABS((gint)g_str_hash(text)):-1)


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __LICENSE_H__ */
