/*
    common
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __COMMON_H__
#define __COMMON_H__


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */


#include <stdio.h>
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#elif HAVE_STRINGS_H
# include <strings.h>
#endif /* HAVE_STRINGS_H */
#include <gtk/gtk.h>


#define SPACING 5


#if defined (USE_THREAD) && ! defined (G_THREADS_ENABLED)
# undef USE_THREAD
#endif /* defined (USE_THREAD) && ! defined (G_THREADS_ENABLED) */


#ifdef G_HAVE_GINT64
typedef gint64 goffset;
typedef gint64 glonglong;
typedef guint64 gulonglong;
#else /* not G_HAVE_GINT64 */
typedef gint32 goffset;
typedef gint32 glonglong;
typedef guint32 gulonglong;
#endif /* not G_HAVE_GINT64 */


#define g_strlen(s) ((s)?strlen(s):0)
#define g_strcmp(s1,s2) ((s1)&&(s2)?strcmp(s1,s2):0)
#define g_strncmp(s1,s2,n) ((s1)&&(s2)?strncmp(s1,s2,n):0)
#define g_strchr(s,c) ((s)?strchr(s,c):NULL)
#define g_strrchr(s,c) ((s)?strrchr(s,c):NULL)
#define g_strtok(s,delim) ((delim)?strtok(s,delim):NULL)
#define g_memset(s,c,n) ((s)?memset(s,c,n):(s))
#define g_memcmp(s1,s2,n) ((s1)&&(s2)?memcmp(s1,s2,n):0)
#if GLIB_CHECK_VERSION(2,4,0)
# define g_strcpy(dest,src) g_strlcpy(dest,src,G_MAXSIZE)
# define g_strcat(dest,src) g_strlcat(dest,src,G_MAXSIZE)
#else /* not GLIB_CHECK_VERSION(2,4,0) */
# define g_strcpy(dest,src) g_strlcpy(dest,src,G_MAXINT)
# define g_strcat(dest,src) g_strlcat(dest,src,G_MAXINT)
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
#define g_strncpy(dest,src,n) ((dest)&&(src)?strncpy(dest,src,n):(dest))
#define g_strncat(dest,src,n) ((dest)&&(src)?strncat(dest,src,n):(dest))
#define g_strstr(haystack,needle) g_strstr_len(haystack,g_strlen(haystack),needle)
#ifdef G_OS_WIN32
# define g_strfilecmp(s1,s2) g_ascii_strcasecmp(s1,s2)
# define g_strfilencmp(s1,s2,n) g_ascii_strncasecmp(s1,s2,n)
#else /* not G_OS_WIN32 */
# define g_strfilecmp(s1,s2) g_strcmp(s1,s2)
# define g_strfilencmp(s1,s2,n) g_strncmp(s1,s2,n)
#endif /* not G_OS_WIN32 */


#if GLIB_CHECK_VERSION(2,4,0)
# include <glib/gi18n.h>
#else /* not GLIB_CHECK_VERSION(2,4,0) */
# ifdef ENABLE_NLS
#  include <libintl.h>
#  define _(String) dgettext(PACKAGE,String)
#  ifdef gettext_noop
#   define N_(String) gettext_noop(String)
#  else /* not gettext_noop */
#   define N_(String) (String)
#  endif /* not gettext_noop */
#  define Q_(String) g_strip_context((String),gettext(String))
# else /* not ENABLE_NLS */
#  define _(String) (String)
#  define N_(String) (String)
#  define Q_(String) (String)
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,String) (String)
#  define dcgettext(Domain,String,Type) (String)
#  define bindtextdomain(Domain,Directory) (Domain)
# endif /* not ENABLE_NLS */
#endif /* not GLIB_CHECK_VERSION(2,4,0) */


#if ! GLIB_CHECK_VERSION(2,6,0)
# ifdef G_OS_WIN32
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR||(c)=='/')
# else /* not G_OS_WIN32 */
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR)
# endif /* not G_OS_WIN32 */
#endif /* not GLIB_CHECK_VERSION(2,6,0) */


#endif /* __COMMON_H__ */
