/*
    Text maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "icons.h"


/******************************************************************************
*                                                                             *
* ja:アイコン                                                                 *
*                                                                             *
******************************************************************************/
/* XPM */
const gchar *tmaid16_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"+  c #008000",
"@  c #FF0000",
"#  c #FFFF00",
"       .        ",
"      ...       ",
"     .....      ",
"    .@#@#@.     ",
"   .@#@#@#@.    ",
"  .@#@#@#@#@.   ",
" .@#@..#@#@#@.  ",
" .#@.++..@#@#.  ",
" .@..++++..#..  ",
" ..+.+++++..+.  ",
" .++.+++++.++.  ",
" .++.+++++.++.  ",
" .++.+++++.++.  ",
" .++.+++++.++.  ",
" .++.+++++.++.  ",
" .++.+++++.++.  "};


/* XPM */
const gchar *tmaid24_xpm[] = {
"24 24 5 1",
"   c None",
".  c #000000",
"+  c #008000",
"@  c #FF0000",
"#  c #FFFF00",
"           ..           ",
"          ....          ",
"         ......         ",
"        ........        ",
"       .#@#@#@#@.       ",
"      .#@#@#@#@#@.      ",
"     .#@#@#@#@#@#@.     ",
"    .#@#@#@#@#@#@#@.    ",
"   .#@#@#@#@#@#@#@#@.   ",
"  .#@#@#...#@#@#@#@#@.  ",
"  .@#@#.+++..@#@#@#@#.  ",
"  .#@#..+++++.@#@#@#..  ",
"  ..#.+.++++++..#@#.+.  ",
"  .+.++.++++++++.#.++.  ",
"  .++++.++++++++..+++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  ",
"  .++++.++++++++.++++.  "};


/* XPM */
const gchar *tmaid32_xpm[] = {
"32 32 9 1",
"   c None",
".  c #000000",
"+  c #0000FF",
"@  c #008000",
"#  c #FF0000",
"$  c #FF00FF",
"%  c #00FF00",
"&  c #00FFFF",
"*  c #FFFF00",
"               .                ",
"              ...               ",
"             .....              ",
"            .......             ",
"           .#*#*#*#.            ",
"          .#*#*#*#*#.           ",
"         .#*#*#*#*#*#.          ",
"        .#*#*#*#*#*#*#.         ",
"       .#*#*#*#*#*#*#*#.        ",
"      .#*#*#*#*#*#*#*#*#.       ",
"     .#*#*#*#*#*#*#*#*#*#.      ",
"    .#*#*#*...*#*#*#*#*#...     ",
"   .#*#*#*.@@@.*#*#*#*#.@@@.    ",
"  .#*#*#*.@@@@@.*#*#*#.@@@@@.   ",
"  ..#*#*.@@@@@@@.*#*#..@@@@@.   ",
"  .@.#*..@@@@@@$@.*#.@.@@@@@.   ",
"  .@@..@.@@@@@$$@@..@@.@@@@@.   ",
"  .@@@@@.@@@@$$$@@@@@@.@@@@@.   ",
"  .@@@@@.@@@@$$$@@@@@@.@@@@@.   ",
"  .@@@@@.#@@$$$$++++++.@@@@@.   ",
"  .@@@@@.###$$$$+++++@.@@@@@.   ",
"  .@@@@@.@####$$+++&@@.@@@@@.   ",
"  .@@@@@.@#####$+&&&@@.@@@@@.   ",
"  .@@@@@.@@###*%&&&&&@.@@@@@.   ",
"  .@@@@@.@@#***%%&&&&@.@@@@@.   ",
"  .@@@@@.@*****%%%%&&&.@@@@@.   ",
"  .@@@@@.******%%%%@@&.@@@@@.   ",
"  .@@@@@.@@@@@@%%%@@@@.@@@@@.   ",
"  .@@@@@.@@@@@@%%%@@@@.@@@@@.   ",
"  .@@@@@.@@@@@@%%@@@@@.@@@@@.   ",
"  .@@@@@.@@@@@@%@@@@@@.@@@@@.   ",
"  .@@@@@.@@@@@@@@@@@@@.@@@@@.   "};


/* XPM */
const gchar *tmaid48_xpm[] = {
"48 48 9 1",
"   c None",
".  c #000000",
"+  c #0000FF",
"@  c #008000",
"#  c #FF0000",
"$  c #FF00FF",
"%  c #00FF00",
"&  c #00FFFF",
"*  c #FFFF00",
"                      ..                        ",
"                     ....                       ",
"                    ......                      ",
"                   ........                     ",
"                  ..........                    ",
"                 ............                   ",
"                .#*#*#*#*#*#*.                  ",
"               .#*#*#*#*#*#*#*.                 ",
"              .#*#*#*#*#*#*#*#*.                ",
"             .#*#*#*#*#*#*#*#*#*.               ",
"            .#*#*#*#*#*#*#*#*#*#*.              ",
"           .#*#*#*#*#*#*#*#*#*#*#*.             ",
"          .#*#*#*#*#*#*#*#*#*#*#*#*.            ",
"         .#*#*#*#*#*#*#*#*#*#*#*#*#*.           ",
"        .#*#*#*#*#*#*#*#*#*#*#*#*#*#*.          ",
"       .#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*.         ",
"      .#*#*#*#*#*...*#*#*#*#*#*#*#*#*.@.        ",
"     .#*#*#*#*#*.@@@.*#*#*#*#*#*#*#*.@@@.       ",
"    .#*#*#*#*#*.@@@@@.*#*#*#*#*#*#*.@@@@@.      ",
"   .#*#*#*#*#*.@@@@@@@.*#*#*#*#*#*.@@@@@@@.     ",
"   .*#*#*#*#*.@@@@@@@@@.*#*#*#*#*.@@@@@@@@.     ",
"   ..*#*#*#*.@@@@@@@@@@@.*#*#*#*..@@@@@@@@.     ",
"   .@.*#*#*..@@@@@@@@@@$@.*#*#*.@.@@@@@@@@.     ",
"   .@@.*#*.@.@@@@@@@@@$$@@.*#*.@@.@@@@@@@@.     ",
"   .@@@...@@.@@@@@@@@@$$@@@...@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@$$$@@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@$$$$@@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.#@@@@@$$$$$+++++++++.@@@@@@@@.     ",
"   .@@@@@@@@.###@@@$$$$$++++++++@.@@@@@@@@.     ",
"   .@@@@@@@@.@###@$$$$$$++++++@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@#####$$$$$+++++@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@#####$$$$+++&&@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@#######$$++&&&&@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@########$&&&&&&@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@######%&&&&&&&&@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@####**%%&&&&&&&@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@##***%%%%&&&&&@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@*****%%%%%%&&&&@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@******%%%%%%@&&&@.@@@@@@@@.     ",
"   .@@@@@@@@.@********%%%%%@@@&&&.@@@@@@@@.     ",
"   .@@@@@@@@.*********%%%%%@@@@@&.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@%%%%@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@%%%@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@%%@@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@%%@@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@%@@@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@@@@@@@@@@@@.@@@@@@@@.     ",
"   .@@@@@@@@.@@@@@@@@@@@@@@@@@@@@.@@@@@@@@.     "};


/* XPM */
const gchar *return16_xpm[] = {
"16 16 119 2",
"   c None",
".  c #000000",
"+  c #BFBFBF",
"@  c #F5F5F5",
"#  c #F6F6F6",
"$  c #F7F7F7",
"%  c #F8F8F8",
"&  c #F9F9F9",
"*  c #B9B9B9",
"=  c #E1E1E1",
"-  c #E2E2E2",
";  c #E3E3E3",
">  c #E4E4E4",
",  c #E5E5E5",
"'  c #E7E7E7",
")  c #E8E8E8",
"!  c #E9E9E9",
"~  c #EAEAEA",
"{  c #EBEBEB",
"]  c #EDEDED",
"^  c #EEEEEE",
"/  c #EFEFEF",
"(  c #6D6D6D",
"_  c #6E6E6E",
":  c #6F6F6F",
"<  c #707070",
"[  c #717171",
"}  c #727272",
"|  c #F0F0F0",
"1  c #A2A2A2",
"2  c #5A5A5A",
"3  c #2C2C2C",
"4  c #989795",
"5  c #F1F1F1",
"6  c #575757",
"7  c #323232",
"8  c #B3B1B0",
"9  c #EEECEB",
"0  c #F0DCAA",
"a  c #E5C470",
"b  c #DFB84F",
"c  c #8A681F",
"d  c #292824",
"e  c #D5D5D4",
"f  c #B1B1B1",
"g  c #3C3C3C",
"h  c #EEECE9",
"i  c #E6D498",
"j  c #EED682",
"k  c #EED680",
"l  c #E3C15E",
"m  c #D29815",
"n  c #976E15",
"o  c #7F5B0A",
"p  c #696761",
"q  c #E5E5E4",
"r  c #464646",
"s  c #EBE9E5",
"t  c #CBB771",
"u  c #735817",
"v  c #C6A546",
"w  c #E3C05D",
"x  c #BC8710",
"y  c #AD7C10",
"z  c #3C3931",
"A  c #DAD9D8",
"B  c #010100",
"C  c #F4F4F4",
"D  c #AE9C5C",
"E  c #BEBDBA",
"F  c #C4C3C0",
"G  c #C6C5C3",
"H  c #91908E",
"I  c #9C7E2B",
"J  c #AB7C12",
"K  c #2F2B1E",
"L  c #D3D3D1",
"M  c #010101",
"N  c #DADAD9",
"O  c #61605E",
"P  c #656462",
"Q  c #696967",
"R  c #6C6B6A",
"S  c #6B6A69",
"T  c #3D351F",
"U  c #A37819",
"V  c #231F13",
"W  c #D0CFCD",
"X  c #020201",
"Y  c #E3E2E2",
"Z  c #D3D2D1",
"`  c #DDDDDC",
" . c #0B0B06",
".. c #A97C1A",
"+. c #6F6F6E",
"@. c #70706F",
"#. c #221E11",
"$. c #EAE8E3",
"%. c #C58F13",
"&. c #B68411",
"*. c #826321",
"=. c #302C19",
"-. c #E6E6E5",
";. c #363220",
">. c #916F25",
",. c #322F1E",
"'. c #070603",
"). c #BEBEBE",
"!. c #EBEBEA",
"~. c #E0E0DF",
"{. c #2B2719",
"]. c #353120",
"^. c #9B9A97",
"/. c #0A0905",
"(. c #030201",
"_. c #937025",
":. c #19160D",
"<. c #0B0905",
"[. c #2F2C19",
"  . . . . . . . . . . . . .     ",
"  + @ @ # # # # $ $ % % & & *   ",
". @ = - ; > , ' ) ! ~ { ] ^ / . ",
". @ - ( ( _ : : < < [ } } / | . ",
". # ; > , 1 2 3 . . . 4 / | 5 . ",
". # > 6 7 8 9 0 a b c . d e ] . ",
". # f g h i j k k l m n o p q . ",
". @ r s t . . . u v w x y z A B ",
". C . D 3 E F G H I k m J K L M ",
". # N M O P Q R S T k m U V W X ",
". % ~ Y Z `  .. . . k m ... . . ",
". & ] } +.@.#.$.k k k m %.&.*.=.",
". & ^ / { ' -.;.$.k k m m >.,.'.",
". )./ | 5 / !.~.{.$.k m >.].^./.",
"    . . . . . . (.=.$._.,.:.<.  ",
"                    =.[.        "};


/* XPM */
const gchar *return24_xpm[] = {
"24 24 118 2",
"   c None",
".  c #000000",
"+  c #E2E2E2",
"@  c #F2F2F2",
"#  c #F3F3F3",
"$  c #F4F4F4",
"%  c #F5F5F5",
"&  c #F6F6F6",
"*  c #F7F7F7",
"=  c #DBDBDB",
"-  c #F0F0F0",
";  c #E0E0E0",
">  c #E1E1E1",
",  c #E3E3E3",
"'  c #E4E4E4",
")  c #E5E5E5",
"!  c #E6E6E6",
"~  c #E7E7E7",
"{  c #E8E8E8",
"]  c #E9E9E9",
"^  c #EAEAEA",
"/  c #EBEBEB",
"(  c #ECECEC",
"_  c #EDEDED",
":  c #EEEEEE",
"<  c #EFEFEF",
"[  c #868686",
"}  c #878787",
"|  c #888888",
"1  c #898989",
"2  c #8A8A8A",
"3  c #8B8B8B",
"4  c #8C8C8C",
"5  c #8D8D8D",
"6  c #8E8E8E",
"7  c #F1F1F1",
"8  c #8F8F8F",
"9  c #909090",
"0  c #919191",
"a  c #929292",
"b  c #F8F8F8",
"c  c #939393",
"d  c #F9F9F9",
"e  c #ABABAB",
"f  c #606060",
"g  c #2F2F2F",
"h  c #9F9E9D",
"i  c #FAFAFA",
"j  c #727272",
"k  c #404040",
"l  c #B3B1B0",
"m  c #EEECEB",
"n  c #F0DCAA",
"o  c #E5C470",
"p  c #DFB84F",
"q  c #8A681F",
"r  c #4D4B47",
"s  c #010100",
"t  c #BDBDBD",
"u  c #3E3E3E",
"v  c #EEECE9",
"w  c #E6D498",
"x  c #EED682",
"y  c #EED680",
"z  c #E3C15E",
"A  c #D29815",
"B  c #976E15",
"C  c #7F5B0A",
"D  c #110F09",
"E  c #2C2C2C",
"F  c #EBE9E5",
"G  c #CBB771",
"H  c #735817",
"I  c #C6A546",
"J  c #E3C05D",
"K  c #BC8710",
"L  c #AD7C10",
"M  c #17150C",
"N  c #3A3A3A",
"O  c #AE9C5C",
"P  c #2F2F2E",
"Q  c #CAC9C6",
"R  c #CFCECC",
"S  c #D0D0CE",
"T  c #989796",
"U  c #9C7E2B",
"V  c #AB7C12",
"W  c #221E11",
"X  c #434343",
"Y  c #7E7D7B",
"Z  c #828280",
"`  c #8A8988",
" . c #8C8B8A",
".. c #8A8A89",
"+. c #3D351F",
"@. c #A37819",
"#. c #231F13",
"$. c #EDECEC",
"%. c #EAEAE9",
"&. c #0B0B06",
"*. c #A97C1A",
"=. c #C9C9C9",
"-. c #FBFBFB",
";. c #FCFCFC",
">. c #231F12",
",. c #EAE8E3",
"'. c #C58F13",
"). c #B68411",
"!. c #826321",
"~. c #302C19",
"{. c #010000",
"]. c #363220",
"^. c #916F25",
"/. c #322F1E",
"(. c #2B2719",
"_. c #353120",
":. c #937025",
"<. c #2F2C19",
"  . . . . . . . . . . . . . . . . . . . .       ",
". + @ @ @ @ # # # $ $ $ % % % & & * * $ = .     ",
". - ; ; > + , ' ) ! ~ { { ] ^ / ( _ : < _ .     ",
". @ > [ [ } } | 1 1 2 2 3 3 4 4 5 5 6 - 7 .     ",
". @ + , , ' ) ! ~ { ] ^ / ( ( _ : < - 7 @ .     ",
". # , } | | 1 1 2 2 3 4 4 5 5 5 6 8 8 @ # .     ",
". # ' ) ! ~ ~ { ] ^ / ( _ : < < - 7 @ # $ .     ",
". # ) 1 1 2 2 2 3 4 4 5 5 6 8 8 8 9 9 $ % .     ",
". $ ! ~ { ] ^ ^ / ( _ : < - 7 @ # # $ % & .     ",
". $ ~ 2 2 3 4 4 4 5 5 6 8 8 9 9 0 a a & * .     ",
". % { ] ^ / ( _ : : < - 7 @ # $ % & * * b .     ",
". % ] 3 4 4 5 5 6 8 8 8 9 9 0 a a c c b d .     ",
". % ^ / ( _ : < - 7 @ @ # e f g . . . h i .     ",
". & / 4 5 5 6 8 8 9 9 j k l m n o p q . r s     ",
". * _ _ : < - 7 @ # t u v w x y y z A B C D     ",
". * : 6 6 8 8 9 9 9 E F G . . . H I J K L M     ",
". b - 7 @ @ # $ % & N O P Q R S T U y A V W     ",
". b 7 9 9 0 0 a a c a X Y Z `  ...+.y A @.#.    ",
". @ @ # $ % & & * b d i $.%.&.. . . y A *.. . . ",
". =._ b % & * b b d i -.;.d >.,.y y y A '.).!.~.",
"  . . . . . . . . . . . . . {.].,.y y A A ^./.  ",
"                                (.,.y A ^._.    ",
"                                  ~.,.:./.      ",
"                                    ~.<.        "};


/* XPM */
const gchar *tab16_xpm[] = {
"16 16 55 1",
"   c None",
".  c #000000",
"+  c #BFBFBF",
"@  c #F5F5F5",
"#  c #F6F6F6",
"$  c #F7F7F7",
"%  c #F8F8F8",
"&  c #F9F9F9",
"*  c #B9B9B9",
"=  c #E1E1E1",
"-  c #E2E2E2",
";  c #E3E3E3",
">  c #E4E4E4",
",  c #E5E5E5",
"'  c #A8A8A8",
")  c #E8E8E8",
"!  c #E9E9E9",
"~  c #EAEAEA",
"{  c #EBEBEB",
"]  c #EDEDED",
"^  c #EEEEEE",
"/  c #EFEFEF",
"(  c #A4A4A4",
"_  c #A5A5A5",
":  c #A6A6A6",
"<  c #A7A7A7",
"[  c #A9A9A9",
"}  c #AAAAAA",
"|  c #ABABAB",
"1  c #ACACAC",
"2  c #ADADAD",
"3  c #AEAEAE",
"4  c #F0F0F0",
"5  c #E7E7E7",
"6  c #F1F1F1",
"7  c #757575",
"8  c #767676",
"9  c #777777",
"0  c #787878",
"a  c #F3F3F3",
"b  c #F4F4F4",
"c  c #797979",
"d  c #7A7A7A",
"e  c #AFAFAF",
"f  c #B1B1B1",
"g  c #B2B2B2",
"h  c #B3B3B3",
"i  c #B4B4B4",
"j  c #B5B5B5",
"k  c #B6B6B6",
"l  c #FBFBFB",
"m  c #FAFAFA",
"n  c #FCFCFC",
"o  c #BEBEBE",
"p  c #C1C1C1",
" .............  ",
" +@@####$$%%&&* ",
".@=-;>,')!~{]^/.",
".@(_:<'[[}|1234.",
".#;>,5)!~{]^/46.",
".#>,5)!7789900a.",
".#,5)!~{]^/46ab.",
".#....{89900cd@.",
".$)!~{]^/46ab@#.",
".$!~{]^900cb@#$.",
".%~{]^/46ab@#$&.",
".&123eeffghijkl.",
".&^/46af@#$&mln.",
".o/46ab@#$&mlnp ",
"  ............  ",
"                "};


/* XPM */
const gchar *tab24_xpm[] = {
"24 24 68 1",
"   c None",
".  c #000000",
"+  c #E2E2E2",
"@  c #F2F2F2",
"#  c #F3F3F3",
"$  c #F4F4F4",
"%  c #F5F5F5",
"&  c #F6F6F6",
"*  c #F7F7F7",
"=  c #DBDBDB",
"-  c #F0F0F0",
";  c #E0E0E0",
">  c #E1E1E1",
",  c #E3E3E3",
"'  c #E4E4E4",
")  c #E5E5E5",
"!  c #AEAEAE",
"~  c #E7E7E7",
"{  c #E8E8E8",
"]  c #E9E9E9",
"^  c #EAEAEA",
"/  c #EBEBEB",
"(  c #ECECEC",
"_  c #EDEDED",
":  c #EEEEEE",
"<  c #EFEFEF",
"[  c #E6E6E6",
"}  c #ACACAC",
"|  c #ADADAD",
"1  c #AFAFAF",
"2  c #B0B0B0",
"3  c #B1B1B1",
"4  c #B2B2B2",
"5  c #B3B3B3",
"6  c #B4B4B4",
"7  c #B5B5B5",
"8  c #B6B6B6",
"9  c #F1F1F1",
"0  c #757575",
"a  c #767676",
"b  c #777777",
"c  c #787878",
"d  c #797979",
"e  c #7A7A7A",
"f  c #7B7B7B",
"g  c #7C7C7C",
"h  c #F8F8F8",
"i  c #F9F9F9",
"j  c #FAFAFA",
"k  c #FBFBFB",
"l  c #FCFCFC",
"m  c #FDFDFD",
"n  c #B7B7B7",
"o  c #B8B8B8",
"p  c #B9B9B9",
"q  c #BABABA",
"r  c #BBBBBB",
"s  c #BCBCBC",
"t  c #BDBDBD",
"u  c #BEBEBE",
"v  c #BFBFBF",
"w  c #C0C0C0",
"x  c #C1C1C1",
"y  c #FFFFFF",
"z  c #FEFEFE",
"A  c #D9D9D9",
"B  c #C9C9C9",
"C  c #DADADA",
" ....................   ",
".+@@@@###$$$%%%&&**$=.  ",
".-;;>+,')!~{{]^/(_:<,.  ",
".@>>+,')[~{]^^/(_:<-~.  ",
".@+}}|!!123445567789{.  ",
".#,'))[~{]^/(__:<-9@].  ",
".#')[~~{]^/(_:<<-9@#^.  ",
".#)[~{]]^0aabbcccdd$/.  ",
".$[~{]^^/(_:<-9@##$%(.  ",
".$~{]^/((abbccddeee&_.  ",
".%......::<-9@#$%&**:.  ",
".%]^/(_:<cccddeeffgh<.  ",
".%^/(_:<-9@@#$%&*hij-.  ",
".&/(_:<-9ddeee&*hijk@.  ",
".*__:<-9@#$%%&*hijkl#.  ",
".*:<<-9@#$%&**hijklm$.  ",
".h-nooopqrrstuuuvwxy%.  ",
".h9@#$$%&*hijklmmzyy%.  ",
".@@#$%&&*sijklmzyyyyA.  ",
".BC:/(_::<-9@#$%%%%'t.  ",
" ....................   ",
"                        ",
"                        ",
"                        "};


/* XPM */
const gchar *character16_xpm[] = {
"16 16 57 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #C3C3C3",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #ADADAD",
";  c #767676",
">  c #5D5D5D",
",  c #404040",
"'  c #F0F0F0",
")  c #E2E2E2",
"!  c #858585",
"~  c #4B4B49",
"{  c #FBE73B",
"]  c #F2B64D",
"^  c #CACACA",
"/  c #EFEFEF",
"(  c #C9C9C9",
"_  c #FCEB3D",
":  c #F7B544",
"<  c #61542E",
"[  c #EEEEEE",
"}  c #FCE93B",
"|  c #F7B545",
"1  c #6C5F34",
"2  c #F9DF39",
"3  c #F4B244",
"4  c #665D3E",
"5  c #EDEDED",
"6  c #ECECEC",
"7  c #EBEBEB",
"8  c #F6D236",
"9  c #EFB44D",
"0  c #5C4F2B",
"a  c #E8E8E8",
"b  c #D7AE74",
"c  c #655930",
"d  c #C0C0C0",
"e  c #EAEAEA",
"f  c #4F4115",
"g  c #E7E7E7",
"h  c #BFBFBF",
"i  c #C2C2C2",
"j  c #E6E6E6",
"k  c #E5E5E5",
"l  c #BEBEBE",
"m  c #E4E4E4",
"n  c #BDBDBD",
"o  c #E3E3E3",
"p  c #BBBBBB",
"q  c #BCBCBC",
"r  c #A0A0A0",
"  .........     ",
" .+...++@#$.    ",
" ...%..%%&*=.   ",
" ......%%-;>,.. ",
" ...%..%')!~.{].",
" ...^..^/^(._:<.",
" .+///[[[[.}|1. ",
" .@[.([((.234.  ",
" .@56667.890..  ",
" ......a.bc.d.  ",
" .@e....f..gh.  ",
" .@...i..jjkl.  ",
" ....jjjkkmmn.  ",
" ......mmooop.  ",
" .innnqqppppr.  ",
"  ...........   "};


/* XPM */
const gchar *character24_xpm[] = {
"24 24 172 2",
"   c None",
".  c #000000",
"+  c #0E0E0E",
"@  c #282828",
"#  c #616161",
"$  c #D3D3D3",
"%  c #F6F6F6",
"&  c #FFFFFF",
"*  c #F9F9F9",
"=  c #F9F9F8",
"-  c #E7E7E7",
";  c #E4E4E4",
">  c #CDCDCD",
",  c #1F1F1F",
"'  c #EFEFEE",
")  c #AFAFAE",
"!  c #E9E9E9",
"~  c #B3B3B3",
"{  c #383838",
"]  c #C2C2C2",
"^  c #C1C1C1",
"/  c #C0C0C0",
"(  c #BDBDBC",
"_  c #B5B5B5",
":  c #A4A4A3",
"<  c #F0F0F0",
"[  c #F4F4F4",
"}  c #ABABAB",
"|  c #050505",
"1  c #FCFCFB",
"2  c #FDFDFD",
"3  c #FBFBFB",
"4  c #F2F2F2",
"5  c #9E9E9E",
"6  c #BEBEBD",
"7  c #BEBEBE",
"8  c #B9B9B9",
"9  c #A1A1A0",
"0  c #B9B7B6",
"a  c #828280",
"b  c #FBE73B",
"c  c #F2B64D",
"d  c #F8F8F7",
"e  c #F8F7F6",
"f  c #F3F2F1",
"g  c #E0E0DF",
"h  c #DBD9D7",
"i  c #FCEB3D",
"j  c #F7B544",
"k  c #5D502B",
"l  c #BCBCBB",
"m  c #BCBBBB",
"n  c #BBBBBA",
"o  c #BBBBB9",
"p  c #B9B8B8",
"q  c #B7B6B5",
"r  c #B5B4B3",
"s  c #FCE93B",
"t  c #F7B545",
"u  c #6C5F34",
"v  c #FAFAF9",
"w  c #F7F6F5",
"x  c #F6F6F4",
"y  c #F5F4F3",
"z  c #F4F3F2",
"A  c #FAE43A",
"B  c #F4B244",
"C  c #615738",
"D  c #BAB9B8",
"E  c #B8B8B7",
"F  c #B8B8B6",
"G  c #B4B4B3",
"H  c #F9DF39",
"I  c #F3AF42",
"J  c #5D5232",
"K  c #6F6B63",
"L  c #F6F5F4",
"M  c #F5F5F3",
"N  c #F3F3F1",
"O  c #F2F2F0",
"P  c #F1F1EF",
"Q  c #F0EFED",
"R  c #F9DC38",
"S  c #EFB44D",
"T  c #665A32",
"U  c #9B9997",
"V  c #7C786F",
"W  c #B5B5B4",
"X  c #B6B5B4",
"Y  c #F8D837",
"Z  c #F0A93F",
"`  c #655930",
" . c #767673",
".. c #ADACA9",
"+. c #908A81",
"@. c #EFEFED",
"#. c #F1F0EE",
"$. c #F6D236",
"%. c #EDA43E",
"&. c #5B5230",
"*. c #9B9A98",
"=. c #ADACAA",
"-. c #C6C4C2",
";. c #9E998E",
">. c #F0F0EE",
",. c #B5B5B3",
"'. c #B5B4B2",
"). c #B4B3B2",
"!. c #B3B2B1",
"~. c #AEADAC",
"{. c #D7AE74",
"]. c #61562F",
"^. c #757473",
"/. c #9A9A97",
"(. c #DAD9D5",
"_. c #9F9A8E",
":. c #E6E5E2",
"<. c #4F4115",
"[. c #ADABA9",
"}. c #B9B8B5",
"|. c #D1D0CD",
"1. c #D8D7D3",
"2. c #DBDAD6",
"3. c #A19B90",
"4. c #EBEAE8",
"5. c #B1B0AE",
"6. c #A8A7A5",
"7. c #C1C0BD",
"8. c #C2C2BE",
"9. c #CECDC9",
"0. c #D2D1CE",
"a. c #DCDBD7",
"b. c #E7E6E3",
"c. c #E4E2DF",
"d. c #E0DFDB",
"e. c #DDDBD9",
"f. c #DEDDD9",
"g. c #D5D4D1",
"h. c #D9D8D4",
"i. c #DBD9D5",
"j. c #D9D7D3",
"k. c #9F998D",
"l. c #E4E3E0",
"m. c #E4E3DF",
"n. c #DDDCD8",
"o. c #DCDAD6",
"p. c #D8D6D2",
"q. c #9E988D",
"r. c #EDEDED",
"s. c #E2E1DD",
"t. c #DFDEDA",
"u. c #DEDCD8",
"v. c #D8D6D1",
"w. c #D7D5D1",
"x. c #9D978B",
"y. c #D1D1D1",
"z. c #DFDDD9",
"A. c #DDDBD7",
"B. c #D7D6D1",
"C. c #D5D3CE",
"D. c #9B958A",
"E. c #999891",
"F. c #A39E92",
"G. c #A49E93",
"H. c #A39D92",
"I. c #A39D91",
"J. c #A19C90",
"K. c #A29C90",
"L. c #A19B8F",
"M. c #9D978C",
"N. c #9B968A",
"O. c #676359",
"                                                ",
"      . . . . . . . . . . . . . + @ #           ",
"    . $ % . . . . & & & & * = = - ; > ,         ",
"    . % . . & & . . & & & & = ' ) ! & ~ {       ",
"    . & . . ] ] . . ^ ] ^ / ( _ : < & [ } |     ",
"    . & . . . . . . 1 2 1 3 = 4 5 . . . . .     ",
"    . & . . ^ / . . 6 7 6 ( ( 8 9 0 a . b c .   ",
"    . & . . 1 3 . . d = d e = f g h . i j k .   ",
"    . & 1 7 6 ( l m n m n o p q r . s t u .     ",
"    . & v = . . w x y x y z z f . A B C . .     ",
"    . & d m . . D p E p E F G . H I J . K .     ",
"    . & L M z z N O P O P Q . R S T . U V .     ",
"    . & z E . . W q X q r . Y Z ` .  ...+..     ",
"    . & z f . . @.#.Q Q . $.%.&.. *.=.-.;..     ",
"    . & >.W W ,.'.).!.~.. {.].. ^.a /.(._..     ",
"    . & . . . . . . :.. <.. . [.}.|.1.2.3..     ",
"    . & 4.5.5.. . . 6.. . 7.8.9.0.1.2.a.3..     ",
"    . & b.:.. . . c.d.e.f.g.(.h.2.(.i.j.k..     ",
"    . * l.. . . m.d.f.(.1.(.n.a.o.o.j.p.q..     ",
"    . r.. . . d.s.t.t.2.a.n.u.o.o.j.v.w.x..     ",
"    . y.. . . . . . z.a.u.A.u.o.o.p.B.C.D..     ",
"    . E.F.G.H.I.H.J.K.J.K.L.3.k.k.M.M.N.O..     ",
"      . . . . . . . . . . . . . . . . . .       ",
"                                                "};


#if ! GTK_CHECK_VERSION(2,10,0)
/* XPM */
const gchar *select_all16_xpm[] = {
"16 16 42 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #C3C3C3",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #494066",
";  c #ADADAD",
">  c #767676",
",  c #5D5D5D",
"'  c #404040",
")  c #FFFFFF",
"!  c #E2E2E2",
"~  c #858585",
"{  c #4B4B49",
"]  c #161616",
"^  c #EEEEEE",
"/  c #C5C5C5",
"(  c #EFEFEF",
"_  c #ECECEC",
":  c #C4C4C4",
"<  c #EBEBEB",
"[  c #EDEDED",
"}  c #EAEAEA",
"|  c #E8E8E8",
"1  c #C0C0C0",
"2  c #E7E7E7",
"3  c #BFBFBF",
"4  c #E5E5E5",
"5  c #BEBEBE",
"6  c #E6E6E6",
"7  c #E4E4E4",
"8  c #BDBDBD",
"9  c #E3E3E3",
"0  c #BBBBBB",
"a  c #C2C2C2",
"b  c #BCBCBC",
"c  c #A0A0A0",
"  .........     ",
" .++++++@#$.    ",
" .+%%%%%%&*=.   ",
" .+%-----;>,'.  ",
" .+%-)))-!~{].  ",
" .+%-------^/.  ",
" .+(-)-)))-_:.  ",
" .@^-------<&.  ",
" .@[-))-))-}$.  ",
" .@<-------|1.  ",
" .@}-)-)))-23.  ",
" .@|-------45.  ",
" .@2266644778.  ",
" .@6444779990.  ",
" .a888bb0000c.  ",
"  ...........   "};


/* XPM */
const gchar *select_all24_xpm[] = {
"24 24 91 1",
"   c None",
".  c #000000",
"+  c #0E0E0E",
"@  c #282828",
"#  c #616161",
"$  c #D3D3D3",
"%  c #F6F6F6",
"&  c #FFFFFF",
"*  c #F9F9F9",
"=  c #F9F9F8",
"-  c #E7E7E7",
";  c #E4E4E4",
">  c #CDCDCD",
",  c #1F1F1F",
"'  c #EFEFEE",
")  c #AFAFAE",
"!  c #E9E9E9",
"~  c #B3B3B3",
"{  c #383838",
"]  c #494066",
"^  c #EEEEEE",
"/  c #A4A4A3",
"(  c #F0F0F0",
"_  c #F4F4F4",
":  c #ABABAB",
"<  c #050505",
"[  c #F2F2F2",
"}  c #9E9E9E",
"|  c #D4D4D3",
"1  c #B9B7B6",
"2  c #838381",
"3  c #848381",
"4  c #6A6763",
"5  c #FEFEFE",
"6  c #F3F2F1",
"7  c #E0E0DF",
"8  c #DCDAD8",
"9  c #CACAC8",
"0  c #B6B6B4",
"a  c #72706C",
"b  c #FCFCFB",
"c  c #C4C3C0",
"d  c #817D74",
"e  c #FAFAF9",
"f  c #E1DFDC",
"g  c #8B867D",
"h  c #F8F8F7",
"i  c #A49E93",
"j  c #F6F5F4",
"k  c #F4F3F2",
"l  c #F0F0EE",
"m  c #E0DFDB",
"n  c #A19C90",
"o  c #EDEDEB",
"p  c #DDDCD8",
"q  c #A19B90",
"r  c #EBEAE8",
"s  c #DCDBD7",
"t  c #E7E6E3",
"u  c #D9D7D3",
"v  c #9F998D",
"w  c #E4E3E0",
"x  c #D8D6D2",
"y  c #9E988D",
"z  c #EDEDED",
"A  c #E1E0DD",
"B  c #E1E0DC",
"C  c #E2E1DD",
"D  c #DFDEDA",
"E  c #E0DEDA",
"F  c #DDDBD7",
"G  c #DCDAD6",
"H  c #D8D6D1",
"I  c #D7D5D1",
"J  c #9D978B",
"K  c #D1D1D1",
"L  c #E1DFDB",
"M  c #DEDDD9",
"N  c #DEDCD8",
"O  c #D7D6D1",
"P  c #D5D3CE",
"Q  c #9B958A",
"R  c #999891",
"S  c #A39E92",
"T  c #A39D92",
"U  c #A39D91",
"V  c #A29C90",
"W  c #A19B8F",
"X  c #9D978C",
"Y  c #9B968A",
"Z  c #676359",
"                        ",
"   .............+@#     ",
"  .$%&&&&&&&&*==-;>,    ",
"  .%&&&&&&&&&&=')!&~{   ",
"  .&&]]]]]]]]]=^/(&_:<  ",
"  .&&]&&]&&&&]=[}.....  ",
"  .&&]]]]]]]]]=_|1234.  ",
"  .&5]&&&&]&&]=67890a.  ",
"  .&b]]]]]]]]]]]]]]cd.  ",
"  .&e]&&&&&&]&&&]&]fg.  ",
"  .&h]]]]]]]]]]]]]]fi.  ",
"  .&j]&&&&&&&]&&&&]fi.  ",
"  .&k]]]]]]]]]]]]]]fi.  ",
"  .&k]&&&]&&]&&&&]]fi.  ",
"  .&l]]]]]]]]]]]]]]mn.  ",
"  .&o]&&&&&]&&&&]&]pq.  ",
"  .&r]]]]]]]]]]]]]]sq.  ",
"  .&t]&&&&&&]&&&&&]uv.  ",
"  .*w]]]]]]]]]]]]]]xy.  ",
"  .zAfBmCmBmBDEFGuHIJ.  ",
"  .KLEDMmMEMENNGGxOPQ.  ",
"  .RSiTUTnVnVWqvvXXYZ.  ",
"   ..................   ",
"                        "};
#endif /* not GTK_CHECK_VERSION(2,10,0) */


/* XPM */
const gchar *next16_xpm[] = {
"16 16 64 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #C3C3C3",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #ADADAD",
";  c #767676",
">  c #5D5D5D",
",  c #404040",
"'  c #898989",
")  c #E2E2E2",
"!  c #858585",
"~  c #4B4B49",
"{  c #161616",
"]  c #888888",
"^  c #6C6C6C",
"/  c #D6D6D6",
"(  c #F3F3F3",
"_  c #EEEEEE",
":  c #C5C5C5",
"<  c #EFEFEF",
"[  c #CACACA",
"}  c #F6F6F6",
"|  c #D2D2D2",
"1  c #ECECEC",
"2  c #C4C4C4",
"3  c #B4B4B4",
"4  c #E7E7E7",
"5  c #F9F9F9",
"6  c #E3E3E3",
"7  c #EBEBEB",
"8  c #EDEDED",
"9  c #838383",
"0  c #666666",
"a  c #B3B3B3",
"b  c #6B6B6B",
"c  c #6F6F6F",
"d  c #CFCFCF",
"e  c #EAEAEA",
"f  c #E8E8E8",
"g  c #848484",
"h  c #5B5B5B",
"i  c #CDCDCD",
"j  c #A0A0A0",
"k  c #DEE6D6",
"l  c #E9E9E9",
"m  c #7C9B40",
"n  c #E6E6E6",
"o  c #50652A",
"p  c #E5E5E5",
"q  c #D8D8D8",
"r  c #E4E4E4",
"s  c #D9D9D9",
"t  c #9CB476",
"u  c #C2C2C2",
"v  c #BDBDBD",
"w  c #BCBCBC",
"x  c #BBBBBB",
"y  c #9C9C9C",
" .........      ",
".++++++@#$.     ",
".+%%%%%%&*=.    ",
".+%%%%%%-;>,.   ",
".+%%'..')!~{.   ",
".+%]^/(^]__:.   ",
".+<.[}+(.|12.   ",
".@_.3456.|7&..  ",
".@890a$bcde$... ",
".@7fg..h..ij..k.",
".@eellfi......m.",
".@fnnnnn3..k.om.",
".@44nnnpq.kmmmo.",
".@nppprrs.tmoo. ",
".uvvvwwxxy.t..  ",
" ...........    "};


/* XPM */
const gchar *next24_xpm[] = {
"24 24 252 2",
"   c None",
".  c #000000",
"+  c #D3D3D3",
"@  c #F6F6F6",
"#  c #FFFFFF",
"$  c #F9F9F9",
"%  c #DADADA",
"&  c #585858",
"*  c #C7C7C7",
"=  c #D1D1D1",
"-  c #D6D6D6",
";  c #FEFEFE",
">  c #FDFDFD",
",  c #C0C0C0",
"'  c #E1E1E1",
")  c #F0F0F0",
"!  c #9B9B9B",
"~  c #FCFCFB",
"{  c #FBFBFB",
"]  c #AFAFAE",
"^  c #E9E9E9",
"/  c #DFDFDF",
"(  c #8F8F8F",
"_  c #FAFAF9",
":  c #F9F9F8",
"<  c #A4A4A3",
"[  c #F4F4F4",
"}  c #CFCFCF",
"|  c #A2A2A2",
"1  c #B8B8B8",
"2  c #47473F",
"3  c #0A0A09",
"4  c #4B4B43",
"5  c #B4B4B3",
"6  c #F7F6F5",
"7  c #9E9E9E",
"8  c #A9A9A8",
"9  c #34342E",
"0  c #9D9D8D",
"a  c #CFCFB9",
"b  c #C4C4AF",
"c  c #8D8D7F",
"d  c #353530",
"e  c #ACACAA",
"f  c #F1F0EF",
"g  c #DEDDDC",
"h  c #D3D2D0",
"i  c #B7B7B5",
"j  c #9D9C9B",
"k  c #6F6E6E",
"l  c #7FA879",
"m  c #689063",
"n  c #46463F",
"o  c #9C9C8C",
"p  c #E2E2D0",
"q  c #EDEDE7",
"r  c #C0C0AC",
"s  c #B2B29F",
"t  c #828274",
"u  c #4C4C44",
"v  c #E4E4E2",
"w  c #E1E1DF",
"x  c #DAD9D7",
"y  c #D8D8D6",
"z  c #C2C1BF",
"A  c #ACABA9",
"B  c #827E75",
"C  c #9ABC95",
"D  c #63865F",
"E  c #F8F8F7",
"F  c #090908",
"G  c #D5D5BF",
"H  c #FBFBFA",
"I  c #C3C3AE",
"J  c #B5B5A2",
"K  c #A6A695",
"L  c #9C9C8F",
"M  c #080807",
"N  c #CFCFCD",
"O  c #E3E2E0",
"P  c #ECEBE9",
"Q  c #E9E8E6",
"R  c #C2C1C0",
"S  c #BDBCBB",
"T  c #8B867D",
"U  c #AFCBAC",
"V  c #F6F5F4",
"W  c #F3F3F1",
"X  c #090909",
"Y  c #CACAB5",
"Z  c #DDDDD0",
"`  c #B7B7A4",
" . c #AAAA98",
".. c #9B9B8B",
"+. c #AEAEA3",
"@. c #BBBAB9",
"#. c #E8E7E5",
"$. c #D2D1CE",
"%. c #CDCCC9",
"&. c #B7D2B2",
"*. c #60835B",
"=. c #F4F3F2",
"-. c #F0EFEE",
";. c #474740",
">. c #929283",
",. c #BABAA7",
"'. c #ADAD9B",
"). c #9F9F8E",
"!. c #ACACA1",
"~. c #CFCFCB",
"{. c #4C4C45",
"]. c #B3B2B1",
"^. c #DBDAD7",
"/. c #D9D7D4",
"(. c #948F85",
"_. c #B9D5B4",
":. c #7BA574",
"<. c #949493",
"[. c #34342F",
"}. c #878779",
"|. c #A0A090",
"1. c #AEAEA2",
"2. c #C3C3BE",
"3. c #010101",
"4. c #B1B0AF",
"5. c #CDCCCA",
"6. c #D1D0CD",
"7. c #CBCAC7",
"8. c #9C968C",
"9. c #B6D3B2",
"0. c #81AB7C",
"a. c #F0F0EE",
"b. c #EDEDEB",
"c. c #DDDDDB",
"d. c #898988",
"e. c #414141",
"f. c #737271",
"g. c #979695",
"h. c #C8EFC3",
"i. c #BDBCB9",
"j. c #79756C",
"k. c #A7CCA2",
"l. c #B5D2B1",
"m. c #80A87A",
"n. c #E1E0DE",
"o. c #CBCAC9",
"p. c #B2B1B0",
"q. c #A3A2A1",
"r. c #9D9C9A",
"s. c #9E9D9C",
"t. c #999997",
"u. c #C6EAC1",
"v. c #DEF7D9",
"w. c #B3D7AE",
"x. c #BBD9B8",
"y. c #AFCCAB",
"z. c #749E6D",
"A. c #EBEAE8",
"B. c #E6E5E3",
"C. c #C8C7C4",
"D. c #B6B6B3",
"E. c #AFAEAC",
"F. c #ABAAA8",
"G. c #A2A19F",
"H. c #6A6968",
"I. c #BBE1B6",
"J. c #DAF5D6",
"K. c #E1F7DD",
"L. c #DCF4D6",
"M. c #D7F0D3",
"N. c #CFECCB",
"O. c #C6E3C3",
"P. c #BCD6B9",
"Q. c #7EA778",
"R. c #64885F",
"S. c #E7E6E3",
"T. c #E6E5E2",
"U. c #E3E2DF",
"V. c #D4D3D0",
"W. c #CFCECA",
"X. c #CDCBC8",
"Y. c #C9C8C4",
"Z. c #B3D5AE",
"`. c #CDEAC9",
" + c #D0EBCB",
".+ c #CAE9C5",
"++ c #C7E6C3",
"@+ c #C3E3BF",
"#+ c #BDDCBA",
"$+ c #B5D2B2",
"%+ c #96B991",
"&+ c #76A071",
"*+ c #3A4E37",
"=+ c #E4E3E0",
"-+ c #E3E2DE",
";+ c #E4E2DF",
">+ c #E0DFDB",
",+ c #DDDCD8",
"'+ c #9CBE97",
")+ c #C7E0C4",
"!+ c #CBE3C6",
"~+ c #CDE6C9",
"{+ c #CDE4C9",
"]+ c #CBE4C8",
"^+ c #C7E1C4",
"/+ c #C2DBBF",
"(+ c #88AF82",
"_+ c #6B9266",
":+ c #557451",
"<+ c #EDEDED",
"[+ c #E1E0DD",
"}+ c #E1DFDC",
"|+ c #E1E0DC",
"1+ c #E2E1DD",
"2+ c #DFDEDA",
"3+ c #DAD9D5",
"4+ c #D9D8D4",
"5+ c #749E6F",
"6+ c #72996B",
"7+ c #739B6D",
"8+ c #739A6D",
"9+ c #71996C",
"0+ c #70986A",
"a+ c #6E9668",
"b+ c #6C9367",
"c+ c #5F815A",
"d+ c #E1DFDB",
"e+ c #E0DEDA",
"f+ c #DEDDD9",
"g+ c #D8D7D3",
"h+ c #DAD8D4",
"i+ c #CCCAC7",
"j+ c #70996B",
"k+ c #6E9467",
"l+ c #698F63",
"m+ c #6B9166",
"n+ c #5D8059",
"o+ c #4D6A49",
"p+ c #999891",
"q+ c #A39E92",
"r+ c #A49E93",
"s+ c #A39D92",
"t+ c #A39D91",
"u+ c #A19C90",
"v+ c #A29C90",
"w+ c #A09B8F",
"x+ c #A09A8E",
"y+ c #9C968B",
"z+ c #938E84",
"A+ c #6D9568",
"B+ c #6A8F64",
"C+ c #283926",
"  . . . . . . . . . . . . .                     ",
". + @ # # # # # # # # $ % & .                   ",
". @ # # # # # # # # # # * = - .                 ",
". # # # # # # # ; # ; > , ' ) ! .               ",
". # # # # # ; > ~ > ~ { ] ^ # / ( .             ",
". # # # ; > ~ { _ { _ : < ) # [ } | .           ",
". # ; > ~ 1 2 3 3 4 5 6 7 . . . . . . . .       ",
". # ~ { 8 9 0 a b c d e f g h i j k . l m .     ",
". # _ : n o p q r s t u v w x y z A B . C D .   ",
". # E 6 F G H I J K L M N O P Q R S T . . U .   ",
". # V W X Y Z `  ...+.3 @.x #.x $.%.T . . &.*.. ",
". # =.-.;.>.,.'.).!.~.{.].h ^.$.. /.(.. . _.:.. ",
". # =.-.<.[.}.|.1.2.3.3.4.5.6.. . 7.8.. . 9.0.. ",
". # a.b.c.d.4 3 3 e.f.3.. g.. h.. i.j.. k.l.m.. ",
". # b.P n.o.p.q.r.s.t.. . . u.v.. . . w.x.y.z.. ",
". # A.Q B.x C.D.E.F.G.H.. I.J.K.L.M.N.O.P.Q.R.. ",
". # S.T.T.U.^.V.W.X.Y.. Z.`. +.+++@+#+$+%+&+*+. ",
". $ =+U.-+;+-+>+,+,+. '+)+!+~+{+]+^+/+(+_+:+.   ",
". <+[+}+|+>+1+>+2+3+4+. 5+6+7+8+9+0+a+b+c+. .   ",
". = d+e+2+f+>+f+e+g+h+i+. j+k+l+m m+n+o+. .     ",
". p+q+r+s+t+s+u+v+w+x+y+z+. A+B+. . . . .       ",
"  . . . . . . . . . . . . . C+_+. . . .         ",
"                              . .               ",
"                                .               "};


/* XPM */
const gchar *previous16_xpm[] = {
"16 16 66 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #A8AFA0",
"&  c #F1F1F1",
"*  c #C3C3C3",
"=  c #D1D1D1",
"-  c #DEE6D6",
";  c #CCDCB8",
">  c #BDD2A1",
",  c #BAD09D",
"'  c #ADADAD",
")  c #9FA498",
"!  c #9BB46F",
"~  c #7C9B40",
"{  c #728E3A",
"]  c #898989",
"^  c #E2E2E2",
"/  c #B1C491",
"(  c #50652A",
"_  c #35431B",
":  c #888888",
"<  c #6C6C6C",
"[  c #D6D6D6",
"}  c #F3F3F3",
"|  c #9CB476",
"1  c #EFEFEF",
"2  c #CACACA",
"3  c #F6F6F6",
"4  c #6B7957",
"5  c #EEEEEE",
"6  c #B4B4B4",
"7  c #E7E7E7",
"8  c #F9F9F9",
"9  c #E3E3E3",
"0  c #BFBFBF",
"a  c #EDEDED",
"b  c #838383",
"c  c #666666",
"d  c #B3B3B3",
"e  c #6B6B6B",
"f  c #6F6F6F",
"g  c #CFCFCF",
"h  c #D5D5D5",
"i  c #EBEBEB",
"j  c #E8E8E8",
"k  c #848484",
"l  c #5B5B5B",
"m  c #CDCDCD",
"n  c #C0C0C0",
"o  c #EAEAEA",
"p  c #E9E9E9",
"q  c #A9A9A9",
"r  c #E6E6E6",
"s  c #E5E5E5",
"t  c #B2B2B2",
"u  c #E4E4E4",
"v  c #A5A5A5",
"w  c #C2C2C2",
"x  c #BDBDBD",
"y  c #BCBCBC",
"z  c #BBBBBB",
"A  c #A0A0A0",
" .........   .  ",
".++++++@#$...%. ",
".+&&&&&&*=.-;>,.",
".+&&&&&&'.)!~~{.",
".+&&]..]^./(._. ",
".+&:<[}<:.|...  ",
".+1.23+}..4..   ",
".@5.6789.0...   ",
".@abcd$efgh..   ",
".@ijk..l..mn.   ",
".@ooppjm...q.   ",
".@jrrrrr6....   ",
".@77rrrsst...   ",
".@rsssuu99tv.   ",
".wxxxyyzzzzA.   ",
" ...........    "};


/* XPM */
const gchar *previous24_xpm[] = {
"24 24 235 2",
"   c None",
".  c #000000",
"+  c #F0FFEE",
"@  c #D3D3D3",
"#  c #F6F6F6",
"$  c #FFFFFF",
"%  c #F9F9F9",
"&  c #DADADA",
"*  c #4B4B4B",
"=  c #CAE3C6",
"-  c #F5FFF4",
";  c #787878",
">  c #0D110C",
",  c #729C6C",
"'  c #A6CAA1",
")  c #CBE4C7",
"!  c #EFFDEE",
"~  c #FEFEFE",
"{  c #8F8F8F",
"]  c #172116",
"^  c #88B583",
"/  c #CCE5C8",
"(  c #CDE6C9",
"_  c #CFE7CB",
":  c #F3FFF2",
"<  c #FDFDFD",
"[  c #FCFCFB",
"}  c #DEDEDD",
"|  c #CDE5C9",
"1  c #CFE7CA",
"2  c #D0E9CC",
"3  c #D4EAD0",
"4  c #D5ECD1",
"5  c #AED5A9",
"6  c #FBFBFB",
"7  c #FAFAF9",
"8  c #A1A1A1",
"9  c #2B3A29",
"0  c #8CB887",
"a  c #70986A",
"b  c #71986B",
"c  c #729A6B",
"d  c #759C6D",
"e  c #759F6F",
"f  c #76A170",
"g  c #567453",
"h  c #B8B8B8",
"i  c #47473F",
"j  c #0A0A09",
"k  c #4B4B43",
"l  c #7EAB77",
"m  c #78A472",
"n  c #6F9669",
"o  c #70976A",
"p  c #71996B",
"q  c #739B6D",
"r  c #759F6E",
"s  c #77A170",
"t  c #526F4C",
"u  c #A9A9A8",
"v  c #34342E",
"w  c #9D9D8D",
"x  c #CFCFB9",
"y  c #C4C4AF",
"z  c #8D8D7F",
"A  c #010101",
"B  c #A5C9A0",
"C  c #9AC195",
"D  c #4F6B4C",
"E  c #769F70",
"F  c #516D4C",
"G  c #F9F9F8",
"H  c #46463F",
"I  c #9C9C8C",
"J  c #E2E2D0",
"K  c #EDEDE7",
"L  c #C0C0AC",
"M  c #B2B29F",
"N  c #10100E",
"O  c #C7E0C3",
"P  c #6D9568",
"Q  c #60835B",
"R  c #878786",
"S  c #A3A2A0",
"T  c #51714E",
"U  c #F8F8F7",
"V  c #F7F6F5",
"W  c #090908",
"X  c #D5D5BF",
"Y  c #FBFBFA",
"Z  c #C3C3AE",
"`  c #B5B5A2",
" . c #A6A695",
".. c #131311",
"+. c #C3DBBF",
"@. c #6B9265",
"#. c #777675",
"$. c #BEBEBC",
"%. c #BBBAB9",
"&. c #F6F5F4",
"*. c #F3F3F1",
"=. c #090909",
"-. c #CACAB5",
";. c #DDDDD0",
">. c #B7B7A4",
",. c #AAAA98",
"'. c #9B9B8B",
"). c #151514",
"!. c #90B68B",
"~. c #79A674",
"{. c #ABABA9",
"]. c #C9C8C6",
"^. c #D7D6D3",
"/. c #7A756D",
"(. c #F4F3F2",
"_. c #F0EFEE",
":. c #474740",
"<. c #929283",
"[. c #BABAA7",
"}. c #ADAD9B",
"|. c #9F9F8E",
"1. c #ACACA1",
"2. c #191919",
"3. c #5B7B57",
"4. c #8CB087",
"5. c #B7B6B4",
"6. c #D0CFCC",
"7. c #DCDBD8",
"8. c #D9D8D5",
"9. c #959086",
"0. c #949493",
"a. c #34342F",
"b. c #878779",
"c. c #A0A090",
"d. c #AEAEA2",
"e. c #C3C3BE",
"f. c #A6C1A3",
"g. c #B9B8B5",
"h. c #D3D2CF",
"i. c #E0DFDC",
"j. c #E1DFDC",
"k. c #A49E93",
"l. c #F0F0EE",
"m. c #EDEDEB",
"n. c #DDDDDB",
"o. c #898988",
"p. c #414141",
"q. c #686766",
"r. c #5E7F5A",
"s. c #8FAF8B",
"t. c #CAC9C6",
"u. c #DDDCD8",
"v. c #E0DFDB",
"w. c #A19C90",
"x. c #ECEBE9",
"y. c #E1E0DE",
"z. c #CBCAC9",
"A. c #B2B1B0",
"B. c #A3A2A1",
"C. c #9D9C9A",
"D. c #9E9D9C",
"E. c #9C9C9A",
"F. c #63885E",
"G. c #759C70",
"H. c #D0D0CC",
"I. c #A19B90",
"J. c #EBEAE8",
"K. c #E9E8E6",
"L. c #E6E5E3",
"M. c #DAD9D7",
"N. c #C8C7C4",
"O. c #B6B6B3",
"P. c #AFAEAC",
"Q. c #B0AFAD",
"R. c #B2B1AF",
"S. c #706F6D",
"T. c #535251",
"U. c #DCDBD7",
"V. c #E7E6E3",
"W. c #E6E5E2",
"X. c #E3E2DF",
"Y. c #DBDAD7",
"Z. c #D4D3D0",
"`. c #D0CFCB",
" + c #D1CFCC",
".+ c #D1D0CC",
"++ c #C7C6C2",
"@+ c #666664",
"#+ c #C9C8C5",
"$+ c #D6D4D0",
"%+ c #9F998D",
"&+ c #E4E3E0",
"*+ c #E3E2DE",
"=+ c #E4E2DF",
"-+ c #DFDEDA",
";+ c #D5D4D0",
">+ c #C0BFBC",
",+ c #7A7977",
"'+ c #BCBAB6",
")+ c #CECCC8",
"!+ c #9D978C",
"~+ c #EDEDED",
"{+ c #E1E0DD",
"]+ c #E1E0DC",
"^+ c #E2E1DD",
"/+ c #DBDAD6",
"(+ c #BBB9B6",
"_+ c #A6A4A1",
":+ c #9E9C99",
"<+ c #ACABA7",
"[+ c #C7C5C2",
"}+ c #9B9589",
"|+ c #D1D1D1",
"1+ c #E1DFDB",
"2+ c #E0DEDA",
"3+ c #DEDDD9",
"4+ c #DEDCD8",
"5+ c #DAD8D4",
"6+ c #BDBCB8",
"7+ c #ACABA8",
"8+ c #B2B1AD",
"9+ c #C6C4C0",
"0+ c #999388",
"a+ c #999891",
"b+ c #A39E92",
"c+ c #A39D92",
"d+ c #A39D91",
"e+ c #A29C90",
"f+ c #A19B8F",
"g+ c #9D978B",
"h+ c #989286",
"i+ c #918C82",
"j+ c #938D83",
"k+ c #979286",
"l+ c #666258",
"                                  .             ",
"                                  . .           ",
"  . . . . . . . . . . . . .       . + .         ",
". @ # $ $ $ $ $ $ $ $ % & * . . . . = - .       ",
". # $ $ $ $ $ $ $ $ $ $ ; > , ' = = ) ) ! .     ",
". $ $ $ $ $ $ $ ~ $ ~ { ] ^ = = ) ) / ( _ : .   ",
". $ $ $ $ $ ~ < [ < } . , = ) ) / | 1 2 3 4 5 . ",
". $ $ $ ~ < [ 6 7 6 8 9 ' = 0 a b c d e f g .   ",
". $ ~ < [ h i j j k . l = m n o p q r s t .     ",
". $ [ 6 u v w x y z A B C n D . . . E F .       ",
". $ 7 G H I J K L M N O P Q . R S . T .         ",
". $ U V W X Y Z `  ...+.@.. #.$.%.. . .         ",
". $ &.*.=.-.;.>.,.'.).!.~.. {.].^.. /..         ",
". $ (._.:.<.[.}.|.1.2.3.4.. 5.6.7.8.9..         ",
". $ (._.0.a.b.c.d.e.. . f.. g.h.i.j.k..         ",
". $ l.m.n.o.k j j p.q.. r.s.. t.u.v.w..         ",
". $ m.x.y.z.A.B.C.D.E.. . F.G.. H.u.I..         ",
". $ J.K.L.M.N.O.P.Q.R.S.. . . T.N.U.I..         ",
". $ V.W.W.X.Y.Z.`. +.+++@+. . . #+$+%+.         ",
". % &+X.*+=+*+v.v.-+-+;+>+,+A A '+)+!+.         ",
". ~+{+j.]+v.^+v.]+v.]+/+.+(+_+:+<+[+}+.         ",
". |+1+2+-+3+v.3+2+3+2+4+5+)+6+7+8+9+0+.         ",
". a+b+k.c+d+c+w.e+w.e+f+I.g+h+i+j+k+l+.         ",
"  . . . . . . . . . . . . . . . . . .           "};


/* XPM */
const gchar *filetype16_xpm[] = {
"16 16 87 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #DADADA",
"#  c #CBCBCB",
"$  c #FDFDFD",
"%  c #E0E0E0",
"&  c #C1C1C1",
"*  c #F1F1F1",
"=  c #CAC8C1",
"-  c #BBBBBB",
";  c #C3C3C3",
">  c #FBFBFB",
",  c #A8A8A8",
"'  c #B1B1B1",
")  c #EBEBE8",
"!  c #EBEBEB",
"~  c #ADADAD",
"{  c #767676",
"]  c #5D5D5D",
"^  c #D8D8D8",
"/  c #F9F8F8",
"(  c #CCCCCC",
"_  c #E2E2E2",
":  c #858585",
"<  c #3D3D3C",
"[  c #D2D0CC",
"}  c #F7F7F7",
"|  c #DEDBD6",
"1  c #A9A9A9",
"2  c #EFEFEF",
"3  c #848484",
"4  c #737373",
"5  c #D3D2CF",
"6  c #E3E2E1",
"7  c #DFDEDC",
"8  c #DBDAD7",
"9  c #A4A19C",
"0  c #656565",
"a  c #292929",
"b  c #838383",
"c  c #C4C4C4",
"d  c #F3F3F3",
"e  c #1D1D1D",
"f  c #D2D1D0",
"g  c #50504F",
"h  c #EDEDED",
"i  c #ECECEC",
"j  c #111111",
"k  c #3D3D3D",
"l  c #494746",
"m  c #DEDEDE",
"n  c #BFBFBF",
"o  c #363636",
"p  c #C8C7C6",
"q  c #6C6967",
"r  c #708295",
"s  c #CFD6DD",
"t  c #7C91A7",
"u  c #E8E8E8",
"v  c #D6D5D5",
"w  c #8A8784",
"x  c #7D8C9C",
"y  c #788DA4",
"z  c #7F99B3",
"A  c #1F272F",
"B  c #E6E6E6",
"C  c #ECEBEA",
"D  c #72706D",
"E  c #8D99A5",
"F  c #748AA2",
"G  c #849EB9",
"H  c #4D5F73",
"I  c #E5E5E5",
"J  c #E4E4E4",
"K  c #D5D4D3",
"L  c #6B6A69",
"M  c #7D91A7",
"N  c #849EBA",
"O  c #D9D9D9",
"P  c #E3E3E3",
"Q  c #DCDCDC",
"R  c #525252",
"S  c #66798F",
"T  c #ACACAC",
"U  c #BCBCBC",
"V  c #A0A0A0",
"  .........     ",
" .++@.#+$%&.  . ",
" .+*.=.-*;>,..'.",
" .+**.).!~{].^. ",
" ..**./.(_:<..  ",
" .[..}|.123.4.  ",
" ..56789.0abc.  ",
" .d.e..fg.0!;.  ",
" .$hiiijkl.mn.  ",
" .$!...o.pq.'.  ",
" .$.rst.u.vw..  ",
" ..xsyzAB(.CD.  ",
" .EsFGH.IIJ.KL. ",
" .sMNH.OJPPQ.fR ",
" .MSH.TU----V.. ",
" ............   "};


/* XPM */
const gchar *filetype24_xpm[] = {
"24 24 218 2",
"   c None",
".  c #000000",
"+  c #BAB5AB",
"@  c #D0CDC6",
"#  c #88857D",
"$  c #D2D2D2",
"%  c #ECECEC",
"&  c #DFDFDF",
"*  c #C9C6BE",
"=  c #CCC8C1",
"-  c #F8F8F8",
";  c #FEFEFE",
">  c #F9F9F9",
",  c #DADADA",
"'  c #585858",
")  c #F4F4F4",
"!  c #E9E9E9",
"~  c #D1D1D1",
"{  c #E5E3E0",
"]  c #D5D5D5",
"^  c #FDFDFD",
"/  c #FFFFFF",
"(  c #C7C7C7",
"_  c #D6D6D6",
":  c #757575",
"<  c #7B7B7B",
"[  c #F2F2F2",
"}  c #E1E1E1",
"|  c #2E2E2E",
"1  c #F6F5F5",
"2  c #929292",
"3  c #C0C0C0",
"4  c #EFEFEF",
"5  c #CCCCCC",
"6  c #AFAFAF",
"7  c #D3D1CB",
"8  c #909090",
"9  c #C1C0BF",
"0  c #F0EFED",
"a  c #9B9A96",
"b  c #5A5A5A",
"c  c #F3F3F2",
"d  c #FAFAFA",
"e  c #AFAFAE",
"f  c #DCDCDC",
"g  c #A5A19C",
"h  c #EAE9E5",
"i  c #F3F1F0",
"j  c #ECECEB",
"k  c #F7F7F6",
"l  c #A4A4A3",
"m  c #EDEDED",
"n  c #202020",
"o  c #A19D96",
"p  c #C1BDB4",
"q  c #DBD8D3",
"r  c #D9D6D1",
"s  c #89857E",
"t  c #F0EFEE",
"u  c #9C9C9C",
"v  c #EBEBEB",
"w  c #AAAAAA",
"x  c #636363",
"y  c #121212",
"z  c #EAE9E6",
"A  c #F5F4F3",
"B  c #C6C2BA",
"C  c #939391",
"D  c #848383",
"E  c #646363",
"F  c #5F5C54",
"G  c #EAEAEA",
"H  c #D7D7D6",
"I  c #CCCCCB",
"J  c #C7C7C6",
"K  c #C7C6C5",
"L  c #C2C1C1",
"M  c #F4F4F3",
"N  c #CBC7C0",
"O  c #AEADAC",
"P  c #B5B5B3",
"Q  c #BBBAB8",
"R  c #A9A8A6",
"S  c #86827A",
"T  c #EDEDEC",
"U  c #E8E7E6",
"V  c #E4E3E2",
"W  c #E2E2E0",
"X  c #DAD9D8",
"Y  c #A6A5A4",
"Z  c #D3D2D0",
"`  c #CFCECD",
" . c #C3C2C1",
".. c #8F8A81",
"+. c #F3F3F1",
"@. c #F2F1F0",
"#. c #E9E9E7",
"$. c #D9D9D7",
"%. c #C3C3C2",
"&. c #676560",
"*. c #54524D",
"=. c #C0BFBD",
"-. c #E1E0DD",
";. c #D2D1CE",
">. c #8D887E",
",. c #F4F3F2",
"'. c #F3F2F1",
"). c #F1F1EF",
"!. c #777676",
"~. c #797978",
"{. c #85827E",
"]. c #79756F",
"^. c #AFAEAC",
"/. c #DFDDDA",
"(. c #979288",
"_. c #7590AE",
":. c #A4BAD0",
"<. c #90A6BE",
"[. c #908F8E",
"}. c #9F9F9E",
"|. c #BEBDBC",
"1. c #B8B4AD",
"2. c #87837C",
"3. c #9C9A98",
"4. c #A29C91",
"5. c #EFEFED",
"6. c #D3DFEA",
"7. c #A2AEBC",
"8. c #9DB6CE",
"9. c #637B95",
"0. c #AAA9A7",
"a. c #A5A4A3",
"b. c #E2E2E2",
"c. c #EEEEED",
"d. c #636059",
"e. c #849CB6",
"f. c #D7E2ED",
"g. c #8D98A5",
"h. c #9DB8D2",
"i. c #607791",
"j. c #B7B6B4",
"k. c #C3C2C0",
"l. c #B9B9B6",
"m. c #99ADC3",
"n. c #DFE7F0",
"o. c #8193A9",
"p. c #586D84",
"q. c #5B7189",
"r. c #D0CECB",
"s. c #CCCBC8",
"t. c #BAB9B5",
"u. c #F1F1F1",
"v. c #EEEDEB",
"w. c #A7A6A5",
"x. c #726F6A",
"y. c #A1B4C8",
"z. c #EEF3F6",
"A. c #60768F",
"B. c #B1B0AD",
"C. c #C1C1BD",
"D. c #D6D5D1",
"E. c #DAD9D5",
"F. c #CACAC6",
"G. c #B5B5B1",
"H. c #DEDDDC",
"I. c #787776",
"J. c #4E4E4D",
"K. c #91A6BE",
"L. c #F0F4F7",
"M. c #97A5B6",
"N. c #898886",
"O. c #BAB9B6",
"P. c #CECDC9",
"Q. c #DBDAD6",
"R. c #DFDEDA",
"S. c #D7D6D3",
"T. c #C8C6C2",
"U. c #B4B2AF",
"V. c #BFBEBD",
"W. c #AAAAA9",
"X. c #ACACAB",
"Y. c #B0C6DB",
"Z. c #EDF2F6",
"`. c #818A95",
" + c #6B6A68",
".+ c #B6B5B2",
"++ c #C8C7C3",
"@+ c #D9D8D4",
"#+ c #DEDDD9",
"$+ c #E0DEDA",
"%+ c #DCDAD6",
"&+ c #D5D4D0",
"*+ c #C4C2BF",
"=+ c #B1AFAB",
"-+ c #6C85A1",
";+ c #C0D1E2",
">+ c #545352",
",+ c #B2B1AE",
"'+ c #C5C3C0",
")+ c #D3D2CE",
"!+ c #DEDCD8",
"~+ c #DBD9D5",
"{+ c #D2D0CC",
"]+ c #C3C2BE",
"^+ c #B2B1AC",
"/+ c #7D7870",
"(+ c #3D3B36",
"_+ c #827D74",
":+ c #8C887D",
"<+ c #999388",
"[+ c #9F9A8E",
"}+ c #A29C90",
"|+ c #A19B8F",
"1+ c #A19B90",
"2+ c #9F998D",
"3+ c #9C968B",
"4+ c #928D82",
"5+ c #5F5C52",
"            . .                                 ",
"      . . . + @ # . . . . . . .                 ",
"    . $ % & . * = + . - ; > , ' .     . .       ",
"    . ) - ! ~ . { * . ] ^ / ( ~ _ . . / : .     ",
"    . . < [ } | 1 * . 2 > ^ 3 } 4 . / 5 6 .     ",
"    . 7 8 . . 9 0 + a b c d e ! ^ . f 6 .       ",
"    . g = = h i + + + . j k l 4 . m . . .       ",
"    . n o p = * q r + s . t u . v . . . . .     ",
"    . w x . . . y z A B s . . 5 . C D E F .     ",
"    . G H I J K L . t M N . 6 . O P Q R S .     ",
"    . > T U V W X J . j . 6 . . Y Z `  ....     ",
"    . ; A +.@.t #.$.%.. 6 . &.*.. =.-.;.>..     ",
"    . / ,.'.).. . . . 6 . !.~.{.].. ^./.(..     ",
"    . / ,.@.. _.:.<.. . [.. }.|.1.2.. 3.4..     ",
"    . / 5.. _.6.7.8.9.. 0.a.. b.c.N s . d..     ",
"    . ; . e.f.g.9.h.i.. j.k.l.. T i * s . .     ",
"    . . m.n.o.p.h._.q.. Q r.s.t.. u.v.w.x.. .   ",
"    . y.z.o.A.h._.q.. B.C.D.E.F.G.. H.I.J.6 .   ",
"  . K.L.M.A.h._.q.. N.O.P.Q.R.S.T.U.. V.W.X..   ",
"  . Y.Z.`.h._.q..  +.+++@+#+$+%+&+*+=+. . .     ",
"  . -+h.;+K.q.. >+,+'+)+!+!+!+%+~+{+]+^+/+.     ",
"    . -+-+9.. (+_+:+<+[+}+|+1+2+2+3+<+4+5+.     ",
"    . . . . . . . . . . . . . . . . . . .       ",
"                                                "};


#if ! GTK_CHECK_VERSION(2,6,0)
/* XPM */
const gchar *about16_xpm[] = {
"16 16 15 1",
"   c None",
".  c #000000",
"+  c #EEF63E",
"@  c #EAF13D",
"#  c #F0F83F",
"$  c #CBD235",
"%  c #E9F03D",
"&  c #E5EC3C",
"*  c #E8F03D",
"=  c #ABB02D",
"-  c #ECF33E",
";  c #EFF73F",
">  c #CED636",
",  c #B4BA2F",
"'  c #CDD435",
"                ",
"                ",
"                ",
"                ",
"        .       ",
"       .+.      ",
"     ..@#$..    ",
"    .######%.   ",
"     .####&.    ",
"     .*###=.    ",
"     .#-.;>.    ",
"     .,. .'.    ",
"      .   .     ",
"                ",
"                ",
"                "};


/* XPM */
const gchar *about24_xpm[] = {
"24 24 15 1",
"   c None",
".  c #000000",
"+  c #EEF63E",
"@  c #EAF13D",
"#  c #F0F83F",
"$  c #C9D034",
"%  c #E9F03D",
"&  c #E5EC3C",
"*  c #E8F03D",
"=  c #A9AE2C",
"-  c #ECF33E",
";  c #EFF73F",
">  c #CED636",
",  c #B1B72E",
"'  c #CCD334",
"                        ",
"     .          .       ",
"    .+.        .+.      ",
"  ..@#$..    ..@#$..    ",
" .######%.  .######%.   ",
"  .####&.    .####&.    ",
"  .*###=.    .*###=.    ",
"  .#-.;>.    .#-.;>.    ",
"  .,. .'.    .,. .'.    ",
"   .   .      .   .     ",
"                        ",
"                        ",
"                        ",
"     .          .       ",
"    .+.        .+.      ",
"  ..@#$..    ..@#$..    ",
" .######%.  .######%.   ",
"  .####&.    .####&.    ",
"  .*###=.    .*###=.    ",
"  .#-.;>.    .#-.;>.    ",
"  .,. .'.    .,. .'.    ",
"   .   .      .   .     ",
"                        ",
"                        "};
#endif /* not GTK_CHECK_VERSION(2,6,0) */
