/*
    orzconf
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __ORZ_CONF_H__
#define __ORZ_CONF_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_CONF            (orz_conf_get_type ())
#define ORZ_CONF(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_CONF, OrzConf))
#define ORZ_CONF_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_CONF, OrzConfClass))
#define ORZ_IS_CONF(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_CONF))
#define ORZ_IS_CONF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_CONF))
#define ORZ_CONF_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_CONF, OrzConfClass))


typedef struct _OrzConf      OrzConf;
typedef struct _OrzConfClass OrzConfClass;

struct _OrzConf
{
  /*< private >*/
  GtkWindow parent_instance;

  /*< public >*/
  GtkWidget *ok_button;     /* ja:了解 */
  GtkWidget *cancel_button; /* ja:取消 */

  /*< private >*/
  GtkWidget *history_spin;  /* ja:履歴 */
  GtkWidget *newfile_check; /* ja:新規ファイル */
  GtkWidget *second_check;  /* ja:新規ウインドウ */
  GtkWidget *width_spin;    /* ja:ウインドウサイズ */
  GtkWidget *height_spin;   /* ja:ウインドウサイズ */
  GtkWidget *left_radio;    /* ja:ノートブックの位置 */
  GtkWidget *top_radio;     /* ja:ノートブックの位置 */
  GtkWidget *right_radio;   /* ja:ノートブックの位置 */
  GtkWidget *bottom_radio;  /* ja:ノートブックの位置 */
};

struct _OrzConfClass
{
  GtkWindowClass parent_class;

  /* -- signals -- */
  void (*close) (OrzConf *conf);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_conf_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
orz_conf_new (void);


/*  ja:履歴を取得する
    conf,ウィジェット
     RET,履歴                                                               */
gint
orz_conf_get_history (OrzConf *conf);


/*  ja:新規ファイルを取得する
    conf,ウィジェット
     RET,新規ファイル                                                       */
gboolean
orz_conf_get_newfile (OrzConf *conf);


/*  ja:新規ウインドウを取得する
    conf,ウィジェット
     RET,新規ウインドウ                                                     */
gboolean
orz_conf_get_second (OrzConf *conf);


/*  ja:ウインドウサイズを取得する
      conf,ウィジェット
     width,幅
    height,高さ                                                             */
void
orz_conf_get_size (OrzConf *conf,
                   gint    *width,
                   gint    *height);


/*  ja:ノートブックの位置を取得する
    conf,ウィジェット
     RET,ノートブックの位置                                                 */
GtkPositionType
orz_conf_get_tab (OrzConf *conf);


/*  ja:履歴を設定する
       conf,ウィジェット
    history,履歴                                                            */
void
orz_conf_set_history (OrzConf    *conf,
                      const gint  history);


/*  ja:新規ファイルを設定する
       conf,ウィジェット
    newfile,新規ファイル                                                    */
void
orz_conf_set_newfile (OrzConf        *conf,
                      const gboolean  newfile);


/*  ja:新規ウインドウを設定する
      conf,ウィジェット
    second,新規ウインドウ                                                   */
void
orz_conf_set_second (OrzConf        *conf,
                     const gboolean  second);


/*  ja:ウインドウサイズを設定する
      conf,ウィジェット
     width,幅
    height,高さ                                                             */
void
orz_conf_set_size (OrzConf    *conf,
                   const gint  width,
                   const gint  height);


/*  ja:ノートブックの位置を設定する
     conf,ウィジェット
    n_pos,ノートブックの位置                                                */
void
orz_conf_set_tab (OrzConf               *conf,
                  const GtkPositionType  n_pos);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_CONF_H__ */
