/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "charset.h"
#include "valchr.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:コード文字入力ダイアログ関数群                                           *
*                                                                             *
******************************************************************************/
static gboolean valchr_clicked_ok;
static gchar valchr_default = ' ';
static guint valchr_base = 16;
static GtkWidget *dialog, *button0, *entry;


/* ja:OKボタンの表示/非表示を判定 */
static void
valchr_dialog_changed (GtkWidget *widget,
                       gpointer   user_data)
{
  gint value;

  misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (widget)),
                                                        valchr_base, FALSE);
  gtk_widget_set_sensitive (button0, 0 <= value && value <= 255
                                            && charset_length (value) == 1);
}


/* ja:ラジオボタンが押された */
static void
valchr_dialog_clicked_radio (GtkWidget *widget,
                             guint      base)
{
  gchar *text;
  gint value;

  misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (entry)),
                                                        valchr_base, FALSE);
  valchr_base = base;
  text = misc_str_from_val (value, valchr_base, 0, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), text);
  g_free (text);
}


/* ja:OKボタンが押された */
static void
valchr_dialog_clicked_ok (GtkWidget *widget,
                          gchar     *valchr)
{
  gint value;

  misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (entry)),
                                                        valchr_base, FALSE);
  *valchr = valchr_default = value;
  gtk_widget_destroy (dialog);
  valchr_clicked_ok = TRUE;
}


/* ja:エントリーでリターンが押された */
static void
valchr_dialog_activate (GtkWidget *widget,
                        gchar     *valchr)
{
  gint value;

  misc_str_to_val (&value, gtk_entry_get_text (GTK_ENTRY (widget)),
                                                        valchr_base, FALSE);
  if (0 <= value && value <= 255 && charset_length (value) == 1)
    valchr_dialog_clicked_ok (widget, valchr);
}


/* ja:ESCが押された */
static gboolean
valchr_dialog_key_press (GtkWidget   *widget,
                         GdkEventKey *event,
                         gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:コード文字入力ダイアログ表示
    valchr,入力文字
       RET,TRUE:OK,FALSE:Cancel                                             */
gboolean
valchr_dialog (gchar *valchr)
{
  gchar *text;
  GtkWidget *button1, *radio0, *radio1, *radio2, *frame, *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Character by Value"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (valchr_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_label (_("OK"));
  button1 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                                G_CALLBACK (valchr_dialog_clicked_ok), valchr);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:エントリー */
  entry = gtk_entry_new_with_max_length (4);
  text = misc_str_from_val (valchr_default, valchr_base, 0, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), text);
  g_free (text);
  g_signal_connect (G_OBJECT (entry), "activate",
                                G_CALLBACK (valchr_dialog_activate), valchr);
  g_signal_connect (G_OBJECT (entry), "changed",
                                    G_CALLBACK (valchr_dialog_changed), NULL);
  /* ja:ラジオボタン */
  radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Hexadecimal"));
  radio1 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio0), _("_Decimal"));
  radio2 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio1), _("_Octal"));
  switch (valchr_base)
    {
      case 16: gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio0), TRUE);
               break;
      case 10: gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
               break;
      case  8: gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio2), TRUE);
    }
  g_signal_connect (G_OBJECT (radio0), "clicked",
                    G_CALLBACK (valchr_dialog_clicked_radio), (gpointer)16);
  g_signal_connect (G_OBJECT (radio1), "clicked",
                    G_CALLBACK (valchr_dialog_clicked_radio), (gpointer)10);
  g_signal_connect (G_OBJECT (radio2), "clicked",
                    G_CALLBACK (valchr_dialog_clicked_radio), (gpointer)8);
  /* ja:フレームとボックス */
  frame = gtk_frame_new (_("Base"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), radio0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), radio1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), radio2, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  valchr_clicked_ok = FALSE;

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return valchr_clicked_ok;
}
