/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __GENERAL_H__
#define __GENERAL_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:キャレットの描画
     tmaid,ウインドウ情報
    cursor,新しいカーソル位置                                               */
void
draw_caret (TmaidWindow *tmaid,
            GdkPoint    *cursor);


/*  ja:メニューを設定する
    tmaid,ウインドウ情報                                                    */
void
set_menu_bar (TmaidWindow *tmaid);


/*  ja:指定範囲を再描画する
    tmaid,ウインドウ情報
    start,開始
      end,終了                                                              */
void
clear_sel (TmaidWindow *tmaid,
           GdkPoint    *start,
           GdkPoint    *end);


/*  ja:移動する
    tmaid,ウインドウ情報
      top,古い左上の座標                                                    */
void
move_edit_window (TmaidWindow *tmaid,
                  GdkPoint    *top);


/*  ja:キャレット位置にデータを挿入/上書きする
     tmaid,ウインドウ情報
      text,データを格納するポインタ
    length,データのバイト数
     caret,TRUE:移動する,FALSE:移動しない
    select,TRUE:選択する,FALSE:選択しない
       RET,逆の操作を行うTmaidHistory構造体,NULL:エラー                     */
TmaidHistory *
edit_operation (TmaidWindow    *tmaid,
                const gchar    *text,
                const gint      length,
                const gboolean  caret,
                const gboolean  select);


/*  ja:リストから削除する
      d,リストの先頭
    RET,削除したリストの数                                                  */
gint
delete_list (TmaidHistory **d);


/*  ja:右マージンで折り返す
    tmaid,TXTウインドウ情報                                                 */
void
modify_margin (TmaidWindow *tmaid);


/*  ja:ファイルの保存を問い合わせる
    tmaid,ウインドウ情報
      RET,TRUE:ファイルは閉じる,FALSE:ファイルを閉じない                    */
gboolean
prompt_close (TmaidWindow *tmaid);


/*  ja:キャラクターセットを置換する
    charlist,置換するキャラクターセット
       ft_id,ファイルタイプのID(-1:追加なし)                                */
void
charlist_renewal_all (const gchar *charlist,
                      const gint ft_id);


/******************************************************************************
*                                                                             *
* ja:高レベル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:編集履歴操作
    tmaid,ウインドウ情報
     kind,TRUE:redo,FALSE:undo                                              */
void
history_operation (TmaidWindow    *tmaid,
                   const gboolean  kind);


/*  ja:右マージンで改行する
    tmaid,ウインドウ情報                                                    */
void
margin_operation (TmaidWindow *tmaid);


/*  ja:タブをスペースに変換する
    tmaid,ウインドウ情報                                                    */
void
tab_operation (TmaidWindow *tmaid);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
