/*
    orzwinmenu
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __ORZ_WINMENU_H__
#define __ORZ_WINMENU_H__


#include "orzmdi.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_WINMENU            (orz_winmenu_get_type ())
#define ORZ_WINMENU(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_WINMENU, OrzWinmenu))
#define ORZ_WINMENU_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_WINMENU, OrzWinmenuClass))
#define ORZ_IS_WINMENU(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_WINMENU))
#define ORZ_IS_WINMENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_WINMENU))
#define ORZ_WINMENU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_WINMENU, OrzWinmenuClass))


typedef struct _OrzWinmenu      OrzWinmenu;
typedef struct _OrzWinmenuClass OrzWinmenuClass;


struct _OrzWinmenu
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gint       position;
  gulong     handler_add;
  gulong     handler_change;
  gulong     handler_remove;
  gulong     handler_switch;
  gulong     handler_destroy_mdi;
  gulong     handler_destroy_menu;
  OrzMdi    *mdi;
  GtkWidget *menu_shell;
  GtkWidget *menu_item_head;
  GtkWidget *menu_item_foot;
  GList     *glist;
};
struct _OrzWinmenuClass
{
  GObjectClass parent_class;

  /* -- signals -- */
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_winmenu_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ウインドウメニュー関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
GObject*
orz_winmenu_new (void);


/*  ja:MDIを取得する
    winmenu,オブジェクト
       mdi,MDI                                                              */
#define orz_winmenu_get_mdi(winmenu) ((winmenu)?ORZ_WINMENU(winmenu)->mdi:NULL)


/*  ja:MDIを設定する
    winmenu,オブジェクト
       mdi,MDI                                                              */
void
orz_winmenu_set_mdi (OrzWinmenu *winmenu,
                     OrzMdi     *mdi);


/*  ja:メニューを取得する
    winmenu,オブジェクト
       menu,メニュー                                                        */
#define orz_winmenu_get_menu(winmenu)                                       \
                            ((winmenu)?ORZ_WINMENU(winmenu)->menu_shell:NULL)


/*  ja:メニューを設定する
       winmenu,オブジェクト
    menu_shell,メニュー
      position,位置(0...,-1:末尾)                                           */
void
orz_winmenu_set_menu (OrzWinmenu *winmenu,
                      GtkWidget  *menu_shell,
                      gint        position);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_WINMENU_H__ */
