/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#define __USE_GNU
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include "call_vmm.h"

static char buf[16384];

static int
vmcall_getstatus (char *buf, int len)
{
	call_vmm_function_t f;
	call_vmm_arg_t a;
	call_vmm_ret_t r;

	CALL_VMM_GET_FUNCTION ("get_status", &f);
	if (!call_vmm_function_callable (&f))
		return -1;
	a.rbx = (long)buf;
	a.rcx = (long)(len - 1);
	call_vmm_call_function (&f, &a, &r);
	if ((int)r.rax)
		return -1;
	buf[(int)r.rcx] = '\0';
	return 0;
}

static void
getstatus (char **st1, char **st2)
{
	*st1 = "Unknown";
	*st2 = "";
	if (vmcall_getstatus (buf, sizeof buf))
		return;
	*st1 = "Running";
	*st2 = buf;
}

static gint
timer_callback (gpointer data)
{
	GtkLabel *label2, *label3;
	char *st1, *st2;

	label2 = (GtkLabel *)lookup_widget ((GtkWidget *)data, "label2");
	label3 = (GtkLabel *)lookup_widget ((GtkWidget *)data, "label3");
	getstatus (&st1, &st2);
	gtk_label_set_text (label2, st1);
	gtk_label_set_text (label3, st2);
	return 1;
}

int
main (int argc, char *argv[])
{
  GtkWidget *vmmstatus;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  vmmstatus = create_vmmstatus ();
  gtk_widget_show (vmmstatus);

  gtk_timeout_add (1000, (GtkFunction)timer_callback, vmmstatus);
  gtk_main ();
  return 0;
}

