/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * リスト処理ヘッダファイル
 * \file IDMan_PKCardAccess.h
 */


/* 標準ライブラリ */


/* 外部ライブラリ */


/* 作成ライブラリ */


#ifndef _IDMAN_PKCARDACCESS_H_
#define _IDMAN_PKCARDACCESS_H_



/* カードアクセス有り定義（コメントアウトするとカードアクセスしない。） */
#define CARD_ACCESS


/* EFID定義 */
#define DIR_INF_EF_ID "\x2F\x00"
#define ODF_INF_EF_ID "\x50\x31"
#define TOK_INF_EF_ID "\x50\x32"

/* APDUコマンド定義 */
#define SEL_BASE_DF "\x00\xA4\x04\x00"
#define SEL_BASE_EF "\x00\xA4\x02\x0C"
#define VER_BASE "\x00\x20\x00\x80"
#define INT_BASE "\x00\x88\x00\x80"
#define READ_BASE "\x00\xB0\x80\x00"
#define UPD_BASE "\x00\xD6\x80\x00"

/* EFタイプ定義 */
#define EF_DIR 0
#define EF_ODF 1
#define EF_TOKEN 2
#define EF_PRKDF 3
#define EF_PUKDF 4
#define EF_CDFZ 5
#define EF_CDFX 6
#define EF_AODF 7
#define EF_DODF 8
#define EF_DODFLEN 9
#define EF_CDFZV 10
#define EF_CDFXV 11
#define EF_DODFV 12

/* ファイルサイズ定義 */
#define MAX_SIZE_DIR 128
#define MAX_SIZE_ODF 128
#define MAX_SIZE_TOKEN 256
#define MAX_SIZE_PRKDF 768
#define MAX_SIZE_PUKDF 768
#define MAX_SIZE_CDF 640
#define MAX_SIZE_AODF 128
#define MAX_SIZE_DODF 128
#define MAX_SIZE_CERT 2048
#define MAX_SIZE_ID_PASS 1280
#define MAX_SIZE_ID_PASS_LEN 4

/* リーダリスト定義（ダミーデータ） */
#define READER_LIST "AseIIIeUSB 00 00\x00\x00"

/* カードデータ定義（ダミーデータ） */
#define	DATA_DIR	"\x30\x42\x61\x1B\x4F\x0C\xA0\x00\x00\x00\x63\x50\x4B\x43\x53\x2D\x31\x35\x50\x07\x52\x53\x41\x20\x44\x49\x52\x51\x02\x50\x00\x61\x23\x4F\x10\x49\x44\x20\x46\x55\x4E\x43\x54\x49\x4F\x4E\x20\x53\x4F\x46\x54\x50\x0B\x49\x44\x20\x46\x55\x4E\x43\x20\x44\x49\x52\x51\x02\x05\x00"

#define	DATA_ODF	"\x30\x46\xA0\x08\x30\x06\x04\x04\x05\x00\x55\x00\xA1\x08\x30\x06\x04\x04\x05\x00\x55\x01\xA3\x08\x30\x06\x04\x04\x05\x00\x55\x03\xA5\x08\x30\x06\x04\x04\x05\x00\x55\x05\xA6\x08\x30\x06\x04\x04\x05\x00\x55\x06\xA7\x08\x30\x06\x04\x04\x05\x00\x55\x07\xA8\x08\x30\x06\x04\x04\x05\x00\x55\x08"

#define	DATA_TOKEN	"\x30\x79\x0C\x0B\x49\x44\x20\x46\x55\x4E\x43\x54\x49\x4F\x4E\x0C\x06\x4E\x54\x54\x43\x4F\x4D\x0C\x06\x54\x4F\x59\x4F\x54\x41\x04\x08\x00\x00\x00\x00\x00\x00\x00\x01\x03\x04\x00\x00\x00\x05\x02\x02\xFF\xFF\x02\x02\x00\x02\x02\x01\x10\x02\x01\x10\x02\x02\x00\x00\x02\x02\x00\x00\x02\x02\x00\x00\x02\x02\x00\x00\x02\x02\x01\x00\x02\x02\x01\x00\x0C\x08\x20\x06\x12\x01\x00\x00\x00\x00\x02\x08\x00\x01\x00\x00\x08\x00\x04\x00\x02\x08\x00\x03\x00\x00\x20\x00\x04\x00\x02\x06\x02\x20\x00\x00\x04\x00"

#define	DATA_PRKDF	"\x70\x82\x02\xAC\x30\x81\xE1\xA0\x01\x00\x04\x02\x00\x03\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x09\x53\x65\x63\x72\x65\x74\x4B\x65\x79\xA1\x03\x03\x01\x00\x04\x02\x00\x00\xA1\x03\x03\x01\x02\x04\x08\x00\x00\x00\x01\x00\x00\x00\x01\xA1\x03\x03\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x03\x01\x11\x04\x04\x20\x07\x12\x31\xA1\x03\x03\x01\x0C\x04\x01\x00\xA1\x03\x03\x01\x63\x04\x01\x00\xA1\x03\x03\x01\x66\x04\x01\x00\xA2\x04\x03\x00\x01\x01\x0C\x0C\x53\x69\x67\x6E\x61\x74\x75\x72\x65\x4B\x65\x79\xA2\x04\x03\x00\x01\x03\x04\x01\x01\xA2\x04\x03\x00\x01\x05\x04\x01\x00\xA2\x04\x03\x00\x01\x08\x04\x01\x01\xA2\x04\x03\x00\x01\x09\x04\x01\x00\xA2\x04\x03\x00\x01\x07\x04\x01\x00\xA2\x04\x03\x00\x01\x62\x04\x01\x00\xA2\x04\x03\x00\x01\x65\x04\x01\x00\xA2\x04\x03\x00\x01\x64\x04\x01\x00\xA2\x04\x03\x00\x02\x10\x04\x01\x00\xA2\x04\x03\x00\x02\x02\x04\x01\x00\xA3\x04\x03\x00\x01\x20\x04\x04\x55\x00\x55\x10\x30\x81\xE1\xA0\x01\x00\x04\x02\x00\x03\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x09\x53\x65\x63\x72\x65\x74\x4B\x65\x79\xA1\x03\x03\x01\x00\x04\x02\x00\x00\xA1\x03\x03\x01\x02\x04\x08\x00\x00\x00\x02\x00\x00\x00\x02\xA1\x03\x03\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x03\x01\x11\x04\x04\x20\x07\x12\x31\xA1\x03\x03\x01\x0C\x04\x01\x00\xA1\x03\x03\x01\x63\x04\x01\x00\xA1\x03\x03\x01\x66\x04\x01\x00\xA2\x04\x03\x00\x01\x01\x0C\x0C\x53\x69\x67\x6E\x61\x74\x75\x72\x65\x4B\x65\x79\xA2\x04\x03\x00\x01\x03\x04\x01\x01\xA2\x04\x03\x00\x01\x05\x04\x01\x00\xA2\x04\x03\x00\x01\x08\x04\x01\x01\xA2\x04\x03\x00\x01\x09\x04\x01\x00\xA2\x04\x03\x00\x01\x07\x04\x01\x00\xA2\x04\x03\x00\x01\x62\x04\x01\x00\xA2\x04\x03\x00\x01\x65\x04\x01\x00\xA2\x04\x03\x00\x01\x64\x04\x01\x00\xA2\x04\x03\x00\x02\x10\x04\x01\x00\xA2\x04\x03\x00\x02\x02\x04\x01\x00\xA3\x04\x03\x00\x01\x20\x04\x04\x55\x00\x55\x20\x30\x81\xE1\xA0\x01\x00\x04\x02\x00\x03\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x09\x53\x65\x63\x72\x65\x74\x4B\x65\x79\xA1\x03\x03\x01\x00\x04\x02\x00\x00\xA1\x03\x03\x01\x02\x04\x08\x00\x00\x00\x03\x00\x00\x00\x03\xA1\x03\x03\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x03\x01\x11\x04\x04\x20\x07\x12\x31\xA1\x03\x03\x01\x0C\x04\x01\x00\xA1\x03\x03\x01\x63\x04\x01\x00\xA1\x03\x03\x01\x66\x04\x01\x00\xA2\x04\x03\x00\x01\x01\x0C\x0C\x53\x69\x67\x6E\x61\x74\x75\x72\x65\x4B\x65\x79\xA2\x04\x03\x00\x01\x03\x04\x01\x01\xA2\x04\x03\x00\x01\x05\x04\x01\x00\xA2\x04\x03\x00\x01\x08\x04\x01\x01\xA2\x04\x03\x00\x01\x09\x04\x01\x00\xA2\x04\x03\x00\x01\x07\x04\x01\x00\xA2\x04\x03\x00\x01\x62\x04\x01\x00\xA2\x04\x03\x00\x01\x65\x04\x01\x00\xA2\x04\x03\x00\x01\x64\x04\x01\x00\xA2\x04\x03\x00\x02\x10\x04\x01\x00\xA2\x04\x03\x00\x02\x02\x04\x01\x00\xA3\x04\x03\x00\x01\x20\x04\x04\x55\x00\x55\x30"



#define	DATA_PUKDF	"\x70\x82\x02\xAC\x30\x81\xE1\xA0\x01\x00\x04\x02\x00\x02\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x09\x50\x75\x62\x6C\x69\x63\x4B\x65\x79\xA1\x03\x02\x01\x00\x04\x02\x00\x00\xA1\x03\x02\x01\x02\x04\x08\x00\x00\x00\x01\x00\x00\x00\x01\xA1\x03\x02\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x02\x01\x11\x04\x04\x20\x07\x12\x31\xA1\x03\x02\x01\x0C\x04\x01\x00\xA1\x03\x02\x01\x63\x04\x01\x00\xA1\x03\x02\x01\x66\x04\x01\x00\xA2\x04\x02\x00\x01\x01\x0C\x0C\x44\x65\x63\x6F\x64\x69\x6E\x67\x4B\x65\x79\x20\xA2\x04\x02\x00\x01\x03\x04\x01\x01\xA2\x04\x02\x00\x01\x05\x04\x01\x01\xA2\x04\x02\x00\x01\x08\x04\x01\x00\xA2\x04\x02\x00\x01\x09\x04\x01\x00\xA2\x04\x02\x00\x01\x07\x04\x01\x00\xA2\x04\x02\x00\x01\x62\x04\x01\x00\xA2\x04\x02\x00\x01\x65\x04\x01\x00\xA2\x04\x02\x00\x01\x64\x04\x01\x00\xA2\x04\x02\x00\x02\x10\x04\x01\x00\xA2\x04\x02\x00\x02\x02\x04\x01\x00\xA3\x04\x02\x00\x01\x20\x04\x04\x55\x00\x55\x11\x30\x81\xE1\xA0\x01\x00\x04\x02\x00\x02\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x09\x50\x75\x62\x6C\x69\x63\x4B\x65\x79\xA1\x03\x02\x01\x00\x04\x02\x00\x00\xA1\x03\x02\x01\x02\x04\x08\x00\x00\x00\x02\x00\x00\x00\x02\xA1\x03\x02\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x02\x01\x11\x04\x04\x20\x07\x12\x31\xA1\x03\x02\x01\x0C\x04\x01\x00\xA1\x03\x02\x01\x63\x04\x01\x00\xA1\x03\x02\x01\x66\x04\x01\x00\xA2\x04\x02\x00\x01\x01\x0C\x0C\x44\x65\x63\x6F\x64\x69\x6E\x67\x4B\x65\x79\x20\xA2\x04\x02\x00\x01\x03\x04\x01\x01\xA2\x04\x02\x00\x01\x05\x04\x01\x01\xA2\x04\x02\x00\x01\x08\x04\x01\x00\xA2\x04\x02\x00\x01\x09\x04\x01\x00\xA2\x04\x02\x00\x01\x07\x04\x01\x00\xA2\x04\x02\x00\x01\x62\x04\x01\x00\xA2\x04\x02\x00\x01\x65\x04\x01\x00\xA2\x04\x02\x00\x01\x64\x04\x01\x00\xA2\x04\x02\x00\x02\x10\x04\x01\x00\xA2\x04\x02\x00\x02\x02\x04\x01\x00\xA3\x04\x02\x00\x01\x20\x04\x04\x55\x00\x55\x21\x30\x81\xE1\xA0\x01\x00\x04\x02\x00\x02\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x09\x50\x75\x62\x6C\x69\x63\x4B\x65\x79\xA1\x03\x02\x01\x00\x04\x02\x00\x00\xA1\x03\x02\x01\x02\x04\x08\x00\x00\x00\x03\x00\x00\x00\x03\xA1\x03\x02\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x02\x01\x11\x04\x04\x20\x07\x12\x31\xA1\x03\x02\x01\x0C\x04\x01\x00\xA1\x03\x02\x01\x63\x04\x01\x00\xA1\x03\x02\x01\x66\x04\x01\x00\xA2\x04\x02\x00\x01\x01\x0C\x0C\x44\x65\x63\x6F\x64\x69\x6E\x67\x4B\x65\x79\x20\xA2\x04\x02\x00\x01\x03\x04\x01\x01\xA2\x04\x02\x00\x01\x05\x04\x01\x01\xA2\x04\x02\x00\x01\x08\x04\x01\x00\xA2\x04\x02\x00\x01\x09\x04\x01\x00\xA2\x04\x02\x00\x01\x07\x04\x01\x00\xA2\x04\x02\x00\x01\x62\x04\x01\x00\xA2\x04\x02\x00\x01\x65\x04\x01\x00\xA2\x04\x02\x00\x01\x64\x04\x01\x00\xA2\x04\x02\x00\x02\x10\x04\x01\x00\xA2\x04\x02\x00\x02\x02\x04\x01\x00\xA3\x04\x02\x00\x01\x20\x04\x04\x55\x00\x55\x31"

#define	DATA_CDFZ	"\x30\x82\x02\x76\x30\x81\xCF\xA0\x01\x00\x04\x02\x00\x01\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x10\x54\x72\x75\x73\x74\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA1\x03\x01\x00\x80\x04\x02\x00\x00\xA1\x03\x01\x00\x86\x04\x01\x01\xA1\x03\x01\x00\x87\x04\x01\x00\xA1\x03\x01\x00\x90\x04\x03\x00\x00\x00\xA1\x03\x01\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x01\x01\x11\x04\x04\x20\x07\x12\x31\xA2\x04\x01\x00\x01\x01\x0C\x0B\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA2\x04\x01\x00\x01\x02\x04\x08\x00\x00\x00\x01\x00\x00\x00\x01\xA2\x04\x01\x00\x00\x81\x04\x06\x4E\x54\x54\x43\x4F\x4D\xA2\x04\x01\x00\x00\x82\x04\x08\x00\x00\x00\x00\x00\x00\x00\x01\xA2\x04\x01\x00\x00\x11\x04\x04\x05\x00\x55\x15\xA2\x04\x01\x00\x00\x89\x04\x00\xA2\x04\x01\x00\x00\x8A\x04\x00\xA2\x04\x01\x00\x00\x8B\x04\x00\xA2\x04\x01\x00\x00\x88\x04\x01\x00\x30\x81\xCF\xA0\x01\x00\x04\x02\x00\x01\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x10\x54\x72\x75\x73\x74\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA1\x03\x01\x00\x80\x04\x02\x00\x00\xA1\x03\x01\x00\x86\x04\x01\x01\xA1\x03\x01\x00\x87\x04\x01\x00\xA1\x03\x01\x00\x90\x04\x03\x00\x00\x00\xA1\x03\x01\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x01\x01\x11\x04\x04\x20\x07\x12\x31\xA2\x04\x01\x00\x01\x01\x0C\x0B\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA2\x04\x01\x00\x01\x02\x04\x08\x00\x00\x00\x02\x00\x00\x00\x02\xA2\x04\x01\x00\x00\x81\x04\x06\x4E\x54\x54\x43\x4F\x4D\xA2\x04\x01\x00\x00\x82\x04\x08\x00\x00\x00\x00\x00\x00\x00\x02\xA2\x04\x01\x00\x00\x11\x04\x04\x05\x00\x55\x25\xA2\x04\x01\x00\x00\x89\x04\x00\xA2\x04\x01\x00\x00\x8A\x04\x00\xA2\x04\x01\x00\x00\x8B\x04\x00\xA2\x04\x01\x00\x00\x88\x04\x01\x00\x30\x81\xCF\xA0\x01\x00\x04\x02\x00\x01\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x10\x54\x72\x75\x73\x74\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA1\x03\x01\x00\x80\x04\x02\x00\x00\xA1\x03\x01\x00\x86\x04\x01\x01\xA1\x03\x01\x00\x87\x04\x01\x00\xA1\x03\x01\x00\x90\x04\x03\x00\x00\x00\xA1\x03\x01\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x01\x01\x11\x04\x04\x20\x07\x12\x31\xA2\x04\x01\x00\x01\x01\x0C\x0B\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA2\x04\x01\x00\x01\x02\x04\x08\x00\x00\x00\x03\x00\x00\x00\x03\xA2\x04\x01\x00\x00\x81\x04\x06\x4E\x54\x54\x43\x4F\x4D\xA2\x04\x01\x00\x00\x82\x04\x08\x00\x00\x00\x00\x00\x00\x00\x03\xA2\x04\x01\x00\x00\x11\x04\x04\x05\x00\x55\x35\xA2\x04\x01\x00\x00\x89\x04\x00\xA2\x04\x01\x00\x00\x8A\x04\x00\xA2\x04\x01\x00\x00\x8B\x04\x00\xA2\x04\x01\x00\x00\x88\x04\x01\x00"

#define	DATA_CDFX	"\x30\x82\x02\x79\x30\x81\xD0\xA0\x01\x00\x04\x02\x00\x01\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x11\x50\x75\x62\x6C\x69\x63\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA1\x03\x01\x00\x80\x04\x02\x00\x00\xA1\x03\x01\x00\x86\x04\x01\x01\xA1\x03\x01\x00\x87\x04\x01\x00\xA1\x03\x01\x00\x90\x04\x03\x00\x00\x00\xA1\x03\x01\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x01\x01\x11\x04\x04\x20\x07\x12\x31\xA2\x04\x01\x00\x01\x01\x0C\x0B\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA2\x04\x01\x00\x01\x02\x04\x08\x00\x00\x00\x01\x00\x00\x00\x01\xA2\x04\x01\x00\x00\x81\x04\x06\x4E\x54\x54\x43\x4F\x4D\xA2\x04\x01\x00\x00\x82\x04\x08\x00\x00\x00\x00\x00\x00\x00\x01\xA2\x04\x01\x00\x00\x11\x04\x04\x05\x00\x55\x16\xA2\x04\x01\x00\x00\x89\x04\x00\xA2\x04\x01\x00\x00\x8A\x04\x00\xA2\x04\x01\x00\x00\x8B\x04\x00\xA2\x04\x01\x00\x00\x88\x04\x01\x00\x30\x81\xD0\xA0\x01\x00\x04\x02\x00\x01\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x11\x50\x75\x62\x6C\x69\x63\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA1\x03\x01\x00\x80\x04\x02\x00\x00\xA1\x03\x01\x00\x86\x04\x01\x01\xA1\x03\x01\x00\x87\x04\x01\x00\xA1\x03\x01\x00\x90\x04\x03\x00\x00\x00\xA1\x03\x01\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x01\x01\x11\x04\x04\x20\x07\x12\x31\xA2\x04\x01\x00\x01\x01\x0C\x0B\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA2\x04\x01\x00\x01\x02\x04\x08\x00\x00\x00\x02\x00\x00\x00\x02\xA2\x04\x01\x00\x00\x81\x04\x06\x4E\x54\x54\x43\x4F\x4D\xA2\x04\x01\x00\x00\x82\x04\x08\x00\x00\x00\x00\x00\x00\x00\x02\xA2\x04\x01\x00\x00\x11\x04\x04\x05\x00\x55\x26\xA2\x04\x01\x00\x00\x89\x04\x00\xA2\x04\x01\x00\x00\x8A\x04\x00\xA2\x04\x01\x00\x00\x8B\x04\x00\xA2\x04\x01\x00\x00\x88\x04\x01\x00\x30\x81\xD0\xA0\x01\x00\x04\x02\x00\x01\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x11\x50\x75\x62\x6C\x69\x63\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA1\x03\x01\x00\x80\x04\x02\x00\x00\xA1\x03\x01\x00\x86\x04\x01\x01\xA1\x03\x01\x00\x87\x04\x01\x00\xA1\x03\x01\x00\x90\x04\x03\x00\x00\x00\xA1\x03\x01\x01\x10\x04\x04\x20\x07\x01\x01\xA1\x03\x01\x01\x11\x04\x04\x20\x07\x12\x31\xA2\x04\x01\x00\x01\x01\x0C\x0B\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x65\xA2\x04\x01\x00\x01\x02\x04\x08\x00\x00\x00\x03\x00\x00\x00\x03\xA2\x04\x01\x00\x00\x81\x04\x06\x4E\x54\x54\x43\x4F\x4D\xA2\x04\x01\x00\x00\x82\x04\x08\x00\x00\x00\x00\x00\x00\x00\x03\xA2\x04\x01\x00\x00\x11\x04\x04\x05\x00\x55\x36\xA2\x04\x01\x00\x00\x89\x04\x00\xA2\x04\x01\x00\x00\x8A\x04\x00\xA2\x04\x01\x00\x00\x8B\x04\x00\xA2\x04\x01\x00\x00\x88\x04\x01\x00"

#define	DATA_AODF	"\x70\x7C\x30\x3C\xA0\x01\x00\x04\x02\x00\x00\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x07\x55\x73\x65\x72\x50\x69\x6E\xA1\x03\x00\x00\x10\x0C\x03\x50\x49\x4E\xA1\x03\x00\x00\x11\x04\x04\x05\x00\x55\x18\xA1\x03\x00\x00\x12\x04\x02\x00\x01\x30\x3C\xA0\x01\x00\x04\x02\x00\x00\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x07\x53\x6F\x20\x20\x50\x69\x6E\xA1\x03\x00\x00\x10\x0C\x03\x50\x49\x4E\xA1\x03\x00\x00\x11\x04\x04\x05\x00\x55\x28\xA1\x03\x00\x00\x12\x04\x02\x00\x02"

#define	DATA_DODF	"\x70\x41\x30\x3F\xA0\x01\x00\x04\x02\x00\x00\xA0\x01\x01\x04\x01\x01\xA0\x01\x02\x04\x01\x01\xA0\x01\x03\x0C\x07\x49\x44\x2F\x50\x41\x53\x53\xA1\x03\x00\x00\x10\x0C\x07\x49\x44\x2F\x50\x41\x53\x53\xA1\x03\x00\x00\x11\x04\x04\x05\x00\x55\x17\xA1\x03\x00\x00\x12\x04\x00"

#define	DATA_DODFV	"\x30\x15\xA0\x13\x0C\x0A\x31\x32\x33\x34\x35\x36\x37\x38\x39\x30\x0C\x05\x30\x31\x32\x33\x34"

#define	DATA_CDFXV	"\x30\x82\x03\x07\x30\x82\x02\x70\xA0\x03\x02\x01\x02\x02\x01\x14\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x05\x05\x00\x30\x81\xD3\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x4A\x50\x31\x0E\x30\x0C\x06\x03\x55\x04\x08\x0C\x05\x41\x69\x63\x68\x69\x31\x0F\x30\x0D\x06\x03\x55\x04\x07\x0C\x06\x54\x6F\x79\x6F\x74\x61\x31\x2E\x30\x2C\x06\x03\x55\x04\x0A\x0C\x25\x54\x6F\x79\x6F\x74\x61\x20\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x43\x6F\x6C\x6C\x65\x67\x65\x20\x6F\x66\x20\x54\x65\x63\x68\x6E\x6F\x6C\x6F\x67\x79\x31\x27\x30\x25\x06\x03\x55\x04\x0B\x0C\x1E\x49\x6E\x66\x6F\x6D\x61\x74\x69\x6F\x6E\x20\x45\x6E\x67\x69\x6E\x65\x65\x72\x69\x6E\x67\x20\x53\x65\x63\x74\x69\x6F\x6E\x31\x21\x30\x1F\x06\x03\x55\x04\x03\x0C\x18\x53\x65\x63\x75\x72\x65\x20\x54\x72\x75\x73\x74\x41\x6E\x63\x68\x6F\x72\x43\x65\x72\x74\x30\x31\x31\x27\x30\x25\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x09\x01\x16\x18\x73\x65\x63\x75\x72\x65\x63\x61\x40\x74\x6F\x79\x6F\x74\x61\x2D\x63\x74\x2E\x61\x63\x2E\x6A\x70\x30\x1E\x17\x0D\x30\x37\x30\x31\x31\x35\x31\x30\x35\x36\x34\x36\x5A\x17\x0D\x30\x37\x30\x33\x31\x36\x31\x30\x35\x36\x34\x36\x5A\x30\x81\xBE\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x4A\x50\x31\x0E\x30\x0C\x06\x03\x55\x04\x08\x0C\x05\x41\x69\x63\x68\x69\x31\x0F\x30\x0D\x06\x03\x55\x04\x07\x0C\x06\x54\x6F\x79\x6F\x74\x61\x31\x2F\x30\x2D\x06\x03\x55\x04\x0A\x0C\x26\x54\x6F\x79\x6F\x74\x61\x20\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x43\x6F\x6C\x6C\x65\x61\x67\x65\x20\x6F\x66\x20\x54\x65\x63\x68\x6E\x6F\x6C\x6F\x67\x79\x31\x27\x30\x25\x06\x03\x55\x04\x0B\x0C\x1E\x49\x6E\x66\x6F\x6D\x61\x74\x69\x6F\x6E\x20\x45\x6E\x67\x69\x6E\x65\x65\x72\x69\x6E\x67\x20\x53\x65\x63\x74\x69\x6F\x6E\x31\x0F\x30\x0D\x06\x03\x55\x04\x03\x0C\x06\x55\x53\x45\x52\x30\x31\x31\x23\x30\x21\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x09\x01\x16\x14\x68\x69\x72\x6F\x40\x75\x73\x65\x2D\x65\x62\x69\x73\x75\x2E\x63\x6F\x2E\x6A\x70\x30\x81\x9F\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x01\x05\x00\x03\x81\x8D\x00\x30\x81\x89\x02\x81\x81\x00\xAF\x5A\xFA\x80\x02\xAA\x7F\x7D\x79\x17\x86\x1F\x08\x0B\x64\x01\xE3\x0A\xF4\xEF\xEB\x19\xF4\x27\xEE\x33\xC4\x47\x19\xB3\xB2\x60\x4A\xC9\xB0\x63\x2E\xEB\x61\x1E\x5F\x83\xF6\xF7\x24\x96\x87\x31\xDE\x32\x2F\xB3\xE1\xAC\xA1\xA2\x69\x40\xB7\x7F\x28\x6C\x63\x95\x53\x70\xED\x9A\xCF\xAF\xAD\x4F\x21\xE9\x0F\x42\x5A\xCA\xEC\x8B\x99\xAC\x54\xE8\xEE\xD8\x8F\x67\x92\x9C\x1F\x9B\x12\x99\xC1\xF3\xC3\xFE\xF9\x66\x96\x11\x73\x63\xEA\x96\x2C\xB7\x6B\x8E\xE3\x1C\x92\x50\xBE\xAE\xDB\x7D\xE5\x1A\x9A\xB2\x42\x7E\xBE\xE8\xA0\xA5\x02\x03\x01\x00\x01\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x05\x05\x00\x03\x81\x81\x00\x8F\x32\xD8\x77\x81\x7B\xEE\x6C\x30\xD8\xD5\xCA\x8E\x3E\xF9\x6B\x64\xAC\xA7\xD8\xE7\x7C\x1A\x16\x8B\x25\x31\x8C\x44\x33\x28\xCE\xF0\x8E\xF0\x26\xE3\x8B\xC9\xF7\x3D\x36\xC1\x72\x17\x9D\xD2\x0F\xBE\x25\x6D\xE5\x03\x37\x5E\x09\x10\xB1\x0C\x9C\x43\x5B\xE0\x20\x52\xEA\xA3\x22\x9A\x9E\x03\xA4\x16\x36\xA1\x7D\x3C\xDB\x5D\x50\x31\x41\x47\x6F\xF3\x04\x5C\xB9\x20\x7B\x29\x35\x43\xB6\x8F\x32\xD5\xB5\xF8\x0D\x87\xDA\x72\x44\xBD\xFC\xF3\x9E\xF9\x42\x24\xDC\xA5\xB6\x34\x30\x30\x48\x04\x96\x71\x90\x91\x90\x23\x9B\xE5\xFD"

CK_RV CardEstablishContext(CK_ULONG_PTR phContext);
CK_RV CardReleaseContext(CK_ULONG_PTR phContext);
CK_RV CardListReaders(CK_ULONG hContext, CK_BYTE_PTR pmszReaders, CK_ULONG_PTR pdwReaders);
CK_RV CardConnect(CK_ULONG hContext, CK_BYTE_PTR reader, CK_ULONG_PTR phCard, CK_ULONG_PTR dwActiveProtocol);
CK_RV CardDisconnect(CK_ULONG hCard);
CK_RV CardStatus(CK_ULONG hCard, CK_BYTE_PTR reader);
CK_RV CardTransmit(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_BYTE_PTR sendBuf, CK_ULONG sendLen, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV SelectFileDF(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_BYTE_PTR aid, CK_ULONG aidLen, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV SelectFileEF(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_BYTE_PTR efid, CK_ULONG efidLen, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV Verify(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_BYTE_PTR pin, CK_ULONG pinLen, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV InternalAuth(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_BYTE_PTR data, CK_ULONG dataLen, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV ReadBinary(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_ULONG efType, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV UpdateBinary(CK_ULONG hCard, CK_ULONG_PTR dwActiveProtocol, CK_BYTE_PTR data, CK_ULONG dataLen, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);
CK_RV GetICCardData( CK_ULONG efType, CK_BYTE_PTR rcvBuf, CK_ULONG_PTR rcvLen);



#endif
