/*
 * From BitVisor 1.4 core/main.c
 */
/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2014 Yuichi Watanabe
 */

#include <core/printf.h>
#include "callrealmode.h"
#include "cpu_emul.h"
#include "current.h"
#include "reload_os.h"
#include "uefi.h"
#include "loadbootsector.h"
#include "vcpu.h"
#include "vm.h"

void
reload_os_thread(void *args)
{
	u32 tmpbufaddr, tmpbufsize;
	u8 boot_drive;
	int method = 0;

	if (uefi_booted) {
		printf("Can't relead OS on UIFI.\n");
		current->vmctl.init_signal ();
		return;
	}

	callrealmode_usevcpu (current);
	method = vm0_boot_method(0, &boot_drive);
	if (method > 0) {
		/* vm0.boot_drive=xx or vm0.boot_partition */
		get_tmpbuf (&tmpbufaddr, &tmpbufsize);
		load_bootsector (boot_drive, tmpbufaddr,
				 tmpbufsize,
				 (method == 2 ? true : false));
	}
	vcpu_reset();
	if (method > 0) {
		/* vm0.boot_drive=xx or vm0.boot_partition */
		copy_bootsector ();
	} else {
		/* vm0.boot_int18 */
		cpu_emul_realmode_int(0x18);
	}
}
