#include "dice_parser.hpp"
#include "dice_funcs.h"
#include <iostream>
#include <string>
#include <map>
#include <algorithm>
#include <iterator>
#include <math.h>

#include <boost/spirit/tree/tree_to_xml.hpp>

// using namespace boost::spirit;

void ray::dice::tree_out(iter_t const& i, std::ostream& out, const std::string& str) {
  out << str << "node : " << std::string( i->value.begin(), i->value.end() ) << std::endl;
  for( iter_t t = i->children.begin(); t != i->children.end(); t++ ) {
    tree_out( t, out, str + "  ");
  }
}

void ray::dice::rpn_out(iter_t const& i, std::ostream& out) {
	for( iter_t t = i->children.begin(); t != i->children.end(); ++t ){
		rpn_out( t, out );
	}
	out << " " << std::string( i->value.begin(), i->value.end() );
}

void ray::dice::xml_out(tree_parse_info<> const& p, std::ostream& out, const std::string& str) {
  std::map<parser_id, std::string> rule_names;
  rule_names[ray::dice::DiceParser::exprID]  = "expr";
  rule_names[ray::dice::DiceParser::stermID] = "sterm";
  rule_names[ray::dice::DiceParser::mtermID] = "mterm";
  rule_names[ray::dice::DiceParser::dtermID] = "dterm";
  rule_names[ray::dice::DiceParser::ptermID] = "pterm";
  rule_names[ray::dice::DiceParser::valID]   = "value";
  rule_names[ray::dice::DiceParser::identID] = "ident";
  rule_names[ray::dice::DiceParser::ftermID] = "fterm";
  tree_to_xml(out, p.trees, str.c_str(), rule_names);
}

ray::dice::node_val_data_t pow(const ray::dice::node_val_data_t& l, const ray::dice::node_val_data_t& r) {
    ray::dice::node_val_data_t ret = 1;
    if( l > 10 || r > 10 ){
        ret = static_cast<ray::dice::node_val_data_t>( ::pow( l, r ) );
    } else {
        for( int i = 0; i < r; ++i ) {
            ret *= l;
        }
    }
    return ret;
}

void ray::dice::calc_val(iter_t const& i, calc_func_t f){
  iter_t st = i->children.begin();
  iter_t ed = i->children.end();

  for( iter_t it = st; it != ed; ++it){
      calc_val( it, f );
  }
	
  if( i->value.id() == ray::dice::DiceParser::valID ){
      std::string integer(i->value.begin(), i->value.end() );
      long lo = strtol(integer.c_str(), 0, 10);
//      std::cerr << "value : " << lo << ".\n";
      i->value.value( static_cast<node_val_data_t>( lo ) );
  }else if( i->value.id() == ray::dice::DiceParser::identID ){
      std::string name( i->value.begin(), i->value.end() );
      std::vector<node_val_data_t> params;
      for( iter_t it = st; it != ed; ++it ) {
          params.push_back( it->value.value() );
      }
//      std::cerr << "function call : " << name << "( ";
//      std::copy( params.begin(), params.end(), std::ostream_iterator<node_val_data_t>( std::cerr, " " ) );
//      std::cerr << ").\n";
      if( f ) {
          i->value.value( f( name.c_str(), params ) );
      } else {
          std::cerr << "assert : calc_function f is null. in calc_val()." << std::endl;
          i->value.value( 0 );
      }
  }else{
      switch( *(i->value.begin()) ){
      case '+':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
          const iter_t end = i->children.end();
          node_val_data_t ret = left->value.value();
          for ( ; right != end; ++right ) {
              ret += right->value.value();
          }
          i->value.value( ret );
      }
      break;
      case '-':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
          const iter_t end = i->children.end();
          node_val_data_t ret = left->value.value();
          for ( ; right != end; ++right ) {
              ret -= right->value.value();
          }
          i->value.value( ret );
      }
      break;
      case '*':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
          const iter_t end = i->children.end();
          node_val_data_t ret = left->value.value();
          for ( ; right != end; ++right ) {
              ret *= right->value.value();
          }
          i->value.value( ret );
      }
      break;
      case '/':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
          const iter_t end = i->children.end();
          node_val_data_t ret = left->value.value();
          for ( ; right != end; ++right ) {
              ret /= right->value.value();
          }
          i->value.value( ret );
      }
      break;
      case '%':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
          const iter_t end = i->children.end();
          node_val_data_t ret = left->value.value();
          for ( ; right != end; ++right ) {
              ret %= right->value.value();
          }
          i->value.value( ret );
      }
      break;
      case '^':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
          node_val_data_t loop = right->value.value();
          const node_val_data_t v = left->value.value();
//          std::cerr << "v is " << v << ", loop is " << loop << ".\n";
          i->value.value( pow(v, loop) );
                
      }
      break;
      case 'D':
      case 'd':
      {
          iter_t left = i->children.begin();
          iter_t right = left;
          ++right;
                
          const node_val_data_t face = right->value.value();
          const node_val_data_t num = left->value.value();
          ray::dice::RangeRandom rr( 1, face, static_cast<long>( time(0) ) );
          node_val_data_t ret = 0;
          for( int j = 0; j < num; ++j ) {
              node_val_data_t n = rr.next();
              ret += n;
//              std::cerr << "dice D" << face << " is " << n << "." << std::endl;
          }
          i->value.value( ret );
      }
      break;
      }
  }
}

void ray::dice::calc_val_out( iter_t const& i, calc_func_t f, std::ostream& out ) {
    calc_val( i, f );
    out << i->value.value();
}

void ray::dice::calc_val_out( iter_t const& i, std::ostream& out ) {
    calc_val( i, NULL );
    out << i->value.value();
}

