<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * [eBeB[ENX
 * 
 * @package  tima
 * @version  SVN: $Id: Utility.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Utility
{

    /**
     * A_[o[L@̕ Pacal L@ɕϊ
     * 
     * @param  string $name
     * @return string
     * @access public
     */
    function formatName($name)
    {
        return 
            str_replace(' ', '', 
                ucwords(
                    preg_replace('[^a-z0-9 ]', '', 
                         str_replace('_', ' ', strtolower($name)))));
    }

    /**
     * ̔z}[W
     * 
     * array_merge()֐łȂdzRɃ}[W
     * array_merge_recursive()֐Ƃ̈Ⴂ͓L[Œl㏑
     * 
     * CakePHPSet::merge()Ql
     * 
     * $a = array('User'=>array('name'=>'ikeda', 'age'=>'26'));
     * $b = array('User'=>array('gender'=>'man','age'=>'27'));
     * Utility::merge($a, $b) == array(1) {
     *   ['User'] => array(3) {
     *     'name'   => ikeda
     *     'age'    => 27
     *     'gender' => man
     *   }
     * }
     * 
     * @param  array $array
     * @param  array [...]
     * @return array
     * @access public
     */
    function merge($array)
    {
        $args   = func_get_args();

        $result = (array)current($args);
        while (($arg = next($args)) !== false) {
            foreach ((array)$arg as $varkey => $varvalue)     {
                if(is_array($varvalue) && 
                   isset($result[$varkey]) && is_array($result[$varkey])) {
                    $result[$varkey] = Utility::merge($result[$varkey], $varvalue);
                } elseif(is_int($varkey)) {
                    $result[] = $varvalue;
                } else {
                    $result[$varkey] = $varvalue;
                }
            }
        }

        return $result;
    }

    /**
     * Ro[^Œlϊ
     * 
     * @param  string  $converter
     * @param  string  $attributes
     * @return string
     * @access public
     * @static $module
     */
    function to($converter, $name)
    {
        static $module;
        if (!isset($module)) {
            $module = &Module::factory('Converter');
        }

        return $module->to($converter, $name);
    }

    /**
     * of[^Œl
     * 
     * @param  string  $validation
     * @param  string  $attributes
     * @param  mixed   $params
     * @return boolean
     * @access public
     * @static $module
     */
    function is($validator, $attributes, $params = null)
    {
        static $module;
        if (!isset($module)) {
            $module = &Module::factory('Validator');
        }

        $args = func_get_args();

        return call_user_func_array(array(&$module, 'is'), $args);
    }

    /**
     * RlN^Œl
     * 
     * @param  string  $connector
     * @param  array   $attributes
     * @param  mixed   $params
     * @return string
     * @access public
     * @static $module
     */
    function zip($connector, $attributes, $params = null)
    {
        static $module;
        if (!isset($module)) {
            $module = &Module::factory('Connector');
        }

        $args = func_get_args();

        return call_user_func_array(array(&$module, 'zip'), $args);
    }

    /**
     * AWŒl𕪊
     * 
     * @param  string  $arranger
     * @param  string  $attributes
     * @param  array   $params
     * @return array
     * @access public
     * @static $module
     */
    function cut($arranger, $attributes, $params = array())
    {
        static $module;
        if (!isset($module)) {
            $module = &Module::factory('Arranger');
        }

        $args = func_get_args();

        return call_user_func_array(array(&$module, 'cut'), $args);
    }
}
