<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * եǤ뤿Υ饹
 * 
 * @package  tima
 * @version  SVN: $Id: Question.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Question
{

    /**
     * 󡦥ȥ
     * 
     * @var    Action
     * @access public
     */
    var $action = null;

    /**
     * 䥯饹ɤ߹
     * 
     * @var    ClassLoader
     * @access public
     */
    var $questionLoader = null;

    /**
     * HTMLӥ
     * 
     * @var    HTML|CHTML
     * @access public
     */
    var $builder = null;

    /**
     * 
     * 
     * @var    array
     * @access private
     */
    var $_elements = array();

    /**
     * 顼å
     * 
     * @var    array
     * @access private
     */
    var $_errors = array();

    /**
     * 顼åο
     * 
     * @var    array
     * @access private
     */
    var $_errorMessages = array();

    /**
     * 󥹥ȥ饯
     * 
     * @param  Action $action  󡦥ȥ
     * @param  string $app_dir ץꥱ֥ѥ
     * @access public
     */
    function Question(&$action, $app_dir)
    {
        $this->action         = &$action;
        $this->questionLoader = &new ClassLoader;

        if ($this->action->userAgent->isMobile()) {
            $this->builder = &new CHtml;
        } else {
            $this->builder = &new Html;
        }

        $this->questionLoader->setParents('Question');
        $this->questionLoader->setIncludePath(
            ROOT_PATH . PATH_SEPARATOR . $app_dir);
    }

    /**
     * ǤƴϿ
     * 
     * @param  string $name   Ǥ̾
     * @param  string $type   䥯饹̾
     * @param  array  $params °
     * @return boolean
     * @access public
     */
    function register($name, $type, $params)
    {
        $class_name = $this->questionLoader->load($type);
        if ($class_name === '') {
            trigger_error("Question '${type}' not found", E_USER_WARNING);
            return false;
        }

        // Ǥ
        $element = &new $class_name($name, $this);
        foreach ($params as $varkey => $varvalue) {
            switch ($varkey) {
            case 'default' :
                // ǥեͤϿ
                if ($varvalue !== null) {
                    $element->set($varvalue);
                }
                break;
            case 'required' :
                // ɬܡǤդϿ
                $element->required = (bool)$varvalue;
                break;
            default : 
                if ($varvalue !== null) {
                    $element->$varkey = $varvalue;
                }
                break;
            }
        }
        $element->initialize();
        $this->_elements[$name] = &$element;

        return true;
    }

    /**
     * ϿƤǤ
     * 
     * @param  string $element Ǥ̾
     * @return void
     * @access public
     */
    function remove($element)
    {
        if (isset($this->_elements[$element])) {
            unset($this->_elements[$element]);
        }
    }

    /**
     * ˤƤǤϢֵ
     * - ֵѤϢϼפ°Τ߸
     *  - string  label    => Ǥι̾
     *  - string  html     => HTML
     *  - string  text     => ʸ
     *  - mixed   value    => Υꥯ
     *   - ͤγǼˡ˵ΤɬΥꥯͤǤϤʤ
     *  - string  error    => Ͽ줿顼å
     *   - ʣΥ顼ϿƤкǸϿ줿顼å
     *   - 顼ϿƤʤжʸ
     *  - boolean required => ɬܡǤ
     *   - ɬ => true
     *   - Ǥ => false
     * 
     * @param  void
     * @return array
     * @access public
     */
    function toArray()
    {
        $elements = array();

        foreach ($this->_elements as $name => $element) {
            $elements[$name] = array(
                    'label'    => $element->label, 
                    'html'     => $element->toHtml(), 
                    'text'     => $element->toText(), 
                    'value'    => $element->value, 
                    'error'    => $this->getError($name), 
                    'required' => $element->required, 
                );
        }

        return $elements;
    }

    /**
     * Ǥβʸֵ
     * 
     * @param  string $element Ǥ̾
     * @return string
     * @access public
     */
    function toText($element)
    {
        $text = '';

        if ($this->exists($element)) {
            $text = $this->_elements[$element]->toText();
        }

        return $text;
    }

    /**
     * ˤƤǤǲ򸡾
     * 
     * @param  void
     * @return void
     * @access public
     */
    function validate()
    {
        foreach ($this->_elements as $element) {
            if ($element->required === true) {
                // ɬܹܤͤɬܾ򽼤Ƥ뤫
                // ڷ̤ʤ餹Ǥ˥顼ʤΤǸνϾά
                if (!$element->checkRequired()) {
                    continue;
                }
            } else {
                // Ǥչܤͤ¸ߤʤиڤ
                if (!$this->isNotNull($element->name)) {
                    continue;
                }
            }

            $element->validate();
        }
    }

    /**
     * Ǥ˥顼åϿ
     * 
     * @param  string $element Ǥ̾
     * @param  string $message 顼å
     * @return void
     * @access public
     */
    function setError($element, $message)
    {
        if (!isset($this->_errors[$element])) {
            $this->_errors[$element] = array();
        }

        $this->_errors[$element][] = $message;
    }

    /**
     * ǤϿ줿顼åֵ
     * 
     * @param  string $element Ǥ̾
     * @return string
     * @access public
     */
    function getError($element)
    {
        $error = 
            (isset($this->_errors[$element]) && 
                (count($this->_errors[$element]) > 0)) ? 
                    end($this->_errors[$element]) : '';

        return $error;
    }

    /**
     * ƤΥ顼åֵ
     * 
     * @param  void
     * @return array
     * @access public
     */
    function getAllError()
    {
        $error = array();

        foreach (array_keys($this->_elements) as $name) {
            $element_error = $this->getError($name);
            if ($element_error !== '') {
                $error[$name] = $element_error;
            }
        }

        return $error;
    }

    /**
     * ǤϿƤ륨顼åõ
     * 
     * @param  string $element Ǥ̾
     * @return void
     * @access public
     */
    function clearError($element)
    {
        $this->_errors[$element] = array();
    }

    /**
     * Ǥ˥顼åϿƤ뤫򸡾
     * 
     * @param  string $element Ǥ̾
     * @return boolean
     * @access public
     * @see    Question::getError()
     */
    function isError($element)
    {
        return 
            ($this->getError($element) !== '');
    }

    /**
     * ˥顼åϿƤ뤫򸡾
     * 
     * @param  void
     * @return boolean
     * @access public
     * @see    Question::getAllError()
     */
    function hasError()
    {
        return 
            (count($this->getAllError()) > 0);
    }

    /**
     * дؿexpectError()פΤΥ顼åοϿ
     * - Ŭϡaction.validation.elementפȤ
     *  - action     => 󡦥ȥ̾
     *  - validation => Хǡ̾
     *  - element    => Ǥ̾
     * - Ȥˤϡ*פΥ磻ɥɤ
     * 
     * @param  string $replacement Ŭ
     * @param  string $message     顼åο
     * @return string
     * @access public
     * @see    Question::expectError()
     */
    function setErrorMessages($replacement, $message)
    {
        $this->_errorMessages[$replacement] = $message;
    }

    /**
     * Ǥ̾ȥХǡ̾
     * Ŭʥ顼åϿƤ
     * - Ŭʿ򸡺Ū
     *  - Ŭ󥭡ȤϢˤʤäƤ
     *   - 󥭡 => action.validation.element
     *    - action     => 󡦥ȥ̾
     *    - validation => Хǡ̾
     *    - element    => Ǥ̾
     *  - ̾Ȥˤϡ*פ磻ɥɤȤɾ
     *  - ϡelement > action > validationפɾǰʲΤȤ
     *   1. action.validation.element
     *   2. action.*.element
     *   3. *.validation.element
     *   4. *.*.element
     *   5. action.validation.*
     *   6. *.validation.*
     *   7. *.*.*
     * - ޤ줿ꥭɤѡ
     *  - ꥭ => %ѿ̾%ѿ̾ == ǤΥץѥƥ̾
     *  - ꥭɤΥѡ
     *   1. preg_replace_callback()ؿꥭɡ%[\w]+%פ򸡺
     *   2. Хåƿ̾ؿǤΥץѥƥͤȲ
     *    - Ǥꥭɤѿ̾Ʊ̾Υץѥƥʤǧ
     *     - ץѥƥ¸ߤʸ˥㥹Ȥִ
     *     - ץѥƥ¸ߤʤжʸִ
     * - ѡ̤򥨥顼åȤֵ
     * 
     * @param  string $element    Ǥ̾
     * @param  string $validation ڤ̾
     * @return string
     * @access public
     */
    function expectError($element, $validation)
    {
        $message = '';

        // Ŭʥ顼åο򸡺
        $action     = strtolower($this->action->getName());
        $validation = strtolower($validation);
        $element    = strtolower($element);
        foreach (
            array(
                    '%1$s.%2$s.%3$s', 
                    '%1$s.*.%3$s', 
                    '*.%2$s.%3$s', 
                    '*.*.%3$s', 
                    '%1$s.%2$s.*', 
                    '*.%2$s.*', 
                    '*.*.*', 
                ) as $replacement) {
            $varkey = sprintf($replacement, $action, $validation, $element);
            if (!isset($this->_errorMessages[$varkey])) {
                continue;
            }

            $message = $this->_errorMessages[$varkey];
            break;
        }

        if ($message === '') {
            trigger_error(
                "Unable to expect error '${name}::${validation}'", E_USER_WARNING);
        }

        if (isset($this->_elements[$element])) {
            // ꥭɤѡ
            // Ǥ򥰥ХѿǻȤƿ̾ؿǻ
            $GLOBALS['__QUESTION_ELEMENT'] = &$this->_elements[$element];
            $message = 
                preg_replace_callback(
                    '/%([\w]+)%/', 
                    create_function(
                        '$matches', 
                        '$key = $matches[1];' . 
                            '$msg = ' . 
                            'isset($GLOBALS["__QUESTION_ELEMENT"]->$key) ? ' . 
                            '(string)$GLOBALS["__QUESTION_ELEMENT"]->$key : "";' . 
                            'return $msg;'), 
                    $message);
            unset($GLOBALS['__QUESTION_ELEMENT']);

            $this->action->logAction(
                'QuestionFailure', 
                get_class($this->_elements[$element]) . ':' . $validation);
        }

        return $message;
    }

    /**
     * ǤβǤʤȤ򸡾
     * 
     * @param  string $element Ǥ̾
     * @return boolean
     * @access public
     */
    function isNotNull($element)
    {
        return (
            isset($this->_elements[$element]) && 
            ($this->_elements[$element]->toText() !== ''));
    }

    /**
     * Ǥ¸ߤƤ뤫򸡾
     * 
     * @param  string $element Ǥ̾
     * @return boolean
     * @access public
     */
    function exists($element)
    {
        return 
            isset($this->_elements[$element]);
    }
}
