<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * ̾ʸˤʬ䤷
 * 
 * @package    tima
 * @subpackage tima_Arranger
 * @version    SVN: $Id: Name.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Arranger_Name extends Arranger_AbstractArranger
{

    /**
     * ̾ʸʬ䤷ֵ
     * 
     * $paramsפͤư
     * - Υǥåʻ꤬ʤСfamilyס
     * - ̾Υǥåʻ꤬ʤСfirstס
     * - ʬ䤹ʸʻ꤬ʤСѥڡס
     * 
     * @param  string     $attribute
     * @param  array|null $params
     * @return array
     * @access protected 
     */
    function doFunction($attribute, $params)
    {
        $family_key = 'family';
        $first_key  = 'first';
        $separator  = '';
        if (($param = array_shift($params)) !== null) {
            $family_key = (string) $param;
        }
        if (($param = array_shift($params)) !== null) {
            $first_key = (string) $param;
        }
        if (($param = array_shift($params)) !== null) {
            $separator = (string) $param;
        }

        $matches = mb_split($separator, $attribute, 2);

        return array(
                $family_key => trim((string)array_shift($matches)), 
                $first_key  => trim((string)array_shift($matches)), 
            );
    }
}
