<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * եȡȥ
 * 
 * @package  tima
 * @version  SVN: $Id: Front.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Front
{

    /**
     * ƥץ졼ȡեγĥ
     * 
     * @var    string
     * @access protected
     */
    var $templateExt = '.html';

    // /**
    //  * 󡦥ȥ־
    //  * 
    //  * @var    mixed
    //  * @access protected
    //  */
    // var $actionLocation = null;

    /**
     * ¹ԥץ
     * 
     * @var    Process
     * @access private
     */
    var $_process = null;

    /**
     * ӥ塼
     * 
     * @var    View
     * @access private
     */
    var $_view = null;

    /**
     * ꥯ
     * 
     * @var    Request
     * @access private
     */
    var $_request = null;

    /**
     * å
     * 
     * @var    session
     * @access private
     */
    var $_session = null;

    /**
     * 쥹ݥ
     * 
     * @var    Response
     * @access private
     */
    var $_response = null;

    /**
     * 桼
     * 
     * @var    UserAgent
     * @access private
     */
    var $_userAgent = null;

    /**
     * ե륿
     * 
     * @var    array
     * @access private
     */
    var $_filters = array();

    /**
     * 
     * 
     * @var    Config
     * @access private
     */
    var $_config = null;

    /**
     * 
     * 
     * @var    Logger
     * @access private
     */
    var $_log = null;

    /**
     * ưϻ
     * 
     * @var    DateMicrotimeAccessor
     * @access private
     */
    var $_beginning = null;

    /**
     * 󥹥ȥ饯
     * - 㳰ȯ۾ｪλ
     *  - 饹¸ߤʤ
     *   - 顼Logger '̾' not found
     *   - 쥹ݥ󥹡500 Internal Server Error
     * 
     * @param  void
     * @access public
     */
    function Front()
    {
        $this->_beginning = &new DateMicrotimeAccessor;
        $this->_process   = &new Process;
        $this->_request   = &new Request;
        $this->_response  = &new Response;
        $this->_config    = &new Config;
        $this->_userAgent = &new UserAgent;

        // եɤ߹
        $root_etc = ROOT_PATH . DS . 'etc';
        $app_etc  = $this->getAppDir() . DS . 'etc';
        $this->_config->setEtcDir($root_etc);
        if ($root_etc !== $app_etc) {
            $this->_config->setEtcDir($app_etc);
        }
        $reading_result = $this->_config->readConfig('all');
        if (!$reading_result) {
            trigger_error(
                "Unable to read the configuration 'all-ini.php'", 
                E_USER_WARNING);
        }

        // ȥͭեɤ߹
        $this->_config->readConfig(get_class($this));

        // å
        $this->_session = 
            &new Session(
                '__Front', 
                $this->_config->get('session_name', 'env'), 
                $this->_config->get('session_lifetime', 'env'));

        // ӥ塼
        $basedir = $this->getAppDir() . DS . 'templates';
        $device  = $this->_userAgent->isMobile() ? 'mobile' : 'pc';
        $this->_view = 
            &new Smarty4View(
                $this->getInternalEncoding(), $this->getContentsEncoding(), 
                Utility::merge(
                    $this->_config->getByNamespace('template'), 
                    array(
                        'template_dir' => $basedir . DS . 'template' . DS . $device, 
                        'compile_dir'  => $basedir . DS . 'templates_c')));
        $this->_view->registerObject('Request', $this->_request);
        $this->_view->registerObject('UserAgent', $this->_userAgent);
        $this->_view->registerObject('Date', $this->_beginning);

        // 
        $logger_class = $this->_config->get('logger_class', 'env');
        if (($logger_class === null) || !class_exists($logger_class)) {
            header('HTTP/1.0 500 Internal Server Error');
            trigger_error("Logger '${logger_class}' not found", E_USER_ERROR);
            exit;
        }
        $this->_log = 
            &new $logger_class(
                $this->_config->get('log_level', 'env'), 
                $this->_config->get('log_option', 'env'));
    }

    /**
     * ȥʥѡ饹Ǥ϶
     * 
     * Ѿ饹ǽФ򥪡С饤
     * νϥ¹Ԥΰֺǽ˸ƤӽФ
     * 
     * @param  void
     * @return void
     * @access public
     */
    function initialize() {}

    /**
     * եȡȥ¹
     * - ¹Էײ褫鿷ƥץ¹
     * - 㳰ȯ۾ｪλ
     *  - 롼ƥ󥰤˼ԡü¹Էײ褬
     *   - 顼Unable to dispatch process in mapping
     *   - 쥹ݥ󥹡500 Internal Server Error
     * 
     * @param  void
     * @return void
     * @access public
     * @see    Front::route()
     * @see    Front::dispatch()
     * @see    Front::process()
     * @see    Front::_applyFiltersBeforeMethod()
     * @see    Front::_applyFiltersAfterMethod()
     */
    function start($mapping = null)
    {
        // եȡȥ
        $this->initialize();

        // ե륿
        $this->_applyFiltersBeforeMethod();

        // ꥯȤ롼ƥ󥰢¹Էײ
        if ($mapping === null) {
            $mapping = $this->route();
        }
        if (!is_array($mapping) || !isset($mapping['path'])) {
            header('HTTP/1.0 500 Internal Server Error');
            trigger_error('Unable to dispatch process in mapping', E_USER_ERROR);
            exit;
        }
        if (!array_key_exists('method', $mapping)) {
            $mapping['method'] = null;
        }

        // ¹Էײ袪ץϿ
        $this->dispatch($mapping['path'], $mapping['method']);

        // 󡦥ȥեɤ߹
        $this->_config->readConfig($mapping['path']);

        // ¹
        $this->process();

        // ե륿
        $this->_applyFiltersAfterMethod();

        // ̤
        $this->_response->flush();
    }

    /**
     * 쥯
     * - 쥹ݥ󥹤˥쥯ȤΤΥإåϿ
     * - 쥹ݥ󥹤˥쥯ȤΤΥƥĤϿ
     *  - Υ᥽åɤľܥ쥯Ƚȯʤ
     *  - ¸Υ쥹ݥ󥹾쥯Ȥξѹ
     *   - ᥽åɤθƤӽФǥ쥹ݥƤ񤭴Х쥯Ȥ̵
     *   - ¸Υ쥹ݥ󥹾ϥ쥯Ⱦǽ񤭴Ƽ
     * - ǥեȤΥơɤϡ302 Moved Temporarily
     *  - RFC2616λͤǤ302ơɤǤϥꥯȤȯԾѤʤ
     *   - POSTΥꥯȤGETǥ쥯Ȥ뤳ȤϤǤʤ
     *   - Ūʥ桼ȤǤ302ơɤǤ̤ư
     *    - POSTΥꥯȤGETǥ쥯ȤƤٹʤȯʤ
     *  - CGIʤɤǤΥ쥯Ȥˤϡ303 See OtherפѤ٤
     *   - 桼ȤˤäƤбƤʤΤ
     *   - бƤ桼ȤǤХ򸫤
     *  - Ūʥ桼ȤȤθߴθ302ơɤ
     *  - Ū˷ٹʤɽФ桼ȤФƤƹ
     * 
     * @param  string $uri
     * @param  array|null $params
     * @param  string     $status_code
     * @return void
     * @access public
     */
    function redirect($url, $params = array(), $status_code = '302')
    {
        if (is_array($params) && (count($params) > 0)) {
            $query = array();
            foreach ($params as $varkey => $varvalue) {
                $query[] = "${varkey}=${varvalue}";
            }
            $url .= '?' . implode('&', $query);
        }

        $this->_response->clearHeader();
        $this->_response->setStatus($status_code);
        $this->_response->setHeader('Location', $url);

        $this->_response->setContents(
            sprintf(
                '<html><head>' . 
                '<meta http-equiv="refresh" content="0;url=%s" />' . 
                '</head></html>', 
                htmlentities($url, ENT_QUOTES, $this->getHttpCharSet())));
    }

    /**
     * ư楳ȥǤդΥ˥쥯
     * - ѥ᡼ǤեλϿ
     * - å󤬳ϤƤСѥ᡼˥åɲ
     * 
     * @param  string     $action
     * @param  array|null $params
     * @return void
     * @access public
     * @see    Front::redirect()
     */
    function redirectAction($action, $params = array())
    {
        // 
        $query = array(
                $this->_config->get('action_key', 'env') => $action, 
            );
        // å
        if ($this->_session->isStarted()) {
            $query[$this->_session->getSessionName()] = $this->_session->getId();
        }

        $this->redirect($this->_request->getUrl(), Utility::merge($query, $params));
    }

    /**
     * 
     * - 㳰ȯ۾ｪλ
     *  - ƥץ졼ȡե뤬¸ߤʤ
     *   - 顼Template 'ƥץ졼ȡե' not found
     *   - 쥹ݥ󥹡500 Internal Server Error'
     * 
     * @param  string $attribute
     * @return void
     * @access public
     * @see    View::isTemplateExists()
     * @see    View::render()
     * @see    Response::getDataModel()
     * @see    Response::setContents()
     */
    function render($attribute)
    {
        $template = $attribute . $this->templateExt;

        if (!$this->_view->isTemplateExists($template)) {
            header('HTTP/1.0 500 Internal Server Error');
            trigger_error("Template '${attribute}' not found", E_USER_ERROR);
            exit;
        }

        $this->_response->setContents(
            $this->_view->render($template, $this->_response->getDataModel()));
    }

    /**
     * ե륿Ͽ
     * - 㳰ȯ۾ｪλ
     *  - ե륿ɤ߹ʤ
     *   - 顼Filter 'ե륿̾' not found
     *   - 쥹ݥ󥹡500 Internal Server Error
     * 
     * @param  string $filter
     * @return void
     * @access public
     * @see    ClassLoader::load()
     */
    function setFilter($filter)
    {
        static $class_loader;
        if (!isset($class_loader)) {
            $class_loader = &new ClassLoader;
            $class_loader->setParents('Filter');
            $class_loader->setIncludePath(ROOT_PATH);
        }

        $class_name = $class_loader->load($filter);
        if ($class_name === '') {
            header('HTTP/1.0 500 Internal Server Error');
            trigger_error("Filter '${filter}' not found", E_USER_ERROR);
            exit;
        }

        $this->_filters[] = &new $class_name;
    }

    /**
     * ץꥱ֤ǥ쥯ȥХѥֵ
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getAppDir()
    {
        $app_dir = '';

        $varvalue = defined('APP_DIR') ? APP_DIR : ROOT_PATH;
        if (OS_WINDOWS) {
            if (preg_match('/^[a-z]:/i', $varvalue) && ($varvalue{2} === DS)) {
                $app_dir = $varvalue;
            }
        } elseif ($varvalue{0} === DS) {
            $app_dir = $varvalue;
        }
        if ($app_dir === '') {
            $app_dir = realpath(ROOT_PATH . DS . $varvalue);
        }

        return $app_dir;
    }

    /**
     * ʸ󥳡ǥ󥰤ֵ
     * 
     * ʸ󥳡ǥ󥰤̵ͭˤäưѲ
     * - ꤢꡧꤵ줿ֵͤ
     * - ʤPHPưĶϿ => Ͽֵͤ
     *  - ưĶο¬ˤmb_internal_encoding()ؿ
     *  - ѹˤäƤʤʤ⤢
     * 
     * @param  void
     * @return string|null
     * @access public
     */
    function getInternalEncoding()
    {
        $internal_encoding = $this->_config->get('internal_encoding', 'env');
        if ($internal_encoding === null) {
            $internal_encoding = mb_internal_encoding();
        }

        return $internal_encoding;
    }

    /**
     * Ϥʸ󥳡ǥ󥰤ֵ
     * 
     * ̵ͭˤäưѲ
     * - ꤢꡧꤵ줿ֵͤ
     * - ʤPHPưĶϿ => Ͽֵͤ
     *  - ưĶο¬ˤmb_http_output()ؿ
     *  - ꤬ưʤʤ⤢
     * 
     * @param  void
     * @return string|null
     * @access public
     */
    function getContentsEncoding()
    {
        $http_encoding = $this->_config->get('contents_encoding', 'env');
        if ($http_encoding === null) {
            $http_encoding = mb_http_output();
        }

        return $http_encoding;
    }

    /**
     * ϤHTMLΥ饯åȤֵ
     * 
     * @param  void
     * @return string|null
     * @access public
     * @see    Front::getContentsEncoding()
     */
    function getHttpCharSet()
    {
        return 
            mb_preferred_mime_name($this->getContentsEncoding());
    }

    /**
     * ꥯȤֵ
     * 
     * @param  void
     * @return Request
     * @access public
     */
    function &getRequest()
    {
        return $this->_request;
    }

    /**
     * åֵ
     * 
     * @param  void
     * @return Session
     * @access public
     */
    function &getSession()
    {
        return $this->_session;
    }

    /**
     * 쥹ݥ󥹤ֵ
     * 
     * @param  void
     * @return Response
     * @access public
     */
    function &getResponse()
    {
        return $this->_response;
    }

    /**
     * 桼Ȥֵ
     * 
     * @param  void
     * @return Session
     * @access public
     */
    function &getUserAgent()
    {
        return $this->_userAgent;
    }

    /**
     * ץֵ
     * 
     * @param  void
     * @return Process
     * @access public
     */
    function &getProcess()
    {
        return $this->_process;
    }

    /**
     * ƥץ졼ȡ󥸥ֵ
     * 
     * @param  void
     * @return object|null
     * @access public
     */
    function &getTemplateEngine()
    {
        return $this->_view->getEngine();
    }

    /**
     * ֵ
     * 
     * @param  void
     * @return Config
     * @access public
     */
    function &getConfig()
    {
        return $this->_config;
    }

    /**
     * ֵ
     * 
     * @param  void
     * @return Logger
     * @access public
     */
    function &getLogger()
    {
        return $this->_log;
    }

    /**
     * ưϻֵ
     * 
     * @param  void
     * @return DateMicrotimeAccessor
     * @access public
     */
    function &getBeginning()
    {
        return $this->_beginning;
    }

    /**
     * ꥯȤURIȥѥ᡼¹Էײ
     * - ꥯURI饢󡦥ȥΥѥ
     *  - /foo/bar/hoge.php => test_html_foo_bar_hoge
     * - ꥯͤ¹ԥ̾
     *  - GET::action::bar => bar
     * - web_root_pathꤵ줿ѥϩƬ
     *  - '/'/test/html/foo/bar/hoge.php => test_html_foo_bar_hoge
     *  - '/test/html/'/test/html/foo/bar/hoge.php => foo_bar_hoge
     * - ɥåȡ.˰ʹߤեĥҤȽǤƺ
     *  - /foo/bar/hoge => foo_bar_hoge
     *  - /foo/bar/hoge.php => foo_bar_hoge
     *  - /foo/bar/hoge.html => foo_bar_hoge
     * 
     * @param  void
     * @return array
     * @access protected
     */
    function route()
    {
        $pathuri  = $this->_request->getPathUri();
        $rootpath = 
            $this->_request->isSecure() ? 
                $this->_config->get('https_root_path', 'env') : 
                $this->_config->get('http_root_path', 'env');

        if (substr($rootpath, 0, 1) !== '/') {
            $rootpath = '/' . $rootpath;
        }
        if (($rootpath !== '') && (strpos($pathuri, $rootpath) === 0)) {
            $start   = strlen($rootpath);
            $pathuri = substr($pathuri, $start, (strlen($pathuri) - $start));
        }
        if (strpos($pathuri, '.') !== false) {
            $pathuri = substr($pathuri, 0, strpos($pathuri, '.'));
        }

        $mapping = array(
                'path' => 
                    preg_replace(
                        '/[^a-z0-9_]/i', '', 
                        str_replace(
                            array('/', '-'), '_', trim(strtolower($pathuri), '/'))), 
                'method' => 
                    $this->_request->getAcceptRequest(
                        $this->_config->get('action_key', 'env'), array('p', 'g')), 
            );

        return $mapping;
    }

    /**
     * ¹Էײ褫饿ƥץϿ
     * - 㳰ȯ۾ｪλ
     *  - ꥯȤб󡦥ȥ餬¸ߤʤ
     *   - 顼Controller 'ȥ̾' not found
     *   - 쥹ݥ󥹡404 Not Found
     *  - 󡦥ȥΥɤ˼
     *   - 顼"Unable to use the Controller 'ȥ̾'
     *   - 쥹ݥ󥹡404 Not Found
     * 
     * @param  string $ctrlpath 󡦥ȥΥѥ
     * @param  string $action   ¹Ԥ륢
     * @return void
     * @access protected
     * @see    Front::_findCtrl()
     * @see    ClassLoader::load()
     */
    function dispatch($ctrlpath, $action)
    {
        $class_loader = &new ClassLoader;
        $class_loader->setParents('Action');
        $class_loader->setIncludePath($this->getAppDir());

        $discovery = $this->_findCtrl($ctrlpath, $class_loader);
        // $this->actionLocation = $this->_findCtrl($ctrlpath, $class_loader);
        if ($discovery === null) {
            header('HTTP/1.0 404 Not Found');
            trigger_error("Action-controller '${ctrlpath}' not found", E_USER_ERROR);
            exit;
        }

        $action_class = $class_loader->load($discovery['ctrl']);
        // $action_class = $class_loader->load($this->actionLocation['ctrl']);
        if ($action_class === '') {
            header('HTTP/1.0 404 Not Found');
            trigger_error(
                "Unable to load the action-controller '${ctrlpath}'", 
                E_USER_ERROR);
            exit;
        }

        $task = &new $action_class($this);
        $this->_process->set($task, $action, $discovery);
        // $this->_process->set($task, $action, $this->actionLocation);
    }

    /**
     * ץΥ¹ԤƼ¹Է̤б
     * 
     * @param  void
     * @return void
     * @access protected
     * @see    Process::invoke()
     * @see    Front::redirectAction()
     * @see    Front::redirect()
     * @see    Front::render()
     */
    function process()
    {
        // ץ¹
        $reply = $this->_process->invoke();

        // ¹Է̤ɾ
        switch (true) {
        case preg_match('/^action::(.+)$/i', $reply, $match) : 
            $this->redirectAction($match[1]);
            break;
        case preg_match('/^redirect::(.+)$/i', $reply, $match) : 
            $this->redirect($match[1]);
            break;
        case ($reply !== '') : 
            $this->render($reply);
            break;
        }
    }

    /**
     * ¹ե륿
     * 
     * @param  void
     * @return void
     * @access private
     */
    function _applyFiltersBeforeMethod()
    {
        for ($i = 0, $n = count($this->_filters); $i < $n; ++$i) {
            if (!method_exists($this->_filters[$i], 'before')) {
                continue;
            }
            $this->_filters[$i]->before($this);
        }
    }

    /**
     * ¹Ըե륿
     * 
     * @param  void
     * @return void
     * @access private
     */
    function _applyFiltersAfterMethod()
    {
        for ($i = (count($this->_filters) - 1); $i >= 0; --$i) {
            if (!method_exists($this->_filters[$i], 'after')) {
                continue;
            }
            $this->_filters[$i]->after($this);
        }
    }

    /**
     * 󡦥ȥΥѥ饯饹̾򸡺
     * - ѥfoo_bar_hoge_moge_abcפõե
     *  1. __action__/FooBarHogeMogeAbc.class.php
     *  2. __action__/foo/BarHogeMogeAbc.class.php
     *  3. __action__/foo_bar/HogeMogeAbc.class.php
     *  4. __action__/foo_bar_hoge/MogeAbc.class.php
     *  5. __action__/foo_bar_hoge_moge/Abc.class.php
     *  6. ԡnullֵѡ
     * 
     * @param  string      $ctrlpath
     * @param  ClassLoader $class_loader
     * @return array|null
     * @access private
     * @see    Utility::formatName()
     * @see    ClassLoader::isReadable()
     */
    function _findCtrl($ctrlpath, &$class_loader)
    {
        // ѥ᥯饹̾
        $classname = Utility::formatName($ctrlpath);
        if ($class_loader->isReadable($classname)) {
            return array('dir' => '', 'ctrl' => $classname);
        }

        // ֥ǥ쥯ȥꤢ꤫
        // ѥζڤ_ˤƬϤ⤯
        $subname  = $ctrlpath;
        $routelen = strlen($ctrlpath);
        while ($subname = strstr($subname, '_')) {
            $sublen  = strlen($subname);
            $subname = substr($subname, 1, $sublen - 1);
            $dirname = substr($ctrlpath, 0, $routelen - $sublen);

            $class_loader->setParents('Action', $dirname);
            $classname = Utility::formatName($subname);

            if ($class_loader->isReadable($classname)) {
                return array('dir' => $dirname, 'ctrl' => $classname);
            }
        }

        return null;
    }
}
