<?php

/**
 * The tiny modules for web application
 * - PHP versions 4 -
 * 
 * @category  web application framework
 * @package   tima
 * @author    IKEDA Youhey <youhey.ikeda@gmail.com>
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @copyright 2007 IKEDA Youhey
 *     Licensed under the Apache License, Version 2.0 (the "License"); 
 *     you may not use this file except in compliance with the License. 
 *     You may obtain a copy of the License at 
 *         http://www.apache.org/licenses/LICENSE-2.0 
 *     Unless required by applicable law or agreed to in writing, software 
 *     distributed under the License is distributed on an "AS IS" BASIS, 
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *     See the License for the specific language governing permissions and 
 *     limitations under the License.
 * @version  1.0.0
 */

/**
 * 󡦥ȥΥѡ饹
 * 
 * - ץΥե
 * - дؿǥ
 *  - ǥꥯȤΥå¹
 *  - ưǤдؿ
 *   - entry
 *   - execute¹Խ
 *   - exit
 *   - validateڽ
 * 
 * @package  tima
 * @version  SVN: $Id: Action.class.php 4 2007-06-20 07:16:44Z do_ikare $
 */
class Action
{

    /**
     * ᡼ե߷
     * - ᡼եǻѤϢ߷
     *  - 󥭡̾
     *   - ̾ϡɬʸפˤ
     *    - 饹ǥʸǴƤԹ礫
     *    - 顼åʤɤ䤬Ǥʤʤޤ
     *  - ͡
     *   - label => ̾
     *    - άΥǥեͤ䥯饹˵
     *   - type => 䥯饹
     *    - άԲ
     *   - required => ɬܾ
     *    - άΥǥեͤϡֵ
     *   - default => ν
     *    - άΥǥեͤ䥯饹˵
     * 
     * @var    array
     * @access protected
     */
    var $form = array();

    /**
     * ǥեȡ̾
     * 
     * @var    string
     * @access protected
     */
    var $defaultAction = 'default';

    /**
     * 
     * 
     * @var    Question
     * @access protected
     */
    var $question = null;

    /**
     * ꥯ
     * 
     * @var    Request
     * @access protected
     */
    var $request = null;

    /**
     * 쥹ݥ
     * 
     * @var    Response
     * @access protected
     */
    var $response = null;

    /**
     * 桼
     * 
     * @var    UserAgent
     * @access protected
     */
    var $userAgent = null;

    /**
     * å
     * 
     * @var    Session
     * @access protected
     */
    var $session = null;

    /**
     * եȡȥ
     * 
     * @var    Front
     * @access protected
     */
    var $front = null;

    /**
     * 
     * 
     * @var    Logger
     * @access protected
     */
    var $logger = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param  Front $front եȡȥ
     * @access public
     */
    function Action(&$front)
    {
        $this->session   = &new Session($this->getName());
        $this->front     = &$front;
        $this->request   = &$front->getRequest();
        $this->response  = &$front->getResponse();
        $this->userAgent = &$front->getUserAgent();
        $this->beginning = &$front->getBeginning();
        $this->logger    = &$front->getLogger();
        $this->question  = &new Question($this, $front->getAppDir());
    }

    /**
     * ȥ
     * 
     * @param  void
     * @return void
     * @access public
     */
    function initialize()
    {
        $config = &$this->front->getConfig();
        foreach ($config->getByNamespace('error') as $varkey => $varvalue) {
            $this->question->setErrorMessages($varkey, $varvalue);
        }

        $this->updateFormDefinition();
    }

    /**
     * ȥμ¹Ը¤ֵѡʥѡ饹ǤϾ˿
     * 
     * Ѿ饹Ǿ˱֤褦С饤
     * 
     * @param  void
     * @return boolean
     * @access public
     */
    function enable()
    {
        return true;
    }

    /**
     * Ƥ뤫򸡺
     * 
     * @param  string  $action ̾
     * @return boolean
     * @access public
     */
    function isActionExists($action)
    {
        return method_exists($this, 'execute' . $action);
    }

    /**
     * ¹
     * 
     * @param  string $action_name
     * @return string
     * @access public
     */
    function invoke($action_name)
    {
        // ư륢̾
        $this->ACTIVE_ACTION = $action_name;

        // 
        $entry_method = 'entry' . $action_name;
        if (method_exists($this, $entry_method)) {
            call_user_func(array(&$this, $entry_method));
        }

        // ¹Խ
        $execute_method = 'execute' . $action_name;
        if (!method_exists($this, $execute_method)) {
            trigger_error(
                "Unable to execute the action '${action_name}'", E_USER_WARNING);
        } else {
            $reply = call_user_func(array(&$this, $execute_method));
            // ̤nullפޤϡsuccessפǤС̾䴰
        }

        // ƥץ졼ȤΥǡǥϿ
        foreach ($this->getProperties() as $varkey => $varvalue) {
            $this->response->setDataModel($varkey, $varvalue);
        }
        $this->response->setDataModel('form', $this->question->toArray());

        // 
        $exit_method = 'exit' . $action_name;
        if (method_exists($this, $exit_method)) {
            call_user_func(array(&$this, $exit_method));
        }

        return $reply;
    }

    /**
     * ǥեȡֵ̾
     * 
     * @param  void
     * @return string
     * @access public
     */
    function getDefaultAction()
    {
        return $this->defaultAction;
    }

    /**
     * Ĥѿֵ
     * 
     * @param  void
     * @return array
     * @access public
     */
    function getProperties()
    {
        static $protected_vars;
        if (!isset($protected_vars)) {
            // ݸѿѿ̾
            // ʼʤprotectedʤʬŤ餤
            $protected_vars = array(
                    'form', 
                    'defaultAction', 
                    'question', 
                    'request', 
                    'response', 
                    'userAgent', 
                    'session', 
                    'logger', 
                    'front', 
                );
        }

        $public_properties = array();
        foreach (get_object_vars($this) as $varkey => $varvalue) {
            if ((strpos($varkey, '_') === 0) || in_array($varkey, $protected_vars)) {
                continue;
            }
            $public_properties[$varkey] = $this->$varkey;
        }

        return $public_properties;
    }

    /**
     * 󡦥ȥʼʡˤֵ̾
     * - ̾ϼºݤΥ饹̾˴طʤɬʸˤʤޤ
     *  - PHP4/5ɤǤƱֵͤѤ뤿
     * 
     * @param  void
     * @return string
     * @access protected
     * @static string $ctrl_name
     */
    function getName()
    {
        static $ctrl_name;
        if (!isset($ctrl_name)) {
            $ctrl_name = 
                preg_match('/^(?:Action_)([\w]+)$/i', get_class($this), $match) ?
                    $match[1] : get_class($this);
        }

        // PHP4/5κۼ뤿strtolower()ؿǾʸѴ
        return strtolower($ctrl_name);
    }

    /**
     * ư˵Ͽ
     * - 귿ǥåϿ
     * 
     * @param  string $action
     * @param  string $message
     * @return void
     * @access protected
     * @static UserAgent $ua
     * @see    Logger::info()
     */
    function logAction($action, $message = '')
    {
        static $ua;
        if (!isset($ua)) {
            $ua = &$this->front->getUserAgent();
        }

        $device = $ua->isMobile() ? 'Mobile' : 'PC';

        $this->logger->info(
            sprintf(
                '[%s] %s / Ctrl:%s?%s Device:%s', 
                $action, 
                $message, 
                $this->getName(), 
                $this->session->getId(), 
                $device));
    }

    /**
     * ե򹹿
     * 
     * @param  void
     * @return void
     * @access protected
     */
    function updateFormDefinition()
    {
        static $defines;
        if (!isset($defines)) {
            // ǥեͤ䴰
            $defines = array('label'=>null, 'required'=>false, 'default'=>null);
        }

        foreach($this->form as $varkey => $varvalue) {
            // եǤ򿳺
            if (!is_array($varvalue) || !array_key_exists('type', $varvalue)) {
                trigger_error(
                    sprintf(
                        "Unable to update the form definition '%s::%s'", 
                        $this->getName(), $varkey), 
                    E_USER_WARNING);
                continue;
            }

            // ǥեͤ䴰
            foreach ($defines as $defkey => $defvalue) {
                if (!array_key_exists($defkey, $varvalue)) {
                    $varvalue[$defkey] = $defvalue;
                }
            }

            // եǤϿ
            $this->question->register($varkey, $varvalue['type'], $varvalue);
        }
    }
}
