<?php
/*----------------------------------------------------

  Related.plugin.phpThreadWikiϢPlugin
   Copyright(C) 2003 by FLATz Co , LTd.
  
  Release note
  
  ThreadWiki's Support
    thread_wiki@flatz.jp
    http://wiki.flatz.jp
  
         ֥å
  ǽ       ɽ˴Ϣ󥯤ɽ
  ƤӽФ &Related(MODE,DISPLAY_TYPE,PAGE);
				MODE:normal/reverse
				  reverse ϸߤϵǽޤ󡣼ȯǼͽ
				DISPLAY_TYPE: ɽ list/flat
  				PAGE:ꤷڡδϢ󥯤ɽ

------------------------------------------------------*/

require_once("Wiki/PluginBase.php");

class Related extends PluginBase
{
var $escape_code;
var $euc_multi_byte;
var $url_valid;

/*----------------------------------------------------

  Related(&$core,&$config,&$wiki_db)󥹥ȥ饯

------------------------------------------------------*/
function Related(&$core,&$config,&$wiki_db)
{
	parent::PluginBase($core,$config,$wiki_db);

	$this->escape_code    = ESCAPE_CODE;
	$this->euc_multi_byte = EUC_MULTI_BYTE;
	$this->url_valid      = URL_VALIDATION;
}
//-----------------------------------------------------


/*----------------------------------------------------

  public runtime_function(
    &$wiki_renderer
    $line_number
    &$row_line_array
    $argument_array
  ) : Bool

------------------------------------------------------*/
function preprocess_function(
  &$wiki_renderer, $line_number, &$row_line_array, $argument_array
){
	$result = false;
	$wikiname_ore_array = array();

	//
	//  & 
	//

	// ڡ⳰δط
	switch(strtolower($argument_array[0])){
	case "reverse":
		break;
	case "normal":
	default:
		// WikiNameǡ
		$wikiname_data = array();
		if(isset($argument_array[2]) and $argument_array[2] != ""){
			WikiCommonLib::regulate_wikiname($argument_array[2], "", $wikiname_data);
		}
		else{
			$wikiname = $this->process_status['namespace'] . "/" .
			            $this->process_status['pagename'];
			WikiCommonLib::regulate_wikiname($wikiname, "", $wikiname_data);
		}

		// ڡ򸡺WikiName
		$result = $this->search_in_page($wikiname_data, $wikiname_ore_array);
		break;
	}

	// ꤷɽ
	if($result){
		switch(strtolower($argument_array[1])){ 
		case "list":
			array_walk($wikiname_ore_array, array($this,'do_list_callback'));
			break;
		case "flat":
		default:
			$flat = "";
			array_walk($wikiname_ore_array, array($this,'do_flat_callback'), &$flat);
			$wikiname_ore_array = array($flat);
			break;
		}
		array_splice($row_line_array,$line_number,1);
		array_splice($row_line_array,$line_number,0,$wikiname_ore_array);
	}

	return $result;
}
//-----------------------------------------------------

/*----------------------------------------------------

  WikiNameõƥꥹȲ
  public search_in_page(
	$wikiname_data
  ) : Bool

------------------------------------------------------*/
function search_in_page($wikiname_data, &$wikiname_ore_array){
	require_once( 'Wiki/PageData.php' );
	$target_page = new PageData();
	if($this->wiki_db->load(
	     $target_page, $wikiname_data['pagename'], $wikiname_data['namespace'],
	     'target_level_only'
	  )
	){
		if($this->core->auth->check_target_page_permission($target_page)){
			$wikiname_ore_array = $this->extract_wikiname($target_page);

			return true;
		}
	}
	return false;
}
//-----------------------------------------------------

/*----------------------------------------------------

  WikiNameȤʤꤨñȴФ
  public extract_wikiname(
	$target_page
  ) : Array

------------------------------------------------------*/
function extract_wikiname( $target_page ){
	$wikiname_ore_array = array();
	foreach( $target_page->data['body'] as $line ){
		if(preg_match("/^ /", $line))
			continue;

		// WikiName ɽ
		$ereg_str = "/(?<![\[A-Za-z0-9\/\.\#\(\,]|{$this->escape_code}|(?:\&gt\;))([A-Z][a-z0-9]+[A-Z][A-Za-z0-9]+)(?!(\])|(\&gt\;))|\[\[(.+?)\]\]|\s({$this->euc_multi_byte}{2,10}?)\s|(?<![\"\'\[]|{$this->escape_code})({$this->url_valid})/";
		if(preg_match_all($ereg_str,$line, $matches, PREG_PATTERN_ORDER)){
			if(preg_match("/\.(png|gif|jpg)$/", $matches[0][0])){
				/*
				  ؤURLϡΤޤΤϤȲ
				  ɽƤޤᡢWikiName˽ľ
				*/
				$matches[0][0] = "[[" . $matches[0][0] . "]]";
			}


			// WikiName εˡۤʤ뤬ƱΤؤƤб
			/*
			  $matches[0][0] ˤ WikiName ˡݡȴФ
			  ˡˤä $matches[$cnt][0] оʸȴФ
			  㡧[[WikiName]] 
			   $matches[0][0] = "[[WikiName]]"
			   $matches[4][0] = "WikiName"
			*/
			for($cnt=1;$cnt<count($matches);$cnt++){
				if($matches[$cnt][0]){
					$wikiname_ore_array[$matches[$cnt][0]] = $matches[0][0];
				}
			}
			//$wikiname_ore_array = array_merge($wikiname_ore_array, $matches[0]);
		}
	}
	//$wikiname_ore_array = array_unique($wikiname_ore_array);
	return $wikiname_ore_array;
}
//-----------------------------------------------------

function do_list_callback( &$value, $key ){
	$value = "-" . $value;	
}
//-----------------------------------------------------

function do_flat_callback( $value, $key, &$flat ){
	$flat .= $value . " ";
}

}
?>
