<?php
/*----------------------------------------------------

  FormMail.phpThreadWiki֥ե᡼Plugin
   Copyright(C) 2003 by FLATz Co , LTd.
  
  Release note
   2003/04/4 FormMail.php ver 0.01
  
  ThreadWiki's Support
    thread_wiki@flatz.jp
    http://wiki.flatz.jp
  
  ǽ       ɽ˥ե᡼Υեִ
  ƤӽФ #FormMail(EMAIL,CONFIRM,NAME,FROM,SUBJECT)
  				  EMAIL : ᡼(To:إå)
				  CONFIRM : ǧ̤ɽ/ʤ on/off ǵ
				  NAME : ̾ε̾
				  FROM : ᡼륢ɥ쥹ε̾
				  SUBJECT : ̾ε̾

				  NAME/FROM/SUBJECT ϾάȤιܤɽʤ

------------------------------------------------------*/
require_once("Wiki/PluginBase.php");
require_once( 'Smarty/Smarty.class.php' );

class FormMail extends PluginBase
{
var $smarty;      // Smarty֥
var $tpl_form;    // եƥץ졼
var $tpl_confirm; // ǧ̥ƥץ졼
var $tpl_thanks;  // 󥯥̥ƥץ졼
var $tpl_system_error;  // ƥ२顼̥ƥץ졼
var $tpl_error;   // 桼顼̥ƥץ졼

var $default_email;

/*----------------------------------------------------

  FormMail(&$core,&$wiki_status,&$wiki_db)󥹥ȥ饯

------------------------------------------------------*/
function FormMail(&$core,&$wiki_status,&$wiki_db)
{
	parent::PluginBase($core,$wiki_status,$wiki_db);
	$this->smarty = new Smarty();
    $this->smarty->template_dir = $this->get_resource_path('FormMail');

	$this->tpl_form    = "formmail_form.tpl";
	$this->tpl_confirm = "confirm.tpl";
	$this->tpl_thanks  = "thanks.tpl";
	$this->tpl_system_error = "system_error.tpl";
	$this->tpl_error   = "error.tpl";

	$this->default_email = $wiki_status->get('email');
}
//-----------------------------------------------------

/*----------------------------------------------------

  runtime_function($line_number,&$row_line_array,$argument_array)
    ¹Իե󥯥WikiText˸ƤӽФ

  $line_number    ץ饰󤬼¹Ԥ줿Կ
  $row_line_array ƤӽФȤνΥڡǡ
  $argument_array ƤӽФΰä
  $page_data      ƤӽФڡPageData֥
  return          HTMLǡ

------------------------------------------------------*/
function runtime_function($line_number,&$row_line_array,$argument_array,&$page_data)
{
	static $id = 0;
	$id++;

	// ȻꤵƤʤ
	if(!preg_match("/^(.+)?@(.+)?\.(.+)$/", $argument_array[0])){
		return "Runtime Error!";
	}

	$url       = $_SERVER['PHP_SELF'];
	$pagename  = $page_data->data['name'];
	$namespace = $page_data->data['name_space'];

	$this->smarty->assign("URL",         $url);
	$this->smarty->assign("PAGENAME",    $pagename);
	$this->smarty->assign("NAMESPACE",   $namespace);

	$this->smarty->assign("ID",          $id);
	$this->smarty->assign("CONFIRM",      $argument_array[1]);
	$this->smarty->assign("NAME_NAME",    $argument_array[2]);
	$this->smarty->assign("FROM_NAME",    $argument_array[3]);
	$this->smarty->assign("SUBJECT_NAME", $argument_array[4]);

	$return_html = $this->smarty->fetch($this->tpl_form);
	
	return $return_html;
}
//-----------------------------------------------------

/*----------------------------------------------------

  post_handler_function(&$page_data,&$post_data_array)
    postե󥯥
    ʥѥ᡼md=plugin pn=pluginnameλ˸ƤӽФ

  $page_data        ƤӽФpagedata֥Ȥؤλ
  $post_data_array  ׽Ѥ$_postؤλ
  $rendering_html   posthtml֤
  return            "ok" = 
                      "modifyed" = ̤οʹ֤˽줿
                      "error"    = ͽ̥顼

------------------------------------------------------*/
function post_handler_function(&$page_data,&$post_data_array,$rendering_html=null)
{
	// оݥե᡼ץ饰ΰ
	$form_infomation =
	  $this->get_form_infomation($page_data, $post_data_array['id']);
	if(!count($form_infomation)){
		$this->smarty->assign("ERROR", "ڡޤ");
		$rendering_html = $this->smarty->fetch($this->tpl_system_error);
		return "ok";
	}
	if(!preg_match("/^(.+)?@(.+)?\.(.+)$/", $form_infomation['to'])){
		$this->smarty->assign("ERROR", "褬ꤵƤޤ");
		$rendering_html = $this->smarty->fetch($this->tpl_system_error);
		return "ok";
	}

	// POSTǡ
	$post_data_array = $this->get_urldecode_from_post_data($post_data_array);
	$error_message = $this->valid_check_post_data($post_data_array, $form_infomation);
	if(count($error_message)){
		$main = $this->fetch_error_html($error_message, $post_data_array, $form_infomation);
	}
	else{
		// ǧ̵̤ͭ
		if(strtolower($form_infomation['confirm']) == "on" &&
		   strtolower($post_data_array['confirm']) == 'on')
		{ 
			$main = $this->process_before_confirm($post_data_array, $form_infomation);
		}
		else{
			$main = $this->process_after_confirm($post_data_array, $form_infomation);
		}
	}
	$rendering_html = $main;

	return "ok";
}
//-----------------------------------------------------

/*----------------------------------------------------

  sendmail(&$page_data,$name,$message,$formmail_id)
     

------------------------------------------------------*/
function sendmail($to, $subject, $body, $extension){
	$to      = mb_encode_mimeheader(trim($to),"JIS");
	$subject = mb_encode_mimeheader(trim($subject), "JIS");
	$body    = mb_convert_encoding($body, "JIS");

	$additional_header = "";
	if(is_array($extension)){
		foreach($extension as $k => $v){
			$v = mb_encode_mimeheader($v, "JIS");
			$additional_header .= "$k: $v\r\n";
		}
	}

	// إåĥ
	$additional_header .= "X-Mailer: Form Mail\r\n";
	$additional_header .= "MIME-Version: 1.0\r\n";
	$additional_header .= "Content-Type: text/plain; charset=\"ISO-2022-JP\"\r\n";
	$additional_header .= "Content-Transfer-Encoding: 7bit\r\n";

	//return mb_send_mail($to, $subject, $body, $extension);
	return mail($to, $subject, $body, $additional_header);
}
//-----------------------------------------------------

/*----------------------------------------------------

  valid_check_post_data($post_data_array, $form_infomation)
    ݥȥǡå

------------------------------------------------------*/
function valid_check_post_data( $post_data_array, $form_infomation ){
	$error_message = array();
	// ᡼륢ɥ쥹
	if($form_infomation['from'] != "" && $post_data_array['from'] == "")
		$error_message[] = $form_infomation['from'] . " ɬܹܤǤ";

	if($post_data_array['from'] != "" &&
	  !preg_match("/^(.+)?@(.+)?\.(.+)$/", $post_data_array['from']))
		$error_message[] = $form_infomation['from'] . "ϤƤ";

	// ֥
	if($form_infomation['subject'] != "" && trim($post_data_array['subject']) == "")
		$error_message[] = $form_infomation['subject'] . " ɬܹܤǤ";

	// ̾
	if($form_infomation['name'] != "" && trim($post_data_array['name']) == "")
		$error_message[] = $form_infomation['name'] . " ɬܹܤǤ";

	// ʸ
	if(trim($post_data_array['message']) == "")
		$error_message[] = "å ɬܹܤǤ";

	return $error_message;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private get_display_from_post_data(
    $post_data_array : 
  )  Hash $display_data_array

------------------------------------------------------*/
function get_display_from_post_data($post_data_array){
/*
	$display_data = array();
	foreach($post_data_array as $k => $v){
		$v = htmlspecialchars($v, ENT_QUOTES, 'EUC-JP');
		$display_data[$k] = $v;
	}
	return $display_data;
*/
	return $post_data_array;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private get_hidden_from_post_data(
    $post_data_array : 
  )  Hash $hidden_data_array

------------------------------------------------------*/
function get_hidden_from_post_data($post_data_array){
	$hidden_data = array();
	foreach($post_data_array as $k => $v){
		$v = urlencode($v);
		$hidden_data[$k] = $v;
	}
	return $hidden_data;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private get_urldecode_from_post_data(
    $post_data_array : 
  )  Hash $hidden_data_array

------------------------------------------------------*/
function get_urldecode_from_post_data($post_data_array){
	$decode_data = array();
	foreach($post_data_array as $k => $v){
		$v = urldecode($v);
		$decode_data[$k] = $v;
	}
	return $decode_data;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private process_before_confirm(
    $post_data_array
	$form_infomation
  ) : $main : ǧ̤ɽ

------------------------------------------------------*/
function process_before_confirm($post_data_array, $form_infomation){
	// POSTǡHTMLɽѤִ
	$display_data = $this->get_display_from_post_data($post_data_array);
	$hidden_data  = $this->get_hidden_from_post_data($post_data_array);

	// ǧ̤ɽ
	$url       = $_SERVER['PHP_SELF'];

	// ƥHIDDENǡ
	$this->smarty->assign("URL",      $url);
	$this->smarty->assign("PAGENAME", $post_data_array['pg']);
	$this->smarty->assign("NAMESPACE",$post_data_array['ns']);

	$this->smarty->assign("ID",       $hidden_data['id']);
	$this->smarty->assign("CONFIRM",  'off');

	// HTMLɽ
	$this->smarty->assign("NAME_NAME",     $form_infomation['name']);
	$this->smarty->assign("FROM_NAME",     $form_infomation['from']);
	$this->smarty->assign("SUBJECT_NAME",  $form_infomation['subject']);

	$this->smarty->assign("NAME",     $display_data['name']);
	$this->smarty->assign("FROM",     $display_data['from']);
	$this->smarty->assign("SUBJECT",  $display_data['subject']);
	$this->smarty->assign("MESSAGE",
	    preg_replace("/\r?\n/", "<br>$0", $display_data['message'])
	);

	// HIDDENǡ
	$this->smarty->assign("HIDDEN_NAME",   $hidden_data['name']);
	$this->smarty->assign("HIDDEN_FROM",   $hidden_data['from']);
	$this->smarty->assign("HIDDEN_SUBJECT",$hidden_data['subject']);
	$this->smarty->assign("HIDDEN_MESSAGE",$hidden_data['message']);

	$main = $this->smarty->fetch($this->tpl_confirm);
	return $main;
}

/*----------------------------------------------------

  private process_after_confirm(
    $post_data_array
	$form_infomation
  ) : $main : ᡼ & 󥯥̤ɽ

------------------------------------------------------*/
function process_after_confirm($post_data_array, $form_infomation){
	$post_data_array = $this->take_back_htmlspecialchars($post_data_array);
		
	// إå
	$extension = array("From" => $this->default_email);
	if($form_infomation['from'] != ""){
		$extension['From'] = $post_data_array['from'];
	}

	$message = "";
	if($form_infomation['name'] != ""){
		$message .= "{$post_data_array['name']} 󤫤Υ᡼Ǥ\n";
	}
	$message .= $post_data_array['message'] . "\n";
	$message .= date("Y-m-d h:i:s") . "\n";

	$subject = "[ThreadWiki]ե᡼뤫Υ᡼Ǥ";
	if($form_infomation['subject'] != ""){
		$subject = $post_data_array['subject'];
	}

	// ᡼
	$result = $this->sendmail(
	  $form_infomation['to'],
	  $subject,
	  $message,
	  $extension
	);

	if($result){
		// 󥯥̤ɽ
		$main = $this->smarty->fetch($this->tpl_thanks);
	}
	else{
		// 顼̤ɽ
		$this->smarty->assign("ERROR", "᡼˼Ԥޤ");
		$main = $this->smarty->fetch($this->tpl_system_error);
	}
	return $main;
}

/*----------------------------------------------------

  private take_back_htmlspecialchars(
    in $data_array
  ) : $data_array : HTMLSPECIALCHARS줿ʸ򸵤᤹

------------------------------------------------------*/
function take_back_htmlspecialchars($data_array){
	$search  = array("&amp;", "&quot;", "&lt;", "&gt;", "&039;");
	$replace = array("&",     "\"",     "<",    ">",    "'");
	$data_array = str_replace($search, $replace, $data_array);
	return $data_array;
}

/*----------------------------------------------------

  private fetch_error_html(
    in $error_message,
	in $data_arary,
	in $form_infomation,
  ) : $return_html : 顼̤Ǥ

------------------------------------------------------*/
function fetch_error_html($error_message, $data_array, $form_infomation){
	$url       = $_SERVER['PHP_SELF'];
	$pagename  = $data_array['pg'];
	$namespace = $data_array['ns'];

	$error = join("<br>\n", $error_message);

	$this->smarty->assign("ERROR",      $error);
	$this->smarty->assign("URL",        $url);
	$this->smarty->assign("PAGENAME",   $pagename);
	$this->smarty->assign("NAMESPACE",  $namespace);

	$this->smarty->assign("ID",          $data_array['id']);
	$this->smarty->assign("CONFIRM",       $form_infomation['confirm']);
	$this->smarty->assign("NAME_NAME",     $form_infomation['name']);
	$this->smarty->assign("FROM_NAME",     $form_infomation['from']);
	$this->smarty->assign("SUBJECT_NAME",  $form_infomation['subject']);

	$this->smarty->assign("NAME",     $data_array['name']);
	$this->smarty->assign("FROM",     $data_array['from']);
	$this->smarty->assign("SUBJECT",  $data_array['subject']);
	$this->smarty->assign("MESSAGE",  $data_array['message']);

	$return_html = $this->smarty->fetch($this->tpl_error);
	return $return_html;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private get_form_infomation(
    in $page_data
	in $id
  ) : $form_infomation :
  #FormMail() õФơΰ

------------------------------------------------------*/
function get_form_infomation($page_data, $id){
	$this->wiki_db->load(
	  $page_data,
	  $this->process_status['pagename'],
	  $this->process_status['namespace'],
	  "target_level_only"
	);

	$form_infomation = array();
	$found_cnt = 0;  // #FormMail򸫤Ĥ
	foreach($page_data->data['body'] as $line){
		if(preg_match("/^#FormMail\(([^)]*)\)/i", $line, $matches)){
			$found_cnt++;
			if($found_cnt != $id)
				continue;

			$argument = preg_split("/ *, */", $matches[1]);
			$form_infomation = array(
			  "to"      => $argument[0],
			  "confirm" => $argument[1],
			  "name"    => $argument[2],
			  "from"    => $argument[3],
			  "subject" => $argument[4]
			);
			break;
		}
	}
	return $form_infomation;
}
//-----------------------------------------------------
}
?>
