<?php
/*----------------------------------------------------

  Calendar.plugin.phpThreadWiki֥ڡꥹȤĥ꡼ɽPlugin
   Copyright(C) 2003 by FLATz Co , LTd.
  
  Release note
  
  ThreadWiki's Support
    thread_wiki@flatz.jp
    http://wiki.flatz.jp
  
         Ρޥ
  ǽ       ɽڡ֤̾ˤäƥĥ꡼ɽ
  ƤӽФ #TreePageList(NAMESPACE, ROOT_NAME);
  
               NAMESPACE : ֤̾ꤹȡоְ̾ʲΥڡꥹȤĥ꡼ɽ
               ROOT_NAME : ĥ꡼Υ롼ȤФ̾(ά)
               
------------------------------------------------------*/

require_once("Wiki/PluginBase.php");

class TreePageList extends PluginBase
{
	var $tree;
	var $status;
	var $except_pages;
	var $selected;
	var $icon_width = 19;
	var $icon_home;
	var $icon_home_selected;
	var $icon_empty;             // empty image
	var $icon_line;              // vertical line
	
	var $icon_i_normal;          // node icon normal
	var $icon_i_selected;        // node icon selected
	var $icon_i_opened;          // node icon opened
	var $icon_i_selected_opened; // node icon selected opened

	var $icon_il_normal ;        // leaf icon normal
	var $icon_il_selected ;      // leaf icon selected
	
	var $icon_j;                 // junction image for leaf
	var $icon_j_last;            // junction image for last leaf
	var $icon_j_closed;          // junction image for closed node
	var $icon_j_last_closed;     // junctioin image for last closed node
	var $icon_j_opened;          // junction image for opened node
	var $icon_j_last_opened;     // junctioin image for last opended nod
	
	
	/*----------------------------------------------------
	
	  TreePageList(&$core,&$config,&$wiki_db)󥹥ȥ饯
	
	------------------------------------------------------*/
	function TreePageList(&$core,&$config,&$wiki_db)
	{
		parent::PluginBase($core,$config,$wiki_db);
		$this->rsrc_url = $this->config->get('resource_dir_url')."tree_page_list/";
		
		$this->except_pages           = '/SideMenu/';
		
		$this->icon_home              = "icons/home.gif";
		$this->icon_home_selected     = "icons/home_selected.gif";
		$this->icon_empty             = "icons/empty.gif";
		$this->icon_line              = "icons/line.gif";
		
		$this->icon_i_normal          = "icons/folder.gif";
		$this->icon_i_selected        = "icons/folder_selected.gif";
		$this->icon_i_opened          = "icons/folder_opened.gif";
		$this->icon_i_selected_opened = "icons/folder_selected_opened.gif";
	
		$this->icon_il_normal         = "icons/page.gif";
		$this->icon_il_selected       = "icons/page_selected.gif";
		
		$this->icon_j                 = "icons/join.gif";
		$this->icon_j_last            = "icons/join_last.gif";
		$this->icon_j_closed          = "icons/plus.gif";
		$this->icon_j_last_closed     = "icons/plus_last.gif";
		$this->icon_j_opened          = "icons/minus.gif";
		$this->icon_j_last_opened     = "icons/minus_last.gif";
	}
	//-----------------------------------------------------
	
	/*----------------------------------------------------
	
	  runtime_function($line_number,&$row_line_array,$argument_array)
	    ¹Իե󥯥WikiText˸ƤӽФ
	
	  $line_number    ץ饰󤬼¹Ԥ줿Կ
	  $row_line_array ƤӽФȤνΥڡǡ
	  $argument_array ƤӽФΰä
	  $page_data      ƤӽФڡPageData֥
	  return          HTMLǡ
	
	------------------------------------------------------*/
	function runtime_function($line_number,&$row_line_array,$argument_array,&$page_data)
	{
		return $this->tree_page_list_render( $argument_array[0], $argument_array[1] );
	}
	
	function tree_page_list_render( $namespace, $root_name )
	{
		//print_r( $this->rendering_status );
		$this->tree =& $this->wiki_db->get_page_tree_list( $namespace );
		
		//ɽڡ֤ˤ
		$this->selected = $this->_get_page_id( $this->tree->namespace_data->data['name'].$this->core->process_status['namespace'].$this->core->process_status['pagename']);
		
		//ĥ꡼γľ֤
		$this->status = array();
		$str = $_COOKIE['status'];
		$status_arr = split( ":", $str);
		foreach( $status_arr as $key => $val ){
			$st = split("@", $val );
			$this->status[$st[0]] = $st[1];
		}
		
		$content = "
<script src='" . $this->rsrc_url ."tw_tree.js'></script>
<script type='text/javascript'>
var rsrc   = '".$this->rsrc_url."';
var imgPre = new Image();
imgPre.src = rsrc + '".$this->icon_home_selected."';
imgPre.src = rsrc + '".$this->icon_empty."';
imgPre.src = rsrc + '".$this->icon_line."';
imgPre.src = rsrc + '".$this->icon_i_normal."';
imgPre.src = rsrc + '".$this->icon_il_normal."';
imgPre.src = rsrc + '".$this->icon_il_selectedl."';
imgPre.src = rsrc + '".$this->icon_j."';
imgPre.src = rsrc + '".$this->icon_j_last."';
imgPre.src = rsrc + '".$this->icon_j_closed."';
imgPre.src = rsrc + '".$this->icon_j_last_closed."';
imgPre.src = rsrc + '".$this->icon_j_opened."';
imgPre.src = rsrc + '".$this->icon_j_last_opened."';
</script>
";
		
		if( $root_name == '' ){
			$root_name = $this->tree->namespace_data->data['name'] ? array_pop( explode( '/', $this->tree->namespace_data->data['name'])) : 'ۡ';
		}
		$id = $this->_get_page_id( $this->tree->namespace_data->data['name'].$this->tree->namespace_data->data['name'].$this->tree->pagedata->data['name'] );
		$icon  = $this->icon_home;
		
		if( $this->selected == $id ){
			$style = 'bold';
			$icon = $this->icon_home_selected;
			$this->_set_selected_cookie( $id );
		}
		$content .= "<table cellspacing=0 cellpadding=0 border=0><tr><td nowrap><a href='" . WikiCommonLib::make_myself_url( 'read', $this->tree->pagedata->data['name'], $this->tree->namespace_data->data['name'])."' id='".$id."' onClick=\"javascript:tpSelected('". $id ."');\"><img src='".$this->rsrc_url.$icon ."' border='0'/>".$root_name."</a></td></tr></table>";
		$content .= $this->_get_tree_page_list_html( $this->tree->children_list );
		return $content;
		
	}
	
	function _get_tree_page_list_html( &$page_tree, $depth=1 ){
		$html = '';
		for( $i = 0; $i < count( $page_tree ); $i++){
			$value =& $page_tree[$i];
			if( $value->is_namespace == 1 ){
				$id = $this->_get_page_id($this->tree->namespace_data->data['name'].$value->namespace_data->data['name'].$value->pagedata->data['name']);
				$html .= $this->_get_item_html( $value, 'namespace', $depth, $id );
				$display = $this->status[$id] == 1 ? 'block':'none';
				$html .= "<div id='".$id."' style='display:". $display.";'>".$this->_get_tree_page_list_html( $value->children_list, $depth+1 )."</div>";
			}else{
				if( preg_match($this->except_pages,$value->pagedata->data['name']) ){
					continue;
				}
				$id    = $this->_get_page_id($this->tree->namespace_data->data['name'].$value->parent_ref->namespace_data->data['name'].$value->pagedata->data['name']);
				$html .= $this->_get_item_html( $value, 'page', $depth, $id );
			}
		}
		return $html;
	}
	
	function _get_item_html( &$item, $mode='', $depth, $id=''){
		$html = '';
		
		//֤̾ξ
		if( $mode == 'namespace' ){
			$html  ="<table cellspacing=0 cellpadding=0 border=0><tr><td nowrap>";
			$icon = '';
			//ޡ
			$current =& $item->parent_ref;
			$margin_array = array();
			for( $i = $depth; $i > 1; $i-- ){
				$icon  = count( $current->parent_ref->children_list )-1 == (int)$current->order ? $this->icon_empty : $this->icon_line;
				array_unshift( $margin_array, "<img src='". $this->rsrc_url . $icon . "' border='0' align='absbottom' />" );
				$current =& $current->parent_ref;
			}
			$html .= implode( "", $margin_array );
			//junction
			$is_last = '';
			if( count( $item->children_list ) > 0 ){
				if( count( $item->parent_ref->children_list )-1 == $item->order ){
					$icon = $this->status[$id] == 1 ? $this->icon_j_last_opened : $this->icon_j_last_closed;
					$is_last = '_last';
				}else{
					$icon = $this->status[$id] == 1 ? $this->icon_j_opened : $this->icon_j_closed;
				}
			}else{
				if( count( $item->parent_ref->children_list ) -1 == $item->order ){
					$icon = $this->icon_j_last;
				}else{
					$icon = $this->icon_j;
				}
			}
			
			$tmp =& $item->namespace_data;
			$img_html = "<img src='". $this->rsrc_url.$icon."' id='j_icon". $id ."' border='0' align='absbottom' />";
			if( count($item->children_list) > 0 ){
				$html .= "<a href='javascript:void(0);' style='font-weight:".$style.";' onclick=\"javasctipt:tpToggle('". $id ."','".$is_last."','folder');\">" . $img_html ."</a>";
			}else{
				$html .= $img_html;
			}
			
			//󡢥
			$icon = $this->icon_i_normal;
			$style = 'normal';
			if( $this->selected == $id ){
				$this->_set_selected_cookie( $id );
				$style = 'bold';
				if( $this->status[$id] == 1 ){
					$icon = $this->icon_i_selected_opened;
				}else{
					$icon  = $this->icon_i_selected;
				}
			}elseif( $this->status[$id] == 1 ){
				$icon = $this->icon_i_opened;
			}

			$html .= "<a href='".WikiCommonLib::make_myself_url( 'read', $item->pagedata->data['name'], $item->namespace_data->data['name'])."' onClick=\"javascript:tpSelected('".$id."','folder');\" style='font-weight:".$style.";'><img src='". $this->rsrc_url.$icon."' border='0' align='absbottom' id='folder".$id."' />" .array_pop( explode( '/', $tmp->data['name'] ) ) ."</a>";
			$html .= "</td></tr></table>";
			
		}else{ //ڡǡξ
			
			$html  ="<table cellspacing=0 cellpadding=0 border=0 valign='bottom'><tr><td nowrap>";
			$icon = '';
			//ޡ
			$current =& $item->parent_ref;
			$margin_array = array();
			for( $i = $depth; $i > 1; $i-- ){
				$icon  = count( $current->parent_ref->children_list )-1 == $current->order ? $this->icon_empty : $this->icon_line;
				array_unshift( $margin_array, "<img src='". $this->rsrc_url . $icon . "' border='0' align='absbottom' />" );
				$current =& $current->parent_ref;
			}
			$html .= implode( "", $margin_array );
			//junction
			if( count( $item->parent_ref->children_list  )-1 == $item->order ){
				$icon = $this->icon_j_last;
			}else{
				$icon = $this->icon_j;
			}
			$tmp =& $item->pagedata;
			$html .= "<img src='". $this->rsrc_url.$icon."' border='0' align='absbottom' />";
			
			$style = 'normal';
			$icon  = $this->icon_il_normal;
			if( $this->selected == $id ){
				$this->_set_selected_cookie( $id );
				$style = 'bold';
				$icon = $this->icon_il_selected;
			}
			//icon
			$html .= "<a href='".WikiCommonLib::make_myself_url( 'read', $item->pagedata->data['name'], $item->parent_ref->namespace_data->data['name'])."' id='".$id."'
			 onClick=\"javascript:tpSelected('". $id ."');\" style='font-weight:". $style .";' ><img src='". $this->rsrc_url.$icon."' border='0' align='absbottom' />". $tmp->data['name'] ."</a>";
			$html .= "</td></tr></table>";
		}
		return $html;
	}
	
	function _get_page_id( $str ){
		return crc32($str);
	}
	function _set_selected_cookie( $id ){
		setcookie("tw_selected", $id, time()+60*60*24*30 );
	}
}
?>