<?php
/*----------------------------------------------------

 WikiRenderer  Wiki󥰥饹

------------------------------------------------------*/

require_once( 'Wiki/BasicDefinition.php' );

class WikiRenderer
{

var $config;
var $wiki_db;
var $plugin_manager;
var $process_status;

var $escape_code;
var $euc_multi_byte;
var $url_valid;

/*----------------------------------------------------

  WikiRenderer(&$config,&$wiki_db,&$plugin_manager)
     󥹥ȥ饯

  $config         TwConfig饹֥
  $wiki_db        WikiDB饹֥
  $plugin_manager PluginManager饹֥

------------------------------------------------------*/
function WikiRenderer(&$config,&$wiki_db,&$plugin_manager)
{
	$this->config        = &$config;
	$this->wiki_db       = &$wiki_db;
	$this->plugin_manager= &$plugin_manager;
	
	$this->escape_code    = ESCAPE_CODE;
	$this->euc_multi_byte = EUC_MULTI_BYTE;
	$this->url_valid      = URL_VALIDATION;

}
//-----------------------------------------------------


/*----------------------------------------------------

  reset_status()  󥰻ѿν

------------------------------------------------------*/
function reset_status()
{
	$this->process_status['pagename']  = "";
	$this->process_status['namespace'] = "";
	$this->process_status['default_namespace'] = "";
	$this->process_status['now_mode'] = "";
	$this->process_status['tail'] = array();
	$this->process_status['tail_flag'] = 0;
	$this->process_status['depth'] = 0;
	
}
//-----------------------------------------------------

/*----------------------------------------------------

  push_tail($set_strˡѿ

------------------------------------------------------*/
function push_tail($set_str)
{
	$this->process_status['tail'][] = $set_str;
}
//-----------------------------------------------------

/*----------------------------------------------------

  pop_tail($count=-1) ѿ

------------------------------------------------------*/
function pop_tail($count=-1)
{
	$limit = ($count == -1)? count($this->process_status['tail']) : $count;
	
	$temp_str = "";
	for($i=0;$i<$limit;$i++){
		$temp_str .= array_pop($this->process_status['tail']);
	}
	return $temp_str;
}
//-----------------------------------------------------




/*----------------------------------------------------

  process(&$page_data,$pickup_word="",$pickup_line_number=0) 
    оݥǡ֤
  
  &$page_data    оWikiData֥Ȥؤλ
  return         Ѵǡ

------------------------------------------------------*/
function process(&$page_data,$pickup_word="",$pickup_line_number=0)
{
	$target_data = $page_data->data['body'];
	
	// Ĵʸ
	if( $pickup_word )
	{
		$target_data[$pickup_line_number-1] = $target_data[$pickup_line_number-1] . "&&point&&";
	}
	
	// ץץ
	$this->preprocess($target_data);
	
	// ̾
	$processed_data = array();
	$this->reset_status();
	$this->process_status['namespace'] = $this->process_status['default_namespace'] = $page_data->data['name_space'];
	$this->process_status['pagename']  = $page_data->data['name'];
	
	for($i=0;$i<count($target_data);$i++){
		$line_type = $this->judge_line_type($target_data[$i]);
		
		//ɽ
		if($line_type != 2 && $this->process_status['now_mode'] == "source"){
			$processed_data[] = $target_data[$i] ."<br />";
			continue;
		}
		
		switch($line_type){
			case(0): //Ρޥ
				$processed_data[] = $this->convert_normal_line($target_data[$i],$this->process_status['namespace']);
				break;
			
			case(1): //ȹ
				$processed_data[] = $this->convert_comment_line($target_data[$i]);
				break;
			
			case(2): //ޥɹ
				$processed_data[] = $this->interpret_command($target_data[$i]);
				break;
			
			case(3)://ץ饰ƤӽФ
				$processed_data[] = $this->call_plugin($i,$target_data,$page_data);
				break;
			
		}
	
	}
	$processed_data[] = $this->pop_tail();
	
	
	// Ĵʸ
	if( $pickup_word )
	{
		for( $i=$pickup_line_number-1;$i<count($processed_data);$i++ )
		{
			if( preg_match("/\&\&point\&\&/",$processed_data[$i]) )
			{
				$processed_data[$i] = preg_replace("/\&\&point\&\&/","",$processed_data[$i]);
				$processed_data[$i] = "<a id=\"point\"></a>".preg_replace("/($pickup_word)/","<span class=\"point\">$1</span>",$processed_data[$i]);
			}
		}
	}
	
	return $processed_data;

}
//-----------------------------------------------------

/*----------------------------------------------------

  post_time_plugin_call(&$page_data)  оݥǡ֤
  
  &$page_data    оWikiData֥Ȥؤλ

------------------------------------------------------*/
function post_time_plugin_call( &$page_data )
{
	for( $i=0; $i<count($page_data->data['body']); $i++ )
	{
		$page_data->data['body'][$i] = preg_replace_callback( "/(?<!{$this->escape_code})(\&amp\;[A-Za-z][A-Za-z0-9\_]*?(?<!{$this->escape_code})\(.*?(?<!{$this->escape_code})\)\;)/",array($this,"inline_plugin_callback_post_time"),$page_data->data['body'][$i] );
	}

}

//-----------------------------------------------------



/*----------------------------------------------------

  preprocess( &$target_data )ץץ

------------------------------------------------------*/
function preprocess( &$target_data )
{
	for( $i=0; $i<count($target_data) ;$i++)
	{
		if(preg_match("/^#[A-Za-z]/",$target_data[$i]))
		{
			if($this->plugin_manager->call_preprocess_function($this,$i,$target_data))
			{
				$i--;
				continue;
			}
		}
	}
}

//-----------------------------------------------------

/*----------------------------------------------------

  judge_line_type($line)  оݹԤΥפȽ
  
  return  ԥ
           0 = normal
           1 = comment
           2 = command
           3 = plugin

------------------------------------------------------*/
function judge_line_type(&$line)
{
	if(preg_match("/^\#[A-Za-z]/",$line)){
		return 3;
	}
	elseif(preg_match("/^\/\//",$line)){
		return 1;
	}
	elseif(preg_match("/^\/[A-Za-z]/",$line)){
		return 2;
	}
	return 0;
}
//-----------------------------------------------------


/*----------------------------------------------------

  call_plugin($line_number,&$row_line_array,&$page_data)
    ץ饰ƤӽФ

------------------------------------------------------*/
function call_plugin($line_number,&$row_line_array,&$page_data)
{
	$add_line_array = array();
	$this->process_status['now_mode'] = "";
	$add_line_array[] = $this->pop_tail();
	
	$this->plugin_manager->call_runtime_function($line_number,&$row_line_array,$add_line_array,$page_data);
	
	return join("",$add_line_array);
}
//-----------------------------------------------------



/*----------------------------------------------------

  interpret_command(&$line)  ޥɹԤ

------------------------------------------------------*/
function interpret_command( $line )
{
	if( preg_match("/^\/pre text start/",$line) )
	{
		//ɽΥ
		if( $this->process_status['now_mode'] != "source" )
		{
			$this->process_status['now_mode'] = "source";
			$temp_tail = $this->pop_tail();
			$this->push_tail("</p></div>\n");
			return $temp_tail ."<div class=\"pretext\"><p>\n";
		}
	}
	elseif( preg_match("/^\/pre text end/",$line) )
	{
		//ɽνλ
		$this->process_status['now_mode'] = "";
		return $this->pop_tail();
	}
	elseif( preg_match("/^\/using namespace (.*)/",$line,$hitdata) )
	{
		//ֻ̾
		$this->process_status['namespace'] = $hitdata[1];
		return "";
	}
	elseif( preg_match("/^\/using default namespace/",$line,$hitdata) )
	{
		//ֻ̾
		$this->process_status['namespace'] = $this->process_status['default_namespace'];
		return "";
	}
	elseif( preg_match("/^\/namespace end/",$line) )
	{
		//ֻ̾root᤹
		$this->process_status['namespace'] = "";
		return "";
	}
	else
	{
		//ʥޥɥ顼
		return "<span class='nopage'>Runtime Error : Unkown command </span>\n";
	}
	
}
//-----------------------------------------------------


/*----------------------------------------------------

  modify_char($line)оݹԤʸԤ

------------------------------------------------------*/
function modify_char($line)
{
	while(1)
	{
		$modifyed = preg_replace_callback("/(?<!{$this->escape_code})FONT(?<!{$this->escape_code})\((.+?)(?<!{$this->escape_code})\)(?<!{$this->escape_code})\{(.+?)(?<!{$this->escape_code})\}/",array($this,"makeup_chartag"),$line);
		if($line == $modifyed)
		{
			return $modifyed;
		}
		$line = $modifyed;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  makeup_chartag($match_text_array)ʸХåؿ
 
   $match_text_array 
                       [1] =argument 
                       [2] =target_txt

------------------------------------------------------*/
function makeup_chartag($match_text_array)
{
	$argument   = split(",",$match_text_array[1]);
	$target_txt = $match_text_array[2];
	
	$style = "";
	$text_decoration = "";
	$fontsize_flag = false;
	for($i=0;$i<count($argument);$i++){
		
		if(preg_match("/^([0-9\.]+)(px|em)$/",$argument[$i],$hit_size) && !$fontsize_flag){
			$style .= "font-size:".$hit_size[1]. $hit_size[2].";";
			$fontsize_flag = true;
		}
		elseif($argument[$i] == "BOLD"){
			$style .= "font-weight:bold;";
		}
		elseif($argument[$i] == "ITALIC"){
			$style .= "font-style:italic;";
		}
		elseif(preg_match("/^(#[0-9abcdefABCDEF]{6})$/",$argument[$i],$hit_color)){
			$style .= "color:".$hit_color[1] .";";
		}
		elseif($argument[$i] == "UNDERLINE"){
			$text_decoration .= "underline ";
		}
		elseif($argument[$i] == "LINE-THROUGH"){
			$text_decoration .= "line-through ";
		}
		elseif($argument[$i] == "OVERLINE"){
			$text_decoration .= "overline ";
		}
	}
	$style = $style ."text-decoration:" . $text_decoration;
	
	return "<span style=\"${style}\">$target_txt</span>";
}
//-----------------------------------------------------


/*----------------------------------------------------

  process_inline_plugin_call( $target_line )
    饤ץ饰ƤӽФ

------------------------------------------------------*/
function process_inline_plugin_call( $target_line )
{
	return preg_replace_callback( "/(?<!{$this->escape_code})(\&amp\;[A-Za-z][A-Za-z0-9\_]*?(?<!{$this->escape_code})\(.*?(?<!{$this->escape_code})\)\;)/",array($this,"inline_plugin_callback"),$target_line );
}

//-----------------------------------------------------


/*----------------------------------------------------

  inline_plugin_callback( $match_text_array )
     饤ץ饰ƤӽФХåؿ

------------------------------------------------------*/
function inline_plugin_callback( $match_text_array )
{
	return $this->plugin_manager->call_runtime_inline_function( $match_text_array[1] );
}
//-----------------------------------------------------

/*----------------------------------------------------

  inline_plugin_callback_post_time( $match_text_array )
     ƻ饤ץ饰ƤӽФХåؿ

------------------------------------------------------*/
function inline_plugin_callback_post_time( $match_text_array )
{
	return $this->plugin_manager->call_text_replace_function( $match_text_array[1] );
}
//-----------------------------------------------------


/*----------------------------------------------------

  convert_wikiname($line)  оݹԤWikiNameѴ
  
   &$line      оtext
   $namespace  ǥեȤ̾

------------------------------------------------------*/
function convert_wikiname($line,$namespace)
{
	$converted_line = preg_replace_callback("/(?<![\[A-Za-z0-9\/\.\#\(\,]|{$this->escape_code}|(?:\&gt\;))([A-Z][a-z0-9]+[A-Z][A-Za-z0-9]+)(?!(\])|(\&gt\;))/",array($this,"makeup_wikiname"),$line);
	
	$converted_line = preg_replace_callback("/\[\[(.+?)\]\]/",array($this,"makeup_wikiname"),$converted_line);
	$converted_line = preg_replace_callback("/\s({$this->euc_multi_byte}{2,10}?)\s/",array($this,"makeup_wikiname"),$converted_line);
	
	$converted_line = $this->auto_link($converted_line);

	return $converted_line;
}
//-----------------------------------------------------


/*----------------------------------------------------

  makeup_wikiname($match_text_array)
    WikiNameHTMLѴ륳Хåؿ
  
  $match_text_array [1] = WikiName

------------------------------------------------------*/
function makeup_wikiname($match_text_array)
{
	$wiki_data = array();
	WikiCommonLib::regulate_wikiname($match_text_array[1],$this->process_status['namespace'],$wiki_data);
	$display_wikiname = $this->make_display_wikiname($wiki_data);
	
	if($wiki_data['pointing_self'] == "on")
	{
		$wiki_data['pagename']  = $this->process_status['pagename'];
		$wiki_data['namespace'] = $this->process_status['default_namespace'];
	}
	
	if($wiki_data['url'] != "")
	{
		return "<a href='".$wiki_data['url']."'>". $display_wikiname ."</a>";
	}
	
	$exist_result = $this->wiki_db->check_exist($wiki_data['pagename'],$wiki_data['namespace']);
	
	return WikiCommonLib::make_wikiname_html($display_wikiname,$wiki_data,$exist_result);
}
//-----------------------------------------------------


/*----------------------------------------------------

  make_display_wikiname(&$wiki_data)
    WikiNameɽ

------------------------------------------------------*/
function make_display_wikiname(&$wiki_data)
{
	if($wiki_data['alias'])
	{
		return $wiki_data['alias'];
	}
	elseif($wiki_data['headlinename'])
	{
		return $wiki_data['headlinename'];
	}
	else
	{
		if($wiki_data['pagename'] == "" )
		{
			if($wiki_data['namespace'])
			{
				return $wiki_data['namespace'];
			}
			else
			{
				return $this->config->get('site_name');
			}
		}
		else
		{
			return $wiki_data['pagename'];
		}
	}
}
//-----------------------------------------------------


/*----------------------------------------------------

  convert_normal_line(&$line)  оݹԤΡޥѴ

------------------------------------------------------*/
function convert_normal_line($target_line,$now_namespace)
{
	if(preg_match("/^\s(.*)$/",$target_line,$hitdata)){
		//ѥƥ
		$target_line = $this->makeup_pretext_term($hitdata[1]);
		return $target_line;
	}
	
	$target_line = $this->convert_escape_char($target_line);
	$target_line = $this->process_inline_plugin_call($target_line);
	$target_line = $this->modify_char($target_line);
	$target_line = $this->convert_wikiname($target_line,$now_namespace);
	$target_line = $this->makeup_wiki_term($target_line);
	$target_line = $this->remove_escape_char($target_line);
	return $target_line;
}
//-----------------------------------------------------

/*----------------------------------------------------

  convert_escape_char($target_line)ʸִ

------------------------------------------------------*/
function convert_escape_char($target_line)
{
	return preg_replace("/{$this->escape_code}{2}/","&yen;",$target_line);
}
//-----------------------------------------------------

/*----------------------------------------------------

  remove_escape_char($target_line)ʸ

------------------------------------------------------*/
function remove_escape_char($target_line)
{
	return preg_replace("/{$this->escape_code}(?!{$this->escape_code})/","",$target_line);
}
//-----------------------------------------------------


/*----------------------------------------------------

  convert_comment_line($line)  оݥȹԤwikiѴ

------------------------------------------------------*/
function convert_comment_line($line)
{
	return preg_replace("/^\/\/(.*)$/","<!-- $1 -->\n",$line);
}
//-----------------------------------------------------


/*----------------------------------------------------

  makeup_wiki_term($target_line)  оݹԤWikiʸˡᤷ֤

------------------------------------------------------*/
function makeup_wiki_term($target_line)
{
	if(preg_match("/^(\-{1,5})(.*)$/",$target_line,$hitdata)){
		//ꥹȽ
		$target_line = $this->makeup_list_term($hitdata[1],$hitdata[2]);
		return $target_line;
	}
	elseif(preg_match("/^(\+{1,5})(.*)$/",$target_line,$hitdata)){
		//եꥹȽ
		$target_line = $this->makeup_countup_list_term($hitdata[1],$hitdata[2]);
		return $target_line;
	}
	elseif(preg_match("/^((&gt;){1,5})(.*)$/",$target_line,$hitdata)){
		//ѥǥ
		$target_line = $this->makeup_indent_term($hitdata[1],$hitdata[3]);
		return $target_line;
	}
	elseif(preg_match("/^\|(.*?)(?<!{$this->escape_code})\|$/",$target_line,$hitdata)){
		//ɽȤ
		$target_line = $this->makeup_table_term($hitdata[1]);
		return $target_line;
	}
	elseif(preg_match("/^(\*{1,3})(.*)$/",$target_line,$hitdata)){
		//Ф
		$target_line = $this->makeup_headline_term($hitdata[1],$hitdata[2]);
		return $target_line;
	}
	else{
		//̾Խ
		$target_line = $this->makeup_normal_line( $target_line );
		return $target_line;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  auto_link($line)  httpǻϤޤʸư

------------------------------------------------------*/
function auto_link($line)
{
	return preg_replace_callback("/(?<![\"\'\[]|{$this->escape_code})({$this->url_valid})/i",array($this,"make_link_callback"),$line);
}
//-----------------------------------------------------


/*----------------------------------------------------

  make_link_callback($match_url_array)
    png jpg gif ʤimgǥ󥯡ʳʤ饢󥫡ǥ

------------------------------------------------------*/
function make_link_callback($match_url_array)
{
	if(preg_match("/\.(png|gif|jpg)$/",$match_url_array[1])){
		return "<img src=\"" . $match_url_array[1] ."\" alt=\"".$match_url_array[1]."\"/>";
	}
	else{
		return "<a href=\"". $match_url_array[1]. "\" target=\"_blank\">" . $match_url_array[1] . "</a>";
	}
}
//-----------------------------------------------------


/*----------------------------------------------------

   makeup_normal_line( $line ) ̾Ԥ

------------------------------------------------------*/
function makeup_normal_line( $line )
{
	if( $this->process_status['now_mode'] != "normal" && $line != "")
	{
		$this->process_status['now_mode'] = "normal";
		$this->process_status['depth'] = 0;
		$str = $this->pop_tail() . "<p>\n" . $line . "<br />";
		$this->push_tail("</p>\n");
		return $str;
	}
	elseif( $this->process_status['now_mode'] == "normal" && $line != "")
	{
		return $line . "<br />\n";
	}
	elseif( $this->process_status['now_mode'] == "normal" && $line == "")
	{
		$this->process_status['now_mode'] = "";
		return $this->pop_tail();
	}
	else
	{
		return;
	}
}

//-----------------------------------------------------


/*----------------------------------------------------

  makeup_list_term($term,$text)  ꥹȽ

------------------------------------------------------*/
function makeup_list_term($term,$text)
{
	$temp_tail = "";
	if($this->process_status['now_mode'] != "list"){
		$this->process_status['now_mode'] = "list";
		$this->process_status['depth'] = 0;
		$temp_tail = $this->pop_tail();
	}
	
	$makeup_line = "<li>" .$text . "</li>\n";
	$term_count = strlen($term);
	if($term_count == $this->process_status['depth']){
		return $temp_tail . $makeup_line;
	}
	elseif($term_count > $this->process_status['depth']){
		$temp_head = "";
		for($a=$this->process_status['depth'];$a<$term_count;$a++){
			$temp_head .= "<ul>";
			$this->push_tail("</ul>");
		}
		$this->process_status['depth'] = $term_count;
		return $temp_tail . $temp_head . $makeup_line;
	}
	else{
		$temp_tail .= $this->pop_tail($this->process_status['depth'] - $term_count);
		$this->process_status['depth'] = $term_count;
		return $temp_tail . $makeup_line;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  makeup_countup_list_term($term,$text)  եꥹȽ

------------------------------------------------------*/
function makeup_countup_list_term($term,$text)
{
	$temp_tail = "";
	if($this->process_status['now_mode'] != "countup_list"){
		$this->process_status['now_mode'] = "countup_list";
		$this->process_status['depth'] = 0;
		$temp_tail = $this->pop_tail();
	}
	
	$makeup_line = "<li>" .$text . "</li>\n";
	$term_count = strlen($term);
	if($term_count == $this->process_status['depth']){
		return $temp_tail . $makeup_line;
	}
	elseif($term_count > $this->process_status['depth']){
		$temp_head = "";
		for($a=$this->process_status['depth'];$a<$term_count;$a++){
			$temp_head .= "<ol>";
			$this->push_tail("</ol>");
		}
		$this->process_status['depth'] = $term_count;
		return $temp_tail . $temp_head . $makeup_line;
	}
	else{
		$temp_tail .= $this->pop_tail($this->process_status['depth'] - $term_count);
		$this->process_status['depth'] = $term_count;
		return $temp_tail . $makeup_line;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  makeup_indent_term($term,$text)  ǥȽ

------------------------------------------------------*/
function makeup_indent_term($term,$text)
{
	$temp_tail = "";
	$term_count = strlen($term) / 4;
	
	if( $this->process_status['now_mode'] != "indent")
	{
		$this->process_status['now_mode'] = "indent";
		$this->process_status['depth']    = 0;
	}
	elseif( $term_count == $this->process_status['depth'] )
	{
		return $text . "<br />\n";
	}
	$temp_tail = $this->pop_tail();
	
	$temp_head .= "<blockquote class=\"depth${term_count}\">\n";
	$this->push_tail("</blockquote>\n");
	$this->process_status['depth'] = $term_count;
	
	
	return $temp_tail . $temp_head . $text ."<br />\n";
	
}
//-----------------------------------------------------

/*----------------------------------------------------

  makeup_table_term($text)ɽȤߤ

------------------------------------------------------*/
function makeup_table_term($text)
{
	$temp_tail = "";
	$makeup_line = "";
	if($this->process_status['now_mode'] != "table"){
		$this->process_status['now_mode'] = "table";
		$temp_tail = $this->pop_tail();
		$makeup_line .= "<table class=\"wiki_table\" >";
		$this->push_tail("</table>");
	}
	
	$makeup_line .= "<tr>";
	
	$table_cell = preg_split("/(?<!{$this->escape_code})\|/",$text);
	for($i=0;$i<count($table_cell);$i++)
	{
		$td_text = ($table_cell[$i] == "") ? "&nbsp;" : $table_cell[$i];
		$makeup_line .= "<td class=\"wiki_td\">" . $td_text . "</td>";
	}
	$makeup_line .= "</tr>\n";
	
	return $temp_tail . $makeup_line;

}
//-----------------------------------------------------

/*----------------------------------------------------

  makeup_pretext_term($text)ѤߥƥȤ

------------------------------------------------------*/
function makeup_pretext_term($text)
{
	$temp_tail = "";
	$makeup_line = "";
	if($this->process_status['now_mode'] != "pretext"){
		$this->process_status['now_mode'] = "pretext";
		$temp_tail = $this->pop_tail();
		$makeup_line .= "<div class=\"pretext\" >";
		$this->push_tail("</div>");
	}
	
	return $temp_tail . $makeup_line . $text ."<br />\n";

}
//-----------------------------------------------------


/*----------------------------------------------------

  makeup_headline_term($term,$text)  Ф

------------------------------------------------------*/
function makeup_headline_term($term,$text)
{
	$this->process_status['now_mode'] = "normal";
	$this->process_status['depth'] = 0;
	
	$temp_tail = $this->pop_tail();
	$this->push_tail("</p>\n");
	$h_num = strlen($term);
	$makeup_line = "<p>\n<h" . $h_num." class=\"contents\">" . "<a id='#".crc32($text) ."'></a>$text" . "</h".$h_num .">\n";
	return $temp_tail . $makeup_line;
}
//-----------------------------------------------------


}


?>
