<?php
/*----------------------------------------------------

   PostgreSQLManipulate  PostgreSQL饹

    ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.
$Header: /home/cvsroot/thread_wiki/plugin/PostgreSQLManipulate.plugin.php,v 1.5 2004/06/23 08:15:20 nasu Exp $

   Public᥽å
    connect( $conn_string="" )
      : DB³
    query( $q_string, $array_key="" )
      : SQL¹
    fetch_result( $row, $field, $result=0 )
      : SQL¹Է̤ꤷ
    fetch_all( $result=0 )
      : 줿ƤιԤȤƼ
    fetch_array( $row, $result=0 )
      : ԤȤƼ
    fetch_assoc( $row, $result=0 )
      : ԤȤƼͤ˥̾Τߤޤ
    fetch_col($col, $result=0)
      : ȤƼ
    transaction()
      : ȥ󥶥󳫻
    commit()
      : ߥå
    rollback()
      : Хå
    copy_from($table_name, $hash)
      : ơ֥˥ԡ
    num_rows( $result=0 )
      : 줿Կ֤
    depollution_for_sql( $data )
      : SQLѿα

   private᥽å
    PostgreSQLManipulate( $conn_string="" )
    result_error($result)
    

------------------------------------------------------*/
require_once( 'Wiki/RDBManipulate.php' );

class PostgreSQLManipulate extends RDBManipulate
{
//var $dbconn;             // DB³ID
//var $result              // ¹Է̥꥽
//var $error_message       // 顼å
//var $result_history_num  // ¹Է̿ݻ
var $select;
var $insert;
var $update;
var $else;

/*----------------------------------------------------

  󥹥ȥ饯
  : Bool

------------------------------------------------------*/
function PostgreSQLManipulate( $conn_string="" )
{
	$bool = parent::RDBManipulate($conn_string);
}
//-----------------------------------------------------


/*----------------------------------------------------

 DB³
 public connect(
	in $conn_string : String
 ) : Bool

------------------------------------------------------*/
function connect( $conn_string )
{
	if(empty($conn_string)){
		return false;
	}
	if(!($this->dbconn = pg_connect($conn_string))){
		return false;
	}
	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

 ꡼¹
 public query(
	in $q_string  : String
 ) : Bool

------------------------------------------------------*/
function query( $q_string )
{
	if(empty($q_string)){
		return false;
	}
	$result = pg_query($this->dbconn, $q_string);
	if(!$result){
		return false;
	}

	$this->set_result($result);
	if(!$this->result_error()){
		return false;
	}

	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

 ꤷ֤ͤ
 public fetch_result(
	in $row    : Integer
	in $field  : String or Integer
	in $result : Integer = 0
 ) : mixed

 $result ϻꤵʤ硢ľΥ꡼¹Է̤Ѥ
 ꤵ줿ϡη̤Ѥ

------------------------------------------------------*/
function fetch_result( $row, $field, $result=0 )
{
	// ¹Է̤ꤵʤľμ¹Է̤
	$result = $this->get_result($result);

	if(pg_num_rows($result) < $row + 1){
		return "";
	}
	return pg_fetch_result($result, $row, $field);
}
//-----------------------------------------------------

/*-----------------------------------------------------

 ¹Է̤֤
 public fetch_all(
    in $result : Integer = 0
 ) : mixed

-----------------------------------------------------*/
function fetch_all( $result=0 ){
	$result = $this->get_result($result);
	$arr = pg_fetch_all($result);
	if(is_array($arr)){
		return $arr;
	}
	else{
		return array();
	}
}
//----------------------------------------------------

/*-----------------------------------------------------

 ꤷԤ֤
 public fetch_array(
    in $row : Integer = 0
    in $result : Integer = 0
 ) : mixed

-----------------------------------------------------*/
function fetch_array( $row=0, $result=0 ){
	$result = $this->get_result($result);

	if(pg_num_rows($result) < $row + 1){
		return array();
	}
	else{
		return pg_fetch_array($result, $row);
	}
}
//-----------------------------------------------------

/*-----------------------------------------------------

 ꤷԤ֤
 public fetch_assoc(
    in $row : Integer = 0
    in $result : Integer = 0
 ) : mixed

-----------------------------------------------------*/
function fetch_assoc( $row=0, $result=0 ){
	$result = $this->get_result($result);

	if(pg_num_rows($result) < $row + 1){
		return array();
	}
	else{
		return pg_fetch_assoc($result, $row);
	}
}
//-----------------------------------------------------

/*-----------------------------------------------------

 ȥ󥶥󳫻
 public transaction(
 ) : Bool

-----------------------------------------------------*/
function transaction(){
	if(!$this->query("begin")){
		return false;
	}
	return true;
}
//-----------------------------------------------------

/*-----------------------------------------------------

 ߥå
 public commit(
 ) : Bool

-----------------------------------------------------*/
function commit(){
	if(!$this->query("commit")){
		return false;
	}
	return true;
}
//-----------------------------------------------------

/*-----------------------------------------------------

 ߥå
 public rollback(
 ) : Bool

-----------------------------------------------------*/
function rollback(){
	if(!$this->query("rollback")){
		return false;
	}
	return true;
}
//-----------------------------------------------------

/*-----------------------------------------------------

 
 public fetch_col(
   in $col_key : Integer or String = 0
   in $result : Interger = 0
 ) : array

-----------------------------------------------------*/
function fetch_col( $col_key=0, $result=0 ){
	$result = $this->get_result($result);
	$col = array();  // ꥿

	if(!pg_num_rows($result)){
		// ꥽¸ߤʤ
		return array();
	}

	$arr = pg_fetch_all($result);
	foreach( $arr as $row){
		$col[] = $row[$col_key];
	}

	return $col;
}
//-----------------------------------------------------

/*-----------------------------------------------------

 Hashơ֥򥳥ԡ
 public copy_from(
   in $table_name : String
   in $hash : Hash
 ) : Bool

-----------------------------------------------------*/
function copy_from($table_name, $hash){
	if(empty($table_name)){
		return false;
	}

	$sql_name = "";
	$sql_data = "";

	foreach($hash as $k => $v){
		if(is_string($v)){
			$v = "'" . $this->depollution_for_sql($v) . "'";
		}

		$sql_name .= "$k,";
		$sql_data .= "$v,";
	}
	$sql_name = trim($sql_name, ',');
	$sql_data = trim($sql_data, ',');

	$query =<<<EOS
INSERT INTO {$table_name}
( $sql_name )
VALUES
( $sql_data )
EOS;
	if(!$this->query($query)){
		return false;
	}

	return true;
}
//-----------------------------------------------------

/*-----------------------------------------------------

 ꥽ιԿ
 public num_rows(
   in $result : Integer = 0
 ) : Integer

-----------------------------------------------------*/
function num_rows( $result=0 ){
	$result = $this->get_result($result);
	return pg_num_rows($result);
}
//-----------------------------------------------------

/*-----------------------------------------------------
  private result_error (
    in $result : Integer = 0
  ) : Bool
-----------------------------------------------------*/
function result_error( $result=0 ){
	$result = $this->get_result($result);
    $this->error_message = pg_result_error($result);
	if(!empty($this->error_message)){
		return false;
	}
	return true;
}

function count_query( $q_string ){
	if(preg_match("/^ *SELECT/i",  $q_string)) $this->select++;
	elseif(preg_match("/^ *INSERT/i",  $q_string)) $this->insert++;
	elseif(preg_match("/^ *UPDATE/i",  $q_string)) $this->update++;
	else $this->else++;
}

function get_count(){
	print "SELECT: {$this->select}<br>";
	print "INSERT: {$this->insert}<br>";
	print "UPDATE: {$this->update}<br>";
	print "ELSE: {$this->else}<br>";
}

}

?>
