<?php
/*----------------------------------------------------

  WikiCommonLibClass  For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/BasicDefinition.php' );

class WikiCommonLib
{

/*----------------------------------------------------

  WikiNameå
  
  return
   "ok" : 
   "invalid_name" : 
   "name_too_long": Ĺ
   
------------------------------------------------------*/
function check_wiki_name_valid( $wiki_name )
{
	if(preg_match("/[\[\|\~\^\(\)\"\'\]]/",$name)){
		return "invalid_name";
	}
	if(strlen($name) > 100){
		return "name_too_long";
	}
	
	return "ok";
}
//-----------------------------------------------------

/*----------------------------------------------------

 ǥեȥ̵

------------------------------------------------------*/
function convert_slashes( $target_data )
{
	if(get_magic_quotes_gpc()){
		$target_data =  stripslashes($target_data);
	}
	return $target_data;
}
//-----------------------------------------------------

/*----------------------------------------------------
  
  üʸΥ׽
  
------------------------------------------------------*/
function convert_control_char($target_data)
{
	//Nullʸ
	$target_data = str_replace("\0","",$target_data);
	
	//ǸιɤȤꤵ
	$target_data = preg_replace("/\r?\n$/","",$target_data);

	//ޥå̵
	if(get_magic_quotes_gpc()){
		$target_data =  stripslashes($target_data);
	}
	
	//ʸλȤ
	$target_data = preg_replace("/&/","&amp;",$target_data);
	$target_data = preg_replace("/</","&lt;",$target_data);
	$target_data = preg_replace("/>/","&gt;",$target_data);
	$target_data = preg_replace("/\"/","&quot;",$target_data);
	
	return $target_data;
}
//-----------------------------------------------------

/*----------------------------------------------------
  
  üʸΥ׽
  
------------------------------------------------------*/
function convert_control_char_in_array($target_array)
{
	$escaped_data = array();
	while(list($key_name,$value) = each($target_array))
	{
		if(is_array($value)){
			$escaped_data[$key_name] = WikiCommonLib::convert_control_char_in_array($value);
		}
		else{
			$escaped_data[$key_name] = WikiCommonLib::convert_control_char($value);
		}
	}
	
	return $escaped_data;
}
//-----------------------------------------------------


/*----------------------------------------------------

  WikiName
  $row_name          : о
  $base_namespace    : Ȥʤ̾
  &$regularized_data : Ϥؤλ

------------------------------------------------------*/
function regulate_wikiname($row_name,$base_namespace,&$regularized_data)
{
	$regularized_data = array();
	
	// ꥢ뤫
	if(preg_match("/^([^#]+?)\&gt\;(.+)$/",$row_name,$match_data))
	{
		$regularized_data['alias'] = $match_data[1];
		$row_name = $match_data[2];
	}
	
	if(preg_match("/^#(.+)$/",$row_name,$match_data))
	{
		$regularized_data['pointing_self'] = "on";
		$regularized_data['headlinename']  = $match_data[1];
		return;
	}

	// URL
	$url_valid = 's?https?:\/\/[-_\.!~*\'\(\)a-zA-Z0-9;\/\?:@&=+$,%#]+';
	if(preg_match("/^({$url_valid})/",$row_name,$match_data))
	{
		$base_namespace = "";
		$regularized_data['url'] = $match_data[1];
	}
	elseif(preg_match("/^\/(.*)$/",$row_name,$match_data))
	{
		//Хѥ
		$base_namespace = "";
		$row_name = $match_data[1];
	}
	elseif(preg_match("/^((\.\.\/)+)(.*)$/",$row_name,$match_data))
	{
		// ̶ֻ
		$row_name = $match_data[3];
		$base_namespace = WikiCommonLib::reduce_namespace($base_namespace,strlen($match_data[1])/3);
	}
	elseif(preg_match("/^(?:\.\/)?(.*)$/",$row_name,$match_data))
	{
		// л
		$row_name = $match_data[1];
	}
	
	if(preg_match("/^(.+)\/([^\/]*)$/",$row_name,$match_data)){
		$regularized_data['namespace'] = "";
		if($match_data[1] == ""){
			$regularized_data['namespace'] = $base_namespace;
		}
		else{
			if($base_namespace != ""){
				$regularized_data['namespace'] = $base_namespace . "/" . $match_data[1];
			}
			else{
				$regularized_data['namespace'] = $match_data[1];
			}
		}
		$regularized_data['pagename'] = $match_data[2];
	}
	else
	{
		$regularized_data['namespace'] = $base_namespace;
		$regularized_data['pagename'] = $row_name;
	}
	
	if(preg_match("/^(.*?)#(.+)$/",$regularized_data['pagename'],$match_data))
	{
		$regularized_data['pagename'] = $match_data[1];
		$regularized_data['headlinename'] = $match_data[2];
	}
}
//-----------------------------------------------------



/*----------------------------------------------------
  ץȼȤƤӽФURL
------------------------------------------------------*/
function make_myself_url($mode,$pagename,$namespace,$anchor="",$other="")
{
	$param_text = "md=$mode&amp;pg=" .urlencode($pagename) . "&amp;ns=" . urlencode($namespace);
	if($other)
	{
		$param_text .= "&amp;".$other;
	}
	if($anchor)
	{
		$param_text .= "#". crc32($anchor);
	}
	return $_SERVER['PHP_SELF']."?$param_text";
}


/*----------------------------------------------------
  ץȼȤƤӽФHTML󥯤
------------------------------------------------------*/
function make_link_html($display_text,$mode,$pagename,$namespace,$anchor="",$other="")
{
	return "<a href='".WikiCommonLib::make_myself_url($mode,$pagename,$namespace,$anchor,$other)."'>$display_text</a>";
}

//-----------------------------------------------------


/*----------------------------------------------------
  WikiNameʬHTML֤
------------------------------------------------------*/
function make_wikiname_html($display_text,&$wiki_data,$type="hit")
{
	switch($type){
	case('hit_upper_namespace'):
		$class  = "upper";
		$mode   = "read";
		$a_text = $display_text;
		$suffix = WikiCommonLib::make_link_html(
		           "*","edit",$wiki_data['pagename'],$wiki_data['namespace'],
		           $wiki_data['headlinename']);
		break;

	case('not_found'):
		$class  = "nopage";
		$prefix = $display_text;
		$mode   = "edit";
		$a_text = "?";
		break;

	case('hit'):
	default: //  case('hit_index_page') ޤ
		$class  = "hit";
		$mode   = "read";
		$a_text = $display_text;
		break;
	}

	return "<span class='{$class}'>" .
	       $prefix .
	       WikiCommonLib::make_link_html(
	         $a_text, $mode, $wiki_data['pagename'], $wiki_data['namespace'],
	         $wiki_data['headlinename']
	       ) .
		   $suffix .
		   "</span>";
}
//-----------------------------------------------------


/*----------------------------------------------------
  ֤̾ޡ
------------------------------------------------------*/
function marge_namespace($namespace,$add_namespace)
{
	if($namespace == ""){
		return $add_namespace;
	}
	else{
		return $namespace . "/" . $add_namespace;
	}
}
//-----------------------------------------------------

/*----------------------------------------------------
  ֤̾򿼤ۤʬ
------------------------------------------------------*/
function reduce_namespace($namespace,$count_num)
{
	if($namespace == "" || $count_num==0){return "";}
	
	$name_space_array = split("/",$namespace);
	$new_name = "";
	
	for($i=0;$i<count($name_space_array) - $count_num;$i++){
	
		$new_name .= $name_space_array[$i] . "/";
	}
	
	$new_name = preg_replace("/\/$/","",$new_name);
	
	return $new_name;

}
//-----------------------------------------------------


/*----------------------------------------------------
  ߻ޥä
------------------------------------------------------*/
function get_microtime()
{
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$sec + (float)$usec); 
} 


//////////////////////////////////////////
// ϥå򥹥ȥ꡼Ѵ
function encode_filestream($save_data)
{
	
	$stream = "";
	
	reset($save_data);
	
	while (list($hashkey, $value) = each ($save_data)) {
		if($hashkey != "body" && $hashkey != ""){
			$stream .= $hashkey . ":" . $value ."\n";
		}
	}
	
	$stream .= "\n";
	
	for($i=0;$i<count($save_data['body']);$i++){
		$stream .= $save_data['body'][$i] . "\n";
		
	}
	return $stream;

}

//////////////////////////////////////////
// ȥ꡼ϥåѴ
function decode_filestream($stream)
{
	$data_hash = array();
	$data_hash['body'] = array();
	$row_data_array = split("\r?\n",$stream);
	
	$body_flag = 0;
	for($i=0;$i<count($row_data_array);$i++){
		
		if($body_flag){
			$data_hash['body'][] = $row_data_array[$i];
			continue;
		}
		
		if($row_data_array[$i] == ""){
			$body_flag = 1;
			continue;
		}
		else{
			if(preg_match("/^(.+?):(.*)$/",$row_data_array[$i],$hit_data)){
				$data_hash[$hit_data[1]] = $hit_data[2];
			}
		}
	}
	
	return $data_hash;
}

/*----------------------------------------------------

  convert_dir_from_namespace($namespace) 
     ꤷ֤̾ǥ쥯ȥ̾Ѵ
    
    $name_space   ̾

------------------------------------------------------*/
function convert_dir_from_namespace($namespace)
{
	if($namespace == ""){return "";}
	
	$name_space_array = split("/",$namespace);
	$dir_name = "";
	
	for($i=0;$i<count($name_space_array);$i++){
		$dir_name .= WikiCommonLib::convert_filename_from_wikiname($name_space_array[$i]) . "/";
	}
	
	$dir_name = preg_replace("/\/$/","",$dir_name);
	
	return $dir_name;
}
//-----------------------------------------------------

/*----------------------------------------------------

  convert_filename_from_wikiname($wikiname)
      WikiNameбե̾Ѵ

------------------------------------------------------*/
function convert_filename_from_wikiname($wikiname)
{
	$encode_name = "";
	$char_list = preg_split("//", $wikiname, -1, PREG_SPLIT_NO_EMPTY);
	
	foreach($char_list as $char)
	{
		$encode_name .= sprintf("%02x", ord($char));
	}
	return $encode_name;

}
//-----------------------------------------------------

/*----------------------------------------------------

  decode_filename_from_filename($filename)
      WikiName᤹

------------------------------------------------------*/
function decode_filename_from_filename($filename)
{
	return preg_replace_callback("/([0-9a-fA-F][0-9a-fA-F])/",create_function('$match_text','return chr(HexDec($match_text[1]));'),$filename);
}
//-----------------------------------------------------

//////////////////////////////////////////
// ֤̾μ
function last_namespace( $namespace )
{
	$split_array = split("/",$namespace );
	return array_pop($split_array);
}



}

// $Id$
?>
