<?php
/*----------------------------------------------------

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.
  
  ThreadWiki's Support
   http://thread-wiki.sourceforge.jp/
   http://flatz.jp/
  
  Release note
   2004/00/00 ver0.20 alpha
  
  Notice
  
   This software is released under the GNU General Public License.
   If you want to know GPL in detail , read the file "LICENSE.txt".
  
------------------------------------------------------*/
//////////////////////////////////////////
// 顼޻
error_reporting(E_ERROR | E_PARSE);


//////////////////////////////////////////
// 饤֥ѥλ
chdir("..");
ini_set("include_path", "./lib:".ini_get("include_path"));

require_once("Wiki/TwConfig.php");
require_once("Wiki/PluginManager.php");

//////////////////////////////////////////
// ǡѥλ
$Database_dir = "/home/nasu/public_html/thread_wiki/data/";
$Latest_dir   = $Database_dir . "latest/";
$History_dir  = $Database_dir . "history/";

//////////////////////////////////////////
// ե졼եɤ߹
$config_obj = new TwConfig();
if(!$config_obj->load("wiki.ini"))
{
	error_halt("can't load wiki.ini file .");
}

//////////////////////////////////////////
// main

//
// DBץ
//
//ץ饰ޥ͡㡼
$plugin_manager = new PluginManager( $this, $config_obj );

// DB
if( !$plugin_manager->database_connection_initialize() ) {
	error_halt("can't initialize " . $config_obj->get('db_plugin_name'));
}
$db_obj = $plugin_manager->wiki_db;


//
// ǥ쥯ȥ깽¤ե
//
chdir($Database_dir);
$filename_arr = array();
$from = new From( $Latest_dir );
$from->search_start();

//
// ֤̾ɤ
//
$success=0;
$fail=0;
foreach( $from->namespace_arr as $dir ){
  $namespace_obj = new NamespaceData();
  if($dir)
    $namespace_obj->data = $from->read_page($dir . "/namespace_data");
  else
    $namespace_obj->data = $from->read_page($dir . "namespace_data");
  if(!$namespace_obj->data['name']){
    print " ::<font color='red'>Can't Create Namespace named $file</font><br>";
    $fail++;
    continue;
  }

  if(!$namespace_obj->data['last_modify']){
    $namespace_obj->data['last_modify'] = WikiCommonLib::get_microtime();
  }
  $db_obj->make_namespace($namespace_obj);
  print "::Create Namespace named $dir<br>";
  $success++;
}
print "<font color='blue'>Create Namespace : $success</font><br>";
print "<font color='blue'>Fail   Namespace : $fail</font><br>";

print "(ߢώ) (ߢώ) (ߢώ)<br>";
//
// ڡɤ
//
$success=0;
$fail=0;
foreach( $from->filename_arr as $file ){
  if(preg_match("/namespace_data$/", $file)){
    continue;
  }
  $data = $from->read_page($file);

  //
  // DBͤù
  //
  $page_object = new PageData();
  $page_object->data = $data;
  if($db_obj->save($page_object) != "ok"){
    print "::<font color='red'>Can't Create Page named $file</font><br>";
    $fail++;
  }
  print "::Create Page named $file<br>";
  $success++;
}
print "<font color='blue'>Create Page : $success</font><br>";
print "<font color='blue'>Fail   Page : $fail</font><br>";


exit;


//////////////////////////////////////////
// 顼ۥ
function error_halt($message)
{
	print $message;
	exit;
}


//////////////////////////////////////////
// 饹
class From {
var $top_dir;
var $filename_arr;
var $namespace_arr;

function From($dir){
  $this->top_dir = $dir;
  $this->filename_arr  = array();
  $this->namespace_arr = array();
}

function push_filename (&$filename_arr, $file){
  $filename = realpath($file);
  $filename = str_replace($this->top_dir, "", $filename);
  $filename_arr[] = $filename;
}

function search_start(){
  $this->search_dir($this->top_dir);
  $this->push_filename($this->namespace_arr, "");
}

function search_dir ($dir){
  $savedir = getcwd();
  chdir($dir);
  $dh = opendir(".");
  while($file = readdir($dh)){
    $namespace_obj = null;
    if( preg_match("/^\./", $file) ){
      continue;
    }
    if( preg_match("/namespace_dat$/", $file) ){
      continue;
    }

    if( is_dir($file) ){
      $this->search_dir($file);
      $this->push_filename($this->namespace_arr, $file);
    }
    else{
      $this->push_filename($this->filename_arr, $file);
    }
  }
  chdir($savedir);
}

function view_filename_arr(){
  foreach( $this->filename_arr as $file ){
    print $file . "\n";
  }
}

function view_namespace_arr(){
  foreach( $this->namespace_arr as $file ){
    print $file . "\n";
  }
}


function read_page( $file ){
  $body_flg = "off";
  $page_data = array();

  $file = $this->top_dir . $file;
  print_r($file);
  if(file_exists($file)){
    $fp = fopen($file, "r");
    while(!feof($fp)){
      $line = fgets($fp);
      $line = trim($line);
      if($line == ""){
        $body_flg = "on";
        continue;
      }

      if($body_flg != "on"){
        list($key,$value) = split(":",$line);
        $page_data[trim($key)] = trim($value);
      }
      else{
        $page_data['body'][] = $line;
      }
    }
  }
  return $page_data;
}

}



?>
