<?php
/*----------------------------------------------------

  RelationalDBץ饰  
     RelationalDBѤWikiǡ١ץ饰

    ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.
$Header: /home/cvsroot/thread_wiki/plugin/RelationalDB.plugin.php,v 1.4 2004/06/07 06:27:34 nasu Exp $

᥽å
public :
RelationalDB(&$config)
  : 󥹥ȥ饯
db_connect()
  : DB³ؤΥå
self_check()
  : ʿ
check_exist($pagename,$namespace)
  : wikiname¸ߥå
load(&$wikidata_object,$pagename,$namespace,$mode="search")
  : ʸޤ᤿ڡ
load_header(&$wikidata_object,$pagename,$namespace,$mode="search")
  : ʸΤڡ
save(&$page_object)
  : ڡ¸
delete_page(&$page_object, $mode)
  : ڡ
get_recent_change_list($number, $namespace)
  : ǿΥꥹȼ
add_recent_change_list($pagename,$namespace,$timestamp=0)
  : ̤ѡǰΤ¾DB饹ȤΤݻ
gettime_recent_change()
  : ǿι֥ꥹȼ
get_page_list($namespace="",$search_type="search")
  : ڡꥹȼ
get_namespace_list($namespace="",$search_type="search")
  : ֥̾ꥹȼ
get_page_list_data($target_file_list)
  : PageDataΥǡ
get_history_list($pagename,$namespace)
  : ꥹȼ
load_history_data(&$wikidata_object,$pagename,$namespace,$timestamp)
  : ڡ
grep($word,$namespace="",$search_type="search")
  : 
make_namespace(&$namespace_data_object)
   ֤̾
delete_namespace($namespace)
   ֤̾

private :
save_namespace ( $namespace )
  : ̾¸
check_namespace ( $name, $pid )
  : ̾¸ߥå
get_sql_from_search_type( $namespace, $search_type )
  : search_type鸡SQL
save_history( $page_object )
  : ڡ¸
wikidata_read ( $search_condition, $mode="all" )
  : ڡɤ߹߼
_load ( &$wikidata_object, $pagename, $namespace, $mode="all" )
  : ڡɼνؤΥå
get_text(&$body,$hit)
  : ʸ$hitܤΥǡ
count_in_line( $data, $word )
  : $word¸ߤԿ֤
save_page( $pid, $data )
  : pageơ֥¸
save_permission( $page_id, $action_str, $user )
  : permissionơ֥¸
change_wikiname( &$pagename, &$namespace )
  : å夫Ŭwikiname
check_index_page_exist( $pagename, $namespace )
  : оpagename֤̾ȤȤindexpageҥåȤ뤫å
check_upper_namespace_exist( $pagename, $namespace )
  : ̤֤̾оpagename¸ߤ뤫å
load_namespace(&$namespace_data_object,$namespace)
  о֤̾ξNamespace饹֥Ȥɤ߹

------------------------------------------------------*/

require_once( 'Wiki/TwDatabase.php' );
require_once( 'Wiki/WikiCommonLib.php' );
//require_once( 'FLATz/FileControlLib.php' );

class RelationalDB extends TwDatabase
{

var $db_obj;
var $db_host;
var $db_port;
var $db_name;
var $db_user;
var $db_pass;
var $recent_change_list_cache;
var $status_cache;

/*----------------------------------------------------

  Sw_db_txt($db_dir)  󥹥ȥ饯

  $config  WikiStatus饹֥

------------------------------------------------------*/
function RelationalDB(&$config)
{

	// ǡ
	parent::twdatabase($config);
	$this->db_host = $config->data['db_host'];
	$this->db_port = $config->data['db_port'];
	$this->db_name = $config->data['db_name'];
	$this->db_user = $config->data['db_user'];
	$this->db_pass = $config->data['db_pass'];

    //ץ饰ޥ͡㡼
    $this->plugin_manager = new PluginManager( $this,$this->config );

	// ǴϢDB饹Ƥեɤ߹
	require_once(
	  $config->get('plugin_dir') . '/' . $config->get('rdbms') . '.plugin.php'
	);
	$class_name = $config->get('rdbms');
	$this->db_obj  = new $class_name();

	$this->recent_change_list_cache = array();
	$this->status_cache = array();

	// ǡ١³
	if(!$this->db_connect()){
		// error
	}
	
}
//-----------------------------------------------------


/*----------------------------------------------------
 db_connect() : DB³
  return : true/false /
------------------------------------------------------*/
function db_connect() {
	$conn_string = "";
	if(!empty($this->db_host)){
		$conn_string .= " host=$this->db_host";
	}
	if(!empty($this->db_port)){
		$conn_string .= " port=$this->db_port";
	}
	if(!empty($this->db_name)){
		$conn_string .= " dbname=$this->db_name";
	}
	if(!empty($this->db_user)){
		$conn_string .= " user=$this->db_user";
	}
	if(!empty($this->db_pass)){
		$conn_string .= " password=$this->db_pass";
	}

	return $this->db_obj->connect($conn_string);
}

/*----------------------------------------------------

 self_check()  ʿ
 
  return  error or ok

------------------------------------------------------*/
function self_check()
{
	return "򤹤ФΤ";
}
//-----------------------------------------------------


/*----------------------------------------------------

  check_exist($pagename,$namespace)
       оݥڡ¸ߤƤ뤫å
      
  return : "hit" = ¸ߤ
           "not_found" = ¸ߤʤ
           "hit_upper_namespace" = ̤֤̾¸ߤƤ
           "hit_index_page" = оpagename֤̾ȤȤindexpageҥå
           "wikiname_empty" = pagenameꤵ줿
           "error" = ͽ̥顼

------------------------------------------------------*/
function check_exist($pagename,$namespace)
{

	//
	// ֤̾wikiڡ̾򸡺
	//
/*
	if($pagename == ""){return "wikiname_empty";}
	if($pagename == $this->index_page){
		$pagename = "";
	}
*/
	$pagename_clean  = $this->db_obj->depollution_for_sql($pagename);
	$namespace_clean = $this->db_obj->depollution_for_sql($namespace);
	$query =<<<EOS
SELECT count(*) as cnt
FROM ONLY page P, name_space NS
WHERE
  P.name = '$pagename_clean' AND NS.full_name = '$namespace_clean' AND
  P.name_space = NS.id
EOS;

	if(!$this->db_obj->query($query)){
		return "error";
	}
	if($this->db_obj->fetch_result(0,'cnt')){
		return "hit";
	}

	//
	// оpagename֤̾ȤȤindexpageҥåȤ뤫
	//
/*
	if($this->check_index_page_exist($pagename, $namespace)){
		return "hit_index_page";
	}
*/

	//
	// ̤֤̾¸ߤƤ뤫
	//
	if($this->check_upper_namespace_exist($pagename, $namespace)){
		return "hit_upper_namespace";
	}
	return "not_found";
}
//-----------------------------------------------------

/*-----------------------------------------------------
  wiki֤̾̾wikiǡHashꤵ줿ѿ
  private _load (
    out &$wikidata_object
    in  $pagename
    in  $namespace
    in  $mode {all/header}
  ) : Bool
------------------------------------------------------*/
function _load( &$wikidata_object, $pagename, $namespace, $mode="all" ){
	//
	// åå
	//
	$this->change_wikiname($pagename, $namespace);

	//
	// DBǡɤ
	//
	$search_condition = array(
	  "name"       => $pagename,
	  "name_space" => $namespace,
	);

	$page_arr = $this->wikidata_read($search_condition,$mode);
	if(!$page_arr['id']){
		return false;
	}

	// оݥ֥ȤإǡϤ
	$wikidata_object->clear();
	$wikidata_object->data = $page_arr;

	return true;
}
//----------------------------------------------------

/*----------------------------------------------------

  load(&$wikidata_object,$pagename,$namespace,$mode)  оݥǡ
    
    $wikidata_object : ɤ߹pagedata֥
    $pagename   pagename
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƥʥǥեȡ
       target_level_only = о֤̾Τߥ

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load(&$wikidata_object,$pagename,$namespace,$mode="search")
{
	return $this->_load($wikidata_object,$pagename,$namespace,"all");
}
//-----------------------------------------------------


/*----------------------------------------------------

  load_header(&$wikidata_object,$pagename,$namespace,$mode)  оݥǡإåΤߥ
    
    $wikidata_object : ɤ߹wikidata֥
    $pagename   pagename
    $namespace  ̾
    $mode       ư⡼ɤλ
       search = ֤̾ޤƥʥǥեȡ
       target_level_only = о֤̾Τߥ

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_header(&$wikidata_object,$pagename,$namespace,$mode="search")
{
	return $this->_load($wikidata_object,$pagename,$namespace,"header");

}
//-----------------------------------------------------


/*-----------------------------------------------------

  wiki֤̾̾wikiǡHash֤
  private wikidata_read (
    in $search_condition : Mix
    in $mode {all/header}
  ) : Hash  {顼϶֤}

------------------------------------------------------*/
function wikidata_read ( $search_condition, $mode="all" ) {
	$page_arr = null;  // return

	//
	// pageơ֥
	//
	// ⡼ʬ
	$sql_select = "";
	if($mode == "all"){
		$sql_select = 
 		  "P.id, P.name, NS.full_name as name_space, P.tw_owner, P.tw_group, P.body, P.last_modify";
	}
	else{
		$sql_select =
 		  "P.id, P.name, NS.full_name as name_space, P.tw_owner, P.tw_group, P.last_modify";
	}

	$query = "";
/*
	if($search_condition['name'] == $this->index_page){
		$search_condition['name'] = "";
	}
*/
	$search_condition['name_space'] = trim($search_condition['name_space']);
	$search_condition['name_space'] = trim($search_condition['name_space'], "/");
	$clean_data = $this->db_obj->depollution_for_sql($search_condition);
	if(empty($clean_data['last_modify'])){
		// ꤵʤ硢ǿΥǡ
		$query =<<<EOS
SELECT
  {$sql_select}
FROM 
  ONLY page P, name_space NS
WHERE
  P.name = '{$clean_data['name']}' AND
  NS.full_name = '{$clean_data['name_space']}' AND
  P.name_space = NS.id
EOS;
	}
	else{
		// бǡ
		$query =<<<EOS
SELECT
  {$sql_select}
FROM
  page P, name_space NS
WHERE 
  P.name = '{$clean_data['name']}' AND
  NS.full_name = '{$clean_data['name_space']}' AND
  P.last_modify = '{$clean_data['last_modify']}' AND
  P.name_space = NS.id
EOS;
	}

	if(!$this->db_obj->query($query)){
		return false;
	}
	$page_arr = $this->db_obj->fetch_assoc(0);
	// pagenameѴ
/*
	if($page_arr['name'] == ""){
		$page_arr['name'] = $this->index_page;
	}
*/
	// wikiǡΥ̾Ѵ
	$page_arr['body']  = preg_split("/\r?\n/", $page_arr['body']);
	$page_arr['owner'] = $page_arr['tw_owner'];
	$page_arr['group'] = $page_arr['tw_group'];
	unset($page_arr['tw_owner']);
	unset($page_arr['tw_group']);

	if(!$page_arr['id']){
		return array();
	}
		

	//
	// permissionơ֥
	//
	$query =<<<EOS
SELECT permit_action, user_type
FROM permission
WHERE page_id = {$page_arr['id']}
EOS;
	if(!$this->db_obj->query($query)){
		return array();
	}
	$arr = $this->db_obj->fetch_all();

	list($permit_other, $permit_guest, $permit_group) = array("", "", "");
	foreach( $arr as $row ){
		switch( $row['user_type'] ){
		case('login_user'):
			$permit_other .= $row['permit_action'] . ",";
			break;
		case('guest_user'):
			$permit_guest .= $row['permit_action'] . ",";
			break;
		case('group'):
			$permit_group .= $row['permit_action'] . ",";
			break;
		default:
			break;
		}
	}
	$page_arr['permit_other'] = $permit_other;
	$page_arr['permit_guest'] = $permit_guest;
	$page_arr['permit_group'] = $permit_group;

	return $page_arr;
}
	

/*----------------------------------------------------

   save(&$page_object)  Ϥ줿ǡ¸
   
   $page_object  ¸ڡ饹֥
   return       "ok" = 
                  "freezed"  = ¾Ԥˤä 
                  "modifyed" = ̤οʹ֤˽줿
                  "_error"    = ͽ̥顼

------------------------------------------------------*/
function save(&$page_object)
{
	$valid_result = $page_object->check_valid();
	if($valid_result != "ok"){return $valid_result;}

	// ȥ󥶥󳫻
	$this->db_obj->transaction();
	
	// 
	// pageơ֥뤫history_pageơ֥إǡư
	// ȥꥬˤǤʤ֤̾̾פΤpage˿
	// Ͽ줿顢ŤΤưŪhistory_page˰ư
	if($this->history_flag != 0){
		if(!$this->save_history($page_object)){
			$this->db_obj->rollback();
			return "_error";
		}
	}
	if($this->delete_page($page_object, "latest") != "ok"){
		$this->db_obj->rollback();
		return "_error";
	}
	
	// ǡ¸
	$check_result = $this->check_save($page_object);
	if($check_result == "ok"){
		// ֤̾¸
		$namespace_object = new NamespaceData();
		$namespace_object->data['name'] = $page_object->data['name_space'];
		$namespace_object->data['last_modify'] = WikiCommonLib::get_microtime();
		//$pid = $this->save_namespace($page_object->data['name_space']);
		$pid = $this->save_namespace($namespace_object);
		if(empty($pid)){
			$this->db_obj->rollback();
			return "_error";
		}

		// wikidata¸
		$id = $this->save_page($pid, $page_object->data);
		if(empty($id)){
			$this->db_obj->rollback();
			return "_error";
		}

		// 軰ʤ̤ΤΤ˽񤭴ۤ
		// 롼פؤεϿ
		if(!$this->save_permission($id, $page_object->data['permit_group'],'group')){
			$this->db_obj->rollback();
			return "_error";	
		}

		// 桼ؤεϿ
		if(!$this->save_permission($id, $page_object->data['permit_other'],'login_user')){
			$this->db_obj->rollback();
			return "_error";	
		}
		// ȤؤεϿ
		if(!$this->save_permission($id, $page_object->data['permit_guest'],'guest_user')){
			$this->db_obj->rollback();
			return "_error";	
		}
	}
	else{
		$this->db_obj->rollback();
		return $check_result;
	}

	// ȥ󥶥λ
	$this->db_obj->commit();
	return "ok";
}
//-----------------------------------------------------

/*-----------------------------------------------------

  private save_history (
    in $page_object : Hash
  ) : Bool

-----------------------------------------------------*/
function save_history( $page_object ){
/*
	if($page_object->data['name'] == $this->index_page){
		$page_object->data['name'] = "";
	}
*/
	$clean_data = $this->db_obj->depollution_for_sql($page_object->data);
	$query =<<<EOS
SELECT P.*
FROM ONLY page P, name_space NS
WHERE
  P.name = '{$clean_data['name']}' AND
  NS.full_name = '{$clean_data['name_space']}' AND
  P.name_space = NS.id
EOS;
	if(!$this->db_obj->query($query)){
		return false;
	}

	if($this->db_obj->num_rows() <= 0){
		// ǡ¸ߤʤ
		return true;
	}
	elseif($this->db_obj->num_rows() > 1){
		// ǡʣ¸ߤ
		// ϥǡ١ȿ
		return false;
	}
	else{
		$arr = $this->db_obj->fetch_assoc(0);
		// 05/08 ʤǤä
		// IDˤϰѤʤ
		//unset($arr['id']);

		if(!$this->db_obj->copy_from("history_page", $arr)){
			return false;
		}
		return true;
	}
}
//----------------------------------------------------

/*-----------------------------------------------------

  ֤̾DB¸ơǲؤ֤̾ID֤
  private save_namespace (
    in $namespace_object : Namespace
  ) : Integer

-----------------------------------------------------*/
function save_namespace ( $namespace_object ){
	// ֤̾Ф餹
	$namespace_list = split("/", $namespace_object->data['name']);
    $clean_data = $this->db_obj->depollution_for_sql($namespace_object->data);

	// ֤̾γǧ¸
	$pid = 1;  // 롼
	$current_namespace_full = "";
	foreach( $namespace_list as $name ){
		$current_namespace_full .= "/" . $name;
		$cid = $this->check_namespace($name, $pid);

		// ֤̾DBˤʤɲä
		if(empty($cid)){
			// 
			$full_name = preg_replace("/\/+/", "/", $current_namespace_full);
			$full_name = trim($full_name, "/");

			$name_clean      = $this->db_obj->depollution_for_sql($name);
			$full_name_clean = $this->db_obj->depollution_for_sql($full_name);
			$query =<<<EOS
INSERT INTO name_space
( name, parent_id, full_name, tw_owner, tw_group, last_modify, update )
VALUES(
 '{$name_clean}', {$pid}, '{$full_name_clean}',
 '{$clean_data['owner']}', '{$clean_data['group']}',
  {$clean_data['last_modify']}, CURRENT_TIMESTAMP
)
EOS;
			if(!$this->db_obj->query($query)){
				return -1;
			}

			// ɲäǡIDƼ
			$cid = $this->check_namespace($name, $pid);

			// ֤̾θϿ
			// 롼פؤεϿ
			if(!$this->save_namespace_permission(
			  $cid, $namespace_object->data['permit_group'],'group')
			){
				return -1;
			}

			// 桼ؤεϿ
			if(!$this->save_namespace_permission(
			  $cid, $namespace_object->data['permit_other'],'login_user')
			){
				return -1;
			}
			// ȤؤεϿ
			if(!$this->save_namespace_permission(
			  $cid, $namespace_object->data['permit_guest'],'guest_user')
			){
				return -1;
			}

		}

		// ֤̾ο֤̾ꤹ
		$pid = $cid;
	}
	return $pid;
}

//----------------------------------------------------

/*---------------------------------------------------
  private save_page(
    in $pid  : Integer
    in $data : PageData
  ) : Integer
---------------------------------------------------*/
function save_page( $pid, $data ){
	// ڡǡΥեޥåȤʤɤѹ
/*
	if($data['name'] == $this->index_page){
		$data['name'] = "";
	}
*/
	$data['body'] = join('\n', $data['body']);
	$last_modify = WikiCommonLib::get_microtime();

	// ɲ
	$clean_data = $this->db_obj->depollution_for_sql($data);

	$query =<<<EOS
INSERT INTO page (
  name, name_space, tw_owner, tw_group, body, last_modify, update
)
VALUES(
  '{$clean_data['name']}', {$pid},
  '{$clean_data['owner']}', '{$clean_data['group']}',
  '{$clean_data['body']}', {$last_modify}, CURRENT_TIMESTAMP
)
EOS;
	if(!$this->db_obj->query($query)){
		return -1;
	}

	// ǧIDμ
	$query =<<<EOS
SELECT id
FROM ONLY page
WHERE name = '{$clean_data['name']}' AND name_space = {$pid}
EOS;
	if(!$this->db_obj->query($query)){
		return -1;
	}
	return $this->db_obj->fetch_result(0,'id');
}
//----------------------------------------------------

/*----------------------------------------------------
  private save_permission(
    in page_id     : Integer
    in action_str  : String
	in user        : String
  ) : Bool
----------------------------------------------------*/
function save_permission( $page_id, $action_str, $user ){
	// 
	$action_arr = preg_split('/,/', $action_str);

	$user_clean = $this->db_obj->depollution_for_sql($user);
	foreach( $action_arr as $action ){
		$action = preg_replace("/ +/", "", $action);
		if($action == ""){
			continue;
		}
		$action_clean = $this->db_obj->depollution_for_sql($action);
		
		$query =<<<EOS
INSERT INTO permission(page_id, permit_action, user_type)
VALUES ( {$page_id}, '{$action_clean}', '{$user_clean}' )
EOS;
		if(!$this->db_obj->query($query)){
			return false;
		}
	}
	return true;
}
//----------------------------------------------------

/*----------------------------------------------------
  private save_namespace_permission(
    in namespace_id : Integer
    in action_str   : String
	in user         : String
  ) : Bool
----------------------------------------------------*/
function save_namespace_permission( $namespace_id, $action_str, $user ){
	// 
	$action_arr = preg_split('/,/', $action_str);

	$user_clean = $this->db_obj->depollution_for_sql($user);
	foreach( $action_arr as $action ){
		$action = preg_replace("/ +/", "", $action);
		if($action == ""){
			continue;
		}
		$action_clean = $this->db_obj->depollution_for_sql($action);
		
		$query =<<<EOS
INSERT INTO namespace_permission(namespace_id, permit_action, user_type)
VALUES ( {$namespace_id}, '{$action_clean}', '{$user_clean}' )
EOS;
		if(!$this->db_obj->query($query)){
			return false;
		}
	}
	return true;
}
//----------------------------------------------------

/*----------------------------------------------------

  ֤̾Ĵ٤
  private check_namespace (
    in $name
	in $pid
  ) : Integer

------------------------------------------------------*/
function check_namespace ( $name, $pid ){

	$name = preg_replace("/\/+/", "/", $name);
	$name = trim($name, "/");
	if($name==""){
		return $pid;
	}

	$name_clean      = $this->db_obj->depollution_for_sql($name);
	$query =<<<EOS
SELECT CNS.id as cid
FROM name_space CNS
WHERE
 CNS.name = '{$name_clean}' AND CNS.parent_id = {$pid}
EOS;
	if(!$this->db_obj->query($query)){
		return -1;
	}
	$cid = $this->db_obj->fetch_result(0,'cid');
	return $cid;
}
//----------------------------------------------------

/*----------------------------------------------------

  delete_page(&$page_object, $mode="all")
       оݥڡ

  in $mode : String=all {all/latest}
      
  return : "ok" = 
           "not_found" = ¸ߤʤ
           "freezed"   = ¾Ԥˤä 
           "modifyed"  = ̤οʹ֤˽줿
           "error"     = ͽ̥顼

------------------------------------------------------*/
function delete_page(&$page_object, $mode="all")
{
	$valid_result = $page_object->check_valid();
	if($valid_result != "ok"){return $valid_result;}
	
	$check_result = $this->check_save($page_object);
	if($check_result == "ok"){
		//
		// 
		//
/*
		if($page_object->data['name'] == $this->index_page){
			$page_object->data['name'] = "";
		}
*/
		$clean_data = $this->db_obj->depollution_for_sql($page_object->data);

		//
		// ǡID
		//
		$id_str = "";
		if($mode == "all"){
			$query =<<<EOS
SELECT id
FROM page
WHERE
  page.name = '{$clean_data['name']}' AND
  name_space.full_name = '{$clean_data['name_space']}' AND
  page.name_space = name_space.id
EOS;
			if(!$this->db_obj->query($query)){
				return "error";
			}
			$id_arr = $this->db_obj->fetch_col('id');
			foreach( $id_arr as $id ){
				$id_str .= $id . ",";
			}
			$id_str = trim($id_str, ",");
		}

		//
		// 
		//
		$sql_only = "ONLY";
		if($mode == "all"){
			$sql_only = "";
		}
		$query =<<<EOS
DELETE FROM ${sql_only} page
WHERE
  page.name = '{$clean_data['name']}' AND
  name_space.full_name = '{$clean_data['name_space']}' AND
  page.name_space = name_space.id
EOS;
		if(!$this->db_obj->query($query)){
			return "error";
		}

		//
		// ¤κ
		//
		if($mode == "all" && !empty($id_str)){
			$query =<<<EOS
DELETE FROM permission
WHERE
  page_id in ($id_str)
EOS;
			if(!$this->db_obj->query($query)){
				return "error";
			}
		}

		return $check_result;
	}
	else{
		return $check_result;
	}
	
}
//-----------------------------------------------------


/*----------------------------------------------------

  ǶιꥹȤ
  public get_recent_change_list(
    in $number      Integer ɬפʥꥹȤο
    int $namespace  String = null ̾
  return եΥǡΣ
  
  $data[n]['pagename']  = ڡ̾
  $data[n]['namespace'] = ڡ¸ߤ̾
  $data[n]['timestamp'] = UNIXॹ

------------------------------------------------------*/
function get_recent_change_list($number, $namespace=null) {
	if(is_null($namespace)){
		$namespace = "/";
	}
	else{
		$namespace_clean = $this->db_obj->depollution_for_sql($namespace);
		$add_where_in_query = "AND NS.full_name = '{$namespace_clean}'";
	}

	if(count($this->recent_change_list_cache[$namespace]) < $number){
		//å夬­ʤɤľ
		$this->recent_change_list_cache[$namespace] = array();
		$query =<<<EOS
SELECT
  P.name as pagename, P.last_modify as timestamp, NS.full_name as namespace
FROM
  ONLY page P, name_space NS
WHERE
  P.name_space = NS.id /* AND P.name <> '' */
  {$add_where_in_query}
ORDER BY P.update DESC
LIMIT {$number}
EOS;

		if(!$this->db_obj->query($query)){
			return array();
		}
		$this->recent_change_list_cache[$namespace] = $this->db_obj->fetch_all();

		// indexpageΰ
		for($i=0;$i<count($this->recent_chage_list_cache);$i++){
			if($this->recent_change_list_cache[$namespace][$i]['name'] == ""){
				$this->recent_change_list_cache[$namespace][$i]['name'] = $this->index_page;
			}
		}

	}
	return $this->recent_change_list_cache[$namespace];
}
//-----------------------------------------------------

/*----------------------------------------------------

  Υ饹ǤϻѤޤ
  ߴΤȤꤢ᥽åɤ¸ߤ
  add_recent_change_list($pagename,$namespace,$timestamp=0)
     ǶιꥹȤɲä

  return  "ok" = 
            "error" = 

------------------------------------------------------*/
function add_recent_change_list($pagename,$namespace,$timestamp=0)
{
	return "ok";
}
//-----------------------------------------------------


/*----------------------------------------------------

  gettime_recent_change() ǤǶιUNIXॹפ

  return UNIXॹ

------------------------------------------------------*/
function gettime_recent_change()
{
	$query =<<<EOS
SELCT last_modify
FROM page
ORDER BY update DESC
LIMIT 1
EOS;
	if(!$this->db_obj->query($query)){
		return -1;
	}
	return $this->db_obj->fetch_result(0,'last_modify');
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_page_list($namespace="",$search_type="target_level_only")
     о֤̾ΥڡꥹȤ

   $namespace  оݤˤʤ̾
   $search_type  õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ
       search_index = ǥåڡΤߡĲLV򥵡

   return $keysort줿PageData֥Ȥäϥå

------------------------------------------------------*/
function get_page_list($namespace="",$search_type="search")
{
	$list = array();

	$namespace = trim($namespace);
	$namespace = trim($namespace, "/");
	$sql_condition = $this->get_sql_from_search_type($namespace, $search_type);

	$query =<<<EOS
SELECT P.name as name, NS.full_name as name_space
FROM ONLY page P, name_space NS
WHERE
  P.name_space = NS.id AND
  {$sql_condition}
ORDER BY NS.full_name, P.name
EOS;

	if(!$this->db_obj->query($query)){
		return array();
	}

	$list = $this->db_obj->fetch_all();
	// indexpageΰ
/*
	for($i=0;$i<count($list);$i++){
		if($list[$i]['name'] == ""){
			$list[$i]['name'] = $this->index_page;
		}
	}
*/
	
	$list_data = $this->get_page_list_data($list);
	return $list_data;
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_namespace_list($namespace="",$search_type="target_level_only")
     оְ̾ʲѤ֥̾ꥹȤ

   $namespace  оݤˤʤ̾
   $search_type  õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ
       search_index = ǥåڡΤߡĲLV򥵡

   return sort줿֤̾ä

------------------------------------------------------*/
function get_namespace_list($namespace="",$search_type="search")
{
	$list = array();
	$namespace = trim($namespace);
	$namespace = trim($namespace, "/");
	$sql_condition = $this->get_sql_from_search_type($namespace, $search_type);

	$query =<<<EOS
SELECT CNS.full_name as name_space
FROM name_space CNS, name_space NS
WHERE {$sql_condition} AND  CNS.parent_id = NS.id
ORDER BY CNS.full_name
EOS;

	if(!$this->db_obj->query($query)){
		return array();
	}

	$list = $this->db_obj->fetch_col('name_space');

	/*
	  ģ¸ / ȥߥ󥰤Ƥ뤿
	  ХѥɽľƬ / Ĥ
	*/
	$list2 = array();
	foreach($list as $namespace){
		$list2[] = "/" . $namespace;
	}

	return $list2;
}
//-----------------------------------------------------

/*------------------------------------------------------

  private get_sql_from_search_type (
    in $namespace : String
	in $search_type : String
  ) : String

-------------------------------------------------------*/
function get_sql_from_search_type( $namespace, $search_type ){
	$namespace = $this->db_obj->depollution_for_sql($namespace);

	//
	$sql_condition="";
	if($search_type == "search"){
		// ؤ֤̾ޤƥ
		$sql_condition = "NS.full_name LIKE '{$namespace}%'";
	}
	elseif($search_type == "target_level_only"){
		// о֤̾Τߥ
		$sql_condition = "NS.full_name = '{$namespace}'";
	}
	elseif($search_type == "search_index"){
		// ĲؤޤǤ֤̾򥵡
		$sql_condition .= " NS.full_name LIKE '{$namespace}%' AND" . "\n";
		$sql_condition .= " NS.full_name NOT LIKE '{$namespace}/%/%'";
	}

	return $sql_condition;
}


/*----------------------------------------------------

  get_page_list_data($target_file_list)
     ڡꥹȥǡ

------------------------------------------------------*/
function get_page_list_data($target_file_list)
{
	$data_list = array();
	
	for($i=0;$i<count($target_file_list);$i++){
		$page_data = new PageData();
		if($this->load_header(
			$page_data,$target_file_list[$i]['name'],$target_file_list[$i]['name_space'])
		){
			if($page_data->data['name'] == ""){continue;}
			
			$key_name = "";
			if($page_data->data['index_name'] != ""){
				$key_name = $page_data->data['index_name'];
			}
			elseif($page_data->data['name'] == $this->index_name){
				if($page_data->data['name_space'] == ""){continue;}
				else{$key_name = $page_data->data['name_space'];}
			}
			else{
				$key_name = $page_data->data['name'] . $page_data->data['name_space'];
			}
			$key_name = ucfirst($key_name);
			$key_num = "";
			while(array_key_exists($key_name . $key_num , $data_list)){
				$key_num++;
			}
			$data_list[$key_name . $key_num] = $page_data;
		}
	}
	ksort($data_list);
	return $data_list;
}
//-----------------------------------------------------

/*----------------------------------------------------

  get_history_list($pagename,$namespace)
    оݥڡꥹȡtimeͤΥꥹȤ

  $pagename   pagename
  $namespace  ̾
  return      array timeͤΥꥹ

------------------------------------------------------*/
function get_history_list($pagename,$namespace)
{
/*
	if($pagename == $this->index_page){
		$pagename = "";
	}
*/
	$pagename  = $this->db_obj->depollution_for_sql($pagename);
	$namespace = $this->db_obj->depollution_for_sql($namespace);
	$query =<<<EOS
SELECT HP.last_modify
FROM history_page HP, name_space NS
WHERE
  HP.name = '{$pagename}' AND NS.full_name = '{$namespace}' AND
  HP.name_space = NS.id
ORDER BY HP.update DESC
LIMIT {$this->history_flag}
EOS;
	if(!$this->db_obj->query($query)){
		return array();
	}
	$history_time_list = $this->db_obj->fetch_col('last_modify');
	sort($history_time_list);
	
	return $history_time_list;
}
//-----------------------------------------------------


/*----------------------------------------------------

  load_history_data(&$wikidata_object,$pagename,$namespace,$mode)  оǡ
    
    $wikidata_object : ɤ߹PageData֥
    $pagename   pagename
    $namespace  ̾
    $target_time time
    
   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_history_data(&$wikidata_object,$pagename,$namespace,$timestamp)
{
	$search_condition = array(
	  'name'        => $pagename,
	  'name_space'  => $namespace,
	  'last_modify' => $timestamp,
	);
	$page_arr = $this->wikidata_read($search_condition, $mode="all");
	if(!$page_arr['id']){
		return false;
	}

	$wikidata_object->clear();
	$wikidata_object->data = $page_arr;

	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  grep($word,$namespace="",$search_type="search") оʸʸ

    $word        
    $namespace   ̾֡ʸоݤꤹ
    $search_type õ⡼
       search = ֤̾ޤ
       target_level_only = о֤̾Τߥʥǥեȡ

   return        array("pagename"=>ڡ̾,"namespace"=>̾,
                         "number"=>Կ,"text"=>ʸեƥȤΰ)
                   
                   Ȥ

------------------------------------------------------*/
function grep($word,$namespace="",$search_type="search")
{
	$sql_condition = $this->get_sql_from_search_type($namespace, $search_type);

	$query =<<<EOS
SELECT
  P.name as pagename, NS.full_name as namespace, P.body
FROM ONLY page P, name_space NS
WHERE
  P.name_space = NS.id AND
  P.body LIKE '%{$word}%' AND
  {$sql_condition}
EOS;
	if(!$this->db_obj->query($query)){
		return array();
	}
	$match_data = $this->db_obj->fetch_all();
	for($x=0;$x<count($match_data);$x++){
		// indexpageΰ
/*
		if($match_data[$x]['pagename'] == ""){
			$match_data[$x]['pagename'] = $this->index_page;
		}
*/
		// ɤܤˤ뤫
		$match_data[$x]['number'] =
		  $this->count_in_line($match_data[$x]['body'], $word);
		// ԤȤ˥ڡǡڤʬ
		$match_data[$x]['body'] = preg_split("/\r?\n/", $match_data[$x]['body']);
		// եƥȤ
		$match_data[$x]['text'] =
		  $this->get_text(
		      $match_data[$x]['body'],$match_data[$x]['number']
		  );
		// ʤǡunset
		unset($match_data[$x]['body']);
	}
	return $match_data;
}
//-----------------------------------------------------

/*----------------------------------------------------
  եƥȼ
------------------------------------------------------*/
function get_text(&$body,$hit)
{
	$text = array();
	$hit_count = 0;
	if($hit >= 1)
	{
		if($body[$hit-1] != "")
		{
			array_push($text,$body[$hit-1]);
			$hit_count++;
		}
	}
	
	for( $i=$hit;$i<count($body);$i++)
	{
		if($body[$i] != "")
		{
			array_push($text,$body[$i]);
			$hit_count++;
			if($hit_count > 3){break;}
		}
	}
	
	return join("<br/>",$text);
}
//-----------------------------------------------------

/*-----------------------------------------------------
  ǡιԿ
  private count_in_line(
    $data : String
    $word : String
  ) : Integer
-----------------------------------------------------*/
function count_in_line( $data, $word ){
	$arr = preg_split("/\r?\n/", $data);
	$target_arr = preg_grep("/$word/", $arr);

	// ּ㤤ֹ椬֤뤫ɤ򸡾ڤɬפ
	// +10ȤΤ
	return key($target_arr)+1;
}
//-----------------------------------------------------

/*----------------------------------------------------

  private change_wikiname (
	out $pagename
	out $namespace
  ) : Bool
     åå
	 ֤üʾpagename֤̾򺹤ؤ

------------------------------------------------------*/
function change_wikiname( &$pagename, &$namespace ){
	$orig_pagename  = $pagename;
	$orig_namespace = $namespace;

	if(isset($this->status_cache[$pagename][$namespace]['status'])){
		$pagename  =
		  $this->status_cache[$orig_pagename][$orig_namespace]['pagename'];
		$namespace =
		  $this->status_cache[$orig_pagename][$orig_namespace]['namespace'];
	}
	return true;
}
//-----------------------------------------------------

/*-----------------------------------------------------
  private check_index_page_exist (
    in $pagename  : String
    in $namespace : String
  ) : Bool
-----------------------------------------------------*/
/*
function check_index_page_exist( $pagename, $namespace ){
	$namespace_index = $namespace . "/" . $pagename;
	$namespace_index = preg_replace("/\/+/", "/", $namespace_index);
	$namespace_index = trim($namespace_index, "/");
	$namespace_clean = $this->db_obj->depollution_for_sql($namespace_index);
	
	$query =<<<EOS
SELECT count(*) as cnt
FROM ONLY page P, name_space NS
WHERE
  P.name = '' AND NS.full_name = '$namespace_clean' AND
  P.name_space = NS.id
EOS;
	if(!$this->db_obj->query($query)){
		return false;
	}
	if($this->db_obj->fetch_result(0,'cnt')){
		$this->status_cache[$pagename][$namespace] = array(
		  'status'    => 'hit_index_page',
		  'pagename'  => "",
		  'namespace' => $namespace_index
		);

		return true;
	}
	return false;
}
*/
//-----------------------------------------------------

/*-----------------------------------------------------
  private check_upper_namespace_exist (
    in $pagename  : String
    in $namespace : String
  ) : Bool
-----------------------------------------------------*/
function check_upper_namespace_exist( $pagename, $namespace ){
	$pagename_clean  = $this->db_obj->depollution_for_sql($pagename);

	$upper_namespace = $namespace;
	while(1){
		$upper_namespace = WikiCommonLib::reduce_namespace($upper_namespace,1);
		$upper_namespace_clean =
		  $this->db_obj->depollution_for_sql($upper_namespace);
		$query =<<<EOS
SELECT count(*) as cnt
FROM ONLY page P, name_space NS
WHERE
  P.name = '$pagename_clean' AND
  NS.full_name = '$upper_namespace_clean' AND
  P.name_space = NS.id
EOS;

		if(!$this->db_obj->query($query)){
			return false;
		}
		if($this->db_obj->fetch_result(0,'cnt')){
			$this->status_cache[$pagename][$namespace] = array(
			  'status'    => 'hit_upper_namespace',
			  'pagename'  => $pagename,
			  'namespace' => $upper_namespace
			);
			return true;
		}

		if($upper_namespace == ""){
			return false;
		}
	}
}
//-----------------------------------------------------

/*----------------------------------------------------

  make_namespace(&$namespace_data_object) ֤̾

   $namespace_data_object NamespaceData饹֥
   
   return       true  : 
                  false : 

------------------------------------------------------*/
function make_namespace(&$namespace_data_object)
{
	$pid = $this->save_namespace($namespace_data_object);
	if(empty($pid)){
		return false;
	}
	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  delete_namespace($namespace) ֤̾

   $namespace о̾
   
   return       true  : 
                  false : 

------------------------------------------------------*/
function delete_namespace($namespace)
{
	$namespace = trim($namespace);
	$namespace = trim($namespace, "/");
	$namespace_clean      = $this->db_obj->depollution_for_sql($namespace);
	$query =<<<EOS
DELETE FROM name_space
WHERE
  full_name = '{$namespace_clean}' OR
  full_name LIKE '{$namespace_clean}/%'
EOS;
	if(!$this->db_obj->query($query)){
		return false;
	}
	
	return true;
}
//-----------------------------------------------------

/*----------------------------------------------------

  load_namespace(&$namespace_data_object,$namespace)
    о֤̾ξNamespace饹֥Ȥɤ߹

    $namespace_data_object : ɤ߹Namespace֥
    $namespace  ̾

   return       true  : ɤ߹
                  false : ɤ߹߼

------------------------------------------------------*/
function load_namespace(&$namespace_data_object,$namespace)
{
	$namespace = trim($namespace);
	$namespace = trim($namespace, "/");
	$namespace_clean = $this->db_obj->depollution_for_sql($namespace);

	//
	// name_spaceơ֥
	//
	$query =<<<EOS
SELECT id, full_name, tw_owner, tw_group, last_modify
FROM name_space
WHERE full_name = '{$namespace_clean}'
EOS;
	if(!$this->db_obj->query($query)){
		return false;
	}
	$namespace_arr = $this->db_obj->fetch_assoc();
	if($namespace_arr['id']==""){
		return false;
	}
	
	//
	// namespace_permissionơ֥
	//
	$query =<<<EOS
SELECT permit_action, user_type
FROM namespace_permission
WHERE namespace_id = {$namespace_arr['id']}
EOS;
	if(!$this->db_obj->query($query)){
		return false;
	}
	$permission_arr = $this->db_obj->fetch_all();

	list($permit_other, $permit_guest, $permit_group) = array("", "", "");
	foreach( $permission_arr as $row ){
		switch( $row['user_type'] ){
		case('login_user'):
			$permit_other .= $row['permit_action'] . ",";
			break;
		case('guest_user'):
			$permit_guest .= $row['permit_action'] . ",";
			break;
		case('group'):
			$permit_group .= $row['permit_action'] . ",";
			break;
		default:
			break;
		}
	}
	$namespace_arr['permit_other'] = $permit_other;
	$namespace_arr['permit_guest'] = $permit_guest;
	$namespace_arr['permit_group'] = $permit_group;

	//
	// ǡ
	//
	$namespace_arr['name']  = $namespace_arr['full_name'];
	$namespace_arr['owner'] = $namespace_arr['tw_owner'];
	$namespace_arr['group'] = $namespace_arr['tw_group'];
	unset($namespace_arr['id']);
	unset($namespace_arr['full_name']);
	unset($namespace_arr['tw_owner']);
	unset($namespace_arr['tw_group']);

	$namespace_data_object->clear();
	$namespace_data_object->data = $namespace_arr;
	
	return true;
}
//-----------------------------------------------------


}
?>
