/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/11
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.meta
 * t@C  (file name)    FIndexComparator.java
 */
package net.sf.thirdi.jdbc.meta;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * <i>Tv(abstract)</i>F r\[g
 *@.<p>
 * r\[gsB
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class IndexComparator implements Comparator<ElementIndexable>{

	private static Comparator<ElementIndexable> comp = new IndexComparator();
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(ElementIndexable left, ElementIndexable right) {
		
		if (left.getIndex() == right.getIndex()){
			return 0;
		} else {
			if (left.getIndex() > right.getIndex()) {
				return -1;
			} else {
				return 1;
			}
		}
		
	}
	
	/**
	 * <i>Tv(abstract)</i>F \[g
	 * .<p>
	 * \[g
	 *@
	 * @param list
	 */
	public static void sort(List<? extends ElementIndexable> list) {
		if (comp == null) comp = new IndexComparator();
		Collections.sort(list,comp);
	}

}
