/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/16
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc.impl
 * t@C  (file name)    FCSVColumnImpl.java
 */
package net.sf.thirdi.jdbc.impl;

import net.sf.thirdi.jdbc.CSVColumn;
import net.sf.thirdi.jdbc.CSVColumnDecorator;

/**
 * <i>Tv(abstract)</i>F CSVJ
 *@.<p>
 * CSVJ<BR>
 * {@link net.sf.thirdi.jdbc.CSVColumn}
 * 
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public class CSVColumnImpl implements CSVColumn{
	
	private String columnname;
	
	private String aliasname;
	
	private CSVColumnDecorator csvcolumndecorator = new DefaultCSVColumnDecorator();
	
	private boolean hasaliasname = false;
	
	CSVColumnImpl(String columnName) {
		if (columnName == null || "".equals(columnName))
			// TODO message move to property file.
			throw new IllegalArgumentException("columnName must not be null or blank.");
		this.columnname = columnName.toUpperCase();
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVColumn#getCSVColumnDecorator()
	 */
	@Override
	public CSVColumnDecorator getCSVColumnDecorator() {
		return this.csvcolumndecorator;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVColumn#getColumnAliasName()
	 */
	@Override
	public String getColumnAliasName() {
		return this.aliasname;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVColumn#getColumnName()
	 */
	@Override
	public String getColumnName() {
		return this.columnname;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVColumn#setCSVColumnDecorator(net.sf.thirdi.jdbc.CSVColumnDecorator)
	 */
	@Override
	public void setCSVColumnDecorator(CSVColumnDecorator decorator)
			throws IllegalArgumentException {
		if (decorator == null)
			// TODO message move to property file.
			throw new IllegalArgumentException("decorator must not be null.");
	
		this.csvcolumndecorator = decorator;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVColumn#setColumnAliasName(java.lang.String)
	 */
	@Override
	public void setColumnAliasName(String alias)
			throws IllegalArgumentException {
		
		if (alias == null || "".equals(alias))
		// TODO message move to property file.
		throw new IllegalArgumentException("alias must not be null or blank.");
		
		this.aliasname = alias;
		this.hasaliasname = true;
		
	}

	/**
	 * <i>Tv(abstract)</i>FSet the {@link net.sf.thirdi.jdbc.impl.CSVColumnImpl#columnname}
	 * .<p>
	 * Set the {@link net.sf.thirdi.jdbc.impl.CSVColumnImpl#columnname}.
	 *
	 * @param columnname the columnname to set
	 */
	void setColumnname(String columnname) {
		this.columnname = columnname;
	}

	/* (non-Javadoc)
	 * @see net.sf.thirdi.jdbc.CSVColumn#hasAliasName()
	 */
	@Override
	public boolean hasAliasName() {
		return this.hasaliasname;
	}

}
