/*
 * Copyright 2009- kensir0u.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 * 쐬 (creation date)  F2009/02/14
 * pbP[W  (package name) Fnet.sf.thirdi.jdbc
 * t@C  (file name)    FCSVConverter.java
 */
package net.sf.thirdi.jdbc;

import java.io.Writer;
import java.sql.ResultSet;

/**
 * <i>Tv(abstract)</i>F CSVRo[^[
 *@.<p>
 * CSVRo[^[
 * 
 *
 * @author  kensir0u
 * @version 1.0
 * @since   JDK 5.0
 *
 */
public interface CSVConverter {
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 *  {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 *  WWriterԋpB(UTF-8)
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @param maxcount@ő匏
	 * @return@Ro[g̕WWriter
	 */
	Writer toCSV(ResultSet rs,CSVInfo info,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 * WWriterԋpB(UTF-8)
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param info@info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @return@Ro[g̕WWriter
	 */
	Writer toCSV(ResultSet rs,CSVInfo info);
	
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 * WWriterԋpB(UTF-8)
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param maxcount@ő匏
	 * @return@Ro[g̕WWriter
	 */
	Writer toCSV(ResultSet rs,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F {@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * {@link java.sql.ResultSet}CSVɃRo[gB<BR>
	 * WWriterԋpB(UTF-8)
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @return@Ro[g̕WWriter
	 */
	Writer toCSV(ResultSet rs);
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param writer@w肵Writer
	 * @param info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @param maxcount@ő匏
	 * @return@Ro[g̎w肵Writer
	 */
	<T extends Writer> T toCSV(ResultSet rs,T writer,CSVInfo info,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param writer@w肵Writer
	 * @param info@{@link net.sf.thirdi.jdbc.CSVInfo}IuWFNg
	 * @return@Ro[g̎w肵Writer
	 */
	<T extends Writer> T toCSV(ResultSet rs, T writer,CSVInfo info);
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs@{@link java.sql.ResultSet}IuWFNg
	 * @param writer@w肵Writer
	 * @return@Ro[g̎w肵Writer
	 */
	<T extends Writer> T toCSV(ResultSet rs, T writer);
	
	/**
	 * <i>Tv(abstract)</i>F w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 * .<p>
	 * w肵Writerp{@link java.sql.ResultSet}CSVɃRo[gB
	 *@
	 * @param rs {@link java.sql.ResultSet}IuWFNg
	 * @param writer w肵Writer
	 * @param maxcount ő匏
	 * @return Ro[g̎w肵Writer
	 */
	<T extends Writer> T toCSV(ResultSet rs, T writer,long maxcount);
	
	/**
	 * <i>Tv(abstract)</i>F CSVInfo쐬B
	 * .<p>
	 * CSVInfo쐬B
	 *@
	 * @param rs {@link java.sql.ResultSet}IuWFNg
	 * @return CSVInfo IuWFNg
	 * @throws IllegalArgumentException
	 */
	public CSVInfo createCSVInfo(ResultSet rs) throws IllegalArgumentException;
	
}
