package com.torn.puyoru.parts;

import static com.torn.puyoru.parts.Type.$;
import static com.torn.puyoru.parts.Type._;


public class Table {

	/* TCY */
	private static final int WIDTH  = 12;
	private static final int HEIGHT  = 21;

	/* Qi͌ȂubN */
	public static final int OFFSET = 2;

	/* E[ */
	private static final int L = 1;
	/* [ */
	private static final int R = WIDTH - 2;
	
	/* c~2z */
	private Type[][] table;

	/* ubN̏oʒu */
	private static final int START_X = 5;
	private static final int START_Y = 1 + OFFSET;

	
	
	/* lNXg */
	private NextTable nextTable;

	public Table() {
		/* e[u` */
		table = new Type[HEIGHT + OFFSET][WIDTH];
		/* lNXge[u */
		nextTable = new NextTable();

		/* e[u */
		for (int y = 0; y < table.length; y++) {
			if (table.length-1 == y) {
				for (int x = 0; x < table[y].length; x++) {
					table[y][x] = new Type($);
				}
			} else {
				for (int x = 0; x < table[y].length; x++) {
					if (L > x || R < x) {
						table[y][x] = new Type($);
					} else {
						table[y][x] = new Type(_);
					}
				}
			}
		}
	}

	/**
	 * e[u\p擾
	 */
	public String toString() {
		StringBuilder builder;
		builder = new StringBuilder();

		/* e[u\p쐬(Qi͌ȂubN) */
		for (int i = OFFSET; i < table.length; i++) {
			for (Type block : table[i]) {
//				builder.append(block.getType());
/* fobO */	builder.append(
					(block.isDroppedMark()) ? Type.D : block.getType()
				);
				
			}
			builder.append(System.getProperty("line.separator"));
		}

		return builder.toString();
	}

	/**
	 * lNXg\p擾B
	 * NextTable#toStringbvB
	 * @return
	 */
	public String toStringNext() {
		return nextTable.toString();
	}

	/**************************************************************************/
	/* ~m																	  */
	/**************************************************************************/
	/**
	 * ~m
	 * @return
	 */
	public Puyo initPuyo() {
		/* ނ擾 */
		NextType next = nextTable.getNextType();

		/* ʒu̐ݒ */
		int x = START_X;
		int y = START_Y;

		/* ~m̐ */
		return new Puyo(next, x, y);
	}

	/**
	 * Ղ悪u邩B
	 * ɒS̈ʒuw肷B
	 * @param current
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean isSetPuyo(Puyo current, int x, int y) {
		int cnt;
		int[][] info = current.getInfo();
		boolean ret = true;


//		Debug.println("x:" + x + " y:" + y);

		/* S̔ */
		if (!new Type(_).compare(table[y][x])) {
			ret = false;;
		} else {
			/* 3_̔ */
			for (cnt = 0; cnt < info.length; cnt++) {
				int offsetX = info[cnt][0];
				int offsetY = info[cnt][1];

//				Debug.println("{" + offsetX + ", " + offsetY + "}");

				/* ʒu` */
				Point p = new Point(x + offsetX, y + offsetY);

				/* zOANZX`FbN */
				if (isOutOfRange(p)) {
					ret = false;
					break;
				}

				/*  */
				if (!new Type(_).compare(table[p.y][p.x])) {
					ret = false;
					break;
				}
			}
		}

		return ret;
	}

	/* e[u͈̔͊O */
	private boolean isOutOfRange(Point p) {
		return p.x < 0 || p.x >= table[0].length
			|| p.y < 0 || p.y >= table.length;
	}


	/**
	 * Ղe[uɐݒB
	 * S̈ʒu͐ݒς݂ƂB
	 * 	 * @param current
	 */
	public void setPuyo(Puyo current) {
		Block[] blocks = current.get();

		for (Block b : blocks) {
			table[b.getY()][b.getX()] = b.getType();
		}
	}

	
	/**
	 * Ղ̍폜
	 * @param current
	 */
	void delPuyo(Puyo current) {
		Block[] blocks = current.get();

		for (Block b : blocks) {
			table[b.getY()][b.getX()] = new Type(_);
		}
	}
	
	/**
	 * Ɉړ
	 * @param current
	 * @return
	 */
	public boolean moveDown(Puyo current) {
		int x = current.getCenterX();
		int y = current.getCenterY();

		/* ̈ʒuU */
		delPuyo(current);

		/* ɒu邩 */
		if (!isSetPuyo(current, x, y+1)) {
			Debug.println("ɐݒu");

			/* ̈ʒuɐݒ*/
			setPuyo(current);
			return false;
		}


		/* PɈړ */
		current.setBlock(x, y+1);

		/* 1ɒu */
		setPuyo(current);

		return true;
	}

	/**
	 * EɈړ
	 * @param current
	 * @return
	 */
	public boolean moveRight(Puyo current) {
		int x = current.getCenterX();
		int y = current.getCenterY();

		/* ̈ʒuU */
		delPuyo(current);

		/* Eɒu邩 */
		if (!isSetPuyo(current, x+1, y)) {
			/* ̈ʒuɐݒ*/
			setPuyo(current);
			return false;
		}

		/* PEɈړ */
		current.setBlock(x+1, y);

		/* 1Eɒu */
		setPuyo(current);

		return true;
	}

	/**
	 * Ɉړ
	 * @param current
	 * @return
	 */
	public boolean moveLeft(Puyo current) {
		int x = current.getCenterX();
		int y = current.getCenterY();

		/* ̈ʒuU */
		delPuyo(current);

		/* ɒu邩 */
		if (!isSetPuyo(current, x-1, y)) {
			/* ̈ʒuɐݒ*/
			setPuyo(current);
			return false;
		}

		/* PɈړ */
		current.setBlock(x-1, y);

		/* 1ɒu */
		setPuyo(current);

		return true;
	}
	
	/**********************************************************************/
	/* ]																  */
	/**********************************************************************/
	/**
	 * ]ubNݒuł邩
	 * @param tmp
	 * @param dr
	 * @return
	 */
	private boolean isSetRotatePuyo(Puyo tmp, int dr) {
		/* dr͖gp */
		
		/* ~mzuł */
		boolean ret = isSetPuyo(tmp, tmp.getCenterX(), tmp.getCenterY()); 
		return ret;
	}

	/**
	 * ]~me[uɐݒu
	 * @param current
	 * @param dr
	 * @return
	 */
	public boolean rotate(Puyo current, int dr) {
		boolean ret;

		/* `FbN */
		if (Puyo.R_RIGHT != dr && Puyo.R_LEFT != dr) {
			return false;
		}

		/* ̈ʒuU */
		delPuyo(current);

		/* ~m̃Rs[쐬 */
		Puyo tmpPuyo = current.clone();

		/* Rs[~m] */
		ret = tmpPuyo.rotateInfo(dr);
		if (!ret) {
			/* ̈ʒuɐݒ*/
			setPuyo(current);
			return false;
		}

		/* ]~mu邩 */
		ret = isSetRotatePuyo(tmpPuyo, dr);
		if (!ret) {
			/* ̈ʒuɐݒ*/
			setPuyo(current);
			return false;
		}

		/* 쒆̃~mɕύXKp */
		current.updateRotate(tmpPuyo);

		/* ~me[uɐݒ */
		setPuyo(current);

		return true;
	}
	
	/**********************************************************************/
	/* 																  */
	/**********************************************************************/
	public void setDroppedMark(Puyo current) {
		/*  */
		Block[] blocks = current.get();
		for (Block b : blocks) {
			int y = b.getY();
			int x = b.getX();
			table[y][x].setDroppedMark(true);
		}
	}
	

	/**
	 * \ȃubNɗƂ
	 * @return ꍇtrue
	 */
	/* TODO:x͈͎̔wƂ */
	public boolean dropBlock() {
		boolean ret = false;
		int dropPosY;

		/* 珇ʃ`FbN */
		for (int x = L; x <= R; x++) {
			/* ʒuvZ */
			for (dropPosY = table.length - 1; dropPosY >= 0; dropPosY--) {
				if (new Type(_).compare(table[dropPosY][x])) {
					break;
				}
			}
			/* 珇Ƀ`FbN */
			for (int y = dropPosY - 1; y >= 0; y--) {
				/* ubNłȂ */
				if (!new Type(_).compare(table[y][x])) {
					/* ubNłȂꍇA܂ŗ */
					table[dropPosY][x].setType(table[y][x].getType());
					/* ړubN̈ʒuɈt */
					table[dropPosY][x].setDroppedMark(true);
					
					/* ̈ʒu̓ubN */
					table[y][x] = new Type(_);
					/* ̈ʒuXV */
					dropPosY--;
					/* Alݒ */
					ret = true;
				} else {
					/* ubN̏ꍇȂ */
				}
			}
		}
		return ret;
	}

	private static final int DEL_NUM_MIN = 4;
	private int delCnt = 0;
	
	/* Ɏw肳ꂽubNɁA */
	/* ΏۃubNɂDELETE}[NADELETE}[N */
	/* DEL_NUM_MINȏȂ΃ubN */
	private boolean deleteOne(Point p) {
		boolean ret = false;
		
		/* `FbN */
		if (null == p || isOutOfRange(p)) {
			return false;
		}
		
		/*  */
		delCnt = 0;

		/* Ɏw肳ꂽނ̃ubNDELETE}[N */
		deleteCheck(table[p.y][p.x], p.x, p.y, CALL_NO);

//		Debug.println("delCnt:" + delCnt);
		System.err.println("delCnt:" + delCnt);

		if (DEL_NUM_MIN <= delCnt) {
			/* DELETE}[N̂ubN */
			ret = delete();
			
		}

		/* ǉ̍폜 */
		unSetDeleteMark();
		unSetCheckMark();
	

		return ret;
	}
	private boolean delete() {
		boolean ret = false;
		for (int y = table.length - 2; y >= 0; y--) {
			for (int x = L; x <= R; x++) {
				/* */
				if (table[y][x].isDeleteMark()) {
					table[y][x] = new Type(_);
//					System.err.print("("+ x + "," + y+ ")");
					ret = true;
				}
			}
		}
//		System.err.println();
		return ret;
	}

	/* Bꍇɂ͖߂ltrue */
	public boolean deleteAll() {
		boolean ret = false; /* lfalse */
		
		for (;;) {
		
			/* DROPPED}[N̂ubN */
			/* TODO:^񒆂猟H */
			/* s */
			Point p = new Point(0, 0);
			if (!findDoroppedBlock(p)) {
				/* DROPPED}[ŇɎsꍇɈُԂ */
				unSetDeleteMark();
				unSetCheckMark();
				break;
			}
	
			/* ŏɌDROPPED}[N̕tubN */
			/* ΏۂTsB */
			if (deleteOne(p)) {
				/* ꍇA߂ltrue */
				ret = true;
			}
		}
		return ret;
	}
	
	private static final int CALL_NO = 0;
	private static final int CALL_R = 1;
	private static final int CALL_D = 2;	
	private static final int CALL_L = 3;
	private static final int CALL_U = 4;
	
	
	/* ΏۃubN̒T */
	/* ӁFET̏ꍇ̒T͂Ȃ*/
	private void deleteCheck(Type type, int x, int y, int callType) {
		if (table[y][x].isCheckMark()) {
			return;
		}
		/* TΏۂ̎ނłȂꍇ͑ł؂ */
		if (!table[y][x].compare(type)) {
			return;
		}

		/* CHECK}[N */
		table[y][x].setCheckMark(true);

		/* Ώۂ̃ubN̐Z */
		delCnt++;
		/* DELETE}[N */
		table[y][x].setDeleteMark(true);
		/* DROPPED}[N */
		table[y][x].setDroppedMark(false);
		
		
//		System.err.print("{"+ x + "," + y+ "}");

		/* E */
		if (CALL_L != callType && R >= x + 1) {
			deleteCheck(type, x + 1, y, CALL_R);
		} else {
		}
		/*  */
		if (CALL_U != callType && table.length - 2 >= y + 1) {
			deleteCheck(type, x, y + 1, CALL_D);
		}
		/*  */
		if (CALL_R != callType && L <= x - 1) {
			deleteCheck(type, x - 1, y, CALL_L);
		}
		/*  */
		if (CALL_D != callType && 0 <= y - 1) {
			deleteCheck(type, x, y - 1, CALL_U);
		}
	}
	
	
	private boolean findDoroppedBlock(Point out) {
		if (null == out) {
			return false;
		}
		
		for (int y = table.length - 2; y >= 0; y--) {
			for (int x = L; x <= R; x++) {
				/* */
				if (table[y][x].isDroppedMark()) {
					out.x = x;
					out.y = y;
					return true;
				}
			}
		}
		return false;
	}
	
	
	private void unSetCheckMark() {
		for (int y = table.length - 2; y >= 0; y--) {
			for (int x = L; x <= R; x++) {
				table[y][x].setCheckMark(false);
			}
		}
	}
	private void unSetDeleteMark() {
		for (int y = table.length - 2; y >= 0; y--) {
			for (int x = L; x <= R; x++) {
				table[y][x].setDeleteMark(false);
			}
		}
	}
}
