package com.torn.puyoru.parts;

import static com.torn.puyoru.parts.Type._;

import java.util.Random;

/* lNXg̎ */
class NextType {
	int type1;
	int type2;
	NextType(int type1, int type2) {
		this.type1 = type1;
		this.type2 = type2;
	}
	
	void setNext(Random r) {
		type1 = getRandom(r, 1, 5); 
		type2 = getRandom(r, 1, 5); 
	}

	/* minȏmaxȉ̗ */
	private int getRandom(Random r, int min, int max) {
		/* TODO:΂ */
		return r.nextInt(max+1-min) + min;
	}
}

/* lNXg */
class NextTable {
	
	/* lNXg̊Ǘz */
	private NextType[] nextInfo;

	/* lNXg\pe[u */
	private int[][] nextTable;

	/* lNXgǗ */
	private int num;

	/* lNXg̊Ǘz̗̎vf̓Y */
	private int nextIdx;


	/* fobO */
	int debug = 1; /* 2ɂƁAnum2{̃lNXg悤ɂȂ */


	NextTable() {
		this(7);
	}

	NextTable(int num) {
		nextInfo = new NextType[num * 2];
		nextTable = new int[4 * num * debug][5];
		this.num = num;
		nextIdx = 0;
		
		/*  */
		initTable();
		
		/* lNXg̊ǗzKɏ */
		nextInfo[0] = new NextType(1, 1);
		nextInfo[1] = new NextType(2, 2);
		nextInfo[2] = new NextType(3, 3);
		nextInfo[3] = new NextType(4, 4);
		nextInfo[4] = new NextType(5, 5);
		nextInfo[5] = new NextType(1, 2);
		nextInfo[6] = new NextType(2, 3);
		nextInfo[7] = new NextType(3, 4);
		nextInfo[8] = new NextType(5, 1);
		nextInfo[9] = new NextType(4, 4);
		nextInfo[10] = new NextType(5, 5);
		nextInfo[11] = new NextType(1, 2);
		nextInfo[12] = new NextType(2, 3);
		nextInfo[13] = new NextType(3, 4);

		/* Onum */
		create(0, num-1);
	}


	/* lNXg̎ނ擾 */
	public NextType getNextType() {

//		Debug.println("getNextType() nextidx:" + nextIdx);
		NextType retNext;

		/* lNXg̃~m̎ނ擾 */
		retNext = nextInfo[nextIdx];

		/* numɂP񐶐 */
		if (0 == nextIdx) {
			/* num̐ */
			create(num, num*2-1);
		} else if (num == nextIdx) {
			/* Onum̐ */
			create(0, num-1);
		}

		/* Y̍XV */
		nextIdx = (nextIdx+ 1) % (num * 2);

		return retNext;
	}

	/* p̗ */
	private Random r = new Random();

	/**
	 * 
	 * @param startIdx
	 * @param endIdx
	 */
	public void create(int startIdx, int endIdx) {
		for (int i = startIdx; i < endIdx; i++) {
			nextInfo[i].setNext(r);
		}
	}

	/* lNXge[ȕ */
	private void initTable() {
		for (int y = 0; y < nextTable.length; y++) {
			for (int x = 0; x < nextTable[y].length; x++) {
				nextTable[y][x] = _;
			}
		}
	}

	/**
	 * 𕶎(lNXg\p쐬
	 */
	public String toString() {
		/********************************/
		/* lNXg\e[u */
		/********************************/
		initTable();

		/********************************/
		/* lNXg\e[u쐬 */
		/********************************/
		final int x = 2;	/* ~mݒʒu */
		int y = 2;			/* ~mݒʒu */

		for (int i = 0; i < num * debug; i++) {
			/* 擾vf̓Y */
			int typeIdx = (i + nextIdx) % (num * 2);
			
			/* lNXg̎ނ擾 */
			NextType next = nextInfo[typeIdx];
			
			/* 쐬 */
			Puyo puyo = new Puyo(next, x, y);
			
			/* lNXg`e[uɐݒ */
			setPuyo(puyo);
			
			/* e[u̐ݒʒuXV */
			y += 3;
		}

		/********************************/
		/* lNXg\p쐬     */
		/********************************/
		StringBuilder builder = new StringBuilder();
		for (int[] yoko : nextTable) {
			for (int block : yoko) {
				builder.append(block);
			}
			builder.append(System.getProperty("line.separator"));
		}

		return builder.toString();
	}

	/********************************/
	/* lNXg\e[u         */
	/********************************/
	/* e[uɐݒ */
	private void setPuyo(Puyo puyo) {
		Block[] blocks = puyo.get();
		for (Block b : blocks) {
			nextTable[b.getY()][b.getX()] = b.getIntType();
		}
	}

}
