package com.torn.puyoru.template;

import com.torn.puyoru.parts.Debug;
import com.torn.puyoru.parts.Puyo;
import com.torn.puyoru.parts.Table;

public abstract class GameThread implements Runnable {

	/* isxp[^ */
	protected static int FPS = 60; /* t[[g */ /* ͓ǂݎԊu */
	protected static int DOWN_RATE = 60; /* ~px */


	/*  */
	protected Display display
	/* vC[ */;
	protected Player player;


	public GameThread(Display display, Player player) {
		/* ʂ̓o^ */
		this.display = display;
		/* vC[o^ */
		this.player = player;
	}


	/**
	 * Q[
	 */
	protected abstract void initialize();

	/**
	 * Q[[v
	 */
	public void run() {
		/* Q[ispϐ */
		Table table = new Table();/* e[u */
		Puyo current = null;		/* 쒆̃~m */
		int downCnt = 0;			/* JE^(~p) */

		int retType = Player.OP_NO;	/* ̎ */
		boolean retOperate = false;	/* ̕Al */
		boolean isGrounding = false;/* ݒutO */
		boolean isSettled = false;	/* ݒumtO */
		boolean retDel = true;		/* ̕Al */
		boolean retIsSet = false;	/* o\̕Al */
		boolean retStartSign = false; /* Jn}҂̕Al */

		/* Q[ */
		initialize();
		
		/* e[u\ */
		display.disp(table.toString());
		Debug.println("init table", table.toString());


		/* Jn}҂ */
		retStartSign = display.waitStartSign(player);
		if (!retStartSign) {
			/* ُI */
		}

		/**********************************************************************/
		/* ~mo															  */
		/**********************************************************************/
		/* ~m */
		current = table.initPuyo();

		/* o\͂ł͂Ȃ */

		/* ~me[uɐݒ */
		table.setPuyo(current);

		/* e[u\ */
		display.disp(table.toString());
		Debug.println("new block", table.toString());

		/* lNXg̕\ */
		display.dispNext(table.toStringNext());

		/**********************************************************************/
		/* ړJn															  */
		/**********************************************************************/
		for (downCnt = 0; ; downCnt=(downCnt+1)%DOWN_RATE) {
			/* ubN~^C~O */
			if (0 == downCnt)  {
				/* ubN~ */
				isGrounding = !( table.moveDown(current) );
				/* e[u\ */
				display.disp(table.toString());

				/* ɐݒu */
				if (isGrounding) {
					/* ݒum */
					isSettled = true;
					Debug.println("settle@");
				}
			} else {
				/* ǂݎ(mubLO) */
				retType = player.readOperate();

				/* ~m̑ */
				retOperate = player.doOperate(table, current, retType);

				/* e[u\ */
				display.disp(table.toString());

				/* ɑ삵 */
				if (Player.OP_DOWN == retType) {
					/* ɐݒuĂ */
					if (isGrounding) {
						/* ɐݒuĂꍇAݒum */
						downCnt = DOWN_RATE - 1;
						Debug.println("ݒuɉړ");
					} else {
						/* ړłꍇ */
						if (retOperate) {
							/* ւ̈ړpȂ߂ɁẢړ̃^C~O𒲐 */
							if (isGrounding) System.err.println("ړ̖");
							downCnt = 0;							
						/* ړłȂꍇ */
						} else {
							/* ݒuɂ(ݒũ^C~O~Ɠlɂ) */
							Debug.println("ړsāAn");
							isGrounding = true;
							downCnt = DOWN_RATE - 1;
						 }
					}
				/* Eɑ삵 */
				} else if (Player.OP_RIGHT == retType ||
						Player.OP_LEFT == retType) {
					/* ړłĂAnʂɐݒuĂꍇ */
					if (retOperate && isGrounding) {
					
						/* ݒu̗P\Ԃݒ肷 */
						downCnt = 10;
						System.err.println("idle time!!");
						
						/* ɐݒu */
						/* TODO:isGrounding̎dlǂȂ */
						isGrounding = false;
					}
				/* ]삵 */
				} else if (Player.OP_ROTATE_RIGHT == retType
						|| Player.OP_ROTATE_LEFT == retType) {
					/* ]ł */
					if (retOperate) {
						downCnt = 0;
						if (isGrounding) {
							System.err.println("]̖");
							isGrounding = !isGrounding;
						}
					} else {
						Debug.println("]s");
					}
				/* ȊO͉Ȃ */
				} else {
				}
			}

			/* ݒum肵ꍇ */
			if (isSettled) {
				/* ݒuĂȂԂɂ */
				isSettled = false;
				isGrounding = false;

				/**********************************************************************/
				/* EɂA												  */
				/**********************************************************************/
				/*  */
				retDel = true;
				int rennsa = 0;

				/* 삵ĂubNDROPPED}[Nt */
				table.setDroppedMark(current);

				for (; retDel;) {
					/**********************************************************************/
					/* ĂubNɗƂB									  */
					/* ubNɂDROPPED}[N						  */
					/**********************************************************************/
					table.dropBlock(); /* 
					/* e[u\ */
					display.disp(table.toString());
					Debug.println("del block", table.toString());
					/* 폜OɈꎞ~ */
					try {
						Thread.sleep(1000/4);
					} catch( InterruptedException e) {
					}
					/**********************************************************************/
					/* (DROPPED}[N̂ubNɒT)					  */
					/**********************************************************************/
					retDel = table.deleteAll();
					if (retDel) {
						/* AJEgAbv */
						 rennsa++;
						 
						/* e[u\ */
						display.disp(table.toString());
						Debug.println("del block", table.toString());
						
						/* 폜Ɉꎞ~ */
						try {
							Thread.sleep(1000/3);
						} catch( InterruptedException e) {
						}
					}
				}
				Debug.println("A:" + rennsa);
				System.err.println("A:" + rennsa);


				/**********************************************************************/
				/* Ղo															  */
				/**********************************************************************/
				/* Ղ搶 */
				current = table.initPuyo();

				/* o\ */
				retIsSet = table.isSetPuyo(current, current.getCenterX(), current.getCenterY());
				if (!retIsSet) {
					/* Q[I */
					break;
				}

				/* Ղe[uɐݒ */
				table.setPuyo(current);

				/* e[u\ */
				display.disp(table.toString());
				Debug.println("next block", table.toString());

				/* lNXg̕\ */
				display.dispNext(table.toStringNext());
			}

			/* X[v */
			try {
				Thread.sleep(1000/FPS);
			} catch( InterruptedException e) {
			}
		}

		/**********************************************************************/
		/* I															  */
		/**********************************************************************/
		Debug.println("I!!!");

		/* X[v */
		try {
			Thread.sleep(1000/2);
		} catch( InterruptedException e) {
		}

		/* ăX^[g */
		new Thread(this).start();
	}
	
}
