package com.torn.puyoru.sample.frame;

import static com.torn.puyoru.parts.Type.$;
import static com.torn.puyoru.parts.Type.B;
import static com.torn.puyoru.parts.Type.D;
import static com.torn.puyoru.parts.Type.G;
import static com.torn.puyoru.parts.Type.P;
import static com.torn.puyoru.parts.Type.R;
import static com.torn.puyoru.parts.Type.Y;
import static com.torn.puyoru.parts.Type._;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

import com.torn.puyoru.template.Display;
import com.torn.puyoru.template.Player;

@SuppressWarnings("serial")
class MyGameFrame extends JFrame implements Display {
	private static final int BLOCK_SIZE = 14;
	private static final int PANEL_HEIGHT = 14*21;
	private static final int FRAME_WIDTH = 400;
	private static final int FRAME_HEIGHT = 400;

	/* e[u\ppl */
	private TablePanel panel;

	/* JnbZ[W\pl */
	private JPanel msgPanel;
	/* JnvbZ[W */
	private String msg = "PRESS ENTER TO START";

	/* lNXge[u\ppl */
	private NextPanel nextPanel;


	MyGameFrame() {
		/* t[̐ݒ */
		setTitle("Ղ");
		setVisible(true);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);	/* close operation */

		/* e[u\ppl̐ݒ */
		panel = new TablePanel();

		/* lNXge[u\ppl */
		nextPanel = new NextPanel();
		
		/* bZ[Wo̓pl	*/
		msgPanel = new JPanel() {
			/* CX^Xq */
			{
				setBackground(Color.CYAN);
			}

			/* msg\ */
			public void paint(Graphics g) {
				super.paint(g);
				g.drawString(msg, 50, 20);
			}
		};


		/**************************************************************************/
		/* TCYݒ															  */
		/**************************************************************************/
		/* TODO:TCYݒ̓t[݂̂ƂAׂ͂ăCAEg̐ݒɂs */
		setSize(new Dimension(FRAME_WIDTH , FRAME_HEIGHT));
		panel.setPreferredSize(new Dimension(12*14, PANEL_HEIGHT));
		nextPanel.setPreferredSize(new Dimension(5*14,PANEL_HEIGHT));
		msgPanel.setPreferredSize(new Dimension(100,30)); /* x͂Ȃł */

		/**************************************************************************/
		/* R|[lg̔zu													  */
		/**************************************************************************/
		/* RecyC擾 */
		Container container = this.getContentPane();
		SpringLayout layout = new SpringLayout();
		container.setLayout(layout);

		/* CAEgݒ */
		layout.putConstraint(SpringLayout.NORTH, panel, 10, SpringLayout.NORTH, container);
		layout.putConstraint(SpringLayout.WEST, panel, 10, SpringLayout.WEST, container);

		layout.putConstraint(SpringLayout.NORTH, nextPanel, 10, SpringLayout.NORTH, container);
		layout.putConstraint(SpringLayout.WEST, nextPanel, 10, SpringLayout.EAST, panel);

		layout.putConstraint(SpringLayout.NORTH, msgPanel, 100, SpringLayout.NORTH, panel);
		layout.putConstraint(SpringLayout.WEST, msgPanel, 0, SpringLayout.WEST, panel);
		layout.putConstraint(SpringLayout.EAST, msgPanel, 0, SpringLayout.EAST, nextPanel);

		/* R|[lgǉ */
		container.add(panel);
		container.add(nextPanel);
		container.add(msgPanel);
	}

	/**
	 * e[u̕\
	 * @see com.torn.puyoru.template.Display#disp(java.lang.String)
	 */
	@Override
	public void disp(String strTable) {
		/* NX̃\bhĂяo */
		panel.disp(strTable);
	}


	/**
	 * lNXg̕\
	 * @see com.torn.puyoru.template.Display#dispNext(java.lang.String)
	 */
	@Override
	public void dispNext(String strNextTable) {
		/* NX̃\bhĂяo */
		nextPanel.dispNext(strNextTable);
	}


	/**
	 *  Q[Jn}҂
	 * @see com.torn.puyoru.template.Display#waitStartSign(com.torn.tetoru.sample.frame.MyPlayer)
	 */
	@Override
	public boolean waitStartSign(Player player) {
		boolean ret;

		/* ʂɃL[͂𑣂bZ[W */
		dispStartRequest();

		/* vC[̓͑҂ */
		ret = player.waitStartSign();

		/* bZ[Wsɂ */
		msgPanel.setVisible(false);

		return ret;
	}

	/* ʂɃbZ[W\ */
	private void dispStartRequest() {
		msgPanel.setVisible(true);
		msgPanel.repaint();
	}


	/**************************************************************************/
	/* e[upl(NX)											  */
	/**************************************************************************/
	private class TablePanel extends JPanel {
		/* e[u`p */
		private String strTable =
			  "900000000009\r\n"
			+ "900000000009\r\n"
			+ "900000000009\r\n"
			+ "900003000009\r\n"
			+ "900033300009\r\n";


		TablePanel() {
			/* eݒ */
			setBackground(Color.white);
		}

		/**
		 * e[u̕\
		 * @param strTable
		 */
		public void disp(String strTable) {
			if ("" == strTable) {
				return;
			}
			
			this.strTable = strTable;
			panel.repaint();
		}

		/**
		 * strTable͂ĕ`
		 */
		public void paint(Graphics g) {
			super.paint(g);
			
			/* 1sɕ */
			String[] lines = strTable.split(System.getProperty("line.separator"));
			
			/* 1sɕ` */
			int y = 0;
			for (String line : lines) {
				for (int idx = 0, x = 0; idx < line.length(); idx++, x += BLOCK_SIZE) {
					/* PubN̎ނ擾 */
					char c = line.charAt(idx);
					int type = Integer.parseInt(Character.toString(c));
					/* ubN̎ޖɐFݒ */
					/* TODO:switcho */
					switch (type) {
					case _ :
						g.setColor(Color.WHITE);
						break;
					case $ :
						g.setColor(Color.GRAY);
						break;
					case B :
						g.setColor(Color.BLUE);
						break;
					case Y :
						g.setColor(Color.YELLOW);
						break;
					case G :
						g.setColor(Color.GREEN);
						break;
					case R :
						g.setColor(Color.RED);
						break;
					case P :
						g.setColor(Color.PINK);
						break;
					case D : /* Ώۂ̃ubN */
						g.setColor(Color.PINK.darker());
						break;
					default :
						g.setColor(Color.LIGHT_GRAY);
						break;
					}
					/* ubN` */
					g.fillRect(x + 1, y + 1, BLOCK_SIZE - 1, BLOCK_SIZE - 1);
				}
				y += BLOCK_SIZE;
			}

			/* bZ[WőOʂɕ\ */
			msgPanel.repaint();
		}

	}


	/**************************************************************************/
	/* lNXgpl(NX)											  */
	/**************************************************************************/
	private class NextPanel extends JPanel {
		/* lNXge[u\p */
		private String strNextTable = "";

		NextPanel() {
			/* eݒ */
			setBackground(Color.white);
		}

		/**
		 * lNXg̕\
		 * @param strNextTable
		 */
		public void dispNext(String strNextTable) {
			if ("" == strNextTable) {
				return;
			}
			this.strNextTable = strNextTable;
			repaint();
		}

		/**
		 * strNextTable͂ĕ`
		 */
		public void paint(Graphics g) {
			super.paint(g);

			/* 1sɕ */
			String[] lines = strNextTable.split(System.getProperty("line.separator"));

			/* 1sɕ` */
			int y = 0;
			for (String line : lines) {
				for (int idx = 0, x = 0; idx < line.length(); idx++, x += BLOCK_SIZE) {
					/* PubN̎ނ擾 */
					char c = line.charAt(idx);
					int type = Integer.parseInt(Character.toString(c));
					/* ubN̎ޖɐFݒ */
					/* TODO:switchoŁBcolore[u */
					switch (type) {
					case _ :
						g.setColor(Color.WHITE);
						break;
					case $ :
						g.setColor(Color.GRAY);
						break;
					case B :
						g.setColor(Color.BLUE);
						break;
					case Y :
						g.setColor(Color.YELLOW);
						break;
					case G :
						g.setColor(Color.GREEN);
						break;
					case R :
						g.setColor(Color.RED);
						break;
					case P :
						g.setColor(Color.PINK);
						break;
					default :
						g.setColor(Color.LIGHT_GRAY);
						break;
					}
					/* ubN` */
					g.fillRect(x + 1, y + 1, BLOCK_SIZE - 1, BLOCK_SIZE - 1);
				}
				y += BLOCK_SIZE;
			}
		}
	}


}