package com.torn.puyoru.parts;


/* SBlockA_̏ */
public class Puyo implements Cloneable {

	/* ]̌ */
	public static final int R_NO = 0;
	public static final int R_RIGHT = 1;
	public static final int R_LEFT = -1;

	private static final int INFO_NUM = 1; /* 2 - 1 */

	/* SȊO */
	private int[][] info;	/* ʒu */

	/* eubN */
	private Block[] blocks;

	/* ]̏ */
	private int state; 

	private static final int CENTER = 0;


	/* TODO:NextTypeˑ(Next̓\mĂKv) */
	Puyo(NextType next, int x, int y) {
		blocks = new Block[INFO_NUM + 1];
		
		/* S̐ݒ */
		blocks[CENTER] = new Block(next.type1, x, y);
		
		/* SȊÖʒu */
		info = new int[INFO_NUM][2];
		info[0] = new int[]{0, -1};

		/* ނƈʒu̐ݒ */
		for (int i = 0; i < INFO_NUM; i++) {
			blocks[1 + i] = new Block(next.type2, x + info[i][0], y + info[i][1]);
		}
	}

	public int getCenterX() {
		return blocks[CENTER].getX();
	}
	public int getCenterY() {
		return blocks[CENTER].getY();
	}


	/**
	 * SȊÖʒu̎擾
	 * @return
	 */
	int[][] getInfo() {
		return info;
	}

	/**
	 * S̐ݒ
	 * @param x
	 * @param y
	 */
	void setBlock(int x, int y) {
		blocks[CENTER].setX(x);
		blocks[CENTER].setY(y);
		
		/* Sɍ킹āÃubNݒ */
		for (int i = 0; (1 + i) < blocks.length && i < INFO_NUM; i++) {
			blocks[1 + i].setX(x + info[i][0]);
			blocks[1 + i].setY(y + info[i][1]);
		}
	}

	/**
	 * ׂẴvbN擾
	 * @return
	 */
	Block[] get() {
		return blocks;
	}

	/**************************************************************************/
	/* ]															  */
	/**************************************************************************/
	/* N[̐ */
	public Puyo clone() {
		try {
			Puyo cloned = (Puyo) super.clone();

			/* intźAmɃRs[ */
			cloned.info = new int[INFO_NUM][2];
			for (int cnt = 0; cnt < info.length; cnt++) {
				cloned.info[cnt][0] = info[cnt][0];
				cloned.info[cnt][1] = info[cnt][1];
			}
			
			/* Block[]̃Rs[ */
			cloned.blocks = new Block[INFO_NUM + 1];
			Block[] base = this.get();
			for (int cnt = 0; cnt < blocks.length; cnt++) {
				cloned.blocks[cnt] = base[cnt];
			}

			return cloned;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	/**
	 * ʒủ]
	 * IvbNɂĂ͒Sړ
	 * @param dr
	 * @return
	 */
	boolean rotateInfo(int dr) {
		/* `FbN */
		if (R_RIGHT != dr && R_LEFT != dr) {
			return false;
		}

		/* 3_̉] */
		for (int cnt = 0; cnt < INFO_NUM; cnt++) {
			int x = info[cnt][0];
			int y = info[cnt][1];

			if (R_RIGHT == dr) {	/* Panelł̌ڂ͍] */
				info[cnt][0] = -y;
				info[cnt][1] = x;
			} else { /* R_LEFT == dr */
				info[cnt][0] = y;
				info[cnt][1] = -x;
			}
		}

		/* Ԃς */
		if (R_RIGHT == dr) {
			state = (state + 1) % 4;
		} else {
			state = (state - 1 + 4) % 4;
		}

		return true;
	}

	/**
	 * ]ɕύXXV
	 * @param update
	 */
	void updateRotate(Puyo update) {
		int x = update.blocks[CENTER].getX();
		int y = update.blocks[CENTER].getY();

		setBlock(x, y);
		this.info = update.info;
		this.state = update.state;
	}
}
