#! /usr/local/bin/ruby -Ks
# testcase2csv
# testcase -> csv converter
# 
# 2007/11/26 0.00 garyo R}hCŁ@VK쐬

require 'rexml/document'
require 'kconv'
require 'csv'

class Testsuite

  def initialize
  end

  def readXMLFile(f)
    file = File.new f
    @doc = REXML::Document.new file
  end

  def checkElem(elem,indent)
    puts "  "*indent + "#{elem.name}"
    elem.each_element{|e|
       checkElem(e,indent+1)
    }
  end

  def viewElem
    checkElem(doc.root,0)
  end

  def xmltestsuite2csv(elem)
    ret = ""
    elem.each_element{|e|
      if e.name == "testcase" then
        r = e.attributes["name"]
        r += "," + e.elements["summary"].text
        r += "," + e.elements["steps"].text
        r += "," + e.elements["expectedresults"].text
        if e.elements["keywords"] then
          e.elements["keywords"].each_element{|ky|
            r += "," + ky.attributes["name"]
            r += "," + ky.elements["notes"].text
          }
        end
        r.gsub!(/\n/,"")
        ret += r + "\n"
      end
    }
    ret.tosjis
  end

  def xmltestsuite2array(elem)
    ret = []
    elem.each_element{|e|
      if e.name == "testcase" then
        r =[]
        r << e.attributes["name"]
        r << e.elements["summary"].text
        r << e.elements["steps"].text
        r << e.elements["expectedresults"].text
        if e.elements["keywords"] then
          e.elements["keywords"].each_element{|ky|
            r << ky.attributes["name"]
            r << ky.elements["notes"].text
          }
        end
        r.map!{|x| x.gsub!(/\n/,"");x.tosjis}
        ret << r
      end
    }
    ret
  end

  def getXmltestsuiteName(elem)
    if elem.name=="testsuite" then
      elem.attributes["name"].to_s.tosjis
    else
      nil
    end
  end

  def testsuite2csv(elem)
    file = getXmltestsuiteName(elem)
    if file then
      r = xmltestsuite2array(elem)
      if r.size > 0 then
        file.gsub!(/[\s|\\|\/|\:|\*|\?|\"|\<|\>|\|]/,"")
        wrfile = File.dirname(file) + "/" + File.basename(file, ".*") + ".csv"
        CSV.open(wrfile,"w"){|f|
          r.each{|x|f << x}
        }
      end
      elem.each_element{|e|
        testsuite2csv(e)
      }
    end
  end

  def main
    testsuite2csv(@doc.root)
  end
end

if ARGV.size == 1 then
  ts=Testsuite.new
  ts.readXMLFile(ARGV[0])
  ts.main
else
  puts "Usage testcase2csv testcase.xml"
end
