/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload.AbstractFileDownloadView} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * oCit@C_E[hۂɗpViewۃNXB<br>
 * OFmodelAHTTPNGXgAHTTPX|XNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload.AbstractFileDownloadView
 */
public class AbstractFileDownloadViewTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractFileDownloadViewTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public AbstractFileDownloadViewTest(String name) {
        super(name);
    }

    /**
     * testRenderMergedOutputModel01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getInputStream():NullԂp^[B<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IOException<br>
     *                    iFileDownload Failed. InputStream is null.j<br>
     *         (ԕω) O:OxFG[<br>
     *                    FileDownload Failed. InputStream is null.<br>
     *         
     * <br>
     * TuNXŒ`̓Xg[擾\bhNullԂp^[B
     * IOO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel01() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        MockHttpServletResponse response = 
            new MockHttpServletResponse();
        Map<String, String> model = new HashMap<String, String>();

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (IOException e) {
            // OK
            String expect = "FileDownload Failed. InputStream is null.";
            assertEquals(expect, e.getMessage());
            assertTrue(LogUTUtil.checkError(expect));
        }

        // 
        assertFalse(view.isAddResponseHeader);
    }

    /**
     * testRenderMergedOutputModel02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getInputStream():IOOp^[B<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IOException<br>
     *         (ԕω) O:OxFG[FileDownload Failed.<br>
     *         
     * <br>
     * TuNXŒ`̓Xg[擾\bhIOO𓊂p^[B
     * Oo͂AÔ܂ܓB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel02() throws Exception {
        // O
        AbstractFileDownloadViewStub02 view = 
            new AbstractFileDownloadViewStub02();
        MockHttpServletResponse response = 
            new MockHttpServletResponse();
        Map<String, String> model = new HashMap<String, String>();

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (IOException e) {
            // OK
            assertTrue(LogUTUtil.checkError("FileDownload Failed.", e));
        }

        // 
        assertFalse(view.isAddResponseHeader);
    }

    /**
     * testRenderMergedOutputModel03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getInputStream():ɓ̓Xg[Ԃp^[B<br>
     *         
     * <br>
     * ҒlF(ԕω) inputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         (ԕω) O:IOException<br>
     *         (ԕω) O:OxFG[FileDownload Failed.<br>
     *         
     * <br>
     * o̓Xg[ɗOB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel03() throws Exception {
        // O
        AbstractFileDownloadViewStub03 view = 
            new AbstractFileDownloadViewStub03();
        AbstractFileDownloadView_ByteArrayInputStreamStub01 in = 
            new AbstractFileDownloadView_ByteArrayInputStreamStub01(
                    "test".getBytes());
        view.setInputStream(in);
        AbstractFileDownloadView_MockHttpServletResponseStub01 response = 
            new AbstractFileDownloadView_MockHttpServletResponseStub01();
        Map<String, String> model = new HashMap<String, String>();

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (IOException e) {
            // OK
            assertTrue(LogUTUtil.checkError("FileDownload Failed.", e));
        }

        // 
        assertTrue(in.isClose);
    }

    /**
     * testRenderMergedOutputModel04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () addResponseHeader():ɏsȂp^[B<br>
     *         () getInputStream():ɓ̓Xg[Ԃp^[B<br>
     *         () writeResponseStreamij:IOOԂp^[B<br>
     *         
     * <br>
     * ҒlF(ԕω) addResponseHeader():
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         (ԕω) inputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         (ԕω) outputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         (ԕω) O:IOException<br>
     *         (ԕω) O:OxFG[FileDownload Failed.<br>
     *         
     * <br>
     * ݃\bhwriteResponseStreamIOOp^[̃eXgB
     * Oo͂AÔ܂ܓB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel04() throws Exception {
        // O
        AbstractFileDownloadViewStub04 view = 
            new AbstractFileDownloadViewStub04();
        AbstractFileDownloadView_ByteArrayInputStreamStub01 in = 
            new AbstractFileDownloadView_ByteArrayInputStreamStub01(
                    "test".getBytes());
        view.setInputStream(in);
        MockHttpServletResponse response =  new MockHttpServletResponse();
        AbstractFileDownloadView_ServletOutputStreamStub01 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub01();
        response.setOutputStream(out);
        Map<String, String> model = new HashMap<String, String>();

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (IOException e) {
            // OK
            assertTrue(LogUTUtil.checkError("FileDownload Failed.", e));
        }

        // 
        assertTrue(view.isAddResponseHeader);
        assertTrue(in.isClose);
        assertTrue(out.isClose);
    }

    /**
     * testRenderMergedOutputModel05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () addResponseHeader():
     *         ɏsȂp^[B<br>
     *         () getInputStream():ɓ̓Xg[Ԃp^[B<br>
     *         () writeResponseStreamij:ɏ݂s<br>
     *         
     * <br>
     * ҒlF(ԕω) addResponseHeader():
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         (ԕω) inputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         (ԕω) outputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         (ԕω) O:IOException<br>
     *         (ԕω) O:OxFG[FileDownload Failed.<br>
     *         
     * <br>
     * o̓Xg[̃tbVɎsꍇ̃eXgB
     * tbVɓꂽÔ܂܃X[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel05() throws Exception {
        // O
        AbstractFileDownloadViewStub03 view = 
            new AbstractFileDownloadViewStub03();
        AbstractFileDownloadView_ByteArrayInputStreamStub01 in = 
            new AbstractFileDownloadView_ByteArrayInputStreamStub01(
                    "test".getBytes());
        view.setInputStream(in);
        MockHttpServletResponse response =  new MockHttpServletResponse();
        AbstractFileDownloadView_ServletOutputStreamStub02 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub02();
        response.setOutputStream(out);
        Map<String, String> model = new HashMap<String, String>();

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (IOException e) {
            // OK
            assertTrue(LogUTUtil.checkError("FileDownload Failed.", e));
        }

        // 
        assertTrue(view.isAddResponseHeader);
        assertTrue(in.isClose);
        assertTrue(out.isClose);
    }

    /**
     * testRenderMergedOutputModel06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () addResponseHeader():ɏsȂp^[B<br>
     *         () getInputStream():ɓ̓Xg[Ԃp^[B<br>
     *         () writeResponseStreamij:ɏ݂s<br>
     *         
     * <br>
     * ҒlF(ԕω) response:̓Xg[̃f[^܂B<br>
     *         (ԕω) addResponseHeader():
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         (ԕω) inputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         (ԕω) outputStream.close():
     *         \bhĂяoꂽƂmFB<br>
     *         
     * <br>
     * ɏ݂A
     * ̓Xg[Eo̓Xg[N[YeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel06() throws Exception {
        // O
        AbstractFileDownloadViewStub03 view = 
            new AbstractFileDownloadViewStub03();
        byte[] bytearray = "test".getBytes();
        AbstractFileDownloadView_ByteArrayInputStreamStub01 in = 
            new AbstractFileDownloadView_ByteArrayInputStreamStub01(
                    bytearray);
        view.setInputStream(in);
        MockHttpServletResponse response =  new MockHttpServletResponse();
        AbstractFileDownloadView_ServletOutputStreamStub01 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub01();
        response.setOutputStream(out);
        Map<String, String> model = new HashMap<String, String>();

        // eXg{
        view.renderMergedOutputModel(model, null, response);
        
        // 
        for (int i=0;i<bytearray.length;i++) {
            // bytez̒lmF
            assertEquals(bytearray[i], out.responseData[i]);
        }
        assertTrue(view.isAddResponseHeader);
        assertTrue(in.isClose);
        assertTrue(out.isClose);
    }

    /**
     * testWriteResponseStream01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() inputStream:null<br>
     *         () outputStream:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) outputStream:ωȂ<br>
     *         
     * <br>
     * ̓Xg[Null̏ꍇ̃eXgB<br>
     * IB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteResponseStream01() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        AbstractFileDownloadView_ServletOutputStreamStub03 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub03();
        
        // eXg{
        view.writeResponseStream(null, out);
        
        // 
        assertFalse(out.isWrite);
    }

    /**
     * testWriteResponseStream02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() inputStream:not null<br>
     *         () outputStream:null<br>
     *         
     * <br>
     * ҒlF(ԕω) outputStream:ωȂ<br>
     *         
     * <br>
     * o̓Xg[Null̏ꍇ̃eXgB<br>
     * IB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteResponseStream02() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        AbstractFileDownloadView_ByteArrayInputStreamStub01 in = 
            new AbstractFileDownloadView_ByteArrayInputStreamStub01(
                    "test".getBytes());
        
        // eXg{
        view.writeResponseStream(in, null);
        
        // 
        assertFalse(in.isRead);
    }

    /**
     * testWriteResponseStream03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() inputStream:not null<br>
     *                t@CTCYFOoCg<br>
     *         () outputStream:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) outputStream:ωȂ<br>
     *         
     * <br>
     * ̓Xg[̃t@CTCYȌꍇ̃eXgBIB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteResponseStream03() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        byte[] byteData = new byte[0]; 
        InputStream in = new ByteArrayInputStream(byteData);
        AbstractFileDownloadView_ServletOutputStreamStub04 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub04();
        
        // eXg{
        view.writeResponseStream(in, out);
        
        // 
        assertEquals(0, out.count);
    }

    /**
     * testWriteResponseStream04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,B,D
     * <br><br>
     * ͒lF() inputStream:not null<br>
     *                t@CTCYFQTUoCg<br>
     *         () outputStream:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) outputStream:o̓Xg[
     * ̓Xg[̃f[^<br>
     *         
     * <br>
     * ̓Xg[̃t@CTCYQTȔꍇ̃eXgB
     * `NTCYQTUoCgƓoCg̃t@Cރp^[B
     * ݂̃[vPsȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteResponseStream04() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        byte[] byteData = new byte[256]; 
        for (int i=0;i<256;i++) {
            byteData[i] = 1;
        }
        InputStream in = new ByteArrayInputStream(byteData);
        AbstractFileDownloadView_ServletOutputStreamStub04 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub04();
        
        // eXg{
        view.writeResponseStream(in, out);
        
        // 
        assertEquals(1, out.count);
    }

    /**
     * testWriteResponseStream05()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA,B,D
     * <br><br>
     * ͒lF() inputStream:not null<br>
     *                t@CTCYFQTVoCg<br>
     *         () outputStream:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) outputStream:o̓Xg[
     * ̓Xg[̃f[^<br>
     *         
     * <br>
     * ̓Xg[̃t@CTCYQTV̏ꍇ̃eXgB
     * `NTCYQTUoCg傫t@Cރp^[B
     * ݂̃[vQsȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteResponseStream05() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        byte[] byteData = new byte[257]; 
        for (int i=0;i<257;i++) {
            byteData[i] = 1;
        }
        InputStream in = new ByteArrayInputStream(byteData);
        AbstractFileDownloadView_ServletOutputStreamStub04 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub04();
        
        // eXg{
        view.writeResponseStream(in, out);
        
        // 
        assertEquals(2, out.count);
    }

    /**
     * testWriteResponseStream06()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA,B,D
     * <br><br>
     * ͒lF() inputStream:not null<br>
     *                t@CTCYFVOOoCg<br>
     *         () outputStream:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) outputStream:o̓Xg[
     * ̓Xg[̃f[^<br>
     *         
     * <br>
     * ̓Xg[̃t@CTCYVOȌꍇ̃eXgB
     * `NTCYQTUoCg傫t@Cރp^[B
     * ݂̃[vRsȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testWriteResponseStream06() throws Exception {
        // O
        AbstractFileDownloadViewStub01 view = 
            new AbstractFileDownloadViewStub01();
        byte[] byteData = new byte[700]; 
        for (int i=0;i<700;i++) {
            byteData[i] = 1;
        }
        InputStream in = new ByteArrayInputStream(byteData);
        AbstractFileDownloadView_ServletOutputStreamStub04 out = 
            new AbstractFileDownloadView_ServletOutputStreamStub04();
        
        // eXg{
        view.writeResponseStream(in, out);
        
        // 
        assertEquals(3, out.count);
    }

}
