/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.CastorView} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Castor𗘗pHTTPX|XsNXB<br>
 * OFmodelAHTTPNGXgAHTTPX|XAoxmapperNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.
 * CastorView
 */
public class CastorViewTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CastorViewTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public CastorViewTest(String name) {
        super(name);
    }
    
    /**
     * testRenderMergedOutputModel01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () this.getContentType():null<br>
     *         () response.getWriter():o̓Xg[ԂB<br>
     *         () responseWriter.close():ɃN[YB<br>
     *         
     * <br>
     * ҒlF(ԕω) response:oxmapper.marshal()̌ʂ܂B
     * Rec^Cvݒ肳ȂB<br>
     *         (ԕω) oxmapper.marshalij:ĂяoꂽƂmFB<br>
     *         (ԕω) response.getWriter():ĂяoꂽƂmFB<br>
     *         (ԕω) responseWriter.write():ĂяoꂽƂmFB<br>
     *         (ԕω) responseWriter.close():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * IuWFNgf[^XMLɕϊAHTTPX|Xɐݒ肷eXgB
     * Rec^CvHTTPX|Xɏ܂Ȃp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel01() throws Exception {
        // O
    	CastorViewStub01 view = new CastorViewStub01();
        UTUtil.setPrivateField(view, "contentType", null);
        CastorView_OXMapperImplStub01 oxmapper = 
            new CastorView_OXMapperImplStub01();
        UTUtil.setPrivateField(view, "oxmapper", oxmapper);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        CastorView_MockHttpServletResponseStub02 response = 
            new CastorView_MockHttpServletResponseStub02();
        CastorView_PrintWriterStub01 printWriter = 
            new CastorView_PrintWriterStub01(System.out);
        response.setWriter(printWriter);
        Map<String, String> model = new HashMap<String, String>();
        model.put(Constants.RESULT_KEY, "test");

        // eXg{
        view.renderMergedOutputModel(model, request, response);

        // 
        assertTrue(oxmapper.isMarshal);
        Object resultContentType = 
            UTUtil.getPrivateField(response, "contentType");
        assertEquals(null, resultContentType);
        assertTrue(response.isGetWriter);
        assertTrue(printWriter.isWrite);
        assertTrue(printWriter.isClose);
        
        // addHeader()̌ĂяomF
        assertEquals(model, view.modelData);
        assertEquals(request, view.requestData);
        assertEquals(response, view.responseData);
    }

    /**
     * testRenderMergedOutputModel02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () this.getContentType():not null<br>
     *         () response.getWriter():o̓Xg[ԂB<br>
     *         () responseWriter.close():ɃN[YB<br>
     *         
     * <br>
     * ҒlF(ԕω) response:oxmapper.marshal()̌ʂ܂B
     * Rec^Cvݒ肳B<br>
     *         (ԕω) oxmapper.marshalij:ĂяoꂽƂmFB<br>
     *         (ԕω) response.getWriter():ĂяoꂽƂmFB<br>
     *         (ԕω) responseWriter.write():ĂяoꂽƂmFB<br>
     *         (ԕω) responseWriter.close():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * IuWFNgf[^XMLɕϊAHTTPX|Xɐݒ肷eXgB
     * Rec^CvHTTPX|Xɏރp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel02() throws Exception {
        // O
    	CastorViewStub01 view = new CastorViewStub01();
        String contentType = "text/xml;charset=UTF-8";
        UTUtil.setPrivateField(view, "contentType", contentType);
        CastorView_OXMapperImplStub01 oxmapper = 
            new CastorView_OXMapperImplStub01();
        UTUtil.setPrivateField(view, "oxmapper", oxmapper);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        CastorView_MockHttpServletResponseStub02 response = 
            new CastorView_MockHttpServletResponseStub02();
        CastorView_PrintWriterStub01 printWriter = 
            new CastorView_PrintWriterStub01(System.out);
        response.setWriter(printWriter);
        Map<String, String> model = new HashMap<String, String>();
        model.put(Constants.RESULT_KEY, "test");

        // eXg{
        view.renderMergedOutputModel(model, request, response);

        // 
        assertTrue(oxmapper.isMarshal);
        Object resultContentType = 
            UTUtil.getPrivateField(response, "contentType");
        assertEquals(contentType, resultContentType);
        assertTrue(response.isGetWriter);
        assertTrue(printWriter.isWrite);
        assertTrue(printWriter.isClose);
        
        // addHeader()̌ĂяomF
        assertEquals(model, view.modelData);
        assertEquals(request, view.requestData);
        assertEquals(response, view.responseData);
    }

    /**
     * testRenderMergedOutputModel03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () this.getContentType():not null<br>
     *         () response.getWriter():IOOԂB<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IOException<br>
     *         (ԕω) O:Cannot get Response Writer object.<br>
     *         
     * <br>
     * o̓Xg[擾IOOp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel03() throws Exception {
        // O
        CastorView view = new CastorView();
        String contentType = "text/xml;charset=UTF-8";
        UTUtil.setPrivateField(view, "contentType", contentType);
        CastorView_OXMapperImplStub01 oxmapper = 
            new CastorView_OXMapperImplStub01();
        UTUtil.setPrivateField(view, "oxmapper", oxmapper);
        MockHttpServletResponse response = 
            new CastorView_MockHttpServletResponseStub01();
        response.setWriter(new PrintWriter(System.out));
        Map<String, String> model = new HashMap<String, String>();
        model.put(Constants.RESULT_KEY, "test");

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (IOException e) {
            // ʊmF
            assertTrue(LogUTUtil.checkError(
                    "Cannot get Response Writer object."));
        }
    }

    /**
     * testRenderMergedOutputModel04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() model:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () this.getContentType():not null<br>
     *         () response.getWriter():NullԂB<br>
     *         
     * <br>
     * ҒlF(ԕω) oxmapper.marshalij:ĂяoꂽƂmFB<br>
     *         (ԕω) O:NullPointerException<br>
     *         
     * <br>
     * o̓Xg[Null̏ꍇAclose\bhĂ΂ȂƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRenderMergedOutputModel04() throws Exception {
        // O
        CastorView view = new CastorView();
        String contentType = "text/xml;charset=UTF-8";
        UTUtil.setPrivateField(view, "contentType", contentType);
        CastorView_OXMapperImplStub01 oxmapper = 
            new CastorView_OXMapperImplStub01();
        UTUtil.setPrivateField(view, "oxmapper", oxmapper);
        CastorView_MockHttpServletResponseStub02 response = 
            new CastorView_MockHttpServletResponseStub02();
        response.setWriter(null);
        Map<String, String> model = new HashMap<String, String>();
        model.put(Constants.RESULT_KEY, "test");

        // eXg{
        try {
            view.renderMergedOutputModel(model, null, response);
            fail();
        } catch (NullPointerException e) {
            // OK
        	return;
        }

        // 
        assertTrue(oxmapper.isMarshal);
        Object resultContentType = 
            UTUtil.getPrivateField(response, "contentType");
        assertEquals("text/xml;charset=UTF-8", resultContentType);
        assertTrue(response.isGetWriter);
    }
    
    /**
     * testGetOxmapper01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.oxmapper:not null<br>
     *         
     * <br>
     * ҒlF(߂l) OXMapper:this.oxmapper<br>
     *         
     * <br>
     * oxmappergetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetOxmapper01() throws Exception {
        // O
        CastorView view = new CastorView();
        OXMapper oxmapper = new CastorView_OXMapperImplStub01();
        UTUtil.setPrivateField(view, "oxmapper", oxmapper);

        // eXg{
        Object result = view.getOxmapper();

        // 
        assertSame(oxmapper, result);
    }

    /**
     * testSetOxmapper01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() oxmapper:not null<br>
     *         () this.oxmapper:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.oxmapper:Őݒ肵l<br>
     *         
     * <br>
     * oxmappersetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetOxmapper01() throws Exception {
        // O
        CastorView view = new CastorView();
        UTUtil.setPrivateField(view, "oxmapper", null);

        // eXg{
        OXMapper oxmapper = new CastorView_OXMapperImplStub01();
        view.setOxmapper(oxmapper);

        // 
        Object result = UTUtil.getPrivateField(view, "oxmapper");
        assertSame(oxmapper, result);
    }
}
