/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.web.servlet.ModelAndView;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ExceptionResolveDelegator̃ftHgNXB<br>
 * OF<br>
 * initMappingNẌmappingKeynullɂȂ邱Ƃ͂ȂB<br>
 * setHeader\bḧresponsenullɂȂ邱Ƃ͂ȂB<br>
 * addObjectToModel\bḧmvnullɂȂ邱Ƃ͂ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl
 */
public class ExceptionResolveDelegatorImplTest extends TestCase {

    /**
     * initMapping\bhmappingKeyiŒj
     */
    private static final String MAPPING_KEY = "mkey";
    
    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ExceptionResolveDelegatorImplTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ExceptionResolveDelegatorImplTest(String name) {
        super(name);
    }

    /**
     * testInitMapping01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:null<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value is null. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:G[xFG[<br>
     *                    linkedExceptionMappings[mkey] value is null. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:null<br>
     *         (ԕω) errorType:null<br>
     *         (ԕω) errorCode:null<br>
     *         
     * <br>
     * mappingValuesnull̏ꍇ̃eXgB<br>
     * OX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping01() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = null;

        // eXg{
        try{
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {
            // 
            String message = "linkedExceptionMappings[" + MAPPING_KEY
                                                     + "] value is null. "
                                                     + "Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }        
        
        

    }

    /**
     * testInitMapping02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,E,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:java.util.Date^̃CX^X<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value is not String type. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:G[xFG[<br>
     *                    linkedExceptionMappings[mkey] value is not String type. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:null<br>
     *         (ԕω) errorType:null<br>
     *         (ԕω) errorCode:null<br>
     *         
     * <br>
     * mappingValuesString^łȂꍇ̃eXgB<br>
     * OX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping02() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        Date mappingValues = new Date();

        // eXg{
        try {
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "linkedExceptionMappings[mkey] value is not String type. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testInitMapping03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,B,C,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:""<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value is insufficient. Two values are necessary. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:G[xFG[<br>
     *                    linkedExceptionMappings[mkey] value is insufficient. Two values are necessary. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:null<br>
     *         (ԕω) errorType:null<br>
     *         (ԕω) errorCode:null<br>
     *         
     * <br>
     * mappingValues󕶎̏ꍇ̃eXgB<br>
     * OX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping03() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = "";

        // eXg{
        try {
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "linkedExceptionMappings[mkey] value is insufficient. Two values are necessary. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testInitMapping04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,B,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc"<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value is insufficient. Two values are necessary. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:G[xFG[<br>
     *                    linkedExceptionMappings[mkey] value is insufficient. Two values are necessary. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:null<br>
     *         (ԕω) errorType:null<br>
     *         (ԕω) errorCode:null<br>
     *         
     * <br>
     * mappingValuesJ}ŕl1Ȃꍇ̃eXgB<br>
     * OX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping04() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = "abc";

        // eXg{
        try {
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "linkedExceptionMappings[mkey] value is insufficient. Two values are necessary. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testInitMapping05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,B
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def"<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:null<br>
     *         
     * <br>
     * mappingValuesJ}ŕl2ꍇ̃eXgB<br>
     * Ɉ̒lɃ}bsOB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping05() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = "abc,def";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));

    }

    /**
     * testInitMapping06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,B
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc , def,ghi"<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:"ghi"<br>
     *         
     * <br>
     * mappingValuesJ}ŕl3ꍇ̃eXgB<br>
     * Ɉ̒lɃ}bsOBG[R[hݒ肳B<br>
     * J}ŕl̑Oɋ󔒂ꍇA폜B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping06() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = "abc , def,ghi";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));
        assertEquals("ghi", UTUtil.getPrivateField(exceptionResolveDelegator, "errorCode"));
    }

    /**
     * testInitMapping07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:",def,ghi"<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value[0] is empty. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    linkedExceptionMappings[mkey] value[0] is empty. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:null<br>
     *         (ԕω) errorType:null<br>
     *         (ԕω) errorCode:null<br>
     *         
     * <br>
     * mappingValuesJ}ŕ1ڂ̒lɋ󕶎ݒ肳Ăꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping07() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = ",def,ghi";

        // eXg{
        try {
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "linkedExceptionMappings[mkey] value[0] is empty. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testInitMapping08()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc, ,ghi"<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value[1] is empty. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    linkedExceptionMappings[mkey] value[1] is empty. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:"ghi"<br>
     *         
     * <br>
     * mappingValuesJ}ŕ2ڂ̒lɋ󕶎iXy[X̒ljݒ肳Ăꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping08() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = "abc, ,ghi";

        // eXg{
        try {
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "linkedExceptionMappings[mkey] value[1] is empty. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testInitMapping09()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def,"<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      message= "linkedExceptionMappings[mkey] value[2] is empty. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    linkedExceptionMappings[mkey] value[2] is empty. Check Spring Bean definition file.<br>
     *         (ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:"ghi"<br>
     *         
     * <br>
     * mappingValuesJ}ŕ3ڂ̒lɋ󕶎ݒ肳Ăꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping09() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();

        // 
        String mappingValues = "abc,def,";

        // eXg{
        try {
            exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, null);
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "linkedExceptionMappings[mkey] value[2] is empty. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testInitMapping10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,B
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def"<br>
     *         () params:null<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         () errorTypeHeaderName:ftHgl("exception")<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:null<br>
     *         (ԕω) errorTypeHeaderName:"exception"<br>
     *         
     * <br>
     * paramsnullꍇ̃eXgB<br>
     * errorTypeHeaderName̓ftHgl"exception"ł邱ƊmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping10() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        Map<String,String> params = null;

        // 
        String mappingValues = "abc,def";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, params);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));
        assertEquals("exception", UTUtil.getPrivateField(exceptionResolveDelegator, "errorTypeHeaderName"));

    }

    /**
     * testInitMapping11()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,B
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def"<br>
     *         () params:{"key","value"}<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         () errorTypeHeaderName:ftHgl("exception")<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:null<br>
     *         (ԕω) errorTypeHeaderName:"exceptionName"<br>
     *         
     * <br>
     * paramsɃL["errorTypeHeaderName"݂Ȃꍇ̃eXgB<br>
     * errorTypeHeaderName̓ftHgl"exception"ł邱ƊmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping11() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        Map<String,String> params = new HashMap<String,String>();
        params.put("key","value");

        // 
        String mappingValues = "abc,def";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, params);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));
        assertEquals("exception", UTUtil.getPrivateField(exceptionResolveDelegator, "errorTypeHeaderName"));

    }
    

    /**
     * testInitMapping12()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def"<br>
     *         () params:{"errorTypeHeaderName",null}<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         () errorTypeHeaderName:ftHgl("exception")<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:null<br>
     *         (ԕω) errorTypeHeaderName:"exception"<br>
     *         
     * <br>
     * paramsɃL["errorTypeHeaderName"݂,̒lnullꍇ̃eXgB<br>
     * errorTypeHeaderName̓ftHgl"exception"ł邱ƊmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping12() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        Map<String,String> params = new HashMap<String,String>();
        params.put("errorTypeHeaderName", null);

        // 
        String mappingValues = "abc,def";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, params);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));
        assertEquals("exception", UTUtil.getPrivateField(exceptionResolveDelegator, "errorTypeHeaderName"));

    }
    
    /**
     * testInitMapping13()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def"<br>
     *         () params:{"errorTypeHeaderName",""}<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         () errorTypeHeaderName:ftHgl("exception")<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:null<br>
     *         (ԕω) errorTypeHeaderName:"exception"<br>
     *         
     * <br>
     * paramsɃL["errorTypeHeaderName"݂,̒l󕶎ꍇ̃eXgB<br>
     * errorTypeHeaderName̓ftHgl"exception"ł邱ƊmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping13() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        Map<String,String> params = new HashMap<String,String>();
        params.put("errorTypeHeaderName", "");

        // 
        String mappingValues = "abc,def";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, params);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));
        assertEquals("exception", UTUtil.getPrivateField(exceptionResolveDelegator, "errorTypeHeaderName"));

    }
    
    /**
     * testInitMapping14()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,B
     * <br><br>
     * ͒lF() mappingKey:"mkey"<br>
     *         () mappingValues:"abc,def"<br>
     *         () params:{"errorTypeHeaderName","exceptionName"}<br>
     *         () mappingKey:null<br>
     *         () mappingValues:null<br>
     *         () viewName:null<br>
     *         () errorType:null<br>
     *         () errorCode:null<br>
     *         () errorTypeHeaderName:ftHgl("exception")<br>
     *         
     * <br>
     * ҒlF(ԕω) mappingKey:mappingKey<br>
     *         (ԕω) mappingValues:mappingValues<br>
     *         (ԕω) viewName:"abc"<br>
     *         (ԕω) errorType:"def"<br>
     *         (ԕω) errorCode:null<br>
     *         (ԕω) errorTypeHeaderName:"exceptionName"<br>
     *         
     * <br>
     * paramsɃL["errorTypeHeaderName"݂,̒lnullƋ󕶎ȊOꍇ̃eXgB<br>
     * errorTypeHeaderNameɂ̒lݒ肷邱ƊmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInitMapping14() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        Map<String,String> params = new HashMap<String,String>();
        params.put("errorTypeHeaderName", "exceptionName");

        // 
        String mappingValues = "abc,def";

        // eXg{
        exceptionResolveDelegator.initMapping(MAPPING_KEY, mappingValues, params);
        
        // 
        assertEquals(MAPPING_KEY, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingKey"));
        assertEquals(mappingValues, UTUtil.getPrivateField(exceptionResolveDelegator, "mappingValues"));
        assertEquals("abc", UTUtil.getPrivateField(exceptionResolveDelegator, "viewName"));
        assertEquals("def", UTUtil.getPrivateField(exceptionResolveDelegator, "errorType"));
        assertEquals("exceptionName", UTUtil.getPrivateField(exceptionResolveDelegator, "errorTypeHeaderName"));

    }
    
    /**
     * testSetHeader01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() response:HttpResponseCX^X<br>
     *         () this.exceptionKey:EXCEPTION_KEY = "exception"<br>
     *         () this.errorType:"validation"<br>
     *         
     * <br>
     * ҒlF(ԕω) response:wb_ exception"validation"ݒ肳邱ƂmFB<br>
     *         
     * <br>
     * ̃X|XɃwb_ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetHeader01() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        UTUtil.setPrivateField(exceptionResolveDelegator, "errorType", "validation");

        // 
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        exceptionResolveDelegator.setHeader(response);

        // 
        assertEquals("validation", ((Map)UTUtil.getPrivateField(response, "httpHeaderMap")).get(ExceptionResolveDelegatorImpl.EXCEPTION_KEY));            
    }

    /**
     * testAddObjectToModel01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() mv:ModelAndViewCX^X<br>
     *         () this.errorCode:null<br>
     *         () Constants.ERRORCODE_KEY:"errorCode"<br>
     *         
     * <br>
     * ҒlF(ԕω) mv:errorCode= null<br>
     *         
     * <br>
     * this.errorCode̒lnull̏ꍇAModelAndViewerrorCodeɃG[R[hݒ肳ȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddObjectToModel01() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        UTUtil.setPrivateField(exceptionResolveDelegator, "errorCode", null);

        // 
        ModelAndView mv = new ModelAndView();

        
        // eXg{
        exceptionResolveDelegator.addObjectToModel(mv);

        // 
        assertNull(mv.getModel().get(Constants.ERRORCODE_KEY));            
            
    }

    /**
     * testAddObjectToModel02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mv:ModelAndViewCX^X<br>
     *         () this.errorCode:"abc"<br>
     *         () Constants.ERRORCODE_KEY:errorCode<br>
     *         
     * <br>
     * ҒlF(ԕω) mv:errorCode= "abc"<br>
     *         
     * <br>
     * this.errorCode̒l"abc"̏ꍇAModelAndViewerrorCodeɃG[R[h"abc"ݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddObjectToModel02() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        UTUtil.setPrivateField(exceptionResolveDelegator, "errorCode", "abc");

        // 
        ModelAndView mv = new ModelAndView();

        
        // eXg{
        exceptionResolveDelegator.addObjectToModel(mv);

        // 
        assertEquals("abc", mv.getModel().get(Constants.ERRORCODE_KEY));            
            
    }

    /**
     * testGetViewName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.viewName:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * viewName̒lԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetViewName01() throws Exception {
        // O
        ExceptionResolveDelegator exceptionResolveDelegator = new ExceptionResolveDelegatorImpl();
        UTUtil.setPrivateField(exceptionResolveDelegator, "viewName", "abc");
        
        // eXg{
        assertEquals("abc", exceptionResolveDelegator.getViewName());
            
    }

}
