/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletInputStream;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.mapper.castor.CastorOXMapperImpl;
import jp.terasoluna.fw.oxm.xsd.SchemaValidator;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import jp.terasoluna.fw.oxm.xsd.xerces.SchemaValidatorImpl;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.exception.XMLRequestIOException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.w3c.dom.Document;

import com.sun.org.apache.xerces.internal.dom.DocumentImpl;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder}
 * NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4>
 * XML`̃NGXgf[^R}hIuWFNgɃoChNXB<br>
 * OFcreator琶邽߁ARXgN^̈target,oxmappernull̏Ԃ݂͑ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder
 */
public class XMLServletRequestDataBinderTest extends TestCase {

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public XMLServletRequestDataBinderTest(String name) {
        super(name);
    }

    /**
     * testXMLServletRequestDataBinder01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() target:not null<br>
     *         () objectName:not null<br>
     *         () oxmapper:not null<br>
     *         () schemaValidator:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.bindingResult.target:not null<br>
     *         (ԕω) this.oxmapper:not null<br>
     *         (ԕω) this.schemaValidator:not null<br>
     *         
     * <br>
     * ̒lɑɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testXMLServletRequestDataBinder01() throws Exception {
        // O
        OXMapper oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "";

        // eXg{
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        //         
        // ɐݒ肳ꂽƂ̊mF
        assertSame(oxmapper, UTUtil.getPrivateField(
                servletDataBinder, "oxmapper"));
        assertSame(schemaValidator, UTUtil.getPrivateField(
                servletDataBinder, "schemaValidator"));
        // ĂяomF
        BindingResult errors = servletDataBinder.getBindingResult();
        assertSame(target, errors.getTarget());
    }

    /**
     * testXMLServletRequestDataBinder02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() target:not null<br>
     *         () oxmapper:not null<br>
     *         () schemaValidator:null<br>
     *         () objectName:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.bindingResult.target:not null<br>
     *         (ԕω) this.oxmapper:not null<br>
     *         (ԕω) this.schemaValidator:null<br>
     *         
     * <br>
     * ̒lɑɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testXMLServletRequestDataBinder02() throws Exception {
        // O
        OXMapper oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = null;
        Object target = new Object();
        String objectName = "target";

        // eXg{
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        // 
        // ɐݒ肳ꂽƂ̊mF
        assertSame(oxmapper, UTUtil.getPrivateField(servletDataBinder, "oxmapper"));
        assertNull(UTUtil.getPrivateField(servletDataBinder, "schemaValidator"));
        // ĂяomF
        BindingResult errors = servletDataBinder.getBindingResult();
        assertSame(target, errors.getTarget());
    }

    /**
     * testBind01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() request:sȓ̓Xg[<br>
     *         () this.oxmapper:not null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         () request.servletInputStream:not null<br>
     *         () request.getInputStream():IOExceptionX[<br>
     *         () request.env:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:XMLRequestIOException{<br>
     *                      cause = IOException<br>
     *                    }<br>
     *         (ԕω) O:OxFerror<br>
     *                    Request stream is Invalid.<br>
     *         
     * <br>
     * request.getInputStream()\bh̎sIOOꍇAXMLRequestIOExceptionX[AOo͂邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBind01() throws Exception {
        // O
        OXMapper oxmapper = null;
        SchemaValidator schemaValidator = null;
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        XMLServletRequestDataBinder_MockHttpServletRequestStub01 request = new XMLServletRequestDataBinder_MockHttpServletRequestStub01();

        try {
            // eXg{
            servletDataBinder.bind(request);
            fail();
        } catch (XMLRequestIOException e) {
            // 
            assertSame(IOException.class, e.getCause().getClass());

            // OmF
            String message = "Request stream error.";
            assertTrue(LogUTUtil.checkError(message, e.getCause()));
            
        }
    }

    /**
     * testBind02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:not null<br>
     *         () this.oxmapper:not null<br>
     *         () this.schemaValidator:null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         () request.servletInputStream:null<br>
     *         () request.env:not null<br>
     *         () oxmapper.unmarshal(InputStream, String, Object):ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * schemaValidatornull̏ꍇAunmarshal(InputStream, String, Object)\bhs邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBind02() throws Exception {
        // O
        XMLServletRequestDataBinder_OXMapperStub01 oxmapper = new XMLServletRequestDataBinder_OXMapperStub01();
        SchemaValidator schemaValidator = null;
        Object out = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                out, oxmapper, schemaValidator, objectName);

        MockHttpServletRequest request = new MockHttpServletRequest();
        ServletInputStream inputStream = null;
        request.setInputStream(inputStream);
        request.setCharacterEncoding("abc");

        // eXg{
        servletDataBinder.bind(request);

        // 
        // ĂяomF
        assertNull(oxmapper.is);
        assertEquals("abc", oxmapper.argCharset);
        assertSame(out, oxmapper.out);

    }

    /**
     * testBind03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() request:not null<br>
     *         () this.oxmapper:not null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         () request.servletInputStream:not null<br>
     *         () request.env:not null<br>
     *         () validate():ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *         () in.close():IOExceptionX[<br>
     *         () oxmapper.unmarshal(Document, Object):ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *         
     * <br>
     * ҒlF(ԕω) O:OxFerror<br>
     *                    "Failed to close request stream.", IOException<br>
     *         
     * <br>
     * schemaValidatornot null̏ꍇAvalidate\bhsAunmarshal(Document, Object)\bhs邱ƂmFB<br>
     * Xg[̃N[YɎsꍇAOo͂As邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBind03() throws Exception {
        // O
        XMLServletRequestDataBinder_OXMapperStub01 oxmapper = new XMLServletRequestDataBinder_OXMapperStub01();
        XMLServletRequestDataBinder_SchemaValidatorStub01 schemaValidator = new XMLServletRequestDataBinder_SchemaValidatorStub01();
        Object out = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder_XMLServletRequestDataBinderStub01 servletDataBinder = new XMLServletRequestDataBinder_XMLServletRequestDataBinderStub01(
                out, oxmapper, schemaValidator, objectName);

        MockHttpServletRequest request = new MockHttpServletRequest();
        XMLServletRequestDataBinder_ServletInputStreamStub01 inputStream = new XMLServletRequestDataBinder_ServletInputStreamStub01();
        request.setInputStream(inputStream);
        request.setCharacterEncoding("abc");

        Document doc = new DocumentImpl();
        servletDataBinder.doc = doc;

        // eXg{
        servletDataBinder.bind(request);

        // 
        // ĂяomF
        assertSame(inputStream, servletDataBinder.in);
        assertSame(doc, oxmapper.doc);
        assertSame(out, oxmapper.out);

        // OmF
        String message = "Failed to close request stream.";
        assertTrue(LogUTUtil.checkError(message, new IOException()));
    }

    /**
     * testBind04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:not null<br>
     *         () this.oxmapper:not null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf1errors<br>
     *         () request.servletInputStream:not null<br>
     *         () request.env:not null<br>
     *         () validate():ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *         () in.close():ĂяoꂽƂ̊mFsB<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * schemaValidatornot nullABindExceptionɃG[i[ĂꍇAvalidate\bhs邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBind04() throws Exception {
        // O
        XMLServletRequestDataBinder_OXMapperStub01 oxmapper = new XMLServletRequestDataBinder_OXMapperStub01();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object out = new Object();
        String objectName = "target";

        XMLServletRequestDataBinder_XMLServletRequestDataBinderStub01 servletDataBinder = new XMLServletRequestDataBinder_XMLServletRequestDataBinderStub01(
                out, oxmapper, schemaValidator, objectName);
        FieldError error = new FieldError("", "", null, false, new String[] {},
                new Object[] {}, "");
        BindingResult errors = servletDataBinder.getBindingResult();
        errors.addError(error);

        MockHttpServletRequest request = new MockHttpServletRequest();
        XMLServletRequestDataBinder_ServletInputStreamStub02 inputStream = new XMLServletRequestDataBinder_ServletInputStreamStub02();
        request.setInputStream(inputStream);
        request.setCharacterEncoding("abc");

        Document doc = new DocumentImpl();
        servletDataBinder.doc = doc;

        // eXg{
        servletDataBinder.bind(request);

        // 
        // ĂяomF
        assertSame(inputStream, servletDataBinder.in);
        assertTrue(inputStream.read);

    }

    /**
     * testValidate01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() in:null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException{<br>
     *                      message = InputStream is null.<br>
     *                    }<br>
     *         (ԕω) O:OxFerror<br>
     *                    InputStream is null.<br>
     *         
     * <br>
     * innull̏ꍇAIllegalArgumentExceptionX[AOo͂邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidate01() throws Exception {
        // O
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object out = new Object();
        String objectName = "target";

        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                out, oxmapper, schemaValidator, objectName);

        ServletInputStream inputStream = null;

        // eXg{
        try {
            servletDataBinder.validate(inputStream);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            String message = "InputStream is null.";
            assertSame(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testValidate02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() in:not null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         () schemaValidator.validate():ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *                <br>
     *                ErrorMassagesɃG[i[ȂB<br>
     *         
     * <br>
     * ҒlF(߂l) -:DocumentCX^X<br>
     *         (ԕω) this.bindingResult.errors:vf0errors<br>
     *         
     * <br>
     * ``FbNŃG[ȂꍇAthis.bindingResult.errorɃG[i[ĂȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidate02() throws Exception {
        // O
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        XMLServletRequestDataBinder_SchemaValidatorStub01 schemaValidator = new XMLServletRequestDataBinder_SchemaValidatorStub01();
        Document doc = new DocumentImpl();
        schemaValidator.doc = doc;        
        Object target = new Object();
        String objectName = "target";

        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);
        ServletInputStream inputStream = new XMLServletRequestDataBinder_ServletInputStreamStub02();

        // eXg{
        Document result = servletDataBinder.validate(inputStream);
        
        // 
        // ߂l
        assertSame(doc, result);
        
        // ĂяomF
        assertSame(inputStream, schemaValidator.in);
        assertSame(target, schemaValidator.object);
        assertSame(ErrorMessages.class, schemaValidator.errorMessages.getClass());
        
        // ԕω
        BindingResult errors = servletDataBinder.getBindingResult();
        assertEquals(0, errors.getErrorCount());
        
    }

    /**
     * testValidate03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() in:not null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         () schemaValidator.validate():ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *                <br>
     *                ErrorMassagesɂP̃G[i[B<br>
     *                ErrorMessage{<br>
     *                  field = "abc",<br>
     *                  key = "123",<br>
     *                  replaceValues[]{"a"}<br>
     *                }<br>
     *         () createReplaceValues():1xĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *                String[]{"jkl","j"}ԋp<br>
     *         
     * <br>
     * ҒlF(߂l) -:DocumentCX^X<br>
     *         (ԕω) this.bindingResult.errors:vf1errors<br>
     *                    FieldError{<br>
     *                      objectName = not null,<br>
     *                      field = "abc",<br>
     *                      rejectedValue = null,<br>
     *                      bindingFailure = false,<br>
     *                      codes[] = {"abc.null.123", "abc.123", "abc"},<br>
     *                      arguments[] = {"abc","a"},<br>
     *                      defaultMessage = null<br>
     *                    }<br>
     *         
     * <br>
     * ``FbNŃG[PꍇAthis.bindingResult.errorFieldErrorCX^XPi[邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidate03() throws Exception {
        // O
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        XMLServletRequestDataBinder_SchemaValidatorStub02 schemaValidator = new XMLServletRequestDataBinder_SchemaValidatorStub02();
        Document doc = new DocumentImpl();
        schemaValidator.doc = doc;
        
        Object target = new Object();
        String objectName = "target";
        
        //DataBinder d = new DataBinder(target,"");

        XMLServletRequestDataBinder_XMLServletRequestDataBinderStub02 servletDataBinder = new XMLServletRequestDataBinder_XMLServletRequestDataBinderStub02(
                target, oxmapper, schemaValidator, objectName);
        
        ServletInputStream inputStream = new XMLServletRequestDataBinder_ServletInputStreamStub02();
                        
        // eXg{
         Document result = servletDataBinder.validate(inputStream);
        
        // 
        // ߂l
        assertSame(doc, result);
        
        // schemaValidator.validate\bȟĂяomF
        assertSame(inputStream, schemaValidator.in);
        assertSame(target, schemaValidator.object);
        assertSame(ErrorMessages.class, schemaValidator.errorMessages.getClass());
        
        // createReplaceValues\bȟĂяomF
        assertEquals(1, servletDataBinder.count);
        assertEquals("abc", servletDataBinder.field);
        assertEquals("a", servletDataBinder.replaceValues[0]);
        assertEquals(1, servletDataBinder.replaceValues.length);
        
        // ꂽFieldError̊mF
        BindingResult errors = servletDataBinder.getBindingResult();
        List errorResults = errors.getAllErrors();
        assertEquals(1, errorResults.size());
        FieldError errorResult = null;
        errorResult = (FieldError) errorResults.get(0);
        assertNotNull(errorResult.getObjectName());
        assertEquals("abc", errorResult.getField());
        assertNull(errorResult.getRejectedValue());
        assertFalse(errorResult.isBindingFailure());
        assertEquals("123", errorResult.getCode());
        assertEquals(3, errorResult.getCodes().length);
        assertEquals("jkl", errorResult.getArguments()[0]);
        assertEquals("j", errorResult.getArguments()[1]);       
        assertEquals(2, errorResult.getArguments().length);
        assertNull(errorResult.getDefaultMessage());
        
    }

    /**
     * testValidate04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() in:not null<br>
     *         () this.schemaValidator:not null<br>
     *         () this.bindingResult.target:not null<br>
     *         () this.bindingResult.errors:vf0errors<br>
     *         () schemaValidator.validate():ĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *                <br>
     *                ErrorMassagesɂR̃G[i[B<br>
     *                ErrorMessage{<br>
     *                {<br>
     *                  field = "abc",<br>
     *                  key = "123",<br>
     *                  replaceValues[]{"a"}<br>
     *                  }<br>
     *                },<br>
     *                ErrorMessage<br>
     *                {<br>
     *                  field = "def",<br>
     *                  key = "456",<br>
     *                  replaceValues[]{"b"}<br>
     *                  }<br>
     *                },<br>
     *                ErrorMessage<br>
     *                {<br>
     *                  field = "ghi",<br>
     *                  key = "789",<br>
     *                  replaceValues[]{"c"}<br>
     *                }<br>
     *         () createReplaceValues():3xĂяoꂽƂ̊mFsB<br>
     *                nꂽƂ̊mFsB<br>
     *                <br>
     *                PڂɌĂяoꂽƂAString[]{"jkl","j"}ԋp<br>
     *                QڂɌĂяoꂽƂAString[]{"mno","m"}ԋp<br>
     *                RڂɌĂяoꂽƂAString[]{"pqr","p"}ԋp<br>
     *         
     * <br>
     * ҒlF(߂l) -:DocumentCX^X<br>
     *         (ԕω) this.bindingResult.errors:vf3errors<br>
     *                    FieldError<br>
     *                    {<br>
     *                      objectName = not null,<br>
     *                      field = "abc",<br>
     *                      rejectedValue = null,<br>
     *                      bindingFailure = false,<br>
     *                      codes[] = {"123"},<br>
     *                      arguments[] = {"jkl","j"},<br>
     *                      defaultMessage = null<br>
     *                    },<br>
     *                    FieldError<br>
     *                    {<br>
     *                      objectName = not null,<br>
     *                      field = "def",<br>
     *                      rejectedVal = null,<br>
     *                      bindingFailure = false,<br>
     *                      codes[] = {"456"},<br>
     *                      arguments[] = {"mno","k"},<br>
     *                      defaultMessage = null<br>
     *                    },<br>
     *                    FieldError<br>
     *                    {<br>
     *                      objectName = not null,<br>
     *                      field = "ghi",<br>
     *                      rejectedVal = null,<br>
     *                      bindingFailure = false,<br>
     *                      codes[] = {"789"},<br>
     *                      arguments[] = {"pqr","l"},<br>
     *                      defaultMessage = null<br>
     *                    }<br>
     *         
     * <br>
     * ``FbNŃG[RꍇAthis.bindingResult.errorFieldErrorCX^XRi[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidate04() throws Exception {
        // O
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        XMLServletRequestDataBinder_SchemaValidatorStub03 schemaValidator = new XMLServletRequestDataBinder_SchemaValidatorStub03();
        Document doc = new DocumentImpl();
        schemaValidator.doc = doc;
        String objectName = "target";
        
        Object target = new Object();

        XMLServletRequestDataBinder_XMLServletRequestDataBinderStub03 servletDataBinder = new XMLServletRequestDataBinder_XMLServletRequestDataBinderStub03(
                target, oxmapper, schemaValidator, objectName);
        ServletInputStream inputStream = new XMLServletRequestDataBinder_ServletInputStreamStub02();

        // eXg{
        Document result = servletDataBinder.validate(inputStream);
        
        // 
        // ߂l
        assertSame(doc, result);
        
        // schemaValidator.validate\bȟĂяomF
        assertSame(inputStream, schemaValidator.in);
        assertSame(target, schemaValidator.object);
        assertSame(ErrorMessages.class, schemaValidator.errorMessages.getClass());
        
        // createReplaceValues\bȟĂяomF        
        assertEquals(3, servletDataBinder.count);        
        assertEquals("abc", servletDataBinder.field01);
        assertEquals("a", servletDataBinder.replaceValues01[0]);
        assertEquals(1, servletDataBinder.replaceValues01.length);
        assertEquals("def", servletDataBinder.field02);
        assertEquals("b", servletDataBinder.replaceValues02[0]);
        assertEquals(1, servletDataBinder.replaceValues02.length);
        assertEquals("ghi", servletDataBinder.field03);
        assertEquals("c", servletDataBinder.replaceValues03[0]);
        assertEquals(1, servletDataBinder.replaceValues03.length);
        
        // ꂽFieldError̊mF
        BindingResult errors = servletDataBinder.getBindingResult();
        List errorResults = errors.getAllErrors();
        assertEquals(3, errorResults.size());
        FieldError errorResult = null;
        
        // 1ڂFieldError
        errorResult = (FieldError) errorResults.get(0);
        assertNotNull(errorResult.getObjectName());
        assertEquals("abc", errorResult.getField());
        assertNull(errorResult.getRejectedValue());
        assertFalse(errorResult.isBindingFailure());
        assertEquals("123", errorResult.getCode());
        assertEquals(3, errorResult.getCodes().length);
        assertEquals("jkl", errorResult.getArguments()[0]);
        assertEquals("j", errorResult.getArguments()[1]);       
        assertEquals(2, errorResult.getArguments().length);
        assertNull(errorResult.getDefaultMessage());
        
        // 2ڂFieldError
        errorResult = (FieldError) errorResults.get(1);
        assertNotNull(errorResult.getObjectName());
        assertEquals("def", errorResult.getField());
        assertNull(errorResult.getRejectedValue());
        assertFalse(errorResult.isBindingFailure());
        assertEquals("456", errorResult.getCode());
        assertEquals(3, errorResult.getCodes().length);
        assertEquals("mno", errorResult.getArguments()[0]);
        assertEquals("k", errorResult.getArguments()[1]);       
        assertEquals(2, errorResult.getArguments().length);
        assertNull(errorResult.getDefaultMessage());

        // 3ڂFieldError
        errorResult = (FieldError) errorResults.get(2);
        assertNotNull(errorResult.getObjectName());
        assertEquals("ghi", errorResult.getField());
        assertNull(errorResult.getRejectedValue());
        assertFalse(errorResult.isBindingFailure());
        assertEquals("789", errorResult.getCode());
        assertEquals(3, errorResult.getCodes().length);
        assertEquals("pqr", errorResult.getArguments()[0]);
        assertEquals("l", errorResult.getArguments()[1]);       
        assertEquals(2, errorResult.getArguments().length);
        assertNull(errorResult.getDefaultMessage());

    }

    /**
     * testCreateReplaceValues01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() field:"abc"<br>
     *         () replaceValues:vf3String[]{"value","str1","str2"}<br>
     *         
     * <br>
     * ҒlF(߂l) resultReplaceValues:vf4String[]{"abc","str1","str2","value"}<br>
     *         
     * <br>
     * ȉ̃[Ŋi[ꂽu񂪕ԋp邱ƂmFB<br>
     * Efield̒lu̐擪<br>
     * EreplaceValues̈Ԗڂ̒lu̖
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateReplaceValues01() throws Exception {
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        String field = "abc";
        String[] replaceValues = new String[]{"value","str1","str2"};
            
        // eXg{
        String[] result = servletDataBinder.createReplaceValues(field, replaceValues);

        // 
        assertEquals(4, result.length);
        assertEquals("abc", result[0]);
        assertEquals("str1", result[1]);
        assertEquals("str2", result[2]);
        assertEquals("value", result[3]);
        
    }

    /**
     * testCreateReplaceValues02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() field:""<br>
     *         () replaceValues:vf3String[]{"value","str1","str2"}<br>
     *         
     * <br>
     * ҒlF(߂l) resultReplaceValues:vf4String[]<br>
     *                  String{"","str1","str2","value"}<br>
     *         
     * <br>
     * field̒l󕶎̏ꍇA擪ɋ󕶎i[ꂽu񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateReplaceValues02() throws Exception {
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        String field = "";
        String[] replaceValues = new String[]{"value","str1","str2"};
            
        // eXg{
        String[] result = servletDataBinder.createReplaceValues(field, replaceValues);

        // 
        assertEquals(4, result.length);
        assertEquals("", result[0]);
        assertEquals("str1", result[1]);
        assertEquals("str2", result[2]);
        assertEquals("value", result[3]);
    }

    /**
     * testCreateReplaceValues03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() field:null<br>
     *         () replaceValues:vf3String[]{null,null,null}<br>
     *         
     * <br>
     * ҒlF(߂l) resultReplaceValues:vf4String[]<br>
     *                  String[]{"",null,null,null}<br>
     *         
     * <br>
     * field̒lnull̏ꍇA擪ɋ󕶎i[ꂽu񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateReplaceValues03() throws Exception {
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        String field = null;
        String[] replaceValues = new String[]{null,null,null};
            
        // eXg{
        String[] result = servletDataBinder.createReplaceValues(field, replaceValues);

        // 
        assertEquals(4, result.length);
        assertEquals("", result[0]);
        assertNull(result[1]);
        assertNull(result[2]);
        assertNull(result[3]);
    }

    /**
     * testCreateReplaceValues04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() field:"abc"<br>
     *         () replaceValues:vf0String[]{}<br>
     *         
     * <br>
     * ҒlF(߂l) resultReplaceValues:vf1String[]<br>
     *                  String[]{"abc"}<br>
     *         
     * <br>
     * replaceValues̃TCY0̏ꍇAfield݂̂i[ꂽu񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateReplaceValues04() throws Exception {
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        String field = "abc";
        String[] replaceValues = new String[]{};
            
        // eXg{
        String[] result = servletDataBinder.createReplaceValues(field, replaceValues);

        // 
        assertEquals(1, result.length);
        assertEquals("abc", result[0]);
    }

    /**
     * testCreateReplaceValues05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() field:"abc"<br>
     *         () replaceValues:vf1String[]{"value"}<br>
     *         
     * <br>
     * ҒlF(߂l) resultReplaceValues:vf2String[]<br>
     *                  String[]{"abc","value"}<br>
     *         
     * <br>
     * replaceValues̃TCY1̏ꍇAȉ̃[Ŋi[ꂽu񂪕ԋp邱ƂmFB<br>
     * Efield̒lu̐擪<br>
     * EreplaceValues̈Ԗڂ̒lu̖
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateReplaceValues05() throws Exception {
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        String field = "abc";
        String[] replaceValues = new String[]{"value"};
            
        // eXg{
        String[] result = servletDataBinder.createReplaceValues(field, replaceValues);

        // 
        assertEquals(2, result.length);
        assertEquals("abc", result[0]);
        assertEquals("value", result[1]);
    }

    /**
     * testCreateReplaceValues06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C,D
     * <br><br>
     * ͒lF() field:"abc"<br>
     *         () replaceValues:null<br>
     *         
     * <br>
     * ҒlF(߂l) resultReplaceValues:String[]{"abc"}<br>
     *         
     * <br>
     * replaceValues̃TCYnull̏ꍇAfield݂̂i[ꂽu񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateReplaceValues06() throws Exception {
        CastorOXMapperImpl oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        Object target = new Object();
        String objectName = "target";
        
        XMLServletRequestDataBinder servletDataBinder = new XMLServletRequestDataBinder(
                target, oxmapper, schemaValidator, objectName);

        String field = "abc";
        String[] replaceValues = null;
            
        // eXg{
        String[] result = servletDataBinder.createReplaceValues(field, replaceValues);

        // 
        assertEquals(1, result.length);
        assertEquals("abc", result[0]);
    }

}
