/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import jp.terasoluna.fw.ex.unit.common.DefaultProperties;
import jp.terasoluna.fw.ex.unit.common.PropertyKeys;
import jp.terasoluna.fw.ex.unit.io.Comparison;
import jp.terasoluna.fw.ex.unit.io.InputSource;
import jp.terasoluna.fw.ex.unit.io.impl.CollectionSource;
import jp.terasoluna.fw.ex.unit.io.impl.CsvSource;
import jp.terasoluna.fw.ex.unit.io.impl.DbSource;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junitx.framework.ArrayAssert;
import junitx.framework.FileAssert;
import junitx.framework.ObjectAssert;
import junitx.framework.StringAssert;
import junitx.framework.ThrowableAssert;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.beans.BeanWrapperImpl;

public class AssertUtils {

    private static String getIsNullMessage(String target) {
        return target + " is null";
    }

    private static String getNotEqualsMessage(Object expected, Object actual) {
        return "expected :<" + expected + "> was not:<" + actual + ">";
    }

    /**
     * IuWFNgmlł邱Ƃ\܂B<br>
     * ΉtB[h̒lꍇAIuWFNglƂ݂Ȃ܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * rIuWFNgString̏ꍇ{@link Assert#assertEquals(String, String)}
     * ̎ŝݍs܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ؑΏۂ̃IuWFNg
     */
    public static void assertReflectionEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            Assert.assertEquals((String) expected, (String) actual);
            return;
        }

        Assert.assertTrue(
                getNotEqualsMessage(
                        ToStringBuilder.reflectionToString(expected),
                        ToStringBuilder.reflectionToString(actual)),
                EqualsBuilder.reflectionEquals(expected, actual));
    }

    /**
     * IuWFNgmlł邱Ƃ\܂B<br>
     * ΉtB[h̒lꍇɃIuWFNglƂ݂Ȃ܂B<br>
     * excludeFieldsɐݒ肵tB[h͔ȓΏۂɂȂ܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * rIuWFNgString̏ꍇ{@link Assert#assertEquals(String, String)}
     * ̎ŝݍs܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ؑΏۂ̃IuWFNg
     * @param excludeFields
     *            rΏۊÕtB[h
     */
    public static void assertReflectionEquals(Object expected, Object actual,
            String[] excludeFields) {
        if (expected instanceof String && actual instanceof String) {
            Assert.assertEquals((String) expected, (String) actual);
            return;
        }

        Assert.assertTrue(
                getNotEqualsMessage(
                        ToStringBuilder.reflectionToString(expected),
                        ToStringBuilder.reflectionToString(actual)),
                EqualsBuilder.reflectionEquals(expected, actual, excludeFields));
    }

    /**
     * IuWFNgmlł邱Ƃ\܂B<br>
     * ΉtB[h̒lꍇɃIuWFNglƂ݂Ȃ܂B<br>
     * testTransientstrueɐݒ肷transienttB[hȓΏۂɂȂ܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * rIuWFNgString̏ꍇ{@link Assert#assertEquals(String, String)}
     * ̎ŝݍs܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ؑΏۂ̃IuWFNg
     * @param testTransients
     *            transient̃tB[hȓΏۂƂ邩ۂ
     */
    public static void assertReflectionEquals(Object expected, Object actual,
            boolean testTransients) {
        if (expected instanceof String && actual instanceof String) {
            Assert.assertEquals((String) expected, (String) actual);
            return;
        }

        Assert.assertTrue(
                getNotEqualsMessage(
                        ToStringBuilder.reflectionToString(expected),
                        ToStringBuilder.reflectionToString(actual)),
                EqualsBuilder
                        .reflectionEquals(expected, actual, testTransients));
    }

    /**
     * 2̓̓f[^Ƃ\܂B<br>
     * CSVADBACOllection擾f[^쐬{@link CsvSource}A{@link DbSource}A
     * {@link CollectionSource}r邱ƂŌ؂s܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * 
     * 
     * @param expected
     *            ̓f[^̊Ғl
     * @param actual
     *            ؑΏۂ̓̓f[^
     */
    public static <T> void assertInputEquals(InputSource<T> expected,
            InputSource<T> actual) {
        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Comparison comparison = expected.compare(actual);
        Assert.assertTrue(comparison.getMessage(),
                Comparison.Result.EQUAL == comparison.getResult());
    }

    /**
     * 2̓̓f[^Ƃ\܂B<br>
     * CSVADBACollection擾Ғl({@link CsvSource}A{@link DbSource}A
     * {@link CollectionSource})ƃRNV^̌ؑΏۓ̓f[^r܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * 
     * @param expected
     *            ̓f[^̊Ғl
     * @param actual
     *            ؑΏۂ̓̓f[^
     */
    public static <T> void assertInputEquals(InputSource<T> expected,
            Collection<T> actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        AssertUtils.<T> assertInputEquals(expected, new CollectionSource<T>(
                actual));
    }

    /**
     * {@link BLogicResult}̌ʕƌʃIuWFNgw肵̂ƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * <pre>
     * ʃIuWFNgMap̏ꍇ͌ʃIuWFNgm̔r{@link AssertUtils#assertMapEquals(Map, Map)}gp܂B
     * ȊOBean̏ꍇAʃIuWFNg̊etB[hɑ΂āA
     *  EtB[hMapł΁Aꂼ̒l{@link AssertUtils#assertMapEquals(Map, Map)}Ŕr܂B
     *  EtB[hCollectionł΁Aꂼ̒l{@link AssertUtils#assertCollectionEquals(Collection, Collection)}Ŕr܂B
     *  EȊȌꍇ́Aꂼ̒l{@link AssertUtils#assertReflectionEquals(Object, Object)}Ŕr܂B
     * 1łtB[h̔rʂȂꍇAʃIuWFNg͓ȂƂɂȂ܂B
     * </pre>
     * 
     * @param expectedResultString
     *            ʕ̊Ғl
     * @param expectedResultObject
     *            ʃIuWFNg̊Ғl
     * @param actual
     *            ؑΏۂBLogicResult
     * @see AssertUtils#assertReflectionEquals(Object, Object)
     */
    public static void assertBLogicResultEquals(String expectedResultString,
            Object expectedResultObject, BLogicResult actual) {
        AssertUtils
                .assertBLogicResultStringEquals(expectedResultString, actual);
        AssertUtils
                .assertBLogicResultObjectEquals(expectedResultObject, actual);
    }

    /**
     * {@link BLogicResult}̌ʃIuWFNgw肵̂ƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * <pre>
     * ʃIuWFNgMap̏ꍇ͌ʃIuWFNgm̔r{@link AssertUtils#assertMapEquals(Map, Map)}gp܂B
     * ȊOBean̏ꍇAʃIuWFNg̊etB[hɑ΂āA
     *  EtB[hMapł΁Aꂼ̒l{@link AssertUtils#assertMapEquals(Map, Map)}Ŕr܂B
     *  EtB[hCollectionł΁Aꂼ̒l{@link AssertUtils#assertCollectionEquals(Collection, Collection)}Ŕr܂B
     *  EȊȌꍇ́Aꂼ̒l{@link AssertUtils#assertReflectionEquals(Object, Object)}Ŕr܂B
     * 1łtB[h̔rʂȂꍇAʃIuWFNg͓ȂƂɂȂ܂B
     * </pre>
     * 
     * @param expectedResultObject
     *            ʃIuWFNg̊Ғl
     * @param actual
     *            ΏۂBLogicResult
     * @see AssertUtils#assertReflectionEquals(Object, Object)
     */
    public static void assertBLogicResultObjectEquals(
            Object expectedResultObject, BLogicResult actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);

        if (expectedResultObject instanceof Map
                && actual.getResultObject() instanceof Map) {
            AssertUtils.assertMapEquals((Map<?, ?>) expectedResultObject,
                    (Map<?, ?>) actual.getResultObject());
        } else {
            Object actualResultObject = actual.getResultObject();

            if (actualResultObject == null) {
                Assert.assertNull(
                        "expectedResultObject must be null because actualResultObject is null",
                        expectedResultObject);
            }

            BeanWrapperImpl actualBw = new BeanWrapperImpl(actualResultObject);
            BeanWrapperImpl expectedBw = new BeanWrapperImpl(
                    expectedResultObject);

            PropertyDescriptor[] pds = actualBw.getPropertyDescriptors();

            for (PropertyDescriptor pd : pds) {
                String propName = pd.getName();
                Object actualProp = actualBw.getPropertyValue(propName);
                Object expectedProp = expectedBw.getPropertyValue(propName);
                if (actualProp instanceof Map && expectedProp instanceof Map) {
                    AssertUtils.assertMapEquals((Map<?, ?>) expectedProp,
                            (Map<?, ?>) actualProp);
                } else if (actualProp instanceof Collection
                        && expectedProp instanceof Collection) {
                    AssertUtils.assertCollectionEquals(
                            (Collection<?>) expectedProp,
                            (Collection<?>) actualProp);
                } else {
                    AssertUtils
                            .assertReflectionEquals(expectedProp, actualProp);
                }
            }
        }
    }

    /**
     * {@link BLogicResult}̌ʕ񂪎w肵̂ƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedResultString
     *            ʕ̊Ғl
     * @param actual
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicResultStringEquals(
            String expectedResultString, BLogicResult actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals("[resultString]", expectedResultString,
                actual.getResultString());
    }

    /**
     * {@link BLogicResult}̌ʕ񂪐ftHgƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * ftHg̓ftHgŁusuccessvłB<br>
     * ̒lύXꍇ̓NXpXɂterasoluna-unit-override.properties<br>
     * usuccess.string=ݒlv<br>
     * ݒ肵ĂB
     * 
     * <pre>
     * ʃIuWFNgMap̏ꍇ͌ʃIuWFNgm̔r{@link AssertUtils#assertMapEquals(Map, Map)}gp܂B
     * ȊOBean̏ꍇAʃIuWFNg̊etB[hɑ΂āA
     *  EtB[hMapł΁Aꂼ̒l{@link AssertUtils#assertMapEquals(Map, Map)}Ŕr܂B
     *  EtB[hCollectionł΁Aꂼ̒l{@link AssertUtils#assertCollectionEquals(Collection, Collection)}Ŕr܂B
     *  EȊȌꍇ́Aꂼ̒l{@link AssertUtils#assertReflectionEquals(Object, Object)}Ŕr܂B
     * 1łtB[h̔rʂȂꍇAʃIuWFNg͓ȂƂɂȂ܂B
     * </pre>
     * 
     * @param actual
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicSuccessResultEquals(
            Object expectedResultObject, BLogicResult actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals(
                DefaultProperties.getValue(PropertyKeys.SUCCESS_STRING),
                actual.getResultString());
        AssertUtils
                .assertBLogicResultObjectEquals(expectedResultObject, actual);
    }

    /**
     * {@link BLogicResult}̌ʕ񂪐ftHgƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link junit.framework.ComparisonFailure}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicSuccess(BLogicResult result) {
        Assert.assertNotNull(getIsNullMessage("result"), result);
        Assert.assertEquals(
                DefaultProperties.getValue(PropertyKeys.SUCCESS_STRING),
                result.getResultString());
    }

    /**
     * {@link BLogicResult}̌ʕ񂪎sftHgƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link junit.framework.ComparisonFailure}
     * X[܂B<br>
     * sftHg̓ftHgŁufailurevłB<br>
     * 
     * <pre>
     * ʃIuWFNgMap̏ꍇ͌ʃIuWFNgm̔r{@link AssertUtils#assertMapEquals(Map, Map)}gp܂B
     * ȊOBean̏ꍇAʃIuWFNg̊etB[hɑ΂āA
     *  EtB[hMapł΁Aꂼ̒l{@link AssertUtils#assertMapEquals(Map, Map)}Ŕr܂B
     *  EtB[hCollectionł΁Aꂼ̒l{@link AssertUtils#assertCollectionEquals(Collection, Collection)}Ŕr܂B
     *  EȊȌꍇ́Aꂼ̒l{@link AssertUtils#assertReflectionEquals(Object, Object)}Ŕr܂B
     * 1łtB[h̔rʂȂꍇAʃIuWFNg͓ȂƂɂȂ܂B
     * </pre>
     * 
     * @param expectedResultObject
     *            Ғl
     * @param actual
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicFailureResultEquals(
            Object expectedResultObject, BLogicResult actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals(
                DefaultProperties.getValue(PropertyKeys.FAILURE_STRING),
                actual.getResultString());
        AssertUtils
                .assertBLogicResultObjectEquals(expectedResultObject, actual);
    }

    /**
     * {@link BLogicResult}̌ʕ񂪎sftHgƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * sftHg̓ftHgŁufailurevłB<br>
     * ̒lύXꍇ̓NXpXɂterasoluna-unit-override.properties<br>
     * ufailure.string=ݒlv<br>
     * ݒ肵ĂB
     * 
     * @param actual
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicFailure(BLogicResult result) {
        Assert.assertNotNull(getIsNullMessage("result"), result);
        Assert.assertEquals(
                DefaultProperties.getValue(PropertyKeys.FAILURE_STRING),
                result.getResultString());
    }

    /**
     * {@link BLogicMessage}̃bZ[WL[ƒu񂪊Ғlǂł邱Ƃ\܂<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicMessagenullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedKey
     *            bZ[WL[̊Ғl
     * @param expectedValues
     *            ůҒl
     * @param expectedResource
     *            bZ[W\[Xgp邩ۂ
     * @param actual
     *            ؑΏۂBLogicMessage
     */
    public static void assertBLogicMessageEquals(String expectedKey,
            Object[] expectedValues, boolean expectedResource,
            BLogicMessage actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals("[key]", expectedKey, actual.getKey());
        assertArrayEquals(expectedValues, actual.getValues());
        Assert.assertEquals("[resource]", expectedResource, actual.isResource());
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[̊Ғl
     * @param expectedMessage
     *            BLogicMessage̊Ғl
     * @param actualBLogicResult
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicMessageEquals(String expectedGroupKey,
            BLogicMessage expectedMessage, BLogicResult actualBLogicResult) {
        Assert.assertNotNull(getIsNullMessage("actualBLogicResult"),
                actualBLogicResult);
        BLogicMessages messages = actualBLogicResult.getMessages();
        Assert.assertNotNull(messages);
        BLogicMessage actual = getBLogicMessage(expectedGroupKey, messages);
        assertBLogicMessageEquals(expectedMessage, actual);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[̊Ғl
     * @param expectedMessageKey
     *            bZ[WL[̊Ғl
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicMessageEquals(String expectedGroupKey,
            String expectedMessageKey, BLogicResult result) {
        assertBLogicMessageEquals(expectedGroupKey, new BLogicMessage(
                expectedMessageKey), result);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[̊Ғl
     * @param expectedMessageKey
     *            bZ[WL[̊Ғl
     * @param expectedMessageValues
     *            ůҒl
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicMessageEquals(String expectedGroupKey,
            String expectedMessageKey, Object[] expectedMessageValues,
            BLogicResult result) {
        assertBLogicMessageEquals(expectedGroupKey, new BLogicMessage(
                expectedMessageKey, expectedMessageValues), result);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[
     * @param expectedMessageKey
     *            bZ[WL[
     * @param expectedResource
     *            bZ[W\[Xgp邩ۂ
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicMessageEquals(String expectedGroupKey,
            String expectedMessageKey, boolean expectedResource,
            BLogicResult result) {
        assertBLogicMessageEquals(expectedGroupKey, new BLogicMessage(
                expectedMessageKey, expectedResource), result);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}
     * (G[bZ[W)ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[
     * @param expectedMessage
     *            bZ[WL[
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicErrorMessageEquals(String expectedGroupKey,
            BLogicMessage expectedMessage, BLogicResult result) {
        Assert.assertNotNull(getIsNullMessage("result"), result);
        BLogicMessages messages = result.getErrors();
        Assert.assertNotNull(getIsNullMessage("errors"), messages);
        BLogicMessage actual = getBLogicMessage(expectedGroupKey, messages);
        assertBLogicMessageEquals(expectedMessage, actual);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}
     * (G[bZ[W)ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[̊Ғl
     * @param expectedMessageKey
     *            bZ[WL[̊Ғl
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicErrorMessageEquals(String expectedGroupKey,
            String expectedMessageKey, BLogicResult result) {
        assertBLogicErrorMessageEquals(expectedGroupKey, new BLogicMessage(
                expectedMessageKey), result);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}
     * (G[bZ[W)ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[̊Ғl
     * @param expectedMessageKey
     *            bZ[WL[̊Ғl
     * @param expectedMessageValues
     *            ůҒl
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicErrorMessageEquals(String expectedGroupKey,
            String expectedMessageKey, Object[] expectedMessageValues,
            BLogicResult result) {
        assertBLogicErrorMessageEquals(expectedGroupKey, new BLogicMessage(
                expectedMessageKey, expectedMessageValues), result);
    }

    /**
     * {@link BLogicResult}ɃZbgꂽ{@link BLogicMessage}
     * (G[bZ[W)ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicResultnullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expectedGroupKey
     *            O[vL[̊Ғl
     * @param expectedMessageKey
     *            bZ[WL[̊Ғl
     * @param expectedResource
     *            bZ[W\[Xgp邩ۂ
     * @param result
     *            ؑΏۂBLogicResult
     */
    public static void assertBLogicErrorMessageEquals(String expectedGroupKey,
            String expectedMessageKey, boolean expectedResource,
            BLogicResult result) {
        assertBLogicErrorMessageEquals(expectedGroupKey, new BLogicMessage(
                expectedMessageKey, expectedResource), result);
    }

    /**
     * BLogicMessagesBLogicMessageoԋp<br>
     * 
     * @param groupKey
     *            O[vL[
     * @param messages
     *            BLogicMessages
     * @return BLogicMessage
     */
    private static BLogicMessage getBLogicMessage(String groupKey,
            BLogicMessages messages) {
        Iterator<String> groupItr = messages.getGroup();
        Iterator<BLogicMessage> messageItr = messages.get();

        while (messageItr.hasNext()) {
            if (!groupItr.hasNext()) {
                break;
            }
            BLogicMessage message = messageItr.next();
            String group = groupItr.next();
            if (groupKey != null && groupKey.equals(group)) {
                return message;
            }
        }
        return null;
    }

    /**
     * {@link BLogicMessage}ҒlƓƂ\܂B<br>
     * ؂Ɏsꍇ{@link AssertionFailedError}X[܂B<br>
     * ؑΏۂBLogicMessagenullłꍇ{@link AssertionFailedError}X[܂B<br>
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ؑΏۂBLogicMessage
     */
    public static void assertBLogicMessageEquals(BLogicMessage expected,
            BLogicMessage actual) {
        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        assertBLogicMessageEquals(expected.getKey(), expected.getValues(),
                expected.isResource(), actual);
    }

    // n
    /**
     * (actual)ɕ(substring)܂܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertContains(java.lang.String,
     *      java.lang.String)
     */
    public static void assertStringContains(String substring, String actual) {
        StringAssert.assertContains(substring, actual);
    }

    /**
     * (actual)ɕ(substring)܂܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertContains(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public static void assertStringContains(String message, String substring,
            String actual) {
        StringAssert.assertContains(message, substring, actual);
    }

    /**
     * (actual)ɕ(substring)܂܂ĂȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertNotContains(java.lang.String,
     *      java.lang.String)
     */
    public static void assertStringNotContains(String substring, String actual) {
        StringAssert.assertNotContains(substring, actual);
    }

    /**
     * (actual)ɕ(substring)܂܂ĂȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertNotContains(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public static void assertStringNotContains(String message,
            String substring, String actual) {
        StringAssert.assertNotContains(message, substring, actual);
    }

    /**
     * (actual)(substring)Ŏn܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertStartsWith(java.lang.String,
     *      java.lang.String)
     */
    public static void assertStringStartsWith(String substring, String actual) {
        StringAssert.assertStartsWith(substring, actual);
    }

    /**
     * (actual)(substring)Ŏn܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertStartsWith(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public static void assertStringStartsWith(String message, String substring,
            String actual) {
        StringAssert.assertStartsWith(message, substring, actual);
    }

    /**
     * (actual)(substring)Ŏn܂ĂȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertNotStartsWith(java.lang.String,
     *      java.lang.String)
     */
    public static void assertStringNotStartsWith(String substring, String actual) {
        StringAssert.assertNotStartsWith(substring, actual);
    }

    /**
     * (actual)(substring)Ŏn܂ĂȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertNotStartsWith(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public static void assertStringNotStartsWith(String message,
            String substring, String actual) {
        StringAssert.assertNotStartsWith(message, substring, actual);
    }

    /**
     * (actual)(substring)ŏIĂ邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertEndsWith(java.lang.String,
     *      java.lang.String)
     */
    public static void assertStringEndsWith(String substring, String actual) {
        StringAssert.assertEndsWith(substring, actual);
    }

    /**
     * (actual)(substring)ŏIĂ邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W ؎sɕ\郁bZ[W
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertEndsWith(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public static void assertStringEndsWith(String message, String substring,
            String actual) {
        StringAssert.assertEndsWith(message, substring, actual);
    }

    /**
     * (actual)(substring)ŏIĂȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertNotEndsWith(java.lang.String,
     *      java.lang.String)
     */
    public static void assertStringNotEndsWith(String substring, String actual) {
        StringAssert.assertNotEndsWith(substring, actual);
    }

    /**
     * (actual)(substring)ŏIĂȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param substring
     *            
     * @param actual
     *            ؑΏۂ̕
     * @see junitx.framework.StringAssert#assertNotEndsWith(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    public static void assertStringNotEndsWith(String message,
            String substring, String actual) {
        StringAssert.assertNotEndsWith(message, substring, actual);
    }

    // zn

    /**
     * 2̔z񂪓lł邱Ƃ\܂B<br>
     * L̏ꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * @E2̔z̒ꍇ<br>
     * @EΉevfǂlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String,
     *      java.lang.Object[], java.lang.Object[])
     */
    // public static void assertArrayEquals(String message, Object[] expected,
    // Object[] actual) {
    // ArrayAssert.assertEquals(message, expected, actual);
    // }
    /**
     * 2̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.Object[],
     *      java.lang.Object[])
     */
    public static void assertArrayEquals(Object[] expected, Object[] actual) {
        if (expected == null && actual == null) {
            return;
        }

        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals("size", expected.length, actual.length);
        for (int i = 0; i < expected.length; i++) {
            Object e = expected[i];
            Object a = actual[i];
            AssertUtils.assertReflectionEquals(e, a);
        }
    }

    /**
     * 2double^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩ̏ꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂ̌덷delta͈͓̔̏ꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @param delta
     * @see junitx.framework.ArrayAssert#assertEquals(double[], double[],
     *      double)
     */
    public static void assertArrayEquals(double[] expected, double[] actual,
            double delta) {
        ArrayAssert.assertEquals(expected, actual, delta);
    }

    /**
     * 2double^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @param delta
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String,
     *      double[], double[], double))
     */
    public static void assertArrayEquals(String message, double[] expected,
            double[] actual, double delta) {
        ArrayAssert.assertEquals(message, expected, actual, delta);
    }

    /**
     * 2float^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩ̏ꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂ̌덷delta͈͓̔̏ꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @param delta
     *            e͈ e͈
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String, float[],
     *      float[], float)
     */
    public static void assertArrayEquals(String message, float[] expected,
            float[] actual, float delta) {
        ArrayAssert.assertEquals(message, expected, actual, delta);
    }

    /**
     * 2float^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @param delta
     *            e͈
     * @see junitx.framework.ArrayAssert#assertEquals(float[], float[], float)
     */
    public static void assertArrayEquals(float[] expected, float[] actual,
            float delta) {
        ArrayAssert.assertEquals(expected, actual, delta);
    }

    /**
     * 2long^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String, long[],
     *      long[])
     */
    public static void assertArrayEquals(String message, long[] expected,
            long[] actual) {
        ArrayAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2long^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(long[], long[])
     */
    public static void assertArrayEquals(long[] expected, long[] actual) {
        ArrayAssert.assertEquals(expected, actual);
    }

    /**
     * 2int^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String, int[],
     *      int[])
     */
    public static void assertArrayEquals(String message, int[] expected,
            int[] actual) {
        ArrayAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2int^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(int[], int[])
     */
    public static void assertArrayEquals(int[] expected, int[] actual) {
        ArrayAssert.assertEquals(expected, actual);
    }

    /**
     * 2short^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfmׂēlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String, short[],
     *      short[])
     */
    public static void assertArrayEquals(String message, short[] expected,
            short[] actual) {
        ArrayAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2short^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(short[], short[])
     */
    public static void assertArrayEquals(short[] expected, short[] actual) {
        ArrayAssert.assertEquals(expected, actual);
    }

    /**
     * 2char^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String, char[],
     *      char[])
     */
    public static void assertArrayEquals(String message, char[] expected,
            char[] actual) {
        ArrayAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2char^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(char[], char[])
     */
    public static void assertArrayEquals(char[] expected, char[] actual) {
        ArrayAssert.assertEquals(expected, actual);
    }

    /**
     * 2boolean^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String,
     *      boolean[], boolean[])
     */
    public static void assertArrayEquals(String message, boolean[] expected,
            boolean[] actual) {
        ArrayAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2boolean^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(boolean[], boolean[])
     */
    public static void assertArrayEquals(boolean[] expected, boolean[] actual) {
        ArrayAssert.assertEquals(expected, actual);
    }

    /**
     * 2byte^̔z񂪓lł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̔z񂪓lłƂ݂Ȃ܂B<br>
     * <br>
     * @Ez̒ꍇ<br>
     * @EΉvfǂlłꍇ<br>
     * @Ez̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(java.lang.String, byte[],
     *      byte[])
     */
    public static void assertArrayEquals(String message, byte[] expected,
            byte[] actual) {
        ArrayAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2byte^̔z񂪓lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquals(byte[], byte[])
     */
    public static void assertArrayEquals(byte[] expected, byte[] actual) {
        ArrayAssert.assertEquals(expected, actual);
    }

    /**
     * 2̔z񂪓ł邱Ƃ\܂B<br>
     * z̗vf͓łi[Ă鏇قȂĂꍇA2̔z͓łƂ݂Ȃ܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquivalenceArrays(java.lang.String,
     *      java.lang.Object[], java.lang.Object[])
     */
    // p~
    // public static void assertArrayEquivalenceArrays(String message,
    // Object[] expected, Object[] actual) {
    // ArrayAssert.assertEquivalenceArrays(message, expected, actual);
    // }
    /**
     * 2̔z񂪓ł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ArrayAssert#assertEquivalenceArrays(java.lang.Object[],
     *      java.lang.Object[])
     */
    // p~
    // public static void assertArrayEquivalenceArrays(Object[] expected,
    // Object[] actual) {
    // ArrayAssert.assertEquivalenceArrays(expected, actual);
    // }
    // Listn
    /**
     * 2̃Xglł邱Ƃ\܂B<br>
     * L̂ꂩꍇ2̃XglłƂ݂Ȃ܂B<br>
     * <br>
     * @EXgɊi[Ăvflłꍇ(i[͍lȂ)<br>
     * @EXg̎QƂnull̏ꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ListAssert#assertEquals(java.util.List,
     *      java.util.List)
     */
    // p~
    // public static void assertListEquals(List<?> expected, List<?> actual) {
    // ListAssert.assertEquals(expected, actual);
    // }
    /**
     * 2̃Xglł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ListAssert#assertEquals(java.lang.String,
     *      java.util.List, java.util.List)
     */
    // p~
    // public static void assertListEquals(String message, List<?> expected,
    // List<?> actual) {
    // ListAssert.assertEquals(message, expected, actual);
    // }
    /**
     * Xg(actual)̗vfɃIuWFNg(value)܂܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param actual
     *            ۂ̒l
     * @param value
     *            IuWFNg
     * @see junitx.framework.ListAssert#assertContains(java.util.List,
     *      java.lang.Object)
     */
    // p~
    // public static void assertListContains(List<?> actual, Object value) {
    // ListAssert.assertContains(actual, value);
    // }
    /**
     * Xg(actual)̗vfɃIuWFNg(value)܂܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param actual
     *            ۂ̒l
     * @param value
     *            IuWFNg
     * @see junitx.framework.ListAssert#assertContains(java.lang.String,
     *      java.util.List, java.lang.Object)
     */
    // p~
    // public static void assertListContains(String message, List<?> actual,
    // Object value) {
    // ListAssert.assertContains(message, actual, value);
    // }
    // Collection
    /**
     * RNV(actual)̗vfw萔(expectedSize)ł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * RNVnullŗLꍇ؎sƂȂ܂B
     * 
     * @param expectedSize
     *            vf̊Ғl
     * @param actual
     *            Ώۂ̃RNV
     */
    public static void assertCollectionSizeEquals(int expectedSize,
            Collection<?> actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals("[size]", expectedSize, actual.size());
    }

    /**
     * RNV(actual)ł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * RNVnullŗLꍇ؎sƂȂ܂B
     * 
     * @param <E>
     *            RNV̌^p[^
     * @param actual
     *            Ώۂ̃RNV
     */
    public static void assertCollectionEmpty(Collection<?> actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertTrue("actual is not empty", actual.isEmpty());
    }

    /**
     * RNV(actual)łȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * RNVnullŗLꍇ؎sƂȂ܂B
     * 
     * @param <E>
     *            RNV̌^p[^
     * @param actual
     *            Ώۂ̃RNV
     */
    public static void assertCollectionNotEmpty(Collection<?> actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertFalse("actual is empty", actual.isEmpty());
    }

    // Collectionn

    /**
     * 2̃RNVł邱Ƃ\܂B<br>
     * RNVɊi[Ăvf̃vpeBmꍇ2̃RNV͓łƂ݂Ȃ܂B<br>
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ؑΏۂ̃RNV
     * 
     */
    public static void assertCollectionEquals(Collection<?> expected,
            Collection<?> actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertNotNull(getIsNullMessage("expected"), expected);

        Assert.assertEquals("size", expected.size(), actual.size());

        Iterator<?> expectedIterator = expected.iterator();
        Iterator<?> actualIterator = actual.iterator();

        while (expectedIterator.hasNext()) {
            Object e = expectedIterator.next();
            Object a = actualIterator.next();
            AssertUtils.assertReflectionEquals(e, a);
        }
    }

    /**
     * RNV(actual)̗vfɃIuWFNg(value)܂܂Ă邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param actual
     *            ۂ̒l
     * @param value
     *            IuWFNg
     * @see junitx.framework.ListAssert#assertContains(java.util.List,
     *      java.lang.Object)
     */
    public static void assertCollectionContains(Collection<?> actual,
            Object value) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertTrue("actual does not contain " + value,
                actual.contains(value));
    }

    // Mapn

    /**
     * 2Mapł邱Ƃ\܂B
     * 
     * <pre>
     * ̏𖞂ꍇɓƂ݂Ȃ܂B
     * EMap̃TCY
     * EMap̑SẴL[Mapɑ݂
     * ESẴL[ɑ΂Map̒l
     * (ł͓̒l̃tB[hmƂӖ܂B{@link #assertReflectionEquals(Object, Object)})QƁB
     * </pre>
     * 
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     */
    public static void assertMapEquals(Map<?, ?> expected, Map<?, ?> actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertNotNull(getIsNullMessage("expected"), expected);

        int actualSize = actual.size();
        int expectedSize = expected.size();
        Assert.assertEquals("size", actualSize, expectedSize);
        for (Entry<?, ?> e : expected.entrySet()) {
            Object expectedKey = e.getKey();
            Object expectedValue = e.getValue();
            Assert.assertTrue("key = " + expectedKey
                    + " is not found in actual",
                    actual.containsKey(expectedKey));
            AssertUtils.assertReflectionEquals(expectedValue,
                    actual.get(expectedKey));
        }
    }

    /**
     * actualMapexpectedKeys̃L[zexpectedValues̒l\Mapł邱Ƃ\܂B
     * 
     * <pre>
     * ̏{@link #assertMapEquals(Map, Map)}QƁB
     * expectedKeysexpectedValues̏̓L[ɑ΂l̏ƈvĂB
     * 
     * </pre>
     * 
     * @param expectedKeys
     *            Ғl̃L[z
     * @param expectedValues
     *            Ғl̒lz
     * @param actual
     *            ۂ̒l
     */
    public static void assertMapEquals(Object[] expectedKeys,
            Object[] expectedValues, Map<?, ?> actual) {
        Assert.assertNotNull(getIsNullMessage("expectedValues"), expectedValues);
        Assert.assertNotNull(getIsNullMessage("expectedKeys"), expectedKeys);
        int keySize = expectedKeys.length;
        int valSize = expectedValues.length;
        Assert.assertEquals("keySize and valueSize are wrong", keySize, valSize);

        Map<Object, Object> expected = new HashMap<Object, Object>();
        for (int i = 0; i < expectedKeys.length; i++) {
            expected.put(expectedKeys[i], expectedValues[i]);
        }

        AssertUtils.assertMapEquals(expected, actual);
    }

    /**
     * }bv(actual)̗vfw萔(expectedSize)ł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B<br>
     * }bvnullŗLꍇ؎sƂȂ܂B
     * 
     * @param expectedSize
     *            vf̊Ғl
     * @param actual
     *            Ώۂ̃}bv
     */
    public static void assertMapSizeEquals(int expectedSize, Map<?, ?> actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals("[size]", expectedSize, actual.size());
    }

    /**
     * IuWFNg(actual)NX(expected)̃CX^Xł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ObjectAssert#assertInstanceOf(java.lang.String,
     *      java.lang.Class, java.lang.Object)
     */
    public static void assertObjectInstanceOf(String message,
            Class<?> expected, Object actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        ObjectAssert.assertInstanceOf(message, expected, actual);
    }

    /**
     * IuWFNg(actual)NX(expected)̃CX^Xł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ObjectAssert#assertInstanceOf(java.lang.Class,
     *      java.lang.Object)
     */
    public static void assertObjectInstanceOf(Class<?> expected, Object actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        ObjectAssert.assertInstanceOf(expected, actual);
    }

    /**
     * IuWFNg(actual)NX(expected)̃CX^Xł͂ȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ObjectAssert#assertNotInstanceOf(java.lang.String,
     *      java.lang.Class, java.lang.Object)
     */
    public static void assertObjectNotInstanceOf(String message,
            Class<?> expected, Object actual) {
        ObjectAssert.assertNotInstanceOf(message, expected, actual);
    }

    /**
     * IuWFNg(actual)NX(expected)̃CX^Xł͂ȂƂ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ObjectAssert#assertNotInstanceOf(java.lang.Class,
     *      java.lang.Object)
     */
    public static void assertObjectNotInstanceOf(Class<?> expected,
            Object actual) {
        ObjectAssert.assertNotInstanceOf(expected, actual);
    }

    // Throwablen

    /**
     * 2̗O܂̓G[lł邱Ƃ\܂B<br>
     * L̏ꍇ2̗O܂̓G[lłƂ݂Ȃ܂B<br>
     * <br>
     * @ENXłꍇ<br>
     * @EbZ[Wꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ThrowableAssert#assertEquals(java.lang.String,
     *      java.lang.Throwable, java.lang.Throwable)
     */
    public static void assertThrowableEquals(String message,
            Throwable expected, Throwable actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        ThrowableAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2̗O܂̓G[lł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ThrowableAssert#assertEquals(java.lang.Throwable,
     *      java.lang.Throwable)
     */
    public static void assertThrowableEquals(Throwable expected,
            Throwable actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        ThrowableAssert.assertEquals(expected, actual);
    }

    /**
     * 2̗O܂̓G[قړlł邱Ƃ\܂B<br>
     * L̏ꍇ2̗O܂̓G[قړlłƂ݂Ȃ܂B<br>
     * <br>
     * @ENXłꍇ<br>
     * @E(actual)̃bZ[WҌ(expected)̃bZ[W܂łꍇ<br>
     * <br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ThrowableAssert#assertSimilar(java.lang.String,
     *      java.lang.Throwable, java.lang.Throwable)
     */
    public static void assertThrowableSimilar(String message,
            Throwable expected, Throwable actual) {
        ThrowableAssert.assertSimilar(message, expected, actual);
    }

    /**
     * 2̗O܂̓G[قړlł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.ThrowableAssert#assertSimilar(java.lang.Throwable,
     *      java.lang.Throwable)
     */
    public static void assertThrowableSimilar(Throwable expected,
            Throwable actual) {
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        ThrowableAssert.assertSimilar(expected, actual);
    }

    // Daten
    /**
     * DateIuWFNg\1970N11 00:00:00 GMT ̃~bƂ\܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     */
    public static void assertDateEquals(Date expected, Date actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertEquals(expected.getTime(), actual.getTime());
    }

    /**
     * expectedŕ\łDateIuWFNgactualDateIuWFNg\1970N11 00:00:00 GMT
     * ̃~bƂ\܂B<br>
     * ŁAuŕ\łvƂ{@link Timestamp#valueOf(String)}ŕϊł邱ƂӖ܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     */
    public static void assertDateEquals(String expected, Date actual) {
        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        assertDateEquals(Timestamp.valueOf(expected), actual);
    }

    /**
     * DateIuWFNg\1970N11 00:00:00 GMT ̃~b̍덷ȉł邱Ƃ\܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @param errorInMillisec
     *            덷(~b)
     */
    public static void assertDateNearEquals(Date expected, Date actual,
            long errorInMillisec) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        Assert.assertNotNull(getIsNullMessage("actual"), actual);
        Assert.assertTrue(
                "error beteween expected and actual is over " + errorInMillisec,
                Math.abs(expected.getTime() - actual.getTime()) <= errorInMillisec);
    }

    /**
     * expectedŕ\łDateIuWFNgactualDateIuWFNg\1970N11 00:00:00 GMT
     * ̃~b̍덷ȉł邱Ƃ\܂B<br>
     * ŁAuŕ\łvƂ{@link Timestamp#valueOf(String)}ŕϊł邱ƂӖ܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @param errorInMillisec
     *            덷(~b)
     */
    public static void assertDateNearEquals(String expected, Date actual,
            long errorInMillisec) {
        Assert.assertNotNull(getIsNullMessage("expected"), expected);
        assertDateNearEquals(Timestamp.valueOf(expected), actual,
                errorInMillisec);
    }

    // Filen

    /**
     * 2̃t@Clł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.FileAssert#assertEquals(java.lang.String,
     *      java.io.File, java.io.File)
     */
    public static void assertFileEquals(String message, File expected,
            File actual) {
        FileAssert.assertEquals(message, expected, actual);
    }

    /**
     * 2̃t@Clł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.FileAssert#assertEquals(java.io.File, java.io.File)
     */
    public static void assertFileEquals(File expected, File actual) {
        FileAssert.assertEquals(expected, actual);
    }

    /**
     * 2̃oCit@Clł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[܂B
     * 
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.FileAssert#assertBinaryEquals(java.io.File,
     *      java.io.File)
     */
    public static void assertFileBinaryEquals(File expected, File actual) {
        FileAssert.assertBinaryEquals(expected, actual);
    }

    /**
     * 2̃oCit@Clł邱Ƃ\܂B<br>
     * ؂ɎsꍇAssertionFailedErrorX[AbZ[W(message)\܂B
     * 
     * @param message
     *            ؎sɕ\郁bZ[W
     * @param expected
     *            Ғl
     * @param actual
     *            ۂ̒l
     * @see junitx.framework.FileAssert#assertBinaryEquals(java.lang.String,
     *      java.io.File, java.io.File)
     */
    public static void assertFileBinaryEquals(String message, File expected,
            File actual) {
        FileAssert.assertBinaryEquals(message, expected, actual);
    }

    /**
     * cӏAjavadoc͂܂xB
     * 
     * @param expected
     * @param actual
     */
    public static void assertIteratorEquals(Iterator<?> expected,
            Iterator<?> actual) {
        while (expected.hasNext()) {
            Object expectedElement = expected.next();
            Assert.assertTrue("length of " + actual + " is less than that of "
                    + expected, actual.hasNext());
            Object actualElement = actual.next();
            assertReflectionEquals(expectedElement, actualElement);
        }
        Assert.assertFalse("length of " + expected + " is less than that of "
                + actual, actual.hasNext());
    }

    /**
     * cӏAjavadoc͂܂xB
     * 
     * @param expected
     * @param actual
     */
    public static void assertIteratorEquals(Collection<?> expected,
            Iterator<?> actual) {
        Iterator<?> expectedItr = expected.iterator();
        assertIteratorEquals(expectedItr, actual);
    }

}
